/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.cldcplatform.BrokenPlatformCustomizer;
import org.netbeans.modules.mobility.cldcplatform.CustomizerPanel;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformConvertor
implements Environment.Provider,
InstanceCookie.Of,
PropertyChangeListener,
Runnable,
InstanceContent.Convertor {
    InstanceContent cookies = new InstanceContent();
    private XMLDataObject holder;
    private Lookup lookup;
    private RequestProcessor.Task saveTask;
    protected Reference<J2MEPlatform> refPlatform = new WeakReference<Object>(null);
    private final LinkedList<PropertyChangeEvent> keepAlive = new LinkedList();
    static final int DELAY = 200;
    static final String ELEMENT_PLATFORM = "platform";
    static final String ELEMENT_DEVICE = "device";
    static final String ELEMENT_CONFIGURATION = "configuration";
    static final String ELEMENT_PROFILE = "profile";
    static final String ELEMENT_OPTIONAL = "optional";
    static final String ELEMENT_SCREEN = "screen";
    static final String ATTR_PROPERTY_NAME = "name";
    static final String ATTR_PROPERTY_HOME = "home";
    static final String ATTR_PROPERTY_TYPE = "type";
    static final String ATTR_PROPERTY_DISPLAYNAME = "displayname";
    static final String ATTR_PROPERTY_SRCPATH = "srcpath";
    static final String ATTR_PROPERTY_DOCPATH = "docpath";
    static final String ATTR_PROPERTY_DESCRIPTION = "description";
    static final String ATTR_PROPERTY_SECURITY_DOMAINS = "securitydomains";
    static final String ATTR_PROPERTY_PREVERIFYCMD = "preverifycmd";
    static final String ATTR_PROPERTY_RUNCMD = "runcmd";
    static final String ATTR_PROPERTY_DEBUGCMD = "debugcmd";
    static final String ATTR_PROPERTY_VERSION = "version";
    static final String ATTR_PROPERTY_DEPENDENCIES = "dependencies";
    static final String ATTR_PROPERTY_CLASSPATH = "classpath";
    static final String ATTR_PROPERTY_DEFAULT = "default";
    static final String ATTR_SCREEN_WIDTH = "width";
    static final String ATTR_SCREEN_HEIGHT = "height";
    static final String ATTR_SCREEN_BITDEPTH = "bitDepth";
    static final String ATTR_SCREEN_ISCOLOR = "isColor";
    static final String ATTR_SCREEN_ISTOUCH = "isTouch";
    private static final String EMPTY = "";

    private PlatformConvertor() {
    }

    public static PlatformConvertor createProvider(FileObject fileObject) {
        return new PlatformConvertor();
    }

    public Lookup getEnvironment(DataObject dataObject) {
        return new PlatformConvertor((XMLDataObject)dataObject).getLookup();
    }

    private PlatformConvertor(XMLDataObject xMLDataObject) {
        this.holder = xMLDataObject;
        this.holder.getPrimaryFile().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(final FileEvent fileEvent) {
                try {
                    ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                        public Object run() throws IOException {
                            String string = fileEvent.getFile().getName();
                            String string2 = "platforms." + string + ".";
                            boolean bl = false;
                            EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                            Iterator iterator = editableProperties.keySet().iterator();
                            while (iterator.hasNext()) {
                                String string3 = (String)iterator.next();
                                if (!string3.startsWith(string2)) continue;
                                iterator.remove();
                                bl = true;
                            }
                            if (bl) {
                                PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                            }
                            return null;
                        }
                    });
                }
                catch (MutexException mutexException) {
                    ErrorManager.getDefault().notify((Throwable)mutexException);
                }
            }
        });
        this.cookies = new InstanceContent();
        this.cookies.add((Object)this);
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.cookies);
        this.cookies.add(Node.class, (InstanceContent.Convertor)this);
    }

    Lookup getLookup() {
        return this.lookup;
    }

    public Class instanceClass() {
        return J2MEPlatform.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceCreate() throws IOException {
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            Object object;
            J2MEPlatform j2MEPlatform = this.refPlatform.get();
            if (j2MEPlatform != null) {
                return j2MEPlatform;
            }
            H h = new H();
            try {
                object = XMLUtil.createXMLReader();
                InputSource inputSource = new InputSource(this.holder.getPrimaryFile().getInputStream());
                inputSource.setSystemId(this.holder.getPrimaryFile().getPath());
                object.setContentHandler(h);
                object.setErrorHandler(h);
                object.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
                object.parse(inputSource);
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                sAXException.printStackTrace();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(sAXException.getMessage());
            }
            object = this.createPlatform(h);
            this.refPlatform = new WeakReference<XMLReader>((XMLReader)object);
            PlatformConvertor.updateBuildProperties((J2MEPlatform)((Object)object));
            return object;
        }
    }

    J2MEPlatform createPlatform(H h) {
        J2MEPlatform j2MEPlatform = h.platform;
        j2MEPlatform.addPropertyChangeListener(this);
        return j2MEPlatform;
    }

    public String instanceName() {
        return this.holder.getName();
    }

    public boolean instanceOf(Class clazz) {
        return clazz.isAssignableFrom(J2MEPlatform.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            if (this.saveTask == null) {
                this.saveTask = RequestProcessor.getDefault().create((Runnable)this);
            }
        }
        platformConvertor = this;
        synchronized (platformConvertor) {
            this.keepAlive.add(propertyChangeEvent);
        }
        this.saveTask.schedule(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PropertyChangeEvent propertyChangeEvent;
        Object object = this;
        synchronized (object) {
            propertyChangeEvent = this.keepAlive.removeFirst();
        }
        object = (J2MEPlatform)((Object)propertyChangeEvent.getSource());
        PlatformConvertor.updateBuildProperties((J2MEPlatform)((Object)object));
        try {
            this.holder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)new W((J2MEPlatform)((Object)object), (MultiDataObject)this.holder));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public Object convert(Object object) {
        if (object == Node.class) {
            try {
                Object object2 = this.instanceCreate();
                return new J2MEPlatformNode((J2MEPlatform)((Object)object2), (DataObject)this.holder);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return null;
    }

    public String displayName(Object object) {
        return ((Class)object).getName();
    }

    public String id(Object object) {
        return object.toString();
    }

    public Class type(Object object) {
        return (Class)object;
    }

    public static DataObject create(J2MEPlatform j2MEPlatform, DataFolder dataFolder, String string) throws IOException {
        W w = new W(j2MEPlatform, dataFolder, string);
        dataFolder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)w);
        return w.holder;
    }

    private static void updateBuildProperties(final J2MEPlatform j2MEPlatform) {
        final String string = j2MEPlatform.getName();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                        public Object run() throws Exception {
                            EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                            Iterator iterator = editableProperties.entrySet().iterator();
                            String string = PlatformConvertor.createName(string, PlatformConvertor.EMPTY);
                            while (iterator.hasNext()) {
                                if (!((String)((Map.Entry)iterator.next()).getKey()).startsWith(string)) continue;
                                iterator.remove();
                            }
                            editableProperties.setProperty(PlatformConvertor.createName(string, PlatformConvertor.ATTR_PROPERTY_HOME), j2MEPlatform.getHomePath());
                            editableProperties.setProperty(PlatformConvertor.createName(string, PlatformConvertor.ATTR_PROPERTY_TYPE), j2MEPlatform.getType());
                            editableProperties.setProperty(PlatformConvertor.createName(string, "preverifycommandline"), j2MEPlatform.getPreverifyCmd() != null ? j2MEPlatform.getPreverifyCmd() : PlatformConvertor.EMPTY);
                            editableProperties.setProperty(PlatformConvertor.createName(string, "runcommandline"), j2MEPlatform.getRunCmd() != null ? j2MEPlatform.getRunCmd() : PlatformConvertor.EMPTY);
                            editableProperties.setProperty(PlatformConvertor.createName(string, "debugcommandline"), j2MEPlatform.getDebugCmd() != null ? j2MEPlatform.getDebugCmd() : PlatformConvertor.EMPTY);
                            PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                            return null;
                        }
                    });
                }
                catch (MutexException mutexException) {
                    ErrorManager.getDefault().notify((Throwable)mutexException.getException());
                }
            }
        });
    }

    protected static String createName(String string, String string2) {
        return "platforms." + string + "." + string2;
    }

    public static String array2string(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(stringArray[i].length() * stringArray.length);
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer != null ? stringBuffer.toString() : EMPTY;
    }

    public static String[] string2array(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected static String toJavaIdentifier(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (stringBuffer.length() == 0 && Character.isJavaIdentifierStart(c)) {
                stringBuffer.append(c);
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static Map<String, String> extractPlatformProperties(String string, J2MEPlatform j2MEPlatform, J2MEPlatform.Device device, String string2, String string3) {
        String string4;
        String string5;
        String string6;
        String string7;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        J2MEPlatform.J2MEProfile j2MEProfile = null;
        J2MEPlatform.J2MEProfile j2MEProfile2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        if (j2MEPlatform == null) {
            string7 = ".default";
            string6 = EMPTY;
            string5 = EMPTY;
            string4 = EMPTY;
        } else {
            string7 = j2MEPlatform.getName();
            string6 = j2MEPlatform.getDisplayName();
            string4 = j2MEPlatform.getType();
            if (device == null && j2MEPlatform.getDevices() != null && j2MEPlatform.getDevices().length > 0) {
                device = j2MEPlatform.getDevices()[0];
            }
            if (device == null) {
                string5 = EMPTY;
            } else {
                J2MEPlatform.Screen screen;
                string5 = device.getName();
                J2MEPlatform.J2MEProfile[] j2MEProfileArray = device.getProfiles();
                for (int i = 0; i < j2MEProfileArray.length; ++i) {
                    String string8;
                    if (ELEMENT_CONFIGURATION.equals(j2MEProfileArray[i].getType())) {
                        if (j2MEProfile == null || !j2MEProfile.toString().equals(string2) && j2MEProfileArray[i].isDefault() || j2MEProfileArray[i].toString().equals(string2)) {
                            j2MEProfile = j2MEProfileArray[i];
                        }
                    } else if (ELEMENT_PROFILE.equals(j2MEProfileArray[i].getType())) {
                        if (j2MEProfile2 == null || !j2MEProfile2.toString().equals(string3) && j2MEProfileArray[i].isDefault() || j2MEProfileArray[i].toString().equals(string3)) {
                            j2MEProfile2 = j2MEProfileArray[i];
                        }
                    } else if (j2MEProfileArray[i].isDefault()) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(j2MEProfileArray[i].toString());
                        if (stringBuffer2.length() > 0) {
                            stringBuffer2.append(':');
                        }
                        stringBuffer2.append(j2MEProfileArray[i].getClassPath());
                    }
                    String string9 = j2MEProfileArray[i].getVersion() == null ? null : j2MEProfileArray[i].getVersion().toString();
                    String string10 = PlatformConvertor.toValidAbility(j2MEProfileArray[i].getName());
                    if (string10 == null || (string8 = (String)hashMap2.get(string10)) != null && (string9 == null || string9.compareTo(string8) <= 0)) continue;
                    hashMap2.put(string10, string9);
                }
                if (j2MEProfile != null) {
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(':');
                    }
                    stringBuffer2.append(j2MEProfile.getClassPath());
                }
                if (j2MEProfile2 != null) {
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(':');
                    }
                    stringBuffer2.append(j2MEProfile2.getClassPath());
                }
                if ((screen = device.getScreen()) != null) {
                    if (screen.getColor() != null && screen.getColor().booleanValue()) {
                        hashMap2.put("ColorScreen", null);
                    }
                    if (screen.getTouch() != null && screen.getTouch().booleanValue()) {
                        hashMap2.put("TouchScreen", null);
                    }
                    if (screen.getBitDepth() != null) {
                        hashMap2.put("ScreenColorDepth", screen.getBitDepth().toString());
                    }
                    if (screen.getWidth() != null) {
                        hashMap2.put("ScreenWidth", screen.getWidth().toString());
                    }
                    if (screen.getHeight() != null) {
                        hashMap2.put("ScreenHeight", screen.getHeight().toString());
                    }
                }
            }
        }
        hashMap.put(string + "platform.active", string7);
        hashMap.put(string + "platform.active.description", string6);
        hashMap.put(string + "platform.device", string5);
        hashMap.put(string + "platform.configuration", j2MEProfile == null ? "CLDC-1.0" : j2MEProfile.toString());
        hashMap.put(string + "platform.profile", j2MEProfile2 == null ? "MIDP-1.0" : j2MEProfile2.toString());
        hashMap.put(string + "platform.apis", stringBuffer.toString());
        hashMap.put(string + "platform.bootclasspath", device == null ? stringBuffer2.toString() : device.sortClasspath(stringBuffer2.toString()));
        hashMap.put(string + "abilities", PlatformConvertor.encodeAbilities(hashMap2));
        hashMap.put(string + "platform.type", string4);
        hashMap.put(string + "platform.trigger", "CLDC");
        return hashMap;
    }

    private static String toValidAbility(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '.' && c != '/' && c != '\\') continue;
            stringBuffer.append(c);
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        if (!Character.isJavaIdentifierStart(stringBuffer.charAt(0))) {
            stringBuffer.insert(0, '_');
        }
        return stringBuffer.toString();
    }

    private static String encodeAbilities(Map<String, String> map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuffer.append(entry.getKey());
            if (entry.getValue() != null && entry.getValue().length() > 0) {
                stringBuffer.append('=').append(entry.getValue());
            }
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    static class H
    extends DefaultHandler {
        J2MEPlatform platform;
        private String name;
        private String home;
        private String type;
        private String displayName;
        private String srcPath;
        private String docPath;
        private ArrayList<J2MEPlatform.Device> devices;
        private String devName;
        private String devDesc;
        private String[] devSecurityDomains;
        private String devPrevCmd;
        private String devRunCmd;
        private String devDebugCmd;
        private ArrayList<J2MEPlatform.J2MEProfile> profiles;
        private J2MEPlatform.Screen screen;

        H() {
        }

        public J2MEPlatform.Device[] getDevices() {
            return this.devices.toArray(new J2MEPlatform.Device[this.devices.size()]);
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        private String getMandatoryValue(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null || string2.length() < 1) {
                throw new SAXException("Missing " + string);
            }
            return string2;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (PlatformConvertor.ELEMENT_PLATFORM.equals(string3)) {
                if (this.platform != null || this.devices != null) {
                    throw new SAXException("Invalid start of element platform");
                }
                this.name = this.getMandatoryValue(attributes, PlatformConvertor.ATTR_PROPERTY_NAME);
                this.home = this.getMandatoryValue(attributes, PlatformConvertor.ATTR_PROPERTY_HOME);
                this.type = this.getMandatoryValue(attributes, PlatformConvertor.ATTR_PROPERTY_TYPE);
                this.displayName = attributes.getValue(PlatformConvertor.ATTR_PROPERTY_DISPLAYNAME);
                this.srcPath = attributes.getValue(PlatformConvertor.ATTR_PROPERTY_SRCPATH);
                this.docPath = attributes.getValue(PlatformConvertor.ATTR_PROPERTY_DOCPATH);
                this.devPrevCmd = attributes.getValue(PlatformConvertor.ATTR_PROPERTY_PREVERIFYCMD);
                this.devRunCmd = attributes.getValue(PlatformConvertor.ATTR_PROPERTY_RUNCMD);
                this.devDebugCmd = attributes.getValue(PlatformConvertor.ATTR_PROPERTY_DEBUGCMD);
            } else if (PlatformConvertor.ELEMENT_DEVICE.equals(string3)) {
                if (this.profiles != null) {
                    throw new SAXException("Invalid start of element device");
                }
                this.devName = this.getMandatoryValue(attributes, PlatformConvertor.ATTR_PROPERTY_NAME);
                this.devDesc = attributes.getValue(PlatformConvertor.ATTR_PROPERTY_DESCRIPTION);
                this.devSecurityDomains = PlatformConvertor.string2array(attributes.getValue(PlatformConvertor.ATTR_PROPERTY_SECURITY_DOMAINS));
                this.profiles = new ArrayList();
                this.screen = null;
            } else if (PlatformConvertor.ELEMENT_CONFIGURATION.equals(string3) || PlatformConvertor.ELEMENT_PROFILE.equals(string3) || PlatformConvertor.ELEMENT_OPTIONAL.equals(string3)) {
                String string4 = this.getMandatoryValue(attributes, PlatformConvertor.ATTR_PROPERTY_NAME);
                String string5 = this.getMandatoryValue(attributes, PlatformConvertor.ATTR_PROPERTY_VERSION);
                String string6 = attributes.getValue(PlatformConvertor.ATTR_PROPERTY_DEPENDENCIES);
                String string7 = attributes.getValue(PlatformConvertor.ATTR_PROPERTY_DISPLAYNAME);
                String string8 = attributes.getValue(PlatformConvertor.ATTR_PROPERTY_CLASSPATH);
                boolean bl = Boolean.valueOf(attributes.getValue(PlatformConvertor.ATTR_PROPERTY_DEFAULT));
                this.profiles.add(new J2MEPlatform.J2MEProfile(string4, string5, string7, string3, string6, string8, bl));
            } else if (PlatformConvertor.ELEMENT_SCREEN.equals(string3)) {
                this.screen = new J2MEPlatform.Screen(attributes.getValue(PlatformConvertor.ATTR_SCREEN_WIDTH), attributes.getValue(PlatformConvertor.ATTR_SCREEN_HEIGHT), attributes.getValue(PlatformConvertor.ATTR_SCREEN_BITDEPTH), attributes.getValue(PlatformConvertor.ATTR_SCREEN_ISCOLOR), attributes.getValue(PlatformConvertor.ATTR_SCREEN_ISTOUCH));
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (PlatformConvertor.ELEMENT_PLATFORM.equals(string3)) {
                if (this.platform != null) {
                    throw new SAXException("Invalid end of element platform");
                }
                if (this.devices == null) {
                    throw new SAXException("Missing device");
                }
                this.platform = new J2MEPlatform(this.name, this.home, this.type, this.displayName, this.srcPath, this.docPath, this.devPrevCmd, this.devRunCmd, this.devDebugCmd, this.devices.toArray(new J2MEPlatform.Device[this.devices.size()]));
            } else if (PlatformConvertor.ELEMENT_DEVICE.equals(string3)) {
                if (this.devices == null) {
                    this.devices = new ArrayList();
                }
                this.devices.add(new J2MEPlatform.Device(this.devName, this.devDesc, this.devSecurityDomains, this.profiles.toArray(new J2MEPlatform.J2MEProfile[this.profiles.size()]), this.screen));
                this.profiles = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class W
    implements FileSystem.AtomicAction {
        J2MEPlatform instance;
        MultiDataObject holder;
        String name;
        DataFolder f;

        W(J2MEPlatform j2MEPlatform, MultiDataObject multiDataObject) {
            this.instance = j2MEPlatform;
            this.holder = multiDataObject;
        }

        W(J2MEPlatform j2MEPlatform, DataFolder dataFolder, String string) {
            this.instance = j2MEPlatform;
            this.name = string;
            this.f = dataFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            Object object;
            Object object2;
            FileLock fileLock;
            FileObject fileObject;
            if (this.holder != null) {
                fileObject = this.holder.getPrimaryEntry().getFile();
                fileLock = this.holder.getPrimaryEntry().takeLock();
            } else {
                object2 = this.f.getPrimaryFile();
                object = FileUtil.findFreeFileName((FileObject)object2, (String)this.name, (String)"xml");
                this.instance.setName((String)object);
                fileObject = object2.createData((String)object, "xml");
                fileLock = fileObject.lock();
            }
            try {
                object2 = fileObject.getOutputStream(fileLock);
                object = new PrintWriter(new OutputStreamWriter((OutputStream)object2, "UTF8"));
                this.write((PrintWriter)object);
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
                ((OutputStream)object2).close();
            }
            finally {
                fileLock.releaseLock();
            }
            if (this.holder == null) {
                this.holder = (MultiDataObject)DataObject.find((FileObject)fileObject);
            }
        }

        void write(PrintWriter printWriter) throws IOException {
            printWriter.println("<?xml version='1.0'?>");
            printWriter.println("<!DOCTYPE platform PUBLIC '-//NetBeans//DTD J2ME PlatformDefinition 1.0//EN' 'http://www.netbeans.org/dtds/j2me-platformdefinition-1_0.dtd'>");
            printWriter.print("<platform name=\"" + XMLUtil.toAttributeValue((String)this.instance.getName()) + "\" home=\"" + XMLUtil.toAttributeValue((String)this.instance.getHomePath()) + "\" type=\"" + XMLUtil.toAttributeValue((String)this.instance.getType()) + "\" displayname=\"" + XMLUtil.toAttributeValue((String)this.instance.getDisplayName()) + "\" srcpath=\"" + XMLUtil.toAttributeValue((String)this.instance.getSourcePath()) + "\" docpath=\"" + XMLUtil.toAttributeValue((String)this.instance.getJavadocPath()));
            if (this.instance.getPreverifyCmd() != null) {
                printWriter.print("\" preverifycmd=\"" + XMLUtil.toAttributeValue((String)this.instance.getPreverifyCmd()));
            }
            if (this.instance.getRunCmd() != null) {
                printWriter.print("\" runcmd=\"" + XMLUtil.toAttributeValue((String)this.instance.getRunCmd()));
            }
            if (this.instance.getDebugCmd() != null) {
                printWriter.print("\" debugcmd=\"" + XMLUtil.toAttributeValue((String)this.instance.getDebugCmd()));
            }
            printWriter.println("\">");
            J2MEPlatform.Device[] deviceArray = this.instance.getDevices();
            for (int i = 0; i < deviceArray.length; ++i) {
                Comparable comparable;
                J2MEPlatform.Device device = deviceArray[i];
                printWriter.print("    <device name=\"" + XMLUtil.toAttributeValue((String)device.getName()));
                String string = PlatformConvertor.array2string(device.getSecurityDomains());
                if (string != null) {
                    printWriter.print("\" securitydomains=\"" + XMLUtil.toAttributeValue((String)string));
                }
                if (device.getDescription() != null) {
                    printWriter.print("\" description=\"" + XMLUtil.toAttributeValue((String)device.getDescription()));
                }
                printWriter.println("\">");
                J2MEPlatform.J2MEProfile[] j2MEProfileArray = device.getProfiles();
                for (int j = 0; j < j2MEProfileArray.length; ++j) {
                    comparable = j2MEProfileArray[j];
                    printWriter.print("        <" + ((J2MEPlatform.J2MEProfile)comparable).getType() + " name=\"" + XMLUtil.toAttributeValue((String)comparable.getName()) + "\" version=\"" + XMLUtil.toAttributeValue((String)comparable.getVersion().toString()) + "\" displayname=\"" + XMLUtil.toAttributeValue((String)((J2MEPlatform.J2MEProfile)comparable).getDisplayName()) + "\" classpath=\"" + XMLUtil.toAttributeValue((String)((J2MEPlatform.J2MEProfile)comparable).getClassPath()));
                    if (((J2MEPlatform.J2MEProfile)comparable).getDependencies() != null) {
                        printWriter.print("\" dependencies=\"" + XMLUtil.toAttributeValue((String)((J2MEPlatform.J2MEProfile)comparable).getDependencies()));
                    }
                    printWriter.println("\" default=\"" + Boolean.toString(((J2MEPlatform.J2MEProfile)comparable).isDefault()) + "\"/>");
                }
                J2MEPlatform.Screen screen = device.getScreen();
                if (screen != null) {
                    comparable = screen.getWidth();
                    Integer n = screen.getHeight();
                    Integer n2 = screen.getBitDepth();
                    Boolean bl = screen.getColor();
                    Boolean bl2 = screen.getTouch();
                    if (comparable != null || n != null || n2 != null || bl != null || bl2 != null) {
                        printWriter.print("        <screen");
                        if (comparable != null) {
                            printWriter.print(" width=\"" + comparable + "\"");
                        }
                        if (n != null) {
                            printWriter.print(" height=\"" + n + "\"");
                        }
                        if (n2 != null) {
                            printWriter.print(" bitDepth=\"" + n2 + "\"");
                        }
                        if (bl != null) {
                            printWriter.print(" isColor=\"" + bl + "\"");
                        }
                        if (bl2 != null) {
                            printWriter.print(" isTouch=\"" + bl2 + "\"");
                        }
                        printWriter.println("/>");
                    }
                }
                printWriter.println("    </device>");
            }
            printWriter.println("</platform>");
        }

        void writeProperties(Map<String, String> map, PrintWriter printWriter) throws IOException {
            TreeSet<String> treeSet = new TreeSet<String>(map.keySet());
            for (String string : treeSet) {
                String string2 = map.get(string);
                printWriter.println("    <property name='" + XMLUtil.toAttributeValue((String)string) + "' value='" + XMLUtil.toAttributeValue((String)string2) + "'/>");
            }
        }
    }

    static class J2MEPlatformNode
    extends AbstractNode
    implements PropertyChangeListener {
        J2MEPlatform platform;

        J2MEPlatformNode(J2MEPlatform j2MEPlatform, DataObject dataObject) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{j2MEPlatform, dataObject}));
            this.platform = j2MEPlatform;
            j2MEPlatform.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)((Object)j2MEPlatform)));
            this.setIconBaseWithExtension("org/netbeans/modules/mobility/cldcplatform/resources/platform.gif");
        }

        public String getDisplayName() {
            return this.platform.getDisplayName();
        }

        public String getHtmlDisplayName() {
            if (this.platform.isValid()) {
                return null;
            }
            return "<font color=\"#A40000\">" + this.platform.getDisplayName() + "</font>";
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(J2MEPlatformNode.class);
        }

        public boolean hasCustomizer() {
            return true;
        }

        public Component getCustomizer() {
            if (this.platform.getInstallFolders().size() == 0) {
                return new BrokenPlatformCustomizer();
            }
            return new CustomizerPanel(this.platform);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
    }

    static interface J2MEPlatformCookie
    extends Node.Cookie {
        public J2MEPlatform getPlatform();
    }
}

