/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.mobility.cldcplatform.DetectPanel;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public final class CustomizerPanel
extends JPanel
implements ChangeListener,
DocumentListener,
FocusListener {
    private static final Dimension PREF_DIM = new Dimension(560, 350);
    public static final String PREFS_TOOL = "prefs";
    public static final String UTILS_TOOL = "utils";
    public static final String MEM_PROP = "kvem.memory.monitor.enable";
    public static final String JAM_PROP = "jammode";
    public static final String NET_PROP = "kvem.netmon.enable";
    public static final String NET_HTTP_PROP = "kvem.netmon.http.enable";
    public static final String NET_HTTPS_PROP = "kvem.netmon.https.enable";
    public static final String PROF_PROP = "kvem.profiler.enable";
    public static final String FALSE = "false";
    String fileChooserValue;
    J2MEPlatform platform;
    DefaultListModel mSources;
    DefaultListModel mJavaDocs;
    boolean mMemoryMonitor;
    boolean mNetworkMonitor;
    boolean mProfiler;
    String preverifyInfo;
    String executionInfo;
    String debuggerInfo;
    ListDataListener sourcesListener = new ListDataListener(){

        public void intervalAdded(ListDataEvent listDataEvent) {
            CustomizerPanel.this.saveSources();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            CustomizerPanel.this.saveSources();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            CustomizerPanel.this.saveSources();
        }
    };
    ListDataListener javadocsListener = new ListDataListener(){

        public void intervalAdded(ListDataEvent listDataEvent) {
            CustomizerPanel.this.saveJavadocs();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            CustomizerPanel.this.saveJavadocs();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            CustomizerPanel.this.saveJavadocs();
        }
    };
    private JButton bJavaDocAddArchive;
    private JButton bJavaDocAddFolder;
    private JButton bJavaDocMoveDown;
    private JButton bJavaDocMoveUp;
    private JButton bJavaDocRemove;
    private JButton bPreferences;
    private JButton bSourceAddArchive;
    private JButton bSourceAddFolder;
    private JButton bSourceMoveDown;
    private JButton bSourceMoveUp;
    private JButton bSourceRemove;
    private JButton bUtilities;
    private JCheckBox cMemoryMonitor;
    private JCheckBox cNetworkMonitor;
    private JCheckBox cProfiler;
    private JTextPane infoPanel;
    private JButton jButtonRefresh;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldDebug;
    private JTextField jTextFieldDevice;
    private JTextField jTextFieldExec;
    private JTextField jTextFieldPreverify;
    private JList lDevices;
    private JList lJavaDocPaths;
    private JList lSourcePaths;

    public CustomizerPanel(J2MEPlatform j2MEPlatform) {
        this.initComponents();
        this.infoPanel.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.infoPanel.setContentType("text/html;charset=UTF-8");
        if (j2MEPlatform.getType().equalsIgnoreCase("custom")) {
            this.jTabbedPane1.remove(this.jPanel5);
        } else {
            this.jTabbedPane1.remove(this.jPanel6);
        }
        this.mSources = new DefaultListModel();
        this.lSourcePaths.setModel(this.mSources);
        this.mJavaDocs = new DefaultListModel();
        this.lJavaDocPaths.setModel(this.mJavaDocs);
        this.loadData(j2MEPlatform);
        this.addListeners();
    }

    void addListeners() {
        this.mSources.addListDataListener(this.sourcesListener);
        this.mJavaDocs.addListDataListener(this.javadocsListener);
        this.cMemoryMonitor.addChangeListener(this);
        this.cNetworkMonitor.addChangeListener(this);
        this.cProfiler.addChangeListener(this);
        this.jTextFieldPreverify.getDocument().addDocumentListener(this);
        this.jTextFieldExec.getDocument().addDocumentListener(this);
        this.jTextFieldDebug.getDocument().addDocumentListener(this);
        this.jTextFieldPreverify.addFocusListener(this);
        this.jTextFieldExec.addFocusListener(this);
        this.jTextFieldDebug.addFocusListener(this);
        this.preverifyInfo = this.loadInfo("nbresloc:/org/netbeans/modules/mobility/cldcplatform/customwizard/preverifyinfo.html");
        this.executionInfo = this.loadInfo("nbresloc:/org/netbeans/modules/mobility/cldcplatform/customwizard/executioninfo.html");
        this.debuggerInfo = this.loadInfo("nbresloc:/org/netbeans/modules/mobility/cldcplatform/customwizard/debuggerinfo.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadInfo(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        InputStreamReader inputStreamReader = null;
        try {
            int n;
            inputStreamReader = new InputStreamReader(new URL(string).openStream(), "UTF-8");
            char[] cArray = new char[4096];
            while ((n = inputStreamReader.read(cArray, 0, 4096)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            String string2 = stringBuffer.toString();
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void clearData() {
        this.platform = null;
        this.mSources.clear();
        this.mJavaDocs.clear();
        this.bPreferences.setEnabled(false);
        this.bUtilities.setEnabled(false);
        this.cMemoryMonitor.setEnabled(false);
        this.mMemoryMonitor = false;
        this.cMemoryMonitor.setSelected(false);
        this.cNetworkMonitor.setEnabled(false);
        this.mNetworkMonitor = false;
        this.cNetworkMonitor.setSelected(false);
        this.cProfiler.setEnabled(false);
        this.mProfiler = false;
        this.cProfiler.setSelected(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public void loadData(J2MEPlatform j2MEPlatform) {
        this.clearData();
        this.platform = j2MEPlatform;
        if (j2MEPlatform == null) {
            return;
        }
        if (this.fileChooserValue == null) {
            this.fileChooserValue = j2MEPlatform.getHomePath();
        }
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        J2MEPlatform.Device[] deviceArray = j2MEPlatform.getDevices();
        if (deviceArray != null) {
            if (deviceArray.length > 0) {
                this.jTextFieldDevice.setText(deviceArray[0].getName());
            }
            for (int i = 0; i < deviceArray.length; ++i) {
                defaultListModel.addElement(deviceArray[i].isValid() ? deviceArray[i].getName() : "<html><font color=\"#A40000\"><strike>" + deviceArray[i].getName() + "</strike></font>");
            }
        }
        this.lDevices.setModel(defaultListModel);
        this.jTextFieldPreverify.setText(j2MEPlatform.getPreverifyCmd());
        this.jTextFieldExec.setText(j2MEPlatform.getRunCmd());
        this.jTextFieldDebug.setText(j2MEPlatform.getDebugCmd());
        FileObject[] fileObjectArray = j2MEPlatform.getSourceFolders().getRoots();
        this.mSources.clear();
        if (fileObjectArray != null) {
            for (Object object : fileObjectArray) {
                this.mSources.addElement(new ListItem<Object>(object));
            }
        }
        List<URL> list = j2MEPlatform.getJavadocFolders();
        this.mJavaDocs.clear();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                URL uRL = (URL)iterator.next();
                this.mJavaDocs.addElement(new ListItem<URL>(uRL));
            }
        }
        this.bPreferences.setEnabled(j2MEPlatform.findTool(PREFS_TOOL) != null);
        this.bUtilities.setEnabled(j2MEPlatform.findTool(UTILS_TOOL) != null);
        File file = new File(j2MEPlatform.getHomePath(), "wtklib" + File.separator + "emulator.properties");
        if (file.exists() && file.canWrite()) {
            Object object;
            Properties properties = new Properties();
            object = null;
            try {
                object = new FileInputStream(file);
                properties.load((InputStream)object);
            }
            catch (IOException iOException) {
            }
            finally {
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (IOException iOException) {}
                    object = null;
                }
            }
            this.cMemoryMonitor.setEnabled(true);
            this.cNetworkMonitor.setEnabled(true);
            this.cProfiler.setEnabled(true);
            this.mMemoryMonitor = Boolean.valueOf(properties.getProperty(MEM_PROP, FALSE));
            this.cMemoryMonitor.setSelected(this.mMemoryMonitor);
            this.mNetworkMonitor = Boolean.valueOf(properties.getProperty(NET_PROP, FALSE));
            this.cNetworkMonitor.setSelected(this.mNetworkMonitor);
            this.mProfiler = Boolean.valueOf(properties.getProperty(PROF_PROP, FALSE));
            this.cProfiler.setSelected(this.mProfiler);
        }
        this.refreshButtons();
    }

    public void saveSources() {
        if (this.platform == null) {
            return;
        }
        Object[] objectArray = this.mSources.toArray();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        if (objectArray != null) {
            for (Object object : objectArray) {
                arrayList.add((FileObject)((ListItem)object).getObject());
            }
        }
        this.platform.setSourceFolders(arrayList);
    }

    public void saveJavadocs() {
        if (this.platform == null) {
            return;
        }
        Object[] objectArray = this.mJavaDocs.toArray();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (objectArray != null) {
            for (Object object : objectArray) {
                arrayList.add((URL)((ListItem)object).getObject());
            }
        }
        this.platform.setJavadocFolders(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWtkExtensions() {
        if (this.platform == null) {
            return;
        }
        File file = new File(this.platform.getHomePath(), "wtklib" + File.separator + "emulator.properties");
        if (file.exists() && file.canWrite() && this.cMemoryMonitor.isEnabled() && (this.cMemoryMonitor.isSelected() != this.mMemoryMonitor || this.cNetworkMonitor.isSelected() != this.mNetworkMonitor || this.cProfiler.isSelected() != this.mProfiler)) {
            Object object;
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    fileInputStream = null;
                }
            }
            if (this.cMemoryMonitor.isSelected() != this.mMemoryMonitor) {
                object = String.valueOf(this.cMemoryMonitor.isSelected());
                properties.setProperty(JAM_PROP, "");
                properties.setProperty(MEM_PROP, (String)object);
            }
            if (this.cNetworkMonitor.isSelected() != this.mNetworkMonitor) {
                object = String.valueOf(this.cNetworkMonitor.isSelected());
                properties.setProperty(NET_PROP, (String)object);
                properties.setProperty(NET_HTTP_PROP, (String)object);
                properties.setProperty(NET_HTTPS_PROP, (String)object);
            }
            if (this.cProfiler.isSelected() != this.mProfiler) {
                object = String.valueOf(this.cProfiler.isSelected());
                properties.setProperty(PROF_PROP, (String)object);
            }
            object = null;
            try {
                object = new FileOutputStream(file);
                properties.store((OutputStream)object, null);
            }
            catch (IOException iOException) {
            }
            finally {
                if (object != null) {
                    try {
                        ((FileOutputStream)object).close();
                    }
                    catch (IOException iOException) {}
                    object = null;
                }
            }
        }
    }

    public void refreshButtons() {
        this.bSourceRemove.setEnabled(this.lSourcePaths.getSelectedValue() != null);
        this.bSourceMoveUp.setEnabled(this.lSourcePaths.getSelectedIndex() > 0);
        this.bSourceMoveDown.setEnabled(this.lSourcePaths.getSelectedIndex() >= 0 && this.lSourcePaths.getSelectedIndex() < this.mSources.getSize() - 1);
        this.bJavaDocRemove.setEnabled(this.lJavaDocPaths.getSelectedValue() != null);
        this.bJavaDocMoveUp.setEnabled(this.lJavaDocPaths.getSelectedIndex() > 0);
        this.bJavaDocMoveDown.setEnabled(this.lJavaDocPaths.getSelectedIndex() >= 0 && this.lJavaDocPaths.getSelectedIndex() < this.mJavaDocs.getSize() - 1);
    }

    private String browseArchive(String string, String string2) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.exists() && file.canRead() && (file.isDirectory() || file.getName().endsWith(".zip") || file.getName().endsWith(".jar"));
            }

            public String getDescription() {
                return NbBundle.getMessage(CustomizerPanel.class, (String)"TXT_Customizer_ZipFilter");
            }
        });
        if (string != null) {
            jFileChooser.setSelectedFile(new File(string));
        }
        jFileChooser.setDialogTitle(string2);
        if (jFileChooser.showOpenDialog(this) == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private String browseFolder(String string, String string2) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.exists() && file.canRead() && file.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(CustomizerPanel.class, (String)"TXT_Customizer_FolderFilter");
            }
        });
        if (string != null) {
            jFileChooser.setSelectedFile(new File(string));
        }
        jFileChooser.setDialogTitle(string2);
        if (jFileChooser.showOpenDialog(this) == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private void openTool(FileObject fileObject) {
        if (fileObject == null) {
            return;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return;
        }
        try {
            Runtime.getRuntime().exec(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerPanel.class, (String)"MSG_CustomizerPanel_CannotExecTool", (Object)file.getAbsolutePath())));
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel5 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.lDevices = new JList();
        this.jButtonRefresh = new JButton();
        this.jPanel6 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jTextFieldDevice = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldPreverify = new JTextField();
        this.jLabel8 = new JLabel();
        this.jTextFieldExec = new JTextField();
        this.jLabel9 = new JLabel();
        this.jTextFieldDebug = new JTextField();
        this.jScrollPane4 = new JScrollPane();
        this.infoPanel = new JTextPane();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lSourcePaths = new JList();
        this.bSourceAddArchive = new JButton();
        this.bSourceAddFolder = new JButton();
        this.bSourceRemove = new JButton();
        this.bSourceMoveUp = new JButton();
        this.bSourceMoveDown = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lJavaDocPaths = new JList();
        this.bJavaDocAddArchive = new JButton();
        this.bJavaDocAddFolder = new JButton();
        this.bJavaDocRemove = new JButton();
        this.bJavaDocMoveUp = new JButton();
        this.bJavaDocMoveDown = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.bPreferences = new JButton();
        this.bUtilities = new JButton();
        this.jLabel5 = new JLabel();
        this.cMemoryMonitor = new JCheckBox();
        this.cNetworkMonitor = new JCheckBox();
        this.cProfiler = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.jTabbedPane1.setRequestFocusEnabled(false);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.lDevices);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Devices"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.jPanel5.add((Component)this.jLabel3, gridBagConstraints);
        this.lDevices.setSelectionMode(0);
        this.jScrollPane3.setViewportView(this.lDevices);
        this.lDevices.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel_Devices"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel5.add((Component)this.jScrollPane3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonRefresh, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Refresh"));
        this.jButtonRefresh.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_Refresh"));
        this.jButtonRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.jButtonRefreshActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel5.add((Component)this.jButtonRefresh, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_Devices"), this.jPanel5);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jLabel6.setLabelFor(this.jTextFieldDevice);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/mobility/cldcplatform/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)resourceBundle.getString("LBL_Customizer_Device"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel6.add((Component)this.jLabel6, gridBagConstraints);
        this.jTextFieldDevice.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.jPanel6.add((Component)this.jTextFieldDevice, gridBagConstraints);
        this.jLabel7.setLabelFor(this.jTextFieldPreverify);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Preverify"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 6, 0, 0);
        this.jPanel6.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 6, 0, 5);
        this.jPanel6.add((Component)this.jTextFieldPreverify, gridBagConstraints);
        this.jLabel8.setLabelFor(this.jTextFieldExec);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Exec"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 6, 0, 0);
        this.jPanel6.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 6, 0, 5);
        this.jPanel6.add((Component)this.jTextFieldExec, gridBagConstraints);
        this.jLabel9.setLabelFor(this.jTextFieldDebug);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Debug"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 6, 0, 0);
        this.jPanel6.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 6, 0, 5);
        this.jPanel6.add((Component)this.jTextFieldDebug, gridBagConstraints);
        this.infoPanel.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.infoPanel.setEditable(false);
        this.jScrollPane4.setViewportView(this.infoPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 6, 5, 5);
        this.jPanel6.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_CMD_Tab"), this.jPanel6);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.lSourcePaths);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(500, 300));
        this.lSourcePaths.setSelectionMode(0);
        this.lSourcePaths.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CustomizerPanel.this.lSourcePathsValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.lSourcePaths);
        this.lSourcePaths.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSourceAddArchive, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_AddArchive"));
        this.bSourceAddArchive.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_SrcAddZip"));
        this.bSourceAddArchive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.bSourceAddArchiveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel1.add((Component)this.bSourceAddArchive, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSourceAddFolder, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_AddFolder"));
        this.bSourceAddFolder.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_SrcAddFolder"));
        this.bSourceAddFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.bSourceAddFolderActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel1.add((Component)this.bSourceAddFolder, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSourceRemove, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Remove"));
        this.bSourceRemove.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_SrcRemove"));
        this.bSourceRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.bSourceRemoveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel1.add((Component)this.bSourceRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSourceMoveUp, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_MoveUp"));
        this.bSourceMoveUp.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_SrcMoveUp"));
        this.bSourceMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.bSourceMoveUpActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel1.add((Component)this.bSourceMoveUp, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSourceMoveDown, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_MoveDown"));
        this.bSourceMoveDown.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_SrcMoveDown"));
        this.bSourceMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.bSourceMoveDownActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel1.add((Component)this.bSourceMoveDown, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_Sources"), this.jPanel1);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.lJavaDocPaths);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_JavaDocs"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane2.setPreferredSize(new Dimension(500, 300));
        this.lJavaDocPaths.setSelectionMode(0);
        this.lJavaDocPaths.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CustomizerPanel.this.lJavaDocPathsValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane2.setViewportView(this.lJavaDocPaths);
        this.lJavaDocPaths.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel_Javadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bJavaDocAddArchive, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_AddArchive"));
        this.bJavaDocAddArchive.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_Javadoc_AddJar"));
        this.bJavaDocAddArchive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.bJavaDocAddArchiveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel2.add((Component)this.bJavaDocAddArchive, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bJavaDocAddFolder, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_AddFolder"));
        this.bJavaDocAddFolder.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_JavadocAddFolder"));
        this.bJavaDocAddFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.bJavaDocAddFolderActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel2.add((Component)this.bJavaDocAddFolder, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bJavaDocRemove, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Remove"));
        this.bJavaDocRemove.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_JavadocRemove"));
        this.bJavaDocRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.bJavaDocRemoveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel2.add((Component)this.bJavaDocRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bJavaDocMoveUp, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_MoveUp"));
        this.bJavaDocMoveUp.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_JavadocMoveUp"));
        this.bJavaDocMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.bJavaDocMoveUpActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel2.add((Component)this.bJavaDocMoveUp, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bJavaDocMoveDown, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_MoveDown"));
        this.bJavaDocMoveDown.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_JavadocMoveDown"));
        this.bJavaDocMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.bJavaDocMoveDownActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel2.add((Component)this.bJavaDocMoveDown, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_JavaDocs"), this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_OpenTools"));
        this.jLabel4.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_OpenTools"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bPreferences, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Preferences"));
        this.bPreferences.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_ToolsPreferences"));
        this.bPreferences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.bPreferencesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel3.add((Component)this.bPreferences, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bUtilities, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Utilities"));
        this.bUtilities.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_ToolsUtilities"));
        this.bUtilities.setPreferredSize(this.bPreferences.getPreferredSize());
        this.bUtilities.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPanel.this.bUtilitiesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel3.add((Component)this.bUtilities, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_WTKExtensions"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel3.add((Component)this.jLabel5, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cMemoryMonitor, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_MemoryMonitor"));
        this.cMemoryMonitor.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_ToolsMemoryMon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel3.add((Component)this.cMemoryMonitor, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cNetworkMonitor, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_NetworkMonitor"));
        this.cNetworkMonitor.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_ToolsNetworkMon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 6);
        this.jPanel3.add((Component)this.cNetworkMonitor, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cProfiler, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Profiler"));
        this.cProfiler.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_ToolsProfiler"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 6);
        this.jPanel3.add((Component)this.cProfiler, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_Tools"), this.jPanel3);
        this.add((Component)this.jTabbedPane1, "Center");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPanel.class, (String)"ACN_CustomizerPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel"));
    }

    private void jButtonRefreshActionPerformed(ActionEvent actionEvent) {
        J2MEPlatform[] j2MEPlatformArray = new J2MEPlatform[]{this.platform};
        DetectPanel detectPanel = new DetectPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)detectPanel, NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_PlatformRefresh"), true, 2, NotifyDescriptor.OK_OPTION, null);
        detectPanel.detectPlatform(j2MEPlatformArray, this.platform.getHomePath(), null, dialogDescriptor);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor))) {
            this.platform.setDevices(j2MEPlatformArray[0].getDevices());
            ArrayList<URL> arrayList = new ArrayList<URL>(this.platform.getJavadocFolders());
            for (URL uRL : j2MEPlatformArray[0].getJavadocFolders()) {
                if (arrayList.contains(uRL)) continue;
                arrayList.add(uRL);
            }
            this.platform.setJavadocFolders(arrayList);
            this.loadData(this.platform);
        }
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void bJavaDocMoveDownActionPerformed(ActionEvent actionEvent) {
        if (this.platform == null) {
            return;
        }
        int n = this.lJavaDocPaths.getSelectedIndex();
        if (n < 0 && n >= this.mJavaDocs.getSize() - 1) {
            return;
        }
        Object e = this.mJavaDocs.get(n);
        Object e2 = this.mJavaDocs.get(n + 1);
        this.mJavaDocs.set(n, e2);
        this.mJavaDocs.set(n + 1, e);
        this.lJavaDocPaths.setSelectedIndex(n + 1);
        this.refreshButtons();
    }

    private void bJavaDocMoveUpActionPerformed(ActionEvent actionEvent) {
        if (this.platform == null) {
            return;
        }
        int n = this.lJavaDocPaths.getSelectedIndex();
        if (n <= 0) {
            return;
        }
        Object e = this.mJavaDocs.get(n - 1);
        Object e2 = this.mJavaDocs.get(n);
        this.mJavaDocs.set(n - 1, e2);
        this.mJavaDocs.set(n, e);
        this.lJavaDocPaths.setSelectedIndex(n - 1);
        this.refreshButtons();
    }

    private void bSourceMoveDownActionPerformed(ActionEvent actionEvent) {
        if (this.platform == null) {
            return;
        }
        int n = this.lSourcePaths.getSelectedIndex();
        if (n < 0 && n >= this.mSources.getSize() - 1) {
            return;
        }
        Object e = this.mSources.get(n);
        Object e2 = this.mSources.get(n + 1);
        this.mSources.set(n, e2);
        this.mSources.set(n + 1, e);
        this.lSourcePaths.setSelectedIndex(n + 1);
        this.refreshButtons();
    }

    private void bSourceMoveUpActionPerformed(ActionEvent actionEvent) {
        if (this.platform == null) {
            return;
        }
        int n = this.lSourcePaths.getSelectedIndex();
        if (n <= 0) {
            return;
        }
        Object e = this.mSources.get(n - 1);
        Object e2 = this.mSources.get(n);
        this.mSources.set(n - 1, e2);
        this.mSources.set(n, e);
        this.lSourcePaths.setSelectedIndex(n - 1);
        this.refreshButtons();
    }

    private void bJavaDocAddFolderActionPerformed(ActionEvent actionEvent) {
        if (this.platform == null) {
            return;
        }
        String string = this.browseFolder(this.fileChooserValue, NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_SelectJavaDocFolder"));
        if (string == null) {
            return;
        }
        this.fileChooserValue = string;
        URL uRL = J2MEPlatform.localfilepath2url(string);
        if (uRL != null) {
            this.mJavaDocs.addElement(new ListItem<URL>(uRL));
            this.refreshButtons();
        }
    }

    private void lJavaDocPathsValueChanged(ListSelectionEvent listSelectionEvent) {
        this.refreshButtons();
    }

    private void lSourcePathsValueChanged(ListSelectionEvent listSelectionEvent) {
        this.refreshButtons();
    }

    private void bSourceAddFolderActionPerformed(ActionEvent actionEvent) {
        if (this.platform == null) {
            return;
        }
        String string = this.browseFolder(this.fileChooserValue, NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_SelectSourceFolder"));
        if (string == null) {
            return;
        }
        this.fileChooserValue = string;
        FileObject fileObject = this.platform.resolveRelativePathToFileObject(string);
        if (fileObject != null) {
            this.mSources.addElement(new ListItem<FileObject>(fileObject));
            this.refreshButtons();
        }
    }

    private void bUtilitiesActionPerformed(ActionEvent actionEvent) {
        this.openTool(this.platform.findTool(UTILS_TOOL));
    }

    private void bPreferencesActionPerformed(ActionEvent actionEvent) {
        this.openTool(this.platform.findTool(PREFS_TOOL));
    }

    private void bJavaDocRemoveActionPerformed(ActionEvent actionEvent) {
        Object e = this.lJavaDocPaths.getSelectedValue();
        if (e == null) {
            return;
        }
        this.mJavaDocs.removeElement(e);
        this.refreshButtons();
    }

    private void bJavaDocAddArchiveActionPerformed(ActionEvent actionEvent) {
        if (this.platform == null) {
            return;
        }
        String string = this.browseArchive(this.fileChooserValue, NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_SelectJavaDocArchive"));
        if (string == null) {
            return;
        }
        this.fileChooserValue = string;
        URL uRL = J2MEPlatform.localfilepath2url(string);
        if (uRL != null) {
            this.mJavaDocs.addElement(new ListItem<URL>(uRL));
            this.refreshButtons();
        }
    }

    private void bSourceRemoveActionPerformed(ActionEvent actionEvent) {
        Object e = this.lSourcePaths.getSelectedValue();
        if (e == null) {
            return;
        }
        this.mSources.removeElement(e);
        this.refreshButtons();
    }

    private void bSourceAddArchiveActionPerformed(ActionEvent actionEvent) {
        if (this.platform == null) {
            return;
        }
        String string = this.browseArchive(this.fileChooserValue, NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_SelectSourceArchive"));
        if (string == null) {
            return;
        }
        this.fileChooserValue = string;
        FileObject fileObject = this.platform.resolveRelativePathToFileObject(string);
        if (fileObject != null) {
            this.mSources.addElement(new ListItem<FileObject>(fileObject));
            this.refreshButtons();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.saveWtkExtensions();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (this.jTextFieldPreverify.getDocument() == document) {
            this.platform.setPreverifyCmd(this.jTextFieldPreverify.getText());
        } else if (this.jTextFieldExec.getDocument() == document) {
            this.platform.setRunCmd(this.jTextFieldExec.getText());
        } else {
            this.platform.setDebugCmd(this.jTextFieldDebug.getText());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component == this.jTextFieldPreverify) {
            this.infoPanel.setText(this.preverifyInfo);
        } else if (component == this.jTextFieldExec) {
            this.infoPanel.setText(this.executionInfo);
        } else if (component == this.jTextFieldDebug) {
            this.infoPanel.setText(this.debuggerInfo);
        }
        this.infoPanel.setCaretPosition(0);
    }

    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getOppositeComponent();
        if (component != null && component != this.jTextFieldPreverify && component != this.jTextFieldExec && component != this.jTextFieldDebug && component != this.infoPanel) {
            this.infoPanel.setText("");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListItem<T> {
        T o;
        String str;

        ListItem(T t) {
            this.o = t;
            if (t instanceof FileObject) {
                this.str = J2MEPlatform.getFilePath((FileObject)t);
            } else if (t instanceof URL) {
                this.str = J2MEPlatform.getFilePath(URLMapper.findFileObject((URL)((URL)t)));
            }
            if (this.str == null) {
                this.str = t != null ? t.toString() : "";
            }
        }

        T getObject() {
            return this.o;
        }

        public String toString() {
            return this.str;
        }
    }
}

