/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ant.freeform.spi.HelpIDFragmentProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.ant.freeform");
    private static final Pattern VALIDATION = Pattern.compile("([A-Za-z0-9])+");

    private Util() {
    }

    public static String getAntScriptName(FileObject fileObject) {
        AntProjectCookie antProjectCookie = Util.getAntProjectCookie(fileObject);
        if (antProjectCookie == null) {
            return null;
        }
        Element element = antProjectCookie.getProjectElement();
        if (element == null) {
            return null;
        }
        String string = element.getAttribute("name");
        return string.length() > 0 ? string : null;
    }

    private static AntProjectCookie getAntProjectCookie(FileObject fileObject) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            err.notify(1, (Throwable)dataObjectNotFoundException);
            return null;
        }
        assert (dataObject != null);
        AntProjectCookie antProjectCookie = (AntProjectCookie)dataObject.getCookie(AntProjectCookie.class);
        if (antProjectCookie == null && fileObject.isData()) {
            try {
                antProjectCookie = Util.forceParse(fileObject);
            }
            catch (IOException iOException) {
                err.notify(1, (Throwable)iOException);
            }
            catch (SAXException sAXException) {
                err.log("Parse error in " + fileObject + ": " + sAXException);
            }
        }
        return antProjectCookie;
    }

    public static String getMergedHelpIDFragments(Project project) {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : project.getLookup().lookupAll(HelpIDFragmentProvider.class)) {
            String string = object2.getHelpIDFragment();
            if (string == null || !VALIDATION.matcher(string).matches()) {
                throw new IllegalStateException("HelpIDFragmentProvider \"" + object2 + "\" provided invalid help ID fragment \"" + string + "\".");
            }
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        StringBuffer stringBuffer = new StringBuffer();
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            stringBuffer.append((String)object2.next());
            if (!object2.hasNext()) continue;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    public static List<String> getAntScriptTargetNames(FileObject fileObject) {
        Set set;
        if (fileObject == null) {
            throw new IllegalArgumentException("Cannot call Util.getAntScriptTargetNames with null");
        }
        AntProjectCookie antProjectCookie = Util.getAntProjectCookie(fileObject);
        if (antProjectCookie == null) {
            return null;
        }
        try {
            set = TargetLister.getTargets((AntProjectCookie)antProjectCookie);
        }
        catch (IOException iOException) {
            err.notify(1, (Throwable)iOException);
            return null;
        }
        TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
        for (TargetLister.Target target : set) {
            if (target.isOverridden() || target.isInternal()) continue;
            treeSet.add(target.getName());
        }
        return new ArrayList<Object>(treeSet);
    }

    private static AntProjectCookie forceParse(FileObject fileObject) throws IOException, SAXException {
        Document document = XMLUtil.parse((InputSource)new InputSource(fileObject.getURL().toExternalForm()), (boolean)false, (boolean)true, (ErrorHandler)new ErrH(), null);
        return new TrivialAntProjectCookie(fileObject, document);
    }

    private static final class TrivialAntProjectCookie
    implements AntProjectCookie.ParseStatus {
        private final FileObject fo;
        private final Document doc;

        public TrivialAntProjectCookie(FileObject fileObject, Document document) {
            this.fo = fileObject;
            this.doc = document;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public File getFile() {
            return FileUtil.toFile((FileObject)this.fo);
        }

        public Document getDocument() {
            return this.doc;
        }

        public Element getProjectElement() {
            return this.doc.getDocumentElement();
        }

        public boolean isParsed() {
            return true;
        }

        public Throwable getParseException() {
            return null;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private static final class ErrH
    implements ErrorHandler {
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }
    }
}

