/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.gotodeclaration.type.CppTypeDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.type.TracingTypeDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.util.NameMatcher;
import org.netbeans.modules.cnd.gotodeclaration.util.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppTypeProvider
implements TypeProvider {
    private boolean isCancelled = false;
    private static final boolean PROCESS_LIBRARIES = true;
    private static final boolean TRACE = Boolean.getBoolean("cnd.type.provider.trace");

    public CppTypeProvider() {
        if (TRACE) {
            System.err.printf("CppTypeProvider.ctor\n", new Object[0]);
        }
    }

    public String name() {
        return "C/C++";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CppTypeProvider.class, (String)"TYPE_PROVIDER_DISPLAY_NAME");
    }

    public void computeTypeNames(TypeProvider.Context context, TypeProvider.Result result) {
        NameMatcher nameMatcher;
        Project project = context.getProject();
        String string = context.getText();
        SearchType searchType = context.getSearchType();
        if (TRACE) {
            System.err.printf("CppTypeProvider.getTypeNames(%s, %s, %s)\n", project, string, searchType);
        }
        if ((nameMatcher = NameMatcherFactory.createNameMatcher(string, searchType)) == null) {
            return;
        }
        if (project == null) {
            Collection collection = CsmModelAccessor.getModel().projects();
            if (!collection.isEmpty()) {
                HashSet<TypeDescriptor> hashSet = new HashSet<TypeDescriptor>();
                for (CsmProject csmProject : collection) {
                    this.processProject(csmProject, hashSet, nameMatcher);
                }
                for (CsmProject csmProject : collection) {
                    if (this.isCancelled) break;
                    HashSet<CsmProject> hashSet2 = new HashSet<CsmProject>();
                    this.processProjectLibs(csmProject, hashSet, nameMatcher, hashSet2);
                }
                result.addResult(new ArrayList<TypeDescriptor>(hashSet));
            }
        } else {
            HashSet<TypeDescriptor> hashSet = new HashSet<TypeDescriptor>();
            CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)project);
            this.processProject(csmProject, hashSet, nameMatcher);
            this.processProjectLibs(csmProject, hashSet, nameMatcher, new HashSet<CsmProject>());
            result.addResult(new ArrayList<TypeDescriptor>(hashSet));
        }
    }

    public void cancel() {
        if (TRACE) {
            System.err.printf("CppTypeProvider.cancel\n", new Object[0]);
        }
        this.isCancelled = true;
    }

    public void cleanup() {
        if (TRACE) {
            System.err.printf("CppTypeProvider.cleanup\n", new Object[0]);
        }
    }

    private static TypeDescriptor createTypeDescriptor(CsmClassifier csmClassifier) {
        CppTypeDescriptor cppTypeDescriptor = new CppTypeDescriptor(csmClassifier);
        return TRACE ? new TracingTypeDescriptor(cppTypeDescriptor) : cppTypeDescriptor;
    }

    private void processProjectLibs(CsmProject csmProject, Set<TypeDescriptor> set, NameMatcher nameMatcher, Set<CsmProject> set2) {
        for (CsmProject csmProject2 : csmProject.getLibraries()) {
            if (this.isCancelled) {
                return;
            }
            if (!csmProject2.isArtificial() || set2.contains(csmProject2)) continue;
            set2.add(csmProject2);
            this.processProject(csmProject2, set, nameMatcher);
        }
    }

    private void processProject(CsmProject csmProject, Set<TypeDescriptor> set, NameMatcher nameMatcher) {
        if (TRACE) {
            System.err.printf("processProject %s\n", csmProject.getName());
        }
        this.processNamespace(csmProject.getGlobalNamespace(), set, nameMatcher);
    }

    private void processNamespace(CsmNamespace csmNamespace, Set<TypeDescriptor> set, NameMatcher nameMatcher) {
        if (TRACE) {
            System.err.printf("processNamespace %s\n", csmNamespace.getQualifiedName());
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : csmNamespace.getDeclarations()) {
            if (this.isCancelled) {
                return;
            }
            this.processDeclaration((CsmDeclaration)csmOffsetableDeclaration, set, nameMatcher);
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : csmNamespace.getNestedNamespaces()) {
            if (this.isCancelled) {
                return;
            }
            this.processNamespace((CsmNamespace)csmOffsetableDeclaration, set, nameMatcher);
        }
    }

    private void processDeclaration(CsmDeclaration csmDeclaration, Set<TypeDescriptor> set, NameMatcher nameMatcher) {
        switch (csmDeclaration.getKind()) {
            case CLASS: 
            case UNION: 
            case STRUCT: {
                CsmClass csmClass = (CsmClass)csmDeclaration;
                if (nameMatcher.matches(((Object)csmDeclaration.getName()).toString())) {
                    set.add(CppTypeProvider.createTypeDescriptor((CsmClassifier)csmClass));
                }
                if (this.isCancelled) break;
                for (CsmMember csmMember : csmClass.getMembers()) {
                    if (this.isCancelled) continue;
                    this.processDeclaration((CsmDeclaration)csmMember, set, nameMatcher);
                }
                break;
            }
            case ENUM: 
            case TYPEDEF: {
                if (!nameMatcher.matches(((Object)csmDeclaration.getName()).toString())) break;
                set.add(CppTypeProvider.createTypeDescriptor((CsmClassifier)csmDeclaration));
                break;
            }
        }
    }
}

