/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogReader {
    private static boolean TRACE = false;
    private String workingDir;
    private final String root;
    private final String fileName;
    private List<SourceFileProperties> result;
    private static final String CURRENT_DIRECTORY = "Current working directory";
    private static final String ENTERING_DIRECTORY = "Entering directory";
    private static final String LABEL_CD = "cd ";
    private static final String INVOKE_SUN_C = "cc ";
    private static final String INVOKE_SUN_CC = "CC ";
    private static final String INVOKE_GNU_C = "gcc ";
    private static final String INVOKE_GNU_CC = "g++ ";
    private static final String MAKE_DELIMITER = ";";
    private static final FileFilter dirFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };

    public LogReader(String string, String string2) {
        this.root = string2;
        this.fileName = string;
        this.setWorkingDir(string2);
    }

    private void run() {
        if (TRACE) {
            System.out.println("LogReader is run for " + this.fileName);
        }
        this.result = new ArrayList<SourceFileProperties>();
        File file = new File(this.fileName);
        if (file.exists() && file.canRead()) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                int n = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray;
                    string = string.trim();
                    while (string.endsWith("\\") && (stringArray = bufferedReader.readLine()) != null) {
                        string = string.substring(0, string.length() - 1) + " " + stringArray.trim();
                    }
                    string = LogReader.trimBackApostropheCalls(string);
                    stringArray = string.split(";|\\|\\||&&");
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!this.parseLine(stringArray[i])) continue;
                        ++n;
                    }
                }
                if (TRACE) {
                    System.out.println("Files found: " + n);
                    System.out.println("Files included in result: " + this.result.size());
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public List<SourceFileProperties> getResults() {
        if (this.result == null) {
            this.run();
        }
        return this.result;
    }

    private boolean checkDirectoryChange(String string) {
        String string2 = null;
        String string3 = null;
        if (string.startsWith(CURRENT_DIRECTORY)) {
            string2 = string.substring(CURRENT_DIRECTORY.length() + 1).trim();
            if (TRACE) {
                string3 = "**>> by [Current working directory] ";
            }
        } else if (string.indexOf(ENTERING_DIRECTORY) >= 0) {
            String string4 = string.substring(string.indexOf(ENTERING_DIRECTORY) + ENTERING_DIRECTORY.length() + 1).trim();
            string2 = string4.replaceAll("`|'|\"", "");
            if (TRACE) {
                string3 = "**>> by [Entering directory] ";
            }
        } else if (string.startsWith(LABEL_CD)) {
            int n = string.indexOf(MAKE_DELIMITER);
            string2 = (n == -1 ? string : string.substring(0, n)).substring(LABEL_CD.length()).trim();
            if (TRACE) {
                string3 = "**>> by [ cd ] ";
            }
        } else if (string.startsWith("/") && string.indexOf(" ") < 0) {
            string2 = string.trim();
            if (TRACE) {
                string3 = "**>> by [just path string] ";
            }
        }
        if (string2 == null) {
            return false;
        }
        if (new File(string2).exists()) {
            if (TRACE) {
                System.err.print(string3);
            }
            this.setWorkingDir(string2);
            return true;
        }
        string2 = this.workingDir + File.separator + string2;
        if (new File(string2).exists()) {
            if (TRACE) {
                System.err.print(string3);
            }
            this.setWorkingDir(string2);
            return true;
        }
        return false;
    }

    private LineInfo testCompilerInvocation(String string) {
        LineInfo lineInfo = new LineInfo(string);
        int n = 0;
        int n2 = -1;
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_GNU_C)) >= 0) {
            lineInfo.compilerType = CompilerType.C;
            n2 = n + INVOKE_GNU_C.length();
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_GNU_CC)) >= 0) {
            lineInfo.compilerType = CompilerType.CPP;
            n2 = n + INVOKE_GNU_CC.length();
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_SUN_C)) >= 0) {
            lineInfo.compilerType = CompilerType.C;
            n2 = n + INVOKE_SUN_C.length();
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_SUN_CC)) >= 0) {
            lineInfo.compilerType = CompilerType.CPP;
            n2 = n + INVOKE_SUN_CC.length();
        }
        if (lineInfo.compilerType != CompilerType.UNKNOWN) {
            lineInfo.compileLine = string.substring(n);
            while (n2 < string.length() && (string.charAt(n2) == ' ' || string.charAt(n2) == '\t')) {
                ++n2;
            }
            if (n2 >= string.length() || string.charAt(n2) != '-') {
                lineInfo.compilerType = CompilerType.UNKNOWN;
            } else if (n > 0 && string.charAt(n - 1) != '/') {
                int n3;
                String string2 = string.substring(0, n - 1).trim();
                if (!(string.charAt(n - 1) == ' ' && (string2.equals("if") || string2.equals("then") || string2.equals("else")) || (n3 = string.substring(0, n).indexOf("libtool")) >= 0 && string.substring(n3, n).indexOf("compile") >= 0)) {
                    lineInfo.compilerType = CompilerType.UNKNOWN;
                    if (TRACE) {
                        System.err.println("Suspicious line: " + string);
                    }
                }
            }
        }
        return lineInfo;
    }

    private void setWorkingDir(String string) {
        if (TRACE) {
            System.err.println("**>> new working dir: " + string);
        }
        this.workingDir = string;
    }

    private boolean parseLine(String string) {
        if (this.checkDirectoryChange(string)) {
            return false;
        }
        if (this.workingDir == null) {
            return false;
        }
        if (!this.workingDir.startsWith(this.root)) {
            return false;
        }
        LineInfo lineInfo = this.testCompilerInvocation(string);
        if (lineInfo.compilerType != CompilerType.UNKNOWN) {
            this.gatherLine(lineInfo.compileLine, lineInfo.compilerType == CompilerType.CPP);
            return true;
        }
        return false;
    }

    private static String trimBackApostropheCalls(String string) {
        int n = string.indexOf(96);
        if (string.lastIndexOf(96) == n) {
            return string;
        }
        if (n < 0 || n == string.length() - 1) {
            return string;
        }
        String string2 = string.substring(0, n - 1);
        int n2 = (string = string.substring(n + 1)).indexOf(96);
        if (n2 < 0) {
            return string;
        }
        string2 = string2 + string.substring(n2 + 1);
        return LogReader.trimBackApostropheCalls(string2);
    }

    private boolean gatherLine(String string, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6 = DwarfSource.scanCommandLine(string);
        boolean bl2 = false;
        Object object7 = object6.iterator();
        while (object7.hasNext()) {
            object5 = object7.next();
            if (!((String)object5).startsWith("\"")) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            object7 = new ArrayList();
            for (int i = 0; i < object6.size(); ++i) {
                object4 = object6.get(i);
                if (((String)object4).startsWith("-D") && i + 1 < object6.size() && ((String)object6.get(i + 1)).startsWith("\"")) {
                    object3 = null;
                    int n = i + 1;
                    while (n < object6.size() && ((String)object6.get(n)).startsWith("\"")) {
                        object3 = object3 != null ? object3 + " " + (String)object6.get(n) : (String)object6.get(n);
                        i = n++;
                    }
                    object7.add((String)object4 + "'" + object3 + "'");
                    continue;
                }
                object7.add(object4);
            }
            object6 = object7;
        }
        object7 = null;
        object5 = new ArrayList();
        object4 = new HashMap();
        object3 = object6.iterator();
        String string2 = null;
        if (object3.hasNext() && (string2 = object3.next()).equals("+") && object3.hasNext()) {
            string2 = object3.next();
        }
        while (object3.hasNext()) {
            string2 = object3.next();
            if (string2.startsWith("-D")) {
                int n;
                if (string2.equals("-D") && object3.hasNext()) {
                    string2 = object3.next();
                }
                if ((n = ((String)(object2 = string2.substring(2))).indexOf(61)) > 0) {
                    object = ((String)object2).substring(n + 1).trim();
                    if (object.length() >= 2 && (object.charAt(0) == '\'' && object.charAt(object.length() - 1) == '\'' || object.charAt(0) == '\"' && object.charAt(object.length() - 1) == '\"')) {
                        object = object.substring(1, object.length() - 1);
                    }
                    object4.put(PathCache.getString(((String)object2).substring(0, n)), PathCache.getString((String)object));
                    continue;
                }
                object4.put(PathCache.getString((String)object2), null);
                continue;
            }
            if (string2.startsWith("-I")) {
                object2 = string2.substring(2);
                if (((String)object2).length() == 0 && object3.hasNext()) {
                    object2 = object3.next();
                }
                String string3 = PathCache.getString((String)object2);
                object5.add(string3);
                continue;
            }
            if (string2.startsWith("-isystem")) {
                object2 = string2.substring(8);
                if (((String)object2).length() == 0 && object3.hasNext()) {
                    object2 = object3.next();
                }
                String string4 = PathCache.getString((String)object2);
                object5.add(string4);
                continue;
            }
            if (string2.startsWith("-Y")) {
                object2 = string2.substring(2);
                if (((String)object2).length() == 0 && object3.hasNext()) {
                    object2 = object3.next();
                }
                if (!((String)object2).startsWith("I,")) continue;
                object2 = ((String)object2).substring(2);
                String string5 = PathCache.getString((String)object2);
                object5.add(string5);
                continue;
            }
            if (string2.equals("-K")) {
                if (!object3.hasNext()) continue;
                object3.next();
                continue;
            }
            if (string2.equals("-R")) {
                if (!object3.hasNext()) continue;
                object3.next();
                continue;
            }
            if (string2.equals("-l")) {
                if (!object3.hasNext()) continue;
                object3.next();
                continue;
            }
            if (string2.equals("-L")) {
                if (!object3.hasNext()) continue;
                object3.next();
                continue;
            }
            if (string2.equals("-M")) {
                if (!object3.hasNext()) continue;
                object3.next();
                continue;
            }
            if (string2.equals("-h")) {
                if (!object3.hasNext()) continue;
                object3.next();
                continue;
            }
            if (string2.equals("-o")) {
                if (!object3.hasNext()) continue;
                object3.next();
                continue;
            }
            if (string2.equals("-z")) {
                if (!object3.hasNext()) continue;
                object3.next();
                continue;
            }
            if (string2.equals("-MF")) {
                if (!object3.hasNext()) continue;
                object3.next();
                continue;
            }
            if (string2.equals("-MT")) {
                if (!object3.hasNext()) continue;
                object3.next();
                continue;
            }
            if (string2.equals("-fopenmp")) {
                object4.put("_OPENMP", null);
                continue;
            }
            if (string2.startsWith("-") || string2.startsWith("ccfe")) continue;
            if (string2.startsWith(">")) break;
            if (string2.endsWith(".il") || string2.endsWith(".o") || string2.endsWith(".a") || string2.endsWith(".so") || string2.endsWith(".so.1")) continue;
            if (object7 == null) {
                object7 = string2;
                continue;
            }
            if (!TRACE) continue;
            System.out.println("**** What is this [" + string2 + "] if previous was [" + (String)object7 + "]?");
            System.out.println("*> " + string);
        }
        if (object7 == null) {
            return false;
        }
        object2 = null;
        object2 = ((String)object7).startsWith("/") ? object7 : this.workingDir + "/" + (String)object7;
        File file = new File((String)object2);
        if (!file.exists() || !file.isFile()) {
            block43: {
                if (TRACE) {
                    System.err.println("**** Not found " + (String)object2);
                }
                if (!((String)object7).startsWith("/")) {
                    try {
                        object = new String[1];
                        boolean bl3 = LogReader.findFiles(new File(this.root), (String)object7, object);
                        if (object[0] == null) {
                            if (TRACE) {
                                System.err.println("** And there is no such file under root");
                            }
                        } else {
                            if (bl3) {
                                this.result.add(new CommandLineSource(bl, object[0], (String)object7, (List)object5, (Map)object4));
                                if (TRACE) {
                                    System.err.println("** Gotcha: " + object[0] + File.separator + (String)object7);
                                }
                                this.setWorkingDir(object[0]);
                                return true;
                            }
                            if (TRACE) {
                                System.err.println("**There are several candidates and I'm not clever enough yet to find correct one.");
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (!TRACE) break block43;
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
            if (TRACE) {
                System.err.println("" + (string.length() > 120 ? string.substring(0, 117) + ">>>" : string) + " [" + (String)object7 + "]");
            }
            return false;
        }
        if (TRACE && TRACE) {
            System.err.println("**** Gotcha: " + (String)object2);
        }
        this.result.add(new CommandLineSource(bl, this.workingDir, (String)object7, (List)object5, (Map)object4));
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Not enough parameters. Format: bla-bla-bla filename root");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        TRACE = true;
        LogReader logReader = new LogReader(string, string2);
        List<SourceFileProperties> list = logReader.getResults();
        System.err.print("\n*** Results: ");
        for (SourceFileProperties sourceFileProperties : list) {
            String string3 = sourceFileProperties.getItemName();
            while (string3.indexOf("../") == 0) {
                string3 = string3.substring(3);
            }
            System.err.print(string3 + " ");
        }
        System.err.println();
    }

    private static boolean findFiles(File file, String string, String[] stringArray) throws IOException {
        File file2 = new File(file.getAbsolutePath() + File.separator + string);
        if (file2.exists() && file2.isFile()) {
            if (stringArray[0] != null && !new File(stringArray[0] + File.separator + string).getCanonicalPath().equals(file2.getCanonicalPath())) {
                return false;
            }
            stringArray[0] = file.getAbsolutePath();
        }
        for (File file3 : file.listFiles(dirFilter)) {
            if (LogReader.findFiles(file3, string, stringArray)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandLineSource
    implements SourceFileProperties {
        private String compilePath;
        private String sourceName;
        private String fullName;
        private ItemProperties.LanguageKind language;
        private List<String> userIncludes;
        private List<String> systemIncludes = Collections.emptyList();
        private Map<String, String> userMacros;
        private Map<String, String> systemMacros = Collections.emptyMap();
        private Set<String> includedFiles = Collections.emptySet();

        private CommandLineSource(boolean bl, String string, String string2, List<String> list, Map<String, String> map) {
            this.language = bl ? ItemProperties.LanguageKind.CPP : ItemProperties.LanguageKind.C;
            this.compilePath = string;
            this.sourceName = string2;
            if (this.sourceName.startsWith("/")) {
                this.fullName = this.sourceName;
                this.sourceName = DwarfSource.getRelativePath(string, this.sourceName);
            } else {
                this.fullName = string + "/" + this.sourceName;
            }
            File file = new File(this.fullName);
            this.fullName = FileUtil.normalizeFile((File)file).getAbsolutePath();
            this.fullName = PathCache.getString(this.fullName);
            this.userIncludes = list;
            this.userMacros = map;
        }

        public String getCompilePath() {
            return this.compilePath;
        }

        public String getItemPath() {
            return this.fullName;
        }

        public String getItemName() {
            return this.sourceName;
        }

        public List<String> getUserInludePaths() {
            return this.userIncludes;
        }

        public List<String> getSystemInludePaths() {
            return this.systemIncludes;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        public Map<String, String> getSystemMacros() {
            return this.systemMacros;
        }

        public ItemProperties.LanguageKind getLanguageKind() {
            return this.language;
        }
    }

    private class LineInfo {
        public String compileLine;
        public CompilerType compilerType = CompilerType.UNKNOWN;

        LineInfo(String string) {
            this.compileLine = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CompilerType {
        CPP,
        C,
        UNKNOWN;

    }
}

