/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Vector;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class BreakpointsTreeModel
implements TreeModel {
    private Listener listener;
    private Vector listeners = new Vector();

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n3 = breakpointArray.length;
            for (int i = 0; i < n3; ++i) {
                String string = breakpointArray[i].getGroupName();
                if (string.equals("")) {
                    arrayList.add(breakpointArray[i]);
                    continue;
                }
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            if (n2 == 0) {
                return arrayList.toArray();
            }
            n2 = Math.min(arrayList.size(), n2);
            n = Math.min(arrayList.size(), n);
            return arrayList.subList(n, n2).toArray();
        }
        if (object instanceof String) {
            String string = (String)object;
            Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
            ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
            int n4 = breakpointArray.length;
            for (int i = 0; i < n4; ++i) {
                if (!breakpointArray[i].getGroupName().equals(string)) continue;
                arrayList.add(breakpointArray[i]);
            }
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            if (n2 == 0) {
                return arrayList.toArray();
            }
            n2 = Math.min(arrayList.size(), n2);
            n = Math.min(arrayList.size(), n);
            return arrayList.subList(n, n2).toArray();
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return Integer.MAX_VALUE;
        }
        if (object instanceof String) {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof Breakpoint) {
            return true;
        }
        if (object instanceof String) {
            return false;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private void fireTreeChanged(ModelEvent modelEvent) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(modelEvent);
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference model;

        public Listener(BreakpointsTreeModel breakpointsTreeModel) {
            this.model = new WeakReference<BreakpointsTreeModel>(breakpointsTreeModel);
            DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
            Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
            int n = breakpointArray.length;
            for (int i = 0; i < n; ++i) {
                breakpointArray[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private BreakpointsTreeModel getModel() {
            BreakpointsTreeModel breakpointsTreeModel = (BreakpointsTreeModel)this.model.get();
            if (breakpointsTreeModel == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
                Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
                int n = breakpointArray.length;
                for (int i = 0; i < n; ++i) {
                    breakpointArray[i].removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
            return breakpointsTreeModel;
        }

        public void breakpointAdded(Breakpoint breakpoint) {
            BreakpointsTreeModel breakpointsTreeModel = this.getModel();
            if (breakpointsTreeModel == null) {
                return;
            }
            breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
            breakpointsTreeModel.fireTreeChanged();
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
            BreakpointsTreeModel breakpointsTreeModel = this.getModel();
            if (breakpointsTreeModel == null) {
                return;
            }
            breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
            breakpointsTreeModel.fireTreeChanged();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BreakpointsTreeModel breakpointsTreeModel = this.getModel();
            if (breakpointsTreeModel == null) {
                return;
            }
            if (!(propertyChangeEvent.getSource() instanceof Breakpoint)) {
                return;
            }
            if (propertyChangeEvent.getPropertyName() == "groupName") {
                breakpointsTreeModel.fireTreeChanged();
            } else {
                Breakpoint breakpoint;
                String string;
                breakpointsTreeModel.fireTreeChanged((ModelEvent)new ModelEvent.NodeChanged((Object)breakpointsTreeModel, propertyChangeEvent.getSource()));
                if (propertyChangeEvent.getPropertyName() == "enabled" && (string = (breakpoint = (Breakpoint)propertyChangeEvent.getSource()).getGroupName()) != null) {
                    breakpointsTreeModel.fireTreeChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)breakpointsTreeModel, (Object)string, "BreakpointEnabled"));
                }
            }
        }
    }
}

