/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.modules.debugger.ui.Utils;
import org.netbeans.spi.project.ui.support.FileSensitiveActions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DebuggerAction
extends AbstractAction {
    private Object action;

    private DebuggerAction(Object object) {
        this.action = object;
        new Listener(this);
        this.setEnabled(DebuggerAction.isEnabled(this.getAction()));
    }

    public Object getAction() {
        return this.action;
    }

    public Object getValue(String string) {
        if (string == "Name") {
            return NbBundle.getMessage(DebuggerAction.class, (String)((String)super.getValue(string)));
        }
        Object object = super.getValue(string);
        if (string == "SmallIcon" && object instanceof String) {
            object = Utils.getIcon((String)object);
        }
        return object;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DebuggerAction.getActionsManager(this.action).postAction(this.action);
    }

    private static ActionsManager getCurrentEngineActionsManager() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine != null) {
            return debuggerEngine.getActionsManager();
        }
        return null;
    }

    private static boolean isEnabled(Object object) {
        ActionsManager actionsManager = DebuggerAction.getCurrentEngineActionsManager();
        if (actionsManager != null && actionsManager.isEnabled(object)) {
            return true;
        }
        return DebuggerManager.getDebuggerManager().getActionsManager().isEnabled(object);
    }

    private static ActionsManager getActionsManager(Object object) {
        ActionsManager actionsManager = DebuggerAction.getCurrentEngineActionsManager();
        if (actionsManager != null && actionsManager.isEnabled(object)) {
            return actionsManager;
        }
        return DebuggerManager.getDebuggerManager().getActionsManager();
    }

    public static DebuggerAction createContinueAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_CONTINUE);
        debuggerAction.putValue("Name", "CTL_Continue_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/Continue");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Continue.gif");
        return debuggerAction;
    }

    public static DebuggerAction createFixAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_FIX);
        debuggerAction.putValue("Name", "CTL_Fix_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/Fix");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Fix.gif");
        return debuggerAction;
    }

    public static DebuggerAction createKillAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_KILL);
        debuggerAction.putValue("Name", "CTL_KillAction_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/Kill");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Kill.gif");
        debuggerAction.setEnabled(false);
        return debuggerAction;
    }

    public static DebuggerAction createMakeCalleeCurrentAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_MAKE_CALLEE_CURRENT);
        debuggerAction.putValue("Name", "CTL_MakeCalleeCurrentAction_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/GoToCalledMethod");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/GoToCalledMethod.gif");
        return debuggerAction;
    }

    public static DebuggerAction createMakeCallerCurrentAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_MAKE_CALLER_CURRENT);
        debuggerAction.putValue("Name", "CTL_MakeCallerCurrentAction_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/GoToCallingMethod");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/GoToCallingMethod.gif");
        return debuggerAction;
    }

    public static DebuggerAction createPauseAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_PAUSE);
        debuggerAction.putValue("Name", "CTL_Pause_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/Pause");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Pause.gif");
        return debuggerAction;
    }

    public static DebuggerAction createPopTopmostCallAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_POP_TOPMOST_CALL);
        debuggerAction.putValue("Name", "CTL_PopTopmostCallAction_name");
        return debuggerAction;
    }

    public static DebuggerAction createRunIntoMethodAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_RUN_INTO_METHOD);
        debuggerAction.putValue("Name", "CTL_Run_into_method_action_name");
        return debuggerAction;
    }

    public static DebuggerAction createRunToCursorAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_RUN_TO_CURSOR);
        debuggerAction.putValue("Name", "CTL_Run_to_cursor_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/RunToCursor");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/RunToCursor.gif");
        return debuggerAction;
    }

    public static DebuggerAction createStepIntoAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_STEP_INTO);
        debuggerAction.putValue("Name", "CTL_Step_into_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/StepInto");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepInto.gif");
        return debuggerAction;
    }

    public static DebuggerAction createStepOutAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_STEP_OUT);
        debuggerAction.putValue("Name", "CTL_Step_out_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/StepOut");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepOut.gif");
        return debuggerAction;
    }

    public static DebuggerAction createStepOverAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_STEP_OVER);
        debuggerAction.putValue("Name", "CTL_Step_over_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/StepOver");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepOver.gif");
        return debuggerAction;
    }

    public static DebuggerAction createStepOperationAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_STEP_OPERATION);
        debuggerAction.putValue("Name", "CTL_Step_operation_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/StepOverOperation");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepOverOperation.gif");
        return debuggerAction;
    }

    public static DebuggerAction createToggleBreakpointAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
        debuggerAction.putValue("Name", "CTL_Toggle_breakpoint");
        return debuggerAction;
    }

    public static Action createDebugFileAction() {
        Action action = FileSensitiveActions.fileCommandAction((String)"debug.single", (String)NbBundle.getMessage(DebuggerAction.class, (String)"LBL_DebugSingleAction_Name"), (Icon)new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/debugger/resources/debugSingle.png")));
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/debugSingle.png");
        action.putValue("noIconInMenu", Boolean.TRUE);
        return action;
    }

    public static Action createDebugTestFileAction() {
        Action action = FileSensitiveActions.fileCommandAction((String)"debug.test.single", (String)NbBundle.getMessage(DebuggerAction.class, (String)"LBL_DebugTestSingleAction_Name"), (Icon)new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/debugger/resources/debugTestSingle.png")));
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/debugTestSingle.png");
        action.putValue("noIconInMenu", Boolean.TRUE);
        return action;
    }

    static class Listener
    extends DebuggerManagerAdapter
    implements ActionsManagerListener {
        private ActionsManager currentActionsManager;
        private WeakReference ref;

        Listener(DebuggerAction debuggerAction) {
            this.ref = new WeakReference<DebuggerAction>(debuggerAction);
            DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            DebuggerManager.getDebuggerManager().getActionsManager().addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            this.updateCurrentActionsManager();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            final DebuggerAction debuggerAction = this.getDebuggerAction();
            if (debuggerAction == null) {
                return;
            }
            this.updateCurrentActionsManager();
            final boolean bl = DebuggerAction.isEnabled(debuggerAction.getAction());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    debuggerAction.setEnabled(bl);
                }
            });
        }

        public void actionPerformed(Object object) {
        }

        public void actionStateChanged(Object object, boolean bl) {
            final DebuggerAction debuggerAction = this.getDebuggerAction();
            if (debuggerAction == null) {
                return;
            }
            if (object != debuggerAction.getAction()) {
                return;
            }
            final boolean bl2 = DebuggerAction.isEnabled(debuggerAction.getAction());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    debuggerAction.setEnabled(bl2);
                }
            });
        }

        private void updateCurrentActionsManager() {
            ActionsManager actionsManager = DebuggerAction.getCurrentEngineActionsManager();
            if (this.currentActionsManager == actionsManager) {
                return;
            }
            if (this.currentActionsManager != null) {
                this.currentActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            if (actionsManager != null) {
                actionsManager.addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            this.currentActionsManager = actionsManager;
        }

        private DebuggerAction getDebuggerAction() {
            DebuggerAction debuggerAction = (DebuggerAction)this.ref.get();
            if (debuggerAction == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
                DebuggerManager.getDebuggerManager().getActionsManager().removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
                if (this.currentActionsManager != null) {
                    this.currentActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
                }
                this.currentActionsManager = null;
                return null;
            }
            return debuggerAction;
        }
    }
}

