/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class BreakpointEnableAction
extends BooleanStateAction
implements ContextAwareAction {
    public boolean isEnabled() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(BreakpointEnableAction.class, (String)"CTL_enabled");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        BreakpointAnnotation breakpointAnnotation = (BreakpointAnnotation)((Object)lookup.lookup(BreakpointAnnotation.class));
        if (breakpointAnnotation != null) {
            BreakpointAwareAction breakpointAwareAction = new BreakpointAwareAction(breakpointAnnotation);
            return breakpointAwareAction;
        }
        return this;
    }

    private static class HiddenBooleanStateAction
    extends BooleanStateAction {
        private Reference<Breakpoint> bRef = new WeakReference<Object>(null);

        public HiddenBooleanStateAction() {
            this.setEnabled(true);
        }

        public void setFor(Breakpoint breakpoint) {
            this.bRef = new WeakReference<Breakpoint>(breakpoint);
            this.setBooleanState(breakpoint.isEnabled());
        }

        public String getName() {
            return NbBundle.getMessage(BreakpointEnableAction.class, (String)"CTL_enabled");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            Breakpoint breakpoint = this.bRef.get();
            if (breakpoint != null) {
                boolean bl = breakpoint.isEnabled();
                boolean bl2 = bl = !bl;
                if (bl) {
                    breakpoint.enable();
                } else {
                    breakpoint.disable();
                }
            }
        }
    }

    private class BreakpointAwareAction
    implements Action,
    Presenter.Menu,
    Presenter.Popup {
        private BreakpointAnnotation ann;
        private HiddenBooleanStateAction hba;

        public BreakpointAwareAction(BreakpointAnnotation breakpointAnnotation) {
            this.ann = breakpointAnnotation;
            this.hba = (HiddenBooleanStateAction)SystemAction.get(HiddenBooleanStateAction.class);
        }

        public Object getValue(String string) {
            return this.hba.getValue(string);
        }

        public void putValue(String string, Object object) {
            this.hba.putValue(string, object);
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isEnabled() {
            this.hba.setFor(this.ann.getBreakpoint());
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.hba.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.hba.removePropertyChangeListener(propertyChangeListener);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JMenuItem getMenuPresenter() {
            this.hba.setFor(this.ann.getBreakpoint());
            return this.hba.getMenuPresenter();
        }

        public JMenuItem getPopupPresenter() {
            this.hba.setFor(this.ann.getBreakpoint());
            return this.hba.getPopupPresenter();
        }
    }
}

