/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.nodes.property;

import com.sun.esb.management.common.ManagementRemoteException;
import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.swing.SwingUtilities;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationMBeanAttributeInfo;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.RuntimeManagementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.nodes.AppserverJBIMgmtNode;
import org.netbeans.modules.sun.manager.jbi.nodes.property.PropertySheetOwner;
import org.netbeans.modules.sun.manager.jbi.util.DoNotShowAgainMessage;
import org.netbeans.modules.sun.manager.jbi.util.StackTraceUtil;
import org.netbeans.modules.sun.manager.jbi.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SchemaBasedConfigPropertySupport<T>
extends PropertySupport.ReadWrite<T> {
    private static boolean promptForApplicationRestart = true;
    private static boolean promptForComponentRestart = true;
    private static boolean promptForServerRestart = true;
    protected Attribute attr;
    protected MBeanAttributeInfo info;
    protected AppserverJBIMgmtNode componentNode;
    protected PropertySheetOwner propertySheetOwner;

    SchemaBasedConfigPropertySupport(PropertySheetOwner propertySheetOwner, Class<T> clazz, Attribute attribute, MBeanAttributeInfo mBeanAttributeInfo) {
        super(attribute.getName(), clazz, mBeanAttributeInfo.getName(), Utils.getTooltip(mBeanAttributeInfo.getDescription()));
        this.attr = attribute;
        this.info = mBeanAttributeInfo;
        this.propertySheetOwner = propertySheetOwner;
        if (propertySheetOwner instanceof AppserverJBIMgmtNode) {
            this.componentNode = (AppserverJBIMgmtNode)propertySheetOwner;
        }
    }

    public T getValue() {
        if (this.info.isReadable()) {
            return (T)this.attr.getValue();
        }
        if (this.info.getType().equals("java.lang.String")) {
            return (T)"********";
        }
        return null;
    }

    public void setValue(T t) {
        if (StackTraceUtil.isCalledBy("org.openide.explorer.propertysheet.PropertyDialogManager", "cancelValue")) {
            return;
        }
        try {
            if (this.validate(t)) {
                this.attr = this.propertySheetOwner.setSheetProperty(this.getName(), t);
                if (this.componentNode != null && this.info instanceof JBIComponentConfigurationMBeanAttributeInfo) {
                    this.checkForPromptToRestart();
                }
            }
        }
        catch (Exception exception) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_SET_COMPONENT_CONFIG_PROPERTY_ERROR", (Object)exception.getMessage()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    protected boolean validate(T t) {
        return true;
    }

    protected void checkForPromptToRestart() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DoNotShowAgainMessage doNotShowAgainMessage;
                JBIComponentConfigurationMBeanAttributeInfo jBIComponentConfigurationMBeanAttributeInfo = (JBIComponentConfigurationMBeanAttributeInfo)SchemaBasedConfigPropertySupport.this.info;
                if (jBIComponentConfigurationMBeanAttributeInfo.isApplicationRestartRequired() && promptForApplicationRestart) {
                    String string = SchemaBasedConfigPropertySupport.this.componentNode.getName();
                    try {
                        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = SchemaBasedConfigPropertySupport.this.componentNode.getAppserverJBIMgmtController().getRuntimeManagementServiceWrapper();
                        List<String> list = runtimeManagementServiceWrapper.getServiceAssemblyNames(string, "server");
                        if (list.size() > 0 && (doNotShowAgainMessage = SchemaBasedConfigPropertySupport.this.promptForRestart("MSG_NEEDS_APPLICATION_RESTART", list.toString())).getDoNotShowAgain()) {
                            promptForApplicationRestart = false;
                        }
                    }
                    catch (ManagementRemoteException managementRemoteException) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)managementRemoteException.getMessage(), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                }
                if (jBIComponentConfigurationMBeanAttributeInfo.isComponentRestartRequired() && promptForComponentRestart && (doNotShowAgainMessage = SchemaBasedConfigPropertySupport.this.promptForRestart("MSG_NEEDS_COMPONENT_RESTART")).getDoNotShowAgain()) {
                    promptForComponentRestart = false;
                }
                if (jBIComponentConfigurationMBeanAttributeInfo.isServerRestartRequired() && promptForServerRestart && (doNotShowAgainMessage = SchemaBasedConfigPropertySupport.this.promptForRestart("MSG_NEEDS_SERVER_RESTART")).getDoNotShowAgain()) {
                    promptForServerRestart = false;
                }
            }
        });
    }

    private DoNotShowAgainMessage promptForRestart(String string) {
        DoNotShowAgainMessage doNotShowAgainMessage = new DoNotShowAgainMessage(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)string), 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)doNotShowAgainMessage);
        return doNotShowAgainMessage;
    }

    private DoNotShowAgainMessage promptForRestart(String string, String string2) {
        DoNotShowAgainMessage doNotShowAgainMessage = new DoNotShowAgainMessage(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)string, (Object)string2), 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)doNotShowAgainMessage);
        return doNotShowAgainMessage;
    }
}

