/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.treeeditor.newtype;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.api.property.PropertyUtil;
import org.netbeans.modules.xml.wsdl.ui.view.OperationConfigurationPanel;
import org.netbeans.modules.xml.wsdl.ui.view.PartAndElementOrTypeTableModel;
import org.netbeans.modules.xml.wsdl.ui.view.common.CommonMessagePanel;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.newtype.OperationPanel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.openide.DialogDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PortTypePanel
extends JPanel {
    private Project mProject;
    private WSDLModel mModel;
    private DialogDescriptor mDD;
    String mErrorMessage = null;
    private List<String> existingMessages = new ArrayList<String>();
    private String mWarningMessage;
    private CommonMessagePanel commonMessagePanel1;
    private OperationConfigurationPanel portTypeConfigurationPanel1;

    public PortTypePanel() {
        this.initComponents();
        this.initGUI();
    }

    public PortTypePanel(Project project, WSDLModel wSDLModel) {
        this.mProject = project;
        this.mModel = wSDLModel;
        this.initComponents();
        this.initGUI();
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.mDD = dialogDescriptor;
    }

    private void initComponents() {
        this.portTypeConfigurationPanel1 = new OperationConfigurationPanel(this.mProject, true, this.mModel, true);
        this.commonMessagePanel1 = new CommonMessagePanel();
        this.portTypeConfigurationPanel1.setFocusCycleRoot(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.portTypeConfigurationPanel1, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(96, 96, 96).add((Component)this.commonMessagePanel1, -1, 414, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.portTypeConfigurationPanel1, -1, -1, Short.MAX_VALUE).add(17, 17, 17).add((Component)this.commonMessagePanel1, -2, -1, -2).add(60, 60, 60)));
    }

    public OperationConfigurationPanel getPortTypeConfiguration() {
        return this.portTypeConfigurationPanel1;
    }

    private void initGUI() {
        Object object;
        ModelSource modelSource = this.mModel.getModelSource();
        String string = this.mModel.getDefinitions().getName();
        if (string == null && (object = (FileObject)modelSource.getLookup().lookup(FileObject.class)) != null) {
            string = object.getName();
        }
        object = string + NbBundle.getMessage(PortTypePanel.class, (String)"LBL_PortType_suffix");
        String string2 = NameGenerator.getInstance().generateUniquePortTypeName(this.mModel, (String)object);
        this.portTypeConfigurationPanel1.setPortTypeName(string2);
        String string3 = string + NbBundle.getMessage(PortTypePanel.class, (String)"LBL_Operation_suffix");
        this.portTypeConfigurationPanel1.setOperationName(string3);
        String[] stringArray = PropertyUtil.getAllMessages(this.mModel);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.existingMessages.add(stringArray[i]);
            }
        }
        String string4 = NameGenerator.getInstance().generateUniqueInputMessageName(string3, this.mModel);
        String string5 = NameGenerator.getInstance().generateUniqueOutputMessageName(string3, this.mModel);
        MessageNameTextChangeListener messageNameTextChangeListener = new MessageNameTextChangeListener();
        this.portTypeConfigurationPanel1.setInputMessages(stringArray, string4, messageNameTextChangeListener);
        this.portTypeConfigurationPanel1.setOutputMessages(stringArray, string5, messageNameTextChangeListener);
        this.portTypeConfigurationPanel1.setFaultMessages(stringArray, null, messageNameTextChangeListener);
        PortTypeNameTextChangeListener portTypeNameTextChangeListener = new PortTypeNameTextChangeListener();
        OperationNameTextChangeListener operationNameTextChangeListener = new OperationNameTextChangeListener();
        this.portTypeConfigurationPanel1.getPortTypeNameTextField().getDocument().addDocumentListener(portTypeNameTextChangeListener);
        this.portTypeConfigurationPanel1.getOperationNameTextField().getDocument().addDocumentListener(operationNameTextChangeListener);
        this.portTypeConfigurationPanel1.addPropertyChangeListener("FAULT_PARTS_LISTENER", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PortTypePanel.this.validateAll();
            }
        });
    }

    private boolean isValidName(String string) {
        try {
            boolean bl = Utils.isValidNCName((String)string);
            this.mErrorMessage = !bl ? NbBundle.getMessage(OperationPanel.class, (String)"ERR_MSG_INVALID_NAME", (Object)string) : null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.mErrorMessage == null;
    }

    private void validateAll() {
        boolean bl = this.isValidName(this.portTypeConfigurationPanel1.getPortTypeNameTextField().getText());
        if (!bl) {
            this.updateMessagePanel();
            return;
        }
        boolean bl2 = this.isPortTypeExists();
        if (bl2) {
            this.updateMessagePanel();
            return;
        }
        boolean bl3 = this.isValidName(this.portTypeConfigurationPanel1.getOperationNameTextField().getText());
        if (!bl3) {
            this.updateMessagePanel();
            return;
        }
        boolean bl4 = this.isValidInputMessage();
        if (!bl4) {
            this.updateMessagePanel();
            return;
        }
        boolean bl5 = this.isValidOutputMessage();
        if (!bl5) {
            this.updateMessagePanel();
            return;
        }
        boolean bl6 = this.isValidFaultMessage();
        if (!bl6) {
            this.updateMessagePanel();
            return;
        }
        this.mErrorMessage = null;
        this.mWarningMessage = null;
        this.updateMessagePanel();
    }

    private boolean isPortTypeExists() {
        boolean bl = false;
        String string = this.portTypeConfigurationPanel1.getPortTypeNameTextField().getText();
        PortType portType = (PortType)this.mModel.findComponentByName(string, PortType.class);
        if (portType != null) {
            this.mErrorMessage = NbBundle.getMessage(PortTypePanel.class, (String)"ERR_MSG_PORTTYPE_EXISTS", (Object)string);
            bl = true;
        }
        return bl;
    }

    private boolean isValidInputMessage() {
        boolean bl = true;
        String string = this.portTypeConfigurationPanel1.getInputMessageName();
        if (string != null && !this.isExistingMessage(string)) {
            bl = this.isValidName(string);
        }
        return bl;
    }

    private boolean isValidOutputMessage() {
        boolean bl = true;
        String string = this.portTypeConfigurationPanel1.getOutputMessageName();
        if (string != null && !this.isExistingMessage(string)) {
            bl = this.isValidName(string);
        }
        return bl;
    }

    private boolean isValidFaultMessage() {
        List<PartAndElementOrTypeTableModel.PartAndElementOrType> list;
        boolean bl = true;
        String string = this.portTypeConfigurationPanel1.getFaultMessageName();
        if (string != null && !this.isExistingMessage(string)) {
            bl = this.isValidName(string);
        }
        if ((list = this.portTypeConfigurationPanel1.getFaultMessageParts()) != null && list.isEmpty()) {
            if (!bl) {
                this.mErrorMessage = null;
                bl = true;
            }
            if (string != null && string.length() > 0) {
                this.mWarningMessage = NbBundle.getMessage(OperationPanel.class, (String)"WARNING_NO_PARTS_IN_FAULT", (Object)string);
                bl = false;
            }
        }
        return bl;
    }

    private boolean isExistingMessage(String string) {
        return this.existingMessages.contains(string);
    }

    private void updateMessagePanel() {
        if (this.mErrorMessage != null) {
            this.commonMessagePanel1.setErrorMessage(this.mErrorMessage);
            if (this.mDD != null) {
                this.mDD.setValid(false);
            }
        } else {
            if (this.mWarningMessage != null) {
                this.commonMessagePanel1.setWarningMessage(this.mWarningMessage);
            } else {
                this.commonMessagePanel1.setMessage("");
            }
            if (this.mDD != null) {
                this.mDD.setValid(true);
            }
        }
    }

    class MessageNameTextChangeListener
    implements DocumentListener {
        MessageNameTextChangeListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            PortTypePanel.this.validateAll();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            PortTypePanel.this.validateAll();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            PortTypePanel.this.validateAll();
        }
    }

    class OperationNameTextChangeListener
    implements DocumentListener {
        OperationNameTextChangeListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            PortTypePanel.this.validateAll();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            PortTypePanel.this.validateAll();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            PortTypePanel.this.validateAll();
        }
    }

    class PortTypeNameTextChangeListener
    implements DocumentListener {
        PortTypeNameTextChangeListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            PortTypePanel.this.validateAll();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            PortTypePanel.this.validateAll();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            PortTypePanel.this.validateAll();
        }
    }
}

