/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Action;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions.WidgetEditCookie;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.border.FilledBorder;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.layout.TableLayout;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.AbstractWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.MessageWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartTypeChooserWidget;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.ui.XAMUtils;
import org.openide.actions.NewAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartWidget
extends AbstractWidget<Part> {
    private LabelWidget nameWidget;
    private PartTypeChooserWidget typeWidget;
    private WidgetAction editorAction;
    public static final Layout ROW_LAYOUT = new TableLayout(2, 1, 0, 100);
    public static final Border CELL_BORDER = new FilledBorder(0, 0, 1, 8, null, Color.WHITE);
    private static final Border BORDER = new FilledBorder(new Insets(1, 0, 0, 0), new Insets(0, 0, 0, 0), new Color(0x999999), null);

    public PartWidget(Scene scene, Part part, Lookup lookup) {
        super(scene, part, lookup);
        this.setLayout(ROW_LAYOUT);
        this.setBorder(BORDER);
        this.editorAction = ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new TextFieldInplaceEditor(){

            public boolean isEnabled(Widget widget) {
                Part part = this.getPart(widget);
                if (part != null) {
                    return XAMUtils.isWritable((Model)part.getModel());
                }
                return false;
            }

            public String getText(Widget widget) {
                Part part = this.getPart(widget);
                String string = part != null ? part.getName() : null;
                return string == null ? "" : string;
            }

            public void setText(Widget widget, String string) {
                Part part = this.getPart(widget);
                if (part != null && !part.getName().equals(string)) {
                    SharedUtils.locallyRenameRefactor((Nameable)part, (String)string);
                }
            }

            private Part getPart(Widget widget) {
                PartWidget partWidget = this.getPartWidget(widget);
                return partWidget == null ? null : (Part)partWidget.getWSDLComponent();
            }

            private PartWidget getPartWidget(Widget widget) {
                for (Widget widget2 = widget; widget2 != null; widget2 = widget2.getParentWidget()) {
                    if (!(widget2 instanceof PartWidget)) continue;
                    return (PartWidget)widget2;
                }
                return null;
            }
        }, null);
        this.createContent();
        this.getActions().addAction((WidgetAction)new WidgetAction.Adapter(){

            public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
                if (widgetKeyEvent.getKeyCode() == 113 || widgetKeyEvent.getKeyCode() == 10) {
                    if (PartWidget.this.editorAction == null || PartWidget.this.nameWidget == null) {
                        return WidgetAction.State.REJECTED;
                    }
                    InplaceEditorProvider.EditorController editorController = ActionFactory.getInplaceEditorController((WidgetAction)PartWidget.this.editorAction);
                    if (editorController.openEditor((Widget)PartWidget.this.nameWidget)) {
                        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
                    }
                    return WidgetAction.State.CONSUMED;
                }
                return WidgetAction.State.REJECTED;
            }
        });
        this.getLookupContent().add((Object)new WidgetEditCookie(){

            public void edit() {
                InplaceEditorProvider.EditorController editorController = ActionFactory.getInplaceEditorController((WidgetAction)PartWidget.this.editorAction);
                editorController.openEditor((Widget)PartWidget.this.nameWidget);
            }

            public void close() {
                InplaceEditorProvider.EditorController editorController = ActionFactory.getInplaceEditorController((WidgetAction)PartWidget.this.editorAction);
                editorController.closeEditor(false);
            }
        });
    }

    PartTypeChooserWidget getPartChooserWidget() {
        return this.typeWidget;
    }

    private void createContent() {
        this.nameWidget = this.createLabelWidget(this.getScene(), this.getName());
        this.typeWidget = new PartTypeChooserWidget(this.getScene(), (Part)this.getWSDLComponent());
        this.addChild((Widget)this.nameWidget);
        this.addChild(this.typeWidget);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.getWSDLComponent()) {
            if (propertyChangeEvent.getPropertyName().equals("element") || propertyChangeEvent.getPropertyName().equals("type")) {
                this.typeWidget.typeOrElementChanged();
            } else if (propertyChangeEvent.getPropertyName().equals("name")) {
                this.nameWidget.setLabel(this.getName());
            }
        }
    }

    private String getName() {
        Part part = (Part)this.getWSDLComponent();
        String string = part.getName();
        if (string == null) {
            string = NbBundle.getMessage(PartWidget.class, (String)"LBL_Undefined");
        } else if (string.trim().equals("")) {
            string = NbBundle.getMessage(PartWidget.class, (String)"LBL_Empty");
        }
        return string;
    }

    private LabelWidget createLabelWidget(Scene scene, String string) {
        LabelWidget labelWidget = new LabelWidget(scene, string);
        labelWidget.setBorder(CELL_BORDER);
        labelWidget.setFont(scene.getDefaultFont());
        labelWidget.setAlignment(LabelWidget.Alignment.LEFT);
        labelWidget.setVerticalAlignment(LabelWidget.VerticalAlignment.CENTER);
        labelWidget.getActions().addAction(this.editorAction);
        return labelWidget;
    }

    @Override
    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        MessageWidget messageWidget;
        super.notifyStateChanged(objectState, objectState2);
        if (objectState.isSelected() ^ objectState2.isSelected() && (messageWidget = this.getMessageWidget()) != null) {
            messageWidget.updateButtonState();
        }
    }

    private MessageWidget getMessageWidget() {
        for (PartWidget partWidget = this; partWidget != null; partWidget = partWidget.getParentWidget()) {
            if (!(partWidget instanceof MessageWidget)) continue;
            return (MessageWidget)((Object)partWidget);
        }
        return null;
    }

    @Override
    protected Shape createSelectionShape() {
        Rectangle rectangle = this.getBounds();
        return new Rectangle2D.Double(rectangle.x + 1, rectangle.y + 2, rectangle.width - 2, rectangle.height - 3);
    }

    @Override
    protected void updateActions(List<Action> list) {
        super.updateActions(list);
        ListIterator<Action> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Action action = listIterator.next();
            if (!(action instanceof NewAction)) continue;
            listIterator.remove();
        }
    }
}

