/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.refactoring.CannotRefactorException;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.ActionHelper;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions.DragDropDecorator;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions.ExtendedDragDropAction;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions.WidgetEditCookie;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.border.FilledBorder;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.AbstractWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.ButtonWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.DnDHandler;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.ExpandableWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.ExpanderWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.HeaderWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.ImageLabelWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.MessagesUtils;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.OperationParameterWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartTypeChooserWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartnerScene;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetConstants;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetFactory;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetHelper;
import org.netbeans.modules.xml.xam.AbstractComponent;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.ui.XAMUtils;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageWidget
extends AbstractWidget<Message>
implements ExpandableWidget,
ActionListener,
DnDHandler {
    private static final boolean EXPANDED_DEFAULT = true;
    private ButtonWidget addPartButton;
    private ButtonWidget removePartButton;
    private Widget contentWidget;
    private Widget header;
    private final Widget tableWidget;
    private Widget buttons;
    private PartHitPointWidget partHitPointWidget;
    private PartHitPointPosition partHitPointPosition;
    private Object draggedObject;
    private ExpanderWidget expanderWidget;
    private WidgetAction editorAction;
    private ImageLabelWidget labelWidget;
    private static final Border BUTTONS_BORDER = new FilledBorder(new Insets(2, 0, 0, 0), new Insets(4, 8, 4, 8), Color.LIGHT_GRAY, Color.WHITE);
    private static final Border TABLE_BORDER = new FilledBorder(new Insets(2, 0, 0, 0), new Insets(0, 0, 0, 0), Color.LIGHT_GRAY, new Color(0x999999));
    private static final Image IMAGE = Utilities.loadImage((String)"org/netbeans/modules/xml/wsdl/ui/view/resources/message.png");
    public static final Border HEADER_CELL_BORDER = new FilledBorder(0, 0, 1, 8, null, new Color(0xEEEEEE));
    private static HitPointBorder hitPointBorder = new HitPointBorder();

    public MessageWidget(Scene scene, Message message, Lookup lookup) {
        super(scene, message, lookup);
        this.setMinimumSize(new Dimension(550, 0));
        this.editorAction = ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new TextFieldInplaceEditor(){

            public boolean isEnabled(Widget widget) {
                Message message = this.getMessage(widget);
                if (message != null) {
                    return XAMUtils.isWritable((Model)message.getModel());
                }
                return false;
            }

            public String getText(Widget widget) {
                Message message = this.getMessage(widget);
                String string = message != null ? message.getName() : null;
                return string != null ? string : "";
            }

            public void setText(Widget widget, String string) {
                Message message = this.getMessage(widget);
                if (message != null && !message.getName().equals(string)) {
                    SharedUtils.locallyRenameRefactor((Nameable)message, (String)string);
                }
            }

            private Message getMessage(Widget widget) {
                MessageWidget messageWidget = this.getMessageWidget(widget);
                return messageWidget != null ? (Message)messageWidget.getWSDLComponent() : null;
            }

            private MessageWidget getMessageWidget(Widget widget) {
                for (Widget widget2 = widget; widget2 != null; widget2 = widget2.getParentWidget()) {
                    if (!(widget2 instanceof MessageWidget)) continue;
                    return (MessageWidget)widget2;
                }
                return null;
            }
        }, null);
        boolean bl = ExpanderWidget.isExpanded(this, true);
        this.expanderWidget = new ExpanderWidget(scene, this, bl);
        this.contentWidget = new Widget(scene);
        this.contentWidget.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.addPartButton = new ButtonWidget(scene, NbBundle.getMessage(MessageWidget.class, (String)"LBL_MessageWidget_AddPart"), true);
        this.addPartButton.setActionListener(this);
        this.removePartButton = new ButtonWidget(scene, NbBundle.getMessage(MessageWidget.class, (String)"LBL_MessageWidget_RemovePart"));
        this.removePartButton.setActionListener(this);
        this.removePartButton.setButtonEnabled(false);
        this.buttons = new Widget(scene);
        this.buttons.setBorder(BUTTONS_BORDER);
        this.buttons.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)8));
        this.buttons.addChild((Widget)this.addPartButton);
        this.buttons.addChild((Widget)this.removePartButton);
        this.setBorder(WidgetConstants.OUTER_BORDER);
        this.setOpaque(true);
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.header = this.createHeader(this.getScene());
        this.addChild(0, this.header);
        this.tableWidget = this.createEmptyTable(scene);
        this.refreshParts();
        this.contentWidget.addChild(this.tableWidget);
        this.contentWidget.addChild(this.buttons);
        this.updateButtonState();
        this.addChild(this.contentWidget);
        this.contentWidget.setVisible(bl);
        this.getActions().addAction(((PartnerScene)scene).getDnDAction());
        this.getActions().addAction((WidgetAction)new WidgetAction.Adapter(){

            public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
                if (widgetKeyEvent.getKeyCode() == 10 && (widgetKeyEvent.getModifiersEx() & 0x40) != 0) {
                    if (MessageWidget.this.header != null) {
                        return MessageWidget.this.header.getActions().keyPressed(widget, widgetKeyEvent);
                    }
                } else if (widgetKeyEvent.getKeyCode() == 113 || widgetKeyEvent.getKeyCode() == 10) {
                    if (MessageWidget.this.editorAction == null || MessageWidget.this.labelWidget == null) {
                        return WidgetAction.State.REJECTED;
                    }
                    InplaceEditorProvider.EditorController editorController = ActionFactory.getInplaceEditorController((WidgetAction)MessageWidget.this.editorAction);
                    if (editorController.openEditor((Widget)MessageWidget.this.labelWidget)) {
                        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
                    }
                    return WidgetAction.State.CONSUMED;
                }
                return WidgetAction.State.REJECTED;
            }
        });
        this.getLookupContent().add((Object)new WidgetEditCookie(){

            public void edit() {
                InplaceEditorProvider.EditorController editorController = ActionFactory.getInplaceEditorController((WidgetAction)MessageWidget.this.editorAction);
                editorController.openEditor((Widget)MessageWidget.this.labelWidget);
            }

            public void close() {
                InplaceEditorProvider.EditorController editorController = ActionFactory.getInplaceEditorController((WidgetAction)MessageWidget.this.editorAction);
                editorController.closeEditor(false);
            }
        });
    }

    void updateButtonState() {
        boolean bl = false;
        if (this.tableWidget != null && this.tableWidget.getChildren() != null) {
            for (Widget widget : this.tableWidget.getChildren()) {
                if (!(widget instanceof PartWidget)) continue;
                bl |= widget.getState().isSelected();
            }
        }
        if (bl != this.removePartButton.isButtonEnabled()) {
            this.removePartButton.setButtonEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addPartButton) {
            Message message = (Message)this.getWSDLComponent();
            WSDLModel wSDLModel = message.getModel();
            Part part = null;
            try {
                if (wSDLModel.startTransaction()) {
                    part = wSDLModel.getFactory().createPart();
                    part.setName(NameGenerator.getInstance().generateUniqueMessagePartName(message));
                    part.setType(MessagesUtils.getDefaultTypeReference(wSDLModel));
                    message.addPart(part);
                }
            }
            finally {
                wSDLModel.endTransaction();
            }
            if (part != null) {
                ActionHelper.selectNode((WSDLComponent)part);
                WidgetEditCookie widgetEditCookie = (WidgetEditCookie)WidgetHelper.getWidgetLookup((WSDLComponent)part, this.getScene()).lookup(WidgetEditCookie.class);
                if (widgetEditCookie != null) {
                    widgetEditCookie.edit();
                }
            }
        } else if (actionEvent.getSource() == this.removePartButton) {
            for (Widget widget : this.tableWidget.getChildren()) {
                PartWidget partWidget;
                if (!(widget instanceof PartWidget) || !(partWidget = (PartWidget)widget).getState().isSelected()) continue;
                Part part = (Part)partWidget.getWSDLComponent();
                try {
                    SharedUtils.silentDeleteRefactor((NamedReferenceable)part, (boolean)true);
                }
                catch (CannotRefactorException cannotRefactorException) {
                    SharedUtils.showDeleteRefactoringUI((NamedReferenceable)part);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                return;
            }
        }
    }

    private PartHitPointPosition getPartHitPointPosition(Point point) {
        Cloneable cloneable;
        Object object;
        if (!this.hasParts()) {
            return new PartHitPointPosition(0, 0);
        }
        Widget[] widgetArray = this.tableWidget.getChildren().toArray(new Widget[0]);
        int n = 0;
        boolean bl = false;
        int n2 = ((Message)this.getWSDLComponent()).getParts().size();
        for (Widget widget : widgetArray) {
            if (widget instanceof PartWidget) {
                object = (PartWidget)widget;
                cloneable = object.convertSceneToLocal(point);
                Rectangle rectangle = object.getBounds();
                if (object.isHitAt((Point)cloneable) && rectangle.getCenterX() < (double)((Point)cloneable).x) {
                    int n3;
                    int n4 = n3 = bl ? n + 1 : n;
                    if (n3 < n2) {
                        return new PartHitPointPosition(n3, 1);
                    }
                }
                ++n;
                continue;
            }
            if (widget != this.partHitPointWidget) continue;
            object = this.partHitPointWidget.convertSceneToLocal(point);
            cloneable = this.partHitPointWidget.getBounds();
            if (this.partHitPointWidget.isHitAt((Point)object) && ((RectangularShape)cloneable).getCenterX() < (double)((Point)object).x && n < n2) {
                return new PartHitPointPosition(n, 1);
            }
            bl = true;
        }
        if (this.partHitPointWidget != null && this.partHitPointWidget.getParentWidget() != null && this.partHitPointWidget.isHitAt(this.partHitPointWidget.convertSceneToLocal(point))) {
            return this.partHitPointPosition;
        }
        n = 0;
        for (Widget widget : widgetArray) {
            if (!(widget instanceof PartWidget)) continue;
            object = (PartWidget)widget;
            cloneable = object.convertSceneToLocal(point);
            if ((double)((Point)cloneable).y < object.getBounds().getCenterY()) {
                return new PartHitPointPosition(n, 0);
            }
            ++n;
        }
        return new PartHitPointPosition(n2, 0);
    }

    private boolean hasParts() {
        Collection collection = ((Message)this.getWSDLComponent()).getParts();
        if (collection == null) {
            return false;
        }
        return !collection.isEmpty();
    }

    private String getPartCount() {
        Collection collection = ((Message)this.getWSDLComponent()).getParts();
        int n = collection == null ? 0 : collection.size();
        return n == 1 ? "(1 part)" : "(" + n + " parts)";
    }

    private void showHitPoint(Point point, Object object) {
        this.draggedObject = object;
        if (this.partHitPointWidget == null) {
            this.partHitPointWidget = new PartHitPointWidget(this.getScene());
        }
        PartHitPointPosition partHitPointPosition = this.getPartHitPointPosition(point);
        PartHitPointPosition partHitPointPosition2 = this.partHitPointPosition;
        this.tableWidget.setVisible(true);
        if (!partHitPointPosition.equals(partHitPointPosition2)) {
            this.partHitPointWidget.removeFromParent();
            if (partHitPointPosition.column == 0) {
                this.tableWidget.addChild(partHitPointPosition.row + 1, (Widget)this.partHitPointWidget);
            }
        }
        this.partHitPointPosition = partHitPointPosition;
    }

    private void hideHitPoint() {
        if (this.partHitPointWidget == null) {
            return;
        }
        this.partHitPointWidget.removeFromParent();
        if (!this.hasParts()) {
            this.tableWidget.setVisible(false);
        }
        this.partHitPointPosition = null;
        this.draggedObject = null;
    }

    private String getName() {
        String string = ((Message)this.getWSDLComponent()).getName();
        if (string == null) {
            string = NbBundle.getMessage(MessageWidget.class, (String)"LBL_Undefined");
        } else if (string.trim().equals("")) {
            string = NbBundle.getMessage(MessageWidget.class, (String)"LBL_Empty");
        }
        return string;
    }

    private ImageLabelWidget createHeaderLabel(Scene scene) {
        String string = this.getName();
        ImageLabelWidget imageLabelWidget = new ImageLabelWidget(scene, IMAGE, string, this.getPartCount());
        imageLabelWidget.getActions().addAction(this.editorAction);
        return imageLabelWidget;
    }

    private Widget createHeader(Scene scene) {
        HeaderWidget headerWidget = new HeaderWidget(scene, this.expanderWidget);
        this.labelWidget = this.createHeaderLabel(scene);
        headerWidget.addChild(this.labelWidget);
        if (this.expanderWidget.getParentWidget() != null) {
            this.expanderWidget.getParentWidget().removeChild((Widget)this.expanderWidget);
        }
        headerWidget.addChild(this.expanderWidget);
        headerWidget.setLayout(WidgetConstants.HEADER_LAYOUT);
        headerWidget.setBorder(WidgetConstants.GRADIENT_BLUE_WHITE_BORDER);
        headerWidget.getActions().addAction((WidgetAction)new ExtendedDragDropAction(new DragDropDecorator(){

            public Widget createDragWidget(Scene scene) {
                return new ImageLabelWidget(scene, IMAGE, ((Message)MessageWidget.this.getWSDLComponent()).getName());
            }
        }, (Widget)((PartnerScene)this.getScene()).getDragOverLayer(), new ConnectProvider(){

            public Widget resolveTargetWidget(Scene scene, Point point) {
                return null;
            }

            public ConnectorState isTargetWidget(Widget widget, Widget widget2) {
                if (widget2 instanceof OperationParameterWidget) {
                    return ConnectorState.ACCEPT;
                }
                return ConnectorState.REJECT;
            }

            public boolean isSourceWidget(Widget widget) {
                return widget == MessageWidget.this.header;
            }

            public boolean hasCustomTargetWidgetResolver(Scene scene) {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void createConnection(Widget widget, Widget widget2) {
                OperationParameter operationParameter;
                Node node;
                if (widget2 instanceof OperationParameterWidget && (node = ((OperationParameterWidget)widget2).getNode()) != null && (operationParameter = (OperationParameter)node.getLookup().lookup(OperationParameter.class)) != null) {
                    Message message = (Message)MessageWidget.this.getWSDLComponent();
                    WSDLModel wSDLModel = message.getModel();
                    try {
                        wSDLModel.startTransaction();
                        operationParameter.setMessage(operationParameter.createReferenceTo((ReferenceableWSDLComponent)message, Message.class));
                    }
                    finally {
                        if (wSDLModel.isIntransaction()) {
                            wSDLModel.endTransaction();
                        }
                    }
                    ActionHelper.selectNode((WSDLComponent)operationParameter);
                }
            }
        }, 2L));
        return headerWidget;
    }

    private Widget createPartsTableHeaderCell(Scene scene, String string) {
        LabelWidget labelWidget = new LabelWidget(scene, string);
        labelWidget.setBorder(HEADER_CELL_BORDER);
        labelWidget.setFont(scene.getDefaultFont());
        labelWidget.setAlignment(LabelWidget.Alignment.CENTER);
        labelWidget.setVerticalAlignment(LabelWidget.VerticalAlignment.CENTER);
        return labelWidget;
    }

    private Widget createPartsTableHeader(Scene scene) {
        Widget widget = new Widget(scene);
        widget.addChild(this.createPartsTableHeaderCell(scene, NbBundle.getMessage(MessageWidget.class, (String)"LBL_MessageWidget_PartName")));
        widget.addChild(this.createPartsTableHeaderCell(scene, NbBundle.getMessage(MessageWidget.class, (String)"LBL_MessageWidget_PartElementOrType")));
        widget.setLayout(PartWidget.ROW_LAYOUT);
        return widget;
    }

    private void refreshParts() {
        List list = ((Message)this.getWSDLComponent()).getChildren(Part.class);
        if (list == null || list.isEmpty()) {
            this.tableWidget.setVisible(false);
            this.updateButtonState();
            return;
        }
        if (!this.tableWidget.isVisible()) {
            this.tableWidget.setVisible(true);
        }
        WidgetFactory widgetFactory = WidgetFactory.getInstance();
        for (Part part : list) {
            this.tableWidget.addChild(widgetFactory.getOrCreateWidget(this.getScene(), (WSDLComponent)part, this.getLookup(), this.tableWidget));
        }
        this.updateButtonState();
    }

    private Widget createEmptyTable(Scene scene) {
        Widget widget = new Widget(scene);
        widget.addChild(this.createPartsTableHeader(scene));
        widget.setBorder(TABLE_BORDER);
        widget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)0));
        return widget;
    }

    @Override
    public void collapseWidget(ExpanderWidget expanderWidget) {
        this.contentWidget.setVisible(false);
    }

    @Override
    public void expandWidget(ExpanderWidget expanderWidget) {
        this.contentWidget.setVisible(true);
    }

    @Override
    public void expandWidget() {
        this.expanderWidget.setExpanded(true);
    }

    @Override
    public void collapseWidget() {
        this.expanderWidget.setExpanded(false);
    }

    @Override
    public boolean isCollapsed() {
        return !this.contentWidget.isVisible();
    }

    @Override
    protected Shape createSelectionShape() {
        Rectangle rectangle = this.getBounds();
        return new Rectangle2D.Double(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
    }

    void update() {
        this.labelWidget.setComment(this.getPartCount());
    }

    @Override
    public void childrenAdded() {
        this.update();
        this.refreshParts();
    }

    @Override
    public void updated() {
        this.labelWidget.setLabel(this.getName());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getSource() == this.getWSDLComponent() && propertyChangeEvent.getPropertyName().equals("part") && propertyChangeEvent.getOldValue() != null) {
            this.update();
            WidgetHelper.removeObjectFromScene(this.getScene(), propertyChangeEvent.getOldValue());
            this.refreshParts();
        }
    }

    @Override
    public void dragExit() {
        this.hideHitPoint();
        this.getScene().validate();
    }

    @Override
    public boolean dragOver(Point point, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
        if (this.isCollapsed()) {
            return false;
        }
        Transferable transferable = widgetDropTargetDragEvent.getTransferable();
        if (transferable != null) {
            for (Node node : Utility.getNodes(transferable)) {
                SchemaComponent schemaComponent = MessagesUtils.extractSchemaComponent(node);
                if (schemaComponent == null) continue;
                this.showHitPoint(point, schemaComponent);
                this.getScene().validate();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Point point, WidgetAction.WidgetDropTargetDropEvent widgetDropTargetDropEvent) {
        Object object;
        if (this.isCollapsed()) {
            return false;
        }
        SchemaComponent schemaComponent = (SchemaComponent)this.draggedObject;
        PartHitPointPosition partHitPointPosition = this.partHitPointPosition;
        this.hideHitPoint();
        this.getScene().validate();
        if (schemaComponent == null || partHitPointPosition == null) {
            return false;
        }
        Message message = (Message)this.getWSDLComponent();
        WSDLModel wSDLModel = message.getModel();
        boolean bl = false;
        Part part = null;
        if (wSDLModel.startTransaction()) {
            try {
                if (partHitPointPosition.column == 0) {
                    part = wSDLModel.getFactory().createPart();
                    part.setName(NameGenerator.getInstance().generateUniqueMessagePartName(message));
                    ((AbstractComponent)message).insertAtIndex("part", (Component)part, partHitPointPosition.row);
                    bl = true;
                } else {
                    object = message.getParts().toArray(new Part[0]);
                    part = object[partHitPointPosition.row];
                }
                if (part != null) {
                    if (schemaComponent instanceof GlobalType) {
                        part.setType(wSDLModel.getDefinitions().createSchemaReference((ReferenceableSchemaComponent)((GlobalType)schemaComponent), GlobalType.class));
                        part.setElement(null);
                    } else {
                        part.setElement(wSDLModel.getDefinitions().createSchemaReference((ReferenceableSchemaComponent)((GlobalElement)schemaComponent), GlobalElement.class));
                        part.setType(null);
                    }
                } else {
                    wSDLModel.rollbackTransaction();
                }
            }
            finally {
                if (wSDLModel.isIntransaction()) {
                    wSDLModel.endTransaction();
                }
            }
        }
        ActionHelper.selectNode(part);
        if (bl && (object = (WidgetEditCookie)WidgetHelper.getWidgetLookup((WSDLComponent)part, this.getScene()).lookup(WidgetEditCookie.class)) != null) {
            object.edit();
        }
        return true;
    }

    @Override
    public void expandForDragAndDrop() {
        this.expanderWidget.setExpanded(true);
    }

    @Override
    public Object hashKey() {
        QName qName;
        Message message = (Message)this.getWSDLComponent();
        if (message != null && (qName = Utility.getQNameForWSDLComponent((WSDLComponent)message, message.getModel())) != null) {
            return qName;
        }
        return this;
    }

    @Override
    protected void paintChildren() {
        super.paintChildren();
        if (this.partHitPointPosition == null) {
            return;
        }
        if (this.partHitPointPosition.column != 1) {
            return;
        }
        int n = this.partHitPointPosition.row;
        PartWidget partWidget = (PartWidget)this.tableWidget.getChildren().get(n + 1);
        PartTypeChooserWidget partTypeChooserWidget = partWidget.getPartChooserWidget();
        ButtonWidget buttonWidget = partTypeChooserWidget.getPartTypeChooserButton();
        Rectangle rectangle = partWidget.convertLocalToScene(partWidget.getBounds());
        Rectangle rectangle2 = partTypeChooserWidget.convertLocalToScene(partTypeChooserWidget.getBounds());
        Rectangle rectangle3 = buttonWidget.convertLocalToScene(buttonWidget.getBounds());
        int n2 = this.convertSceneToLocal((Point)rectangle2.getLocation()).x;
        int n3 = this.convertSceneToLocal((Point)rectangle.getLocation()).y + 1;
        int n4 = rectangle3.x - rectangle2.x;
        int n5 = rectangle.height - 1;
        Graphics2D graphics2D = this.getGraphics();
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n2 + 2, n3 + 2, n4 - 4, n5 - 4, 6.0f, 6.0f);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fill(float_);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setPaint(WidgetConstants.HIT_POINT_BORDER);
        graphics2D.draw(float_);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    private static class PartHitPointPosition {
        public final int row;
        public final int column;

        public PartHitPointPosition(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        public boolean equals(PartHitPointPosition partHitPointPosition) {
            if (partHitPointPosition == null) {
                return false;
            }
            return partHitPointPosition.row == this.row && partHitPointPosition.column == this.column;
        }
    }

    private static class HitPointBorder
    implements Border {
        private HitPointBorder() {
        }

        public Insets getInsets() {
            return new Insets(3, 2, 2, 2);
        }

        public void paint(Graphics2D graphics2D, Rectangle rectangle) {
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fill(rectangle);
            graphics2D.setPaint(new Color(0x888888));
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, 1);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setPaint(WidgetConstants.HIT_POINT_BORDER);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.drawRoundRect(rectangle.x + 2, rectangle.y + 3, rectangle.width - 4, rectangle.height - 5, 6, 6);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
        }

        public boolean isOpaque() {
            return true;
        }
    }

    private static class PartHitPointWidget
    extends LabelWidget {
        public PartHitPointWidget(Scene scene) {
            super(scene, " ");
            this.setBorder(hitPointBorder);
            this.setFont(scene.getDefaultFont());
        }
    }
}

