/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.DnDHandler;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartnerScene;

public class DnDAction
extends WidgetAction.Adapter {
    private DnDHandler currentHandler = null;
    private long lastId = Long.MIN_VALUE;
    private long dragEnterTime = -1L;
    private List<DnDHandler> priorHandlers;
    private static final long EXPAND_TIMEOUT = 1500L;

    public WidgetAction.State dragExit(Widget widget, WidgetAction.WidgetDropTargetEvent widgetDropTargetEvent) {
        if (this.isEventProcessed(widgetDropTargetEvent.getEventID())) {
            return WidgetAction.State.REJECTED;
        }
        ((PartnerScene)widget.getScene()).getDragOverLayer().resetLayer();
        if (this.currentHandler != null) {
            this.currentHandler.dragExit();
            this.currentHandler = null;
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State dragOver(Widget widget, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
        if (this.isEventProcessed(widgetDropTargetDragEvent.getEventID())) {
            return WidgetAction.State.REJECTED;
        }
        Point point = widget.convertLocalToScene(widgetDropTargetDragEvent.getPoint());
        boolean bl = false;
        ((PartnerScene)widget.getScene()).getDragOverLayer().dragOver(point, widgetDropTargetDragEvent);
        if (this.priorHandlers != null && !this.priorHandlers.isEmpty()) {
            if (this.currentHandler != null && this.priorHandlers.contains(this.currentHandler)) {
                bl = this.currentHandler.dragOver(point, widgetDropTargetDragEvent);
            }
            if (!bl) {
                for (DnDHandler dnDHandler : this.priorHandlers) {
                    if (!dnDHandler.dragOver(point, widgetDropTargetDragEvent)) continue;
                    if (this.currentHandler != null && this.currentHandler != dnDHandler) {
                        this.currentHandler.dragExit();
                    }
                    this.currentHandler = dnDHandler;
                    bl = true;
                    break;
                }
            }
        }
        if (!bl) {
            if (widget == this.currentHandler) {
                if (this.dragEnterTime >= 0L && System.currentTimeMillis() - this.dragEnterTime >= 1500L) {
                    this.currentHandler.expandForDragAndDrop();
                    this.dragEnterTime = -1L;
                }
                bl = this.currentHandler.dragOver(point, widgetDropTargetDragEvent);
            } else if (widget instanceof DnDHandler) {
                if (this.currentHandler != null) {
                    this.currentHandler.dragExit();
                }
                this.currentHandler = (DnDHandler)widget;
                this.dragEnterTime = this.currentHandler.isCollapsed() ? System.currentTimeMillis() : -1L;
                bl = this.currentHandler.dragOver(point, widgetDropTargetDragEvent);
            } else if (this.currentHandler != null) {
                this.currentHandler.dragExit();
                this.currentHandler = null;
                this.dragEnterTime = -1L;
            }
        }
        if (bl) {
            widgetDropTargetDragEvent.acceptDrag(widgetDropTargetDragEvent.getDropAction());
            return WidgetAction.State.CONSUMED;
        }
        widgetDropTargetDragEvent.rejectDrag();
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State dragEnter(Widget widget, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
        return this.dragOver(widget, widgetDropTargetDragEvent);
    }

    public WidgetAction.State drop(Widget widget, WidgetAction.WidgetDropTargetDropEvent widgetDropTargetDropEvent) {
        if (this.isEventProcessed(widgetDropTargetDropEvent.getEventID())) {
            return WidgetAction.State.REJECTED;
        }
        Point point = widget.convertLocalToScene(widgetDropTargetDropEvent.getPoint());
        ((PartnerScene)widget.getScene()).getDragOverLayer().resetLayer();
        boolean bl = false;
        if (this.currentHandler != null) {
            bl = this.currentHandler.drop(point, widgetDropTargetDropEvent);
            this.currentHandler = null;
        }
        if (bl) {
            widgetDropTargetDropEvent.acceptDrop(widgetDropTargetDropEvent.getDropAction());
            return WidgetAction.State.CONSUMED;
        }
        widgetDropTargetDropEvent.rejectDrop();
        return WidgetAction.State.REJECTED;
    }

    private boolean isEventProcessed(long l) {
        if (l != this.lastId) {
            this.lastId = l;
            return false;
        }
        return true;
    }

    public void addPriorHandler(DnDHandler dnDHandler) {
        if (this.priorHandlers == null) {
            this.priorHandlers = new ArrayList<DnDHandler>();
        }
        this.priorHandlers.add(dnDHandler);
    }

    public void removePriorHandler(DnDHandler dnDHandler) {
        if (this.priorHandlers == null) {
            return;
        }
        this.priorHandlers.remove(dnDHandler);
    }
}

