/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.extensibility.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.wsdl.ui.cookies.RefreshExtensibilityElementNodeCookie;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElement;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElementInfo;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElementInfoContainer;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.XMLSchemaFileInfo;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.impl.WSDLExtensibilityElementInfoContainerImpl;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.impl.WSDLExtensibilityElementInfoImpl;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.impl.WSDLExtensibilityElementsImpl;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLExtensibilityElementImpl
implements WSDLExtensibilityElement {
    private DataFolder mDataFolder;
    private Map<String, WSDLExtensibilityElementInfo> elementInfoMap = new HashMap<String, WSDLExtensibilityElementInfo>();
    private Map<String, WSDLExtensibilityElementInfoContainer> providersMap = new HashMap<String, WSDLExtensibilityElementInfoContainer>();
    private WSDLExtensibilityElementsImpl mRootElement;

    public WSDLExtensibilityElementImpl(DataFolder dataFolder, WSDLExtensibilityElementsImpl wSDLExtensibilityElementsImpl) {
        this.mDataFolder = dataFolder;
        this.mRootElement = wSDLExtensibilityElementsImpl;
        this.mDataFolder.getPrimaryFile().addFileChangeListener((FileChangeListener)new WSDLExtensibilityElementFileChangeListener());
    }

    @Override
    public WSDLExtensibilityElementInfo getWSDLExtensibilityElementInfos(QName qName) {
        List<WSDLExtensibilityElementInfo> list = this.getAllWSDLExtensibilityElementInfos();
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        for (WSDLExtensibilityElementInfo wSDLExtensibilityElementInfo : list) {
            Schema schema = wSDLExtensibilityElementInfo.getSchema();
            if (schema == null || string == null || !string.equals(schema.getTargetNamespace()) || !string2.equals(wSDLExtensibilityElementInfo.getElementName()) || this.findGlobalElement(qName, schema) == null) continue;
            return wSDLExtensibilityElementInfo;
        }
        return null;
    }

    @Override
    public List<WSDLExtensibilityElementInfo> getAllWSDLExtensibilityElementInfos() {
        ArrayList<WSDLExtensibilityElementInfo> arrayList = new ArrayList<WSDLExtensibilityElementInfo>();
        arrayList.addAll(this.getWSDLExtensibilityElementInfos());
        List<WSDLExtensibilityElementInfoContainer> list = this.getAllWSDLExtensibilityElementInfoContainers();
        for (WSDLExtensibilityElementInfoContainer wSDLExtensibilityElementInfoContainer : list) {
            arrayList.addAll(wSDLExtensibilityElementInfoContainer.getAllWSDLExtensibilityElementInfo());
        }
        return arrayList;
    }

    @Override
    public List<WSDLExtensibilityElementInfo> getWSDLExtensibilityElementInfos() {
        DataObject[] dataObjectArray;
        ArrayList<WSDLExtensibilityElementInfo> arrayList = new ArrayList<WSDLExtensibilityElementInfo>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (DataObject dataObject : dataObjectArray = this.mDataFolder.getChildren()) {
            if (dataObject instanceof DataFolder) continue;
            WSDLExtensibilityElementInfo wSDLExtensibilityElementInfo = this.elementInfoMap.get(dataObject.getName());
            if (wSDLExtensibilityElementInfo == null) {
                wSDLExtensibilityElementInfo = this.createNewElementInfo(dataObject);
                this.elementInfoMap.put(dataObject.getName(), wSDLExtensibilityElementInfo);
            }
            arrayList.add(wSDLExtensibilityElementInfo);
            arrayList2.add(dataObject.getName());
        }
        return arrayList;
    }

    @Override
    public List<WSDLExtensibilityElementInfoContainer> getAllWSDLExtensibilityElementInfoContainers() {
        DataObject[] dataObjectArray;
        ArrayList<WSDLExtensibilityElementInfoContainer> arrayList = new ArrayList<WSDLExtensibilityElementInfoContainer>();
        for (DataObject dataObject : dataObjectArray = this.mDataFolder.getChildren()) {
            if (!(dataObject instanceof DataFolder)) continue;
            WSDLExtensibilityElementInfoContainer wSDLExtensibilityElementInfoContainer = this.providersMap.get(dataObject.getName());
            if (wSDLExtensibilityElementInfoContainer == null) {
                wSDLExtensibilityElementInfoContainer = this.createNewProvider((DataFolder)dataObject);
                this.providersMap.put(dataObject.getName(), wSDLExtensibilityElementInfoContainer);
            }
            arrayList.add(wSDLExtensibilityElementInfoContainer);
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return this.mDataFolder.getName();
    }

    @Override
    public boolean isExtensibilityElementsAvailable() {
        boolean bl = false;
        if (this.getAllWSDLExtensibilityElementInfos().size() != 0) {
            bl = true;
        }
        return bl;
    }

    private WSDLExtensibilityElementInfoContainer createNewProvider(DataFolder dataFolder) {
        WSDLExtensibilityElementInfoContainerImpl wSDLExtensibilityElementInfoContainerImpl = new WSDLExtensibilityElementInfoContainerImpl((DataObject)dataFolder, this.mRootElement);
        return wSDLExtensibilityElementInfoContainerImpl;
    }

    private WSDLExtensibilityElementInfo createNewElementInfo(DataObject dataObject) {
        Object object = dataObject.getPrimaryFile().getAttribute("xsdFileName");
        XMLSchemaFileInfo xMLSchemaFileInfo = null;
        if (object instanceof String) {
            xMLSchemaFileInfo = this.mRootElement.getXMLSchemaFileInfoMatchingFileName((String)object);
        }
        WSDLExtensibilityElementInfoImpl wSDLExtensibilityElementInfoImpl = new WSDLExtensibilityElementInfoImpl(dataObject, xMLSchemaFileInfo);
        return wSDLExtensibilityElementInfoImpl;
    }

    private GlobalElement findGlobalElement(QName qName, Schema schema) {
        Collection collection = schema.getElements();
        for (GlobalElement globalElement : collection) {
            if (!globalElement.getName().equals(qName.getLocalPart())) continue;
            return globalElement;
        }
        return null;
    }

    @Override
    public Collection<WSDLExtensibilityElementInfo> getWSDLExtensibilityElementInfos(String string) {
        List<WSDLExtensibilityElementInfo> list = this.getAllWSDLExtensibilityElementInfos();
        ArrayList<WSDLExtensibilityElementInfo> arrayList = new ArrayList<WSDLExtensibilityElementInfo>();
        for (WSDLExtensibilityElementInfo wSDLExtensibilityElementInfo : list) {
            Schema schema = wSDLExtensibilityElementInfo.getSchema();
            if (schema == null || string == null || !string.equals(schema.getTargetNamespace())) continue;
            arrayList.add(wSDLExtensibilityElementInfo);
        }
        return arrayList;
    }

    class WSDLExtensibilityElementFileChangeListener
    extends FileChangeAdapter {
        WSDLExtensibilityElementFileChangeListener() {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object object;
                    TopComponent topComponent = TopComponent.getRegistry().getActivated();
                    if (topComponent != null && (object = (RefreshExtensibilityElementNodeCookie)topComponent.getLookup().lookup(RefreshExtensibilityElementNodeCookie.class)) != null) {
                        object.refresh();
                    }
                    object = TopComponent.getRegistry().getOpened();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        TopComponent topComponent2 = (TopComponent)iterator.next();
                        RefreshExtensibilityElementNodeCookie refreshExtensibilityElementNodeCookie = (RefreshExtensibilityElementNodeCookie)topComponent2.getLookup().lookup(RefreshExtensibilityElementNodeCookie.class);
                        if (refreshExtensibilityElementNodeCookie == null) continue;
                        refreshExtensibilityElementNodeCookie.refresh();
                    }
                }
            });
        }
    }
}

