/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.jaxwssettings.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsimportOptionsPanel
extends JPanel {
    private static final String[] reservedOptions = new String[]{"xendorsed", "verbose", "sourcedestdir", "extension", "destdir", "wsdl", "wsdlLocation", "catalog"};
    private JButton addBtn;
    private JScrollPane jScrollPane2;
    private JTable optionsTable;
    private OptionsTableModel optionsTableModel;
    private JButton removeBtn;

    public WsimportOptionsPanel(Map<String, String> map) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        Set<String> set = map.keySet();
        for (String object2 : set) {
            arrayList.add(new Option(object2, map.get(object2)));
        }
        this.initComponents();
        this.addBtn.addActionListener(new AddButtonActionListener());
        this.removeBtn.addActionListener(new RemoveButtonActionListener());
        Object[] objectArray = new String[]{NbBundle.getMessage(WsimportOptionsPanel.class, (String)"HEADING_OPTION"), NbBundle.getMessage(WsimportOptionsPanel.class, (String)"HEADING_VALUE")};
        this.optionsTableModel = new OptionsTableModel(objectArray, arrayList);
        this.optionsTable.setModel(this.optionsTableModel);
        this.optionsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ListSelectionListenerImpl listSelectionListenerImpl = new ListSelectionListenerImpl();
        this.optionsTable.getSelectionModel().addListSelectionListener(listSelectionListenerImpl);
        this.optionsTable.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListenerImpl);
        this.updateButtons();
    }

    private void updateButtons() {
        boolean bl = this.optionsTable.getSelectedRowCount() == 1;
        this.removeBtn.setEnabled(bl);
    }

    public Map<String, String> getWsimportOptions() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<Option> list = this.optionsTableModel.getOptions();
        for (Option option : list) {
            hashMap.put(option.getName(), option.getValue());
        }
        return hashMap;
    }

    public TableModel getOptionsTableModel() {
        return this.optionsTableModel;
    }

    private void initComponents() {
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.optionsTable = new JTable();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/jaxwssettings/panel/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.addBtn, (String)resourceBundle.getString("Add_DotDotDot_label"));
        this.addBtn.setToolTipText(NbBundle.getMessage(WsimportOptionsPanel.class, (String)"HINT_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtn, (String)resourceBundle.getString("Remove_label"));
        this.removeBtn.setToolTipText(NbBundle.getMessage(WsimportOptionsPanel.class, (String)"HINT_Remove"));
        this.optionsTable.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jScrollPane2.setViewportView(this.optionsTable);
        this.optionsTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WsimportOptionsPanel.class, (String)"ACSD_WSIMPORT_OPTIONS"));
        this.optionsTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WsimportOptionsPanel.class, (String)"ACSD_Wsimport_OPTIONS_TABLE"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -1, 364, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.addBtn, -1, 95, Short.MAX_VALUE).add((Component)this.removeBtn, -1, 95, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addBtn).addPreferredGap(0).add((Component)this.removeBtn)).add(1, (Component)this.jScrollPane2, -1, 219, Short.MAX_VALUE)).addContainerGap()));
    }

    private int getSelectedRow() {
        ListSelectionModel listSelectionModel = this.optionsTable.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            return -1;
        }
        return listSelectionModel.getMinSelectionIndex();
    }

    private class ListSelectionListenerImpl
    implements ListSelectionListener {
        private ListSelectionListenerImpl() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            WsimportOptionsPanel.this.optionsTable.editCellAt(WsimportOptionsPanel.this.optionsTable.getSelectedRow(), WsimportOptionsPanel.this.optionsTable.getSelectedColumn());
            Component component = WsimportOptionsPanel.this.optionsTable.getEditorComponent();
            if (component != null) {
                component.requestFocus();
            }
            if (component instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)component;
                jTextComponent.selectAll();
            }
            WsimportOptionsPanel.this.updateButtons();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OptionsTableModel
    extends DefaultTableModel {
        private List<Option> options;
        private String[] columnNames;

        public OptionsTableModel(Object[] objectArray, List<Option> list) {
            super(objectArray, list.size());
            this.columnNames = (String[])objectArray;
            this.options = new ArrayList<Option>(list);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public List<Option> getOptions() {
            return this.options;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        private String generateUniqueName(String string) {
            String string2 = string;
            int n = 1;
            HashSet<String> hashSet = new HashSet<String>();
            for (Option option : this.options) {
                hashSet.add(option.getName());
            }
            while (hashSet.contains(string2)) {
                string2 = string + ++n;
            }
            return string2;
        }

        public int addOption() {
            String string = this.generateUniqueName("option");
            int n = this.options.size();
            this.addRow(new String[]{string, "value"});
            this.options.add(new Option(string, "value"));
            this.fireTableRowsInserted(n, n);
            return n;
        }

        public void removeOption(int n) {
            this.options.remove(n);
            this.removeRow(n);
            this.fireTableRowsDeleted(n, n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = null;
            if (n >= 0) {
                Option option = this.options.get(n);
                switch (n2) {
                    case 0: {
                        string = option.getName();
                        break;
                    }
                    case 1: {
                        string = option.getValue();
                    }
                }
            }
            return string;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Option option = null;
            String string = (String)object;
            String string2 = (String)this.getValueAt(n, 1);
            if (n2 == 0) {
                String string3 = (String)this.getValueAt(n, 0);
                if (string3.equals(string)) {
                    return;
                }
                for (String string4 : reservedOptions) {
                    if (!string.trim().equals(string4)) continue;
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WsimportOptionsPanel.class, (String)"ERR_RESERVED_OPTION", (Object)string));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    this.options.set(n, new Option(string3, string2));
                    this.fireTableCellUpdated(n, n2);
                    return;
                }
                option = new Option(string, (String)this.getValueAt(n, 1));
            } else if (n2 == 1) {
                if (string2.equals(string)) {
                    return;
                }
                option = new Option((String)this.getValueAt(n, 0), string);
            }
            this.options.set(n, option);
            this.fireTableCellUpdated(n, n2);
        }
    }

    public static class Option {
        private String name;
        private String value;

        public Option(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    class OptionsTable
    extends JTable {
        public OptionsTable() {
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setResizingAllowed(false);
            jTableHeader.setReorderingAllowed(false);
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            listSelectionModel.setSelectionMode(1);
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        AddButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = WsimportOptionsPanel.this.optionsTableModel.addOption();
            WsimportOptionsPanel.this.optionsTable.getSelectionModel().setSelectionInterval(n, n);
            WsimportOptionsPanel.this.optionsTable.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            WsimportOptionsPanel.this.updateButtons();
        }
    }

    class RemoveButtonActionListener
    implements ActionListener {
        RemoveButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = WsimportOptionsPanel.this.getSelectedRow();
            String string = (String)WsimportOptionsPanel.this.optionsTableModel.getValueAt(n, 0);
            if (this.confirmDeletion(string)) {
                if (n > -1) {
                    WsimportOptionsPanel.this.optionsTableModel.removeOption(n);
                }
                if (n == WsimportOptionsPanel.this.optionsTable.getRowCount()) {
                    --n;
                }
                WsimportOptionsPanel.this.optionsTable.getSelectionModel().setSelectionInterval(n, n);
            }
            WsimportOptionsPanel.this.updateButtons();
        }

        private boolean confirmDeletion(String string) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WsimportOptionsPanel.class, (String)"MSG_CONFIRM_DELETE", (Object)string), NbBundle.getMessage(WsimportOptionsPanel.class, (String)"TTL_CONFIRM_DELETE"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            return confirmation.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

