/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.project.support.ui.MakeSharableWizardPanel1;
import org.netbeans.spi.java.project.support.ui.MakeSharableWizardPanel2;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SharableLibrariesUtils {
    static final String PROP_LOCATION = "location";
    static final String PROP_ACTIONS = "actions";
    static final String PROP_HELPER = "helper";
    static final String PROP_REFERENCE_HELPER = "refhelper";
    static final String PROP_LIBRARIES = "libraries";
    static final String PROP_JAR_REFS = "jars";
    public static final String DEFAULT_LIBRARIES_FILENAME = "nblibraries.properties";
    private static String PROP_LAST_SHARABLE = "lastSharable";

    public static boolean isLastProjectSharable() {
        return NbPreferences.root().node("org.netbeans.modules.java.project.share").getBoolean(PROP_LAST_SHARABLE, false);
    }

    public static void setLastProjectSharable(boolean bl) {
        NbPreferences.root().node("org.netbeans.modules.java.project.share").putBoolean(PROP_LAST_SHARABLE, bl);
    }

    public static String browseForLibraryLocation(String string, Component component, File file) {
        File file2 = PropertyUtils.resolveFile((File)file, (String)string);
        if (!file2.exists()) {
            file2 = file2.getParentFile();
        }
        file2 = FileUtil.normalizeFile((File)file2);
        FileChooser fileChooser = new FileChooser(file, null);
        fileChooser.setCurrentDirectory(file2);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(NbBundle.getMessage(SharableLibrariesUtils.class, (String)"LBL_Browse_Libraries_Title"));
        fileChooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SharableLibrariesUtils.class, (String)"ASCD_Browse_Libraries_Title"));
        if (0 == fileChooser.showOpenDialog(component)) {
            String[] stringArray;
            try {
                stringArray = fileChooser.getSelectedPaths();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
            if (stringArray.length == 1) {
                String string2 = stringArray[0];
                return string2;
            }
        }
        return null;
    }

    public static boolean showMakeSharableWizard(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, List<String> list, List<String> list2) {
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new CopyIterator(antProjectHelper));
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(NbBundle.getMessage(SharableLibrariesUtils.class, (String)"TIT_MakeSharableWizard"));
        wizardDescriptor.putProperty(PROP_HELPER, (Object)antProjectHelper);
        wizardDescriptor.putProperty(PROP_REFERENCE_HELPER, (Object)referenceHelper);
        wizardDescriptor.putProperty(PROP_LIBRARIES, list);
        wizardDescriptor.putProperty(PROP_JAR_REFS, list2);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SharableLibrariesUtils.class, (String)"ACSD_MakeSharableWizard"));
        dialog.setVisible(true);
        dialog.toFront();
        return wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(WizardDescriptor wizardDescriptor, final AntProjectHelper antProjectHelper, final ProgressHandle progressHandle) {
        final String string = (String)wizardDescriptor.getProperty(PROP_LOCATION);
        final List list = (List)wizardDescriptor.getProperty(PROP_ACTIONS);
        assert (string != null);
        progressHandle.start(Math.max(1, list.size() + 1));
        try {
            File file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory()), string);
            }
            if (!(file = FileUtil.normalizeFile((File)file)).exists()) {
                FileUtil.createData((File)file);
            }
            try {
                ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                    public Object run() throws IOException {
                        try {
                            antProjectHelper.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                                public void run() throws IOException {
                                    antProjectHelper.setLibrariesLocation(string);
                                    int n = 1;
                                    for (Action action : list) {
                                        progressHandle.progress(n);
                                        ++n;
                                        action.actionPerformed(null);
                                    }
                                    ProjectManager.getDefault().saveProject(FileOwnerQuery.getOwner((FileObject)antProjectHelper.getProjectDirectory()));
                                }
                            });
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Exceptions.printStackTrace((Throwable)illegalArgumentException);
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mutexException) {
                throw (IOException)mutexException.getException();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            progressHandle.finish();
        }
    }

    private static WizardDescriptor.Panel[] getPanels() {
        WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{new MakeSharableWizardPanel1(), new MakeSharableWizardPanel2()};
        String[] stringArray = new String[panelArray.length];
        for (int i = 0; i < panelArray.length; ++i) {
            Component component = panelArray[i].getComponent();
            stringArray[i] = component.getName();
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
            jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
        return panelArray;
    }

    private static String getJarFolder(URI uRI) {
        String string = uRI.toString();
        int n = string.indexOf("!/");
        if (n != -1 && n + 2 < string.length()) {
            return string.substring(n + 2);
        }
        return null;
    }

    private static URI appendJarFolder(URI uRI, String string) {
        try {
            if (uRI.isAbsolute()) {
                return new URI("jar:" + uRI.toString() + "!/" + (string == null ? "" : string.replace('\\', '/')));
            }
            return new URI(uRI.toString() + "!/" + (string == null ? "" : string.replace('\\', '/')));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    static class CopyLibraryJars
    extends AbstractAction {
        private Library library;
        private ReferenceHelper refHelper;

        CopyLibraryJars(ReferenceHelper referenceHelper, Library library) {
            this.refHelper = referenceHelper;
            this.library = library;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            assert (this.library.getManager() == LibraryManager.getDefault()) : "Only converting from non-sharable to sharable is supported.";
            try {
                this.refHelper.copyLibrary(this.library);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    static class KeepLibraryAtLocation
    extends AbstractAction {
        private boolean keepRelativeLocations;
        private Library library;
        private AntProjectHelper helper;

        KeepLibraryAtLocation(Library library, boolean bl, AntProjectHelper antProjectHelper) {
            this.library = library;
            this.keepRelativeLocations = bl;
            this.helper = antProjectHelper;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.helper.getLibrariesLocation();
            assert (string != null);
            File file = this.helper.resolveFile(string);
            try {
                LibraryManager libraryManager = LibraryManager.forLocation((URL)file.toURI().toURL());
                HashMap hashMap = new HashMap();
                LibraryTypeProvider libraryTypeProvider = LibrariesSupport.getLibraryTypeProvider((String)this.library.getType());
                assert (libraryTypeProvider != null);
                for (String string2 : libraryTypeProvider.getSupportedVolumeTypes()) {
                    List list = this.library.getContent(string2);
                    ArrayList<URI> arrayList = new ArrayList<URI>();
                    for (URL uRL : list) {
                        FileObject fileObject;
                        String string3 = null;
                        if ("jar".equals(uRL.getProtocol())) {
                            string3 = SharableLibrariesUtils.getJarFolder(URI.create(uRL.toExternalForm()));
                            uRL = FileUtil.getArchiveFile((URL)uRL);
                        }
                        if ((fileObject = URLMapper.findFileObject((URL)uRL)) != null) {
                            URI uRI;
                            File file2;
                            if (this.keepRelativeLocations) {
                                file2 = FileUtil.toFile((FileObject)fileObject);
                                String string4 = PropertyUtils.relativizeFile((File)file.getParentFile(), (File)file2);
                                uRI = string4 == null ? file2.toURI() : LibrariesSupport.convertFilePathToURI((String)string4);
                            } else {
                                file2 = FileUtil.toFile((FileObject)fileObject);
                                uRI = file2.toURI();
                            }
                            if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                                uRI = SharableLibrariesUtils.appendJarFolder(uRI, string3);
                            }
                            arrayList.add(uRI);
                            continue;
                        }
                        try {
                            arrayList.add(uRL.toURI());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            Exceptions.printStackTrace((Throwable)uRISyntaxException);
                        }
                    }
                    hashMap.put(string2, arrayList);
                }
                libraryManager.createURILibrary(this.library.getType(), this.library.getName(), hashMap);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    static class KeepJarAtLocation
    extends AbstractAction {
        private ReferenceHelper refhelper;
        private AntProjectHelper ahelper;
        private String reference;
        private boolean relative;

        public KeepJarAtLocation(String string, boolean bl, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            this.reference = string;
            this.ahelper = antProjectHelper;
            this.refhelper = referenceHelper;
            this.relative = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.ahelper.getStandardPropertyEvaluator().evaluate(this.reference);
            this.updateReference(string, this.reference, true);
            String string2 = this.reference.replace("${file.reference", "${source.reference");
            string = this.ahelper.getStandardPropertyEvaluator().evaluate(string2);
            if (!string.startsWith("${source.")) {
                this.updateReference(string, string2.replace("${", "").replace("}", ""), false);
            }
            String string3 = this.reference.replace("${file.reference", "${javadoc.reference");
            string = this.ahelper.getStandardPropertyEvaluator().evaluate(string3);
            if (!string.startsWith("${javadoc.")) {
                this.updateReference(string, string3.replace("${", "").replace("}", ""), false);
            }
        }

        private void updateReference(String string, String string2, boolean bl) {
            String string3;
            File file = this.ahelper.resolveFile(string);
            String string4 = string3 = this.relative ? PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.ahelper.getProjectDirectory()), (File)file) : file.getAbsolutePath();
            if (string3 == null) {
                string3 = file.getAbsolutePath();
            }
            if (!string3.equals(string)) {
                if (bl) {
                    this.refhelper.createForeignFileReferenceAsIs(string3, string2);
                } else {
                    this.refhelper.createExtraForeignFileReferenceAsIs(string3, string2);
                }
            }
        }
    }

    static class CopyJars
    extends AbstractAction {
        private ReferenceHelper refhelper;
        private AntProjectHelper ahelper;
        private String reference;

        public CopyJars(ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String string) {
            this.reference = string;
            this.ahelper = antProjectHelper;
            this.refhelper = referenceHelper;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.ahelper.getStandardPropertyEvaluator().evaluate(this.reference);
            File file = this.ahelper.resolveFile(string);
            String string2 = this.ahelper.getLibrariesLocation();
            File file2 = this.ahelper.resolveFile(string2);
            File file3 = file2.getParentFile();
            if (!file3.exists()) {
                file3.mkdirs();
                FileUtil.refreshFor((File[])new File[]{file3});
            }
            FileObject fileObject = FileUtil.toFileObject((File)file3);
            this.updateReference(file, this.reference, true, fileObject);
            String string3 = this.reference.replace("${file.reference", "${source.reference");
            string = this.ahelper.getStandardPropertyEvaluator().evaluate(string3);
            if (!string.startsWith("${source.")) {
                file = this.ahelper.resolveFile(string);
                this.updateReference(file, string3.replace("${", "").replace("}", ""), false, fileObject);
            }
            String string4 = this.reference.replace("${file.reference", "${javadoc.reference");
            string = this.ahelper.getStandardPropertyEvaluator().evaluate(string4);
            if (!string.startsWith("${javadoc.")) {
                file = this.ahelper.resolveFile(string);
                this.updateReference(file, string4.replace("${", "").replace("}", ""), false, fileObject);
            }
        }

        private void updateReference(File file, String string, boolean bl, FileObject fileObject) {
            FileObject fileObject2;
            FileObject fileObject3 = FileUtil.toFileObject((File)file);
            try {
                fileObject2 = FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject, (String)fileObject3.getName());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                fileObject2 = fileObject3;
            }
            File file2 = FileUtil.toFile((FileObject)fileObject2);
            String string2 = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.ahelper.getProjectDirectory()), (File)file2);
            if (string2 == null) {
                string2 = file2.getAbsolutePath();
            }
            if (bl) {
                this.refhelper.destroyReference(string);
                this.refhelper.createForeignFileReferenceAsIs(string2, string);
            } else {
                this.refhelper.destroyReference(string);
                this.refhelper.createExtraForeignFileReferenceAsIs(string2, string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopyIterator
    extends WizardDescriptor.ArrayIterator<WizardDescriptor>
    implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
        private AntProjectHelper helper;
        private WizardDescriptor desc;

        private CopyIterator(AntProjectHelper antProjectHelper) {
            this.helper = antProjectHelper;
        }

        public Set instantiate(ProgressHandle progressHandle) throws IOException {
            SharableLibrariesUtils.execute(this.desc, this.helper, progressHandle);
            return Collections.EMPTY_SET;
        }

        public Set instantiate() throws IOException {
            throw new UnsupportedOperationException("Not supported");
        }

        public void initialize(WizardDescriptor wizardDescriptor) {
            this.desc = wizardDescriptor;
        }

        public void uninitialize(WizardDescriptor wizardDescriptor) {
            this.desc = wizardDescriptor;
        }

        public WizardDescriptor.Panel<WizardDescriptor>[] initializePanels() {
            return SharableLibrariesUtils.getPanels();
        }
    }
}

