/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

final class MakeSharableVisualPanel1
extends JPanel {
    private AntProjectHelper helper;
    private ChangeSupport support;
    private WizardDescriptor settings;
    private DocumentListener docListener;
    private JButton btnDefinition;
    private JLabel lblDefinition;
    private JLabel lblNote;
    private JTextField txtDefinition;

    public MakeSharableVisualPanel1(ChangeSupport changeSupport) {
        this.initComponents();
        this.support = changeSupport;
        this.docListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                MakeSharableVisualPanel1.this.support.fireChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MakeSharableVisualPanel1.this.support.fireChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                MakeSharableVisualPanel1.this.support.fireChange();
            }
        };
        this.txtDefinition.getDocument().addDocumentListener(this.docListener);
    }

    public String getName() {
        return NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"TIT_LibraryDefinitionSelection");
    }

    boolean isValidPanel() {
        String string = this.getLibraryLocation();
        boolean bl = false;
        if (new File(string).isAbsolute()) {
            this.settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"WARN_MakeSharable.absolutePath"));
            bl = true;
        } else {
            File file;
            File file2 = this.helper.resolveFile(string);
            if (!CollocationQuery.areCollocated((File)file2, (File)(file = PropertyUtils.resolveFile((File)file2, (String)string)))) {
                this.settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"WARN_makeSharable.relativePath"));
                bl = true;
            }
        }
        if (!bl) {
            this.settings.putProperty("WizardPanel_errorMessage", null);
        }
        return true;
    }

    private String getLibraryLocation() {
        return this.txtDefinition.getText().trim();
    }

    private void setLibraryLocation(String string) {
        this.txtDefinition.setText(string);
    }

    void readSettings(WizardDescriptor wizardDescriptor) {
        this.settings = wizardDescriptor;
        String string = (String)wizardDescriptor.getProperty("location");
        this.helper = (AntProjectHelper)wizardDescriptor.getProperty("helper");
        string = string == null ? "." + File.separator + "lib" : string.substring(0, string.length() - "nblibraries.properties".length());
        this.setLibraryLocation(string);
        this.support.fireChange();
    }

    void storeSettings(WizardDescriptor wizardDescriptor) {
        String string = this.getLibraryLocation();
        if (string != null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separatorChar;
            }
            string = string + "nblibraries.properties";
        }
        wizardDescriptor.putProperty("location", (Object)string);
    }

    private void initComponents() {
        this.lblDefinition = new JLabel();
        this.txtDefinition = new JTextField();
        this.btnDefinition = new JButton();
        this.lblNote = new JLabel();
        this.lblDefinition.setLabelFor(this.txtDefinition);
        Mnemonics.setLocalizedText((JLabel)this.lblDefinition, (String)NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"MakeSharableVisualPanel1.lblDefinition.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDefinition, (String)NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"MakeSharableVisualPanel1.btnDefinition.text"));
        this.btnDefinition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MakeSharableVisualPanel1.this.btnDefinitionActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblNote, (String)NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"MakeSharableVisualPanel1.lblNote.text"));
        this.lblNote.setVerticalAlignment(1);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblDefinition).add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblNote, -1, 362, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.txtDefinition, -1, 257, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnDefinition)))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnDefinition).add((Component)this.lblDefinition).add((Component)this.txtDefinition, -2, -1, -2)).addPreferredGap(0).add((Component)this.lblNote, -2, 129, -2).addContainerGap(116, Short.MAX_VALUE)));
        this.lblDefinition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"ACSD_lblDefinition"));
        this.txtDefinition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"ACSD_lblDefinition"));
        this.btnDefinition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"ACSD_btnDefinition"));
    }

    private void btnDefinitionActionPerformed(ActionEvent actionEvent) {
        File file = FileUtil.toFile((FileObject)this.helper.getProjectDirectory());
        String string = SharableLibrariesUtils.browseForLibraryLocation(this.getLibraryLocation(), this, file);
        if (string != null) {
            this.setLibraryLocation(string);
        }
    }
}

