/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.spi.java.project.support.ui.IncludeExcludeVisualizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class IncludeExcludeVisualizerPanel
extends JPanel {
    private final IncludeExcludeVisualizer handle;
    private final DocumentListener listener = new DocumentListener(){

        private void changes() {
            IncludeExcludeVisualizerPanel.this.handle.changedPatterns(IncludeExcludeVisualizerPanel.this.includes.getText(), IncludeExcludeVisualizerPanel.this.excludes.getText());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changes();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changes();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    };
    private final DefaultListModel includedListModel = new DefaultListModel();
    private final DefaultListModel excludedListModel = new DefaultListModel();
    private String rootPrefix;
    private JList excludedList;
    private JLabel excludedListLabel;
    private JScrollPane excludedListPane;
    private JTextField excludes;
    private JLabel excludesLabel;
    private JLabel explanation;
    private JList includedList;
    private JLabel includedListLabel;
    private JScrollPane includedListPane;
    private JTextField includes;
    private JLabel includesLabel;
    private JLabel scanningLabel;

    public IncludeExcludeVisualizerPanel(IncludeExcludeVisualizer includeExcludeVisualizer) {
        this.handle = includeExcludeVisualizer;
        this.initComponents();
        this.includes.getDocument().addDocumentListener(this.listener);
        this.excludes.getDocument().addDocumentListener(this.listener);
        this.includedList.setModel(this.includedListModel);
        this.excludedList.setModel(this.excludedListModel);
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                File file = (File)object;
                String string = file.getAbsolutePath();
                if (IncludeExcludeVisualizerPanel.this.rootPrefix != null) {
                    assert (string.startsWith(IncludeExcludeVisualizerPanel.this.rootPrefix)) : "Expected " + string + " to start with '" + IncludeExcludeVisualizerPanel.access$300(IncludeExcludeVisualizerPanel.this) + "'";
                    string = string.substring(IncludeExcludeVisualizerPanel.this.rootPrefix.length()).replace(File.separatorChar, '/');
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        };
        this.includedList.setCellRenderer(defaultListCellRenderer);
        this.excludedList.setCellRenderer(defaultListCellRenderer);
    }

    void setFields(String string, String string2) {
        assert (EventQueue.isDispatchThread());
        this.includes.getDocument().removeDocumentListener(this.listener);
        this.includes.setText(string);
        this.includes.getDocument().addDocumentListener(this.listener);
        this.excludes.getDocument().removeDocumentListener(this.listener);
        this.excludes.setText(string2);
        this.excludes.getDocument().addDocumentListener(this.listener);
    }

    void setFiles(File[] fileArray, File[] fileArray2, boolean bl, File file) {
        assert (EventQueue.isDispatchThread());
        this.includedListModel.clear();
        for (File file2 : fileArray) {
            this.includedListModel.addElement(file2);
        }
        this.excludedListModel.clear();
        for (File file2 : fileArray2) {
            this.excludedListModel.addElement(file2);
        }
        this.scanningLabel.setVisible(bl);
        if (file == null) {
            this.rootPrefix = null;
        } else {
            assert (file.isDirectory()) : file;
            this.rootPrefix = file.getAbsolutePath() + File.separatorChar;
        }
    }

    private void initComponents() {
        this.includedListLabel = new JLabel();
        this.includedListPane = new JScrollPane();
        this.includedList = new JList();
        this.excludedListLabel = new JLabel();
        this.excludedListPane = new JScrollPane();
        this.excludedList = new JList();
        this.scanningLabel = new JLabel();
        this.includesLabel = new JLabel();
        this.includes = new JTextField();
        this.excludesLabel = new JLabel();
        this.excludes = new JTextField();
        this.explanation = new JLabel();
        this.includedListLabel.setLabelFor(this.includedList);
        Mnemonics.setLocalizedText((JLabel)this.includedListLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.includedListLabel.text"));
        this.includedListPane.setViewportView(this.includedList);
        this.includedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSN_includedList"));
        this.includedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSD_includedList"));
        this.excludedListLabel.setLabelFor(this.excludedList);
        Mnemonics.setLocalizedText((JLabel)this.excludedListLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.excludedListLabel.text"));
        this.excludedListPane.setViewportView(this.excludedList);
        this.excludedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSN_excludedList"));
        this.excludedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSD_excludedList"));
        Mnemonics.setLocalizedText((JLabel)this.scanningLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.scanningLabel.text"));
        this.includesLabel.setLabelFor(this.includes);
        Mnemonics.setLocalizedText((JLabel)this.includesLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.includesLabel.text"));
        this.excludesLabel.setLabelFor(this.excludes);
        Mnemonics.setLocalizedText((JLabel)this.excludesLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.excludesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.explanation, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.explanation.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.includesLabel).add((Component)this.excludesLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.excludes, -1, 390, Short.MAX_VALUE).add((Component)this.includes, -1, 390, Short.MAX_VALUE))).add((Component)this.scanningLabel).add((Component)this.includedListLabel).add((Component)this.excludedListLabel).add(2, (Component)this.includedListPane, -1, 440, Short.MAX_VALUE).add(2, (Component)this.explanation, -1, 440, Short.MAX_VALUE).add(2, (Component)this.excludedListPane, -1, 440, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.includesLabel).add((Component)this.includes, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.excludesLabel).add((Component)this.excludes, -2, -1, -2)).addPreferredGap(0).add((Component)this.scanningLabel).addPreferredGap(0).add((Component)this.includedListLabel).addPreferredGap(0).add((Component)this.includedListPane, -2, -1, -2).addPreferredGap(0).add((Component)this.excludedListLabel).addPreferredGap(0).add((Component)this.excludedListPane, -2, 143, -2).addPreferredGap(0).add((Component)this.explanation, -1, 40, Short.MAX_VALUE).addContainerGap()));
        this.includesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSD_includesLabel"));
        this.excludesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSD_excludesLabel"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSN_IncludeExcludeVisualizerPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSD_IncludeExcludeVisualizerPanel"));
    }
}

