/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.saas.codegen.java.Constants;
import org.netbeans.modules.websvc.saas.codegen.java.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.java.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasMetadata;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.netbeans.modules.websvc.saas.model.wadl.Param;
import org.netbeans.modules.websvc.saas.model.wadl.RepresentationType;
import org.netbeans.modules.websvc.saas.model.wadl.Request;
import org.netbeans.modules.websvc.saas.model.wadl.Resource;
import org.netbeans.modules.websvc.saas.model.wadl.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlSaasBean
extends SaasBean {
    public static final String SAAS_SERVICE_TEMPLATE = "Templates/SaaSServices/SaasService.java";
    public static final String PROTOCOL_SEPERATOR = "://";
    public static final String PROTOCOL_SEPERATOR_ALT = "  ";
    private String url;
    private WadlSaasMethod m;
    private String serviceMethodName = null;

    public WadlSaasBean(WadlSaasMethod wadlSaasMethod) throws IOException {
        this(wadlSaasMethod, false);
    }

    public WadlSaasBean(WadlSaasMethod wadlSaasMethod, boolean bl) throws IOException {
        super((Saas)wadlSaasMethod.getSaas(), Util.deriveResourceName(wadlSaasMethod.getName()), null, Util.deriveUriTemplate(wadlSaasMethod.getName()), new Constants.MimeType[]{Constants.MimeType.XML}, new String[]{"java.lang.String"}, new Constants.HttpMethodType[]{Constants.HttpMethodType.GET});
        this.m = wadlSaasMethod;
        this.setIsDropTargetWeb(bl);
        this.init();
    }

    public WadlSaasMethod getMethod() {
        return this.m;
    }

    public String getSaasServiceMethodName() {
        if (this.serviceMethodName == null) {
            this.serviceMethodName = Util.deriveMethodName(this.getMethod().getName());
            this.serviceMethodName = this.serviceMethodName.substring(0, 1).toLowerCase() + this.serviceMethodName.substring(1);
        }
        return this.serviceMethodName;
    }

    private void init() throws IOException {
        this.setResourceClassTemplate("Templates/SaaSServices/WrapperResource.java");
        this.setHttpMethod(Constants.HttpMethodType.valueOf(this.getMethod().getWadlMethod().getName()));
        this.findAuthentication((SaasMethod)this.m);
        this.initUrl();
        this.getInputParameters();
        this.initMimeTypes();
        this.setMethodTypes(new Constants.HttpMethodType[]{this.getHttpMethod()});
    }

    private void initUrl() throws IOException {
        Resource[] resourceArray = this.m.getResourcePath();
        if (resourceArray == null || resourceArray.length == 0) {
            throw new IllegalArgumentException("Method do not belong to any resource in the WADL.");
        }
        String string = this.m.getSaas().getWadlModel().getResources().getBase();
        string = string.replace(PROTOCOL_SEPERATOR, PROTOCOL_SEPERATOR_ALT);
        for (Resource resource : resourceArray) {
            String string2 = resource.getPath();
            if (string2 == null || string2.trim().length() <= 0) continue;
            string = string + "/" + string2;
        }
        string = string.replace("//", "/");
        string = string.replace("/  ", PROTOCOL_SEPERATOR_ALT);
        string = string.replace("  /", PROTOCOL_SEPERATOR_ALT);
        this.url = string = string.replace(PROTOCOL_SEPERATOR_ALT, PROTOCOL_SEPERATOR);
    }

    @Override
    protected List<ParameterInfo> initInputParameters() {
        boolean bl;
        Object object;
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        try {
            object = this.m.getResourcePath();
            if (object == null || ((Resource[])object).length == 0) {
                throw new IllegalArgumentException("Method do not belong to any resource in the WADL.");
            }
            arrayList.addAll(this.findWadlParams(this.m));
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = null;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = bl = this.getAuthenticationType() == Constants.SaasAuthenticationType.SESSION_KEY;
        if (bl) {
            string = ((SaasBean.SessionKeyAuthentication)this.getAuthentication()).getSessionKeyName();
        }
        if (this.getAuthenticationType() == Constants.SaasAuthenticationType.API_KEY) {
            object = ((SaasBean.ApiKeyAuthentication)this.getAuthentication()).getApiKeyName();
        }
        if (bl) {
            object = ((SaasBean.SessionKeyAuthentication)this.getAuthentication()).getApiKeyName();
        }
        if (object != null) {
            bl2 = true;
        }
        for (ParameterInfo parameterInfo : arrayList) {
            String string2 = parameterInfo.getName();
            if (parameterInfo.getStyle() != ParameterInfo.ParamStyle.QUERY) continue;
            if (bl2 && string2.equals(object)) {
                parameterInfo.setIsApiKey(true);
            }
            if (!bl || !string2.equals(string)) continue;
            parameterInfo.setIsSessionKey(true);
        }
        return arrayList;
    }

    public ArrayList<ParameterInfo> findWadlParams(WadlSaasMethod wadlSaasMethod) {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        arrayList.addAll(this.findWadlParams(wadlSaasMethod.getWadlMethod()));
        Resource[] resourceArray = wadlSaasMethod.getResourcePath();
        if (resourceArray != null && resourceArray.length > 0) {
            for (Resource resource : resourceArray) {
                WadlSaasBean.findWadlParams(arrayList, resource.getParam());
            }
        }
        return arrayList;
    }

    public ArrayList<ParameterInfo> findWadlParams(Method method) {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        Request request = method.getRequest();
        WadlSaasBean.findWadlParams(arrayList, request.getParam());
        List list = request.getRepresentation();
        for (RepresentationType representationType : list) {
            WadlSaasBean.findWadlParams(arrayList, representationType.getParam());
        }
        return arrayList;
    }

    private void initMimeTypes() {
        ArrayList<Constants.MimeType> arrayList = new ArrayList<Constants.MimeType>();
        Response response = this.m.getWadlMethod().getResponse();
        WadlSaasBean.findMediaType(response, arrayList);
        if (arrayList.size() > 0) {
            this.setMimeTypes(arrayList.toArray(new Constants.MimeType[arrayList.size()]));
        }
    }

    public static List<QName> findRepresentationTypes(WadlSaasMethod wadlSaasMethod) {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        Response response = wadlSaasMethod.getWadlMethod().getResponse();
        WadlSaasBean.findRepresentationType(response, arrayList);
        return arrayList;
    }

    public static List<RepresentationType> findInputRepresentations(WadlSaasMethod wadlSaasMethod) {
        return wadlSaasMethod.getWadlMethod().getRequest().getRepresentation();
    }

    public String getUrl() {
        return this.url;
    }

    public static void findMediaType(Response response, List<Constants.MimeType> list) {
        if (response == null) {
            return;
        }
        List list2 = response.getRepresentationOrFault();
        for (JAXBElement jAXBElement : list2) {
            String[] stringArray;
            String string = ((RepresentationType)jAXBElement.getValue()).getMediaType();
            if (string == null) continue;
            for (String string2 : stringArray = string.split(",")) {
                Constants.MimeType mimeType = Constants.MimeType.find(string2);
                if (mimeType == null || list.contains((Object)mimeType)) continue;
                list.add(mimeType);
            }
        }
    }

    public static void findMediaType(Request request, List<String> list) {
        if (request == null) {
            return;
        }
        List list2 = request.getRepresentation();
        for (RepresentationType representationType : list2) {
            String[] stringArray;
            String string = representationType.getMediaType();
            if (string == null) continue;
            for (String string2 : stringArray = string.split(",")) {
                if (string2 == null || list.contains(string2)) continue;
                list.add(string2);
            }
        }
    }

    public static void findWadlParams(List<ParameterInfo> list, List<Param> list2) {
        if (list2 != null) {
            for (Param param : list2) {
                String string = param.getName();
                Class clazz = WadlSaasBean.findJavaType(param.getType().getLocalPart());
                String string2 = param.getDefault();
                ParameterInfo parameterInfo = new ParameterInfo(string, clazz);
                parameterInfo.setStyle(ParameterInfo.ParamStyle.fromValue(param.getStyle().value()));
                parameterInfo.setIsRequired(param.isRequired());
                parameterInfo.setIsRepeating(param.isRepeating());
                parameterInfo.setFixed(param.getFixed());
                parameterInfo.setOption(param.getOption());
                parameterInfo.setDefaultValue(string2);
                list.add(parameterInfo);
            }
        }
    }

    public static void findRepresentationType(Response response, List<QName> list) {
        if (response == null) {
            return;
        }
        List list2 = response.getRepresentationOrFault();
        for (JAXBElement jAXBElement : list2) {
            QName qName = ((RepresentationType)jAXBElement.getValue()).getElement();
            if (qName == null || list.contains(qName)) continue;
            list.add(qName);
        }
    }

    public String getSaasServiceTemplate() {
        return SAAS_SERVICE_TEMPLATE;
    }

    @Override
    protected Object getSignedUrl(SaasMetadata.Authentication authentication) {
        String string;
        Object object = null;
        if (authentication.getSignedUrl() != null && authentication.getSignedUrl().size() > 0 && (object = this.getSignedUrlById(authentication, string = this.m.getWadlMethod().getId())) == null) {
            Resource[] resourceArray = this.m.getResourcePath();
            if (resourceArray == null || resourceArray.length == 0) {
                return null;
            }
            string = resourceArray[resourceArray.length - 1].getId();
            object = this.getSignedUrlById(authentication, string);
        }
        return object;
    }

    private Object getSignedUrlById(SaasMetadata.Authentication authentication, String string) {
        if (string != null && !string.trim().equals("")) {
            for (SaasMetadata.Authentication.SignedUrl signedUrl : authentication.getSignedUrl()) {
                if (!string.equals(signedUrl.getId())) continue;
                return signedUrl;
            }
        }
        return null;
    }

    public boolean canGenerateJAXBUnmarshaller() {
        return this.getHttpMethod() == Constants.HttpMethodType.GET && !WadlSaasBean.findRepresentationTypes(this.getMethod()).isEmpty();
    }
}

