/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import java.io.IOException;
import java.util.ArrayList;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.saas.codegen.java.JaxRsCodeSetupPanel;
import org.netbeans.modules.websvc.saas.codegen.java.JaxWsCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.JaxWsCodeGeneratorFactory;
import org.netbeans.modules.websvc.saas.codegen.java.ProgressDialog;
import org.netbeans.modules.websvc.saas.codegen.java.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.java.model.WsdlSaasBean;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JaxWsEditorDrop
implements ActiveEditorDrop {
    private WsdlSaasMethod method;
    private FileObject targetFO;
    private RequestProcessor.Task generatorTask;

    public JaxWsEditorDrop(WsdlSaasMethod wsdlSaasMethod) {
        this.method = wsdlSaasMethod;
    }

    private boolean isAcceptTarget(JTextComponent jTextComponent) {
        Object object = jTextComponent.getDocument().getProperty("mimeType");
        return object != null && ("text/x-java".equals(object) || "text/x-jsp".equals(object));
    }

    public boolean handleTransfer(JTextComponent jTextComponent) {
        if (this.isAcceptTarget(jTextComponent)) {
            return this.doHandleTransfer(jTextComponent);
        }
        return false;
    }

    private boolean doHandleTransfer(final JTextComponent jTextComponent) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)jTextComponent.getDocument());
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        WsdlOperation wsdlOperation = this.method.getWsdlOperation();
        final String string = wsdlOperation.getName();
        this.targetFO = JaxWsEditorDrop.getTargetFile(jTextComponent);
        if (this.targetFO == null) {
            return false;
        }
        final ArrayList arrayList = new ArrayList();
        final ProgressDialog progressDialog = new ProgressDialog(NbBundle.getMessage(JaxWsEditorDrop.class, (String)"LBL_CodeGenProgress", (Object)string));
        this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JaxWsCodeGenerator jaxWsCodeGenerator = JaxWsCodeGeneratorFactory.create(jTextComponent, JaxWsEditorDrop.this.targetFO, JaxWsEditorDrop.this.method);
                    WsdlSaasBean wsdlSaasBean = jaxWsCodeGenerator.getBean();
                    boolean bl = jaxWsCodeGenerator.canShowParam();
                    ArrayList<ParameterInfo> arrayList2 = new ArrayList<ParameterInfo>(wsdlSaasBean.getHeaderParameters());
                    if (bl && wsdlSaasBean.getInputParameters() != null) {
                        arrayList2.addAll(wsdlSaasBean.getInputParameters());
                    }
                    if (jaxWsCodeGenerator.canShowResourceInfo() || bl && !arrayList2.isEmpty()) {
                        JaxRsCodeSetupPanel jaxRsCodeSetupPanel = new JaxRsCodeSetupPanel(jaxWsCodeGenerator.getSubresourceLocatorUriTemplate(), wsdlSaasBean.getQualifiedClassName(), arrayList2, jaxWsCodeGenerator.canShowResourceInfo(), bl);
                        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jaxRsCodeSetupPanel, NbBundle.getMessage(JaxWsEditorDrop.class, (String)"LBL_CustomizeSaasService", (Object)string));
                        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                        if (object.equals(NotifyDescriptor.YES_OPTION)) {
                            jaxWsCodeGenerator.setSubresourceLocatorUriTemplate(jaxRsCodeSetupPanel.getUriTemplate());
                            jaxWsCodeGenerator.setSubresourceLocatorName(jaxRsCodeSetupPanel.getMethodName());
                        } else {
                            return;
                        }
                    }
                    try {
                        jaxWsCodeGenerator.generate(progressDialog.getProgressHandle());
                    }
                    catch (IOException iOException) {
                        if (!iOException.getMessage().equals("ScanningInProgress")) {
                            arrayList.add(iOException);
                        }
                    }
                }
                catch (Exception exception) {
                    arrayList.add(exception);
                }
                finally {
                    progressDialog.close();
                }
            }
        });
        this.generatorTask.schedule(50);
        progressDialog.open();
        if (arrayList.size() > 0) {
            Exceptions.printStackTrace((Throwable)((Throwable)arrayList.get(0)));
            return false;
        }
        return true;
    }

    public static FileObject getTargetFile(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return null;
        }
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)jTextComponent.getDocument());
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null || editorCookie.getOpenedPanes() == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }
}

