/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.saas.codegen.java.JaxRsCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.JaxRsCodeGeneratorFactory;
import org.netbeans.modules.websvc.saas.codegen.java.JaxRsCodeSetupPanel;
import org.netbeans.modules.websvc.saas.codegen.java.ProgressDialog;
import org.netbeans.modules.websvc.saas.codegen.java.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.java.model.WadlSaasBean;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JaxRsEditorDrop
implements ActiveEditorDrop {
    private WadlSaasMethod method;
    private FileObject targetFO;
    private RequestProcessor.Task generatorTask;

    public JaxRsEditorDrop(WadlSaasMethod wadlSaasMethod) {
        this.method = wadlSaasMethod;
    }

    private boolean isAcceptTarget(JTextComponent jTextComponent) {
        Object object = jTextComponent.getDocument().getProperty("mimeType");
        return object != null && ("text/x-java".equals(object) || "text/x-jsp".equals(object));
    }

    public boolean handleTransfer(JTextComponent jTextComponent) {
        if (this.isAcceptTarget(jTextComponent)) {
            return this.doHandleTransfer(jTextComponent);
        }
        return false;
    }

    private boolean doHandleTransfer(final JTextComponent jTextComponent) {
        final FileObject fileObject = NbEditorUtilities.getFileObject((Document)jTextComponent.getDocument());
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Method method = this.method.getWadlMethod();
        if (method == null) {
            Exceptions.printStackTrace((Throwable)new IOException("Wadl method not found"));
        }
        final String string = method.getName();
        this.targetFO = JaxRsEditorDrop.getTargetFile(jTextComponent);
        if (this.targetFO == null) {
            return false;
        }
        final ArrayList arrayList = new ArrayList();
        final ProgressDialog progressDialog = new ProgressDialog(NbBundle.getMessage(JaxRsEditorDrop.class, (String)"LBL_CodeGenProgress", (Object)string));
        this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JaxRsCodeGenerator jaxRsCodeGenerator = JaxRsCodeGeneratorFactory.create(jTextComponent, JaxRsEditorDrop.this.targetFO, JaxRsEditorDrop.this.method);
                    WadlSaasBean wadlSaasBean = jaxRsCodeGenerator.getBean();
                    boolean bl = jaxRsCodeGenerator.canShowParam();
                    List<ParameterInfo> list = wadlSaasBean.filterParametersByAuth(wadlSaasBean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
                    if (jaxRsCodeGenerator.canShowResourceInfo() || bl && !list.isEmpty()) {
                        JaxRsCodeSetupPanel jaxRsCodeSetupPanel = new JaxRsCodeSetupPanel(jaxRsCodeGenerator.getSubresourceLocatorUriTemplate(), wadlSaasBean.getQualifiedClassName(), list, jaxRsCodeGenerator.canShowResourceInfo(), bl);
                        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jaxRsCodeSetupPanel, NbBundle.getMessage(JaxRsEditorDrop.class, (String)"LBL_CustomizeSaasService", (Object)string));
                        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                        if (object.equals(NotifyDescriptor.YES_OPTION)) {
                            jaxRsCodeGenerator.setSubresourceLocatorUriTemplate(jaxRsCodeSetupPanel.getUriTemplate());
                            jaxRsCodeGenerator.setSubresourceLocatorName(jaxRsCodeSetupPanel.getMethodName());
                        } else {
                            return;
                        }
                    }
                    try {
                        jaxRsCodeGenerator.generate(progressDialog.getProgressHandle());
                    }
                    catch (IOException iOException) {
                        if (!iOException.getMessage().equals("ScanningInProgress")) {
                            arrayList.add(iOException);
                        }
                    }
                }
                catch (Exception exception) {
                    if (exception.getMessage().equals("WARN_UnsupportedDropTarget")) {
                        Util.showUnsupportedDropMessage(new Object[]{fileObject.getNameExt(), "Java Client"});
                        return;
                    }
                    arrayList.add(exception);
                }
                finally {
                    progressDialog.close();
                }
            }
        });
        this.generatorTask.schedule(50);
        progressDialog.open();
        if (arrayList.size() > 0) {
            Exceptions.printStackTrace((Throwable)((Throwable)arrayList.get(0)));
            return false;
        }
        return true;
    }

    public static FileObject getTargetFile(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return null;
        }
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)jTextComponent.getDocument());
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null || editorCookie.getOpenedPanes() == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }
}

