/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.websvc.saas.codegen.java.Constants;
import org.netbeans.modules.websvc.saas.codegen.java.CustomCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.netbeans.modules.websvc.saas.model.CustomSaasMethod;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomJavaClientCodeGenerator
extends CustomCodeGenerator {
    public CustomJavaClientCodeGenerator(JTextComponent jTextComponent, FileObject fileObject, CustomSaasMethod customSaasMethod) throws IOException {
        super(jTextComponent, fileObject, customSaasMethod);
    }

    @Override
    public Set<FileObject> generate(ProgressHandle progressHandle) throws IOException {
        this.initProgressReporting(progressHandle);
        this.preGenerate();
        this.getAuthenticationGenerator().createAuthenticatorClass();
        this.getAuthenticationGenerator().createAuthorizationClasses();
        this.getAuthenticationGenerator().modifyAuthenticationClass();
        this.setJaxbWrapper();
        this.insertSaasServiceAccessCode(this.isInBlock(this.getTargetComponent()));
        this.addImportsToTargetFile();
        this.finishProgressReporting();
        return new HashSet<FileObject>(Collections.EMPTY_LIST);
    }

    private void setJaxbWrapper() {
    }

    @Override
    public void preGenerate() throws IOException {
        Util.addJaxbLib(this.getProject());
        super.preGenerate();
    }

    protected void insertSaasServiceAccessCode(boolean bl) throws IOException {
        try {
            String string = "";
            if (bl) {
                string = this.getCustomMethodBody();
            } else {
                string = "\nprivate String call" + this.getBean().getName() + "Service() {\n";
                string = string + this.getCustomMethodBody() + "\n";
                string = string + "return result;\n";
                string = string + "}\n";
            }
            CustomJavaClientCodeGenerator.insert(string, this.getTargetComponent(), true);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    protected void addImportsToTargetFile() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getBean().getSaasServicePackageName() + "." + this.getBean().getSaasServiceName());
        if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.PLAIN) {
            arrayList.add(this.getBean().getSaasServicePackageName() + "." + this.getBean().getAuthenticatorClassName());
        }
        arrayList.add("org.netbeans.saas.RestResponse");
        Util.addImportsToSource(this.getTargetSource(), arrayList);
    }

    @Override
    protected String getCustomMethodBody() throws IOException {
        String string = "";
        String string2 = "";
        String string3 = "        ";
        String string4 = "             ";
        List<ParameterInfo> list = this.getServiceMethodParameters();
        string = string + Util.getHeaderOrParameterUsage(this.getBean().getInputParameters());
        string2 = string2 + this.getHeaderOrParameterDeclaration(list, string4);
        String string5 = string3 + "try {\n";
        string5 = string5 + "             " + this.getAuthenticationGenerator().getPreAuthenticationCode() + "\n";
        string5 = string5 + string2 + "\n";
        string5 = string5 + string4 + "RestResponse" + " result = " + this.getBean().getSaasServiceName() + "." + this.getBean().getSaasServiceMethodName() + "(" + string + ");\n";
        string5 = string5 + Util.createPrintStatement(this.getBean().getOutputWrapperPackageName(), this.getBean().getOutputWrapperName(), this.getDropFileType(), this.getBean().getHttpMethod(), this.getBean().canGenerateJAXBUnmarshaller(), string4);
        string5 = string5 + string3 + "} catch (Exception ex) {\n";
        string5 = string5 + string4 + "ex.printStackTrace();\n";
        string5 = string5 + string3 + "}\n";
        return string5;
    }

    @Override
    public boolean canShowResourceInfo() {
        return false;
    }

    @Override
    public boolean canShowParam() {
        return true;
    }
}

