/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.delegates.NullLayoutSupport;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.awt.JMenuPlus;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class SelectLayoutAction
extends CallableSystemAction {
    private static String name;

    public String getName() {
        if (name == null) {
            name = NbBundle.getBundle(SelectLayoutAction.class).getString("ACT_SelectLayout");
        }
        return name;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled() {
        Node[] nodeArray = SelectLayoutAction.getNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            RADVisualContainer rADVisualContainer = SelectLayoutAction.getContainer(nodeArray[i]);
            if (rADVisualContainer != null && !rADVisualContainer.hasDedicatedLayoutSupport()) continue;
            return false;
        }
        return true;
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        LayoutMenu layoutMenu = new LayoutMenu(this.getName());
        ((JMenuItem)((Object)layoutMenu)).setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)((Object)layoutMenu), (String)SelectLayoutAction.class.getName());
        return layoutMenu;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction() {
    }

    private static Node[] getNodes() {
        return ComponentInspector.getInstance().getExplorerManager().getSelectedNodes();
    }

    private static RADVisualContainer getContainer(Node node) {
        RADComponent rADComponent;
        RADComponentCookie rADComponentCookie = (RADComponentCookie)node.getCookie(RADComponentCookie.class);
        if (rADComponentCookie != null && (rADComponent = rADComponentCookie.getRADComponent()) instanceof RADVisualContainer) {
            return (RADVisualContainer)rADComponent;
        }
        return null;
    }

    private static PaletteItem[] getAllLayouts() {
        PaletteItem[] paletteItemArray = PaletteUtils.getAllItems();
        ArrayList<PaletteItem> arrayList = new ArrayList<PaletteItem>();
        for (int i = 0; i < paletteItemArray.length; ++i) {
            if (!paletteItemArray[i].isLayout()) continue;
            arrayList.add(paletteItemArray[i]);
        }
        PaletteItem[] paletteItemArray2 = new PaletteItem[arrayList.size()];
        arrayList.toArray(paletteItemArray2);
        return paletteItemArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertToNewLayout(RADVisualContainer rADVisualContainer) {
        Object object;
        FormModel formModel = rADVisualContainer.getFormModel();
        LayoutModel layoutModel = formModel.getLayoutModel();
        formModel.setNaturalContainerLayout(rADVisualContainer);
        FormDesigner formDesigner = FormEditor.getFormDesigner(formModel);
        Container container = rADVisualContainer.getContainerDelegate(formDesigner.getComponent(rADVisualContainer));
        Insets insets = new Insets(0, 0, 0, 0);
        if (container instanceof JComponent && (object = ((JComponent)container).getBorder()) != null) {
            insets = object.getBorderInsets(container);
        }
        object = new HashMap();
        Rectangle rectangle = new Rectangle();
        for (RADVisualComponent rADVisualComponent : rADVisualContainer.getSubComponents()) {
            Component component = (Component)formDesigner.getComponent(rADVisualComponent);
            if (component == null) {
                component = (Component)rADVisualComponent.getBeanInstance();
            }
            Rectangle rectangle2 = component.getBounds();
            Dimension dimension = component.getPreferredSize();
            if (rectangle2.equals(rectangle)) {
                rectangle2.setSize(dimension);
            }
            rectangle2 = new Rectangle(rectangle2.x - insets.left, rectangle2.y - insets.top, rectangle2.width, rectangle2.height);
            object.put(rADVisualComponent.getId(), rectangle2);
        }
        Object object2 = layoutModel.getChangeMark();
        UndoableEdit undoableEdit = layoutModel.getUndoableEdit();
        int n = 1;
        try {
            formDesigner.getLayoutDesigner().copyLayoutFromOutside((Map<String, Rectangle>)object, rADVisualContainer.getId(), false);
            n = 0;
        }
        finally {
            if (!object2.equals(layoutModel.getChangeMark())) {
                formModel.addUndoableEdit(undoableEdit);
            }
            if (n != 0) {
                formModel.forceUndoOfCompoundEdit();
            } else {
                FormEditor.updateProjectForNaturalLayout(formModel);
            }
        }
    }

    private static class LayoutActionListener
    implements ActionListener {
        private PaletteItem paletteItem;

        LayoutActionListener(PaletteItem paletteItem) {
            this.paletteItem = paletteItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Node[] nodeArray = SelectLayoutAction.getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                RADVisualContainer rADVisualContainer = SelectLayoutAction.getContainer(nodeArray[i]);
                if (rADVisualContainer == null) continue;
                if (this.paletteItem != null) {
                    rADVisualContainer.getFormModel().getComponentCreator().createComponent(this.paletteItem.getComponentClassSource(), rADVisualContainer, null);
                    continue;
                }
                if (rADVisualContainer.getLayoutSupport() == null) continue;
                SelectLayoutAction.convertToNewLayout(rADVisualContainer);
            }
        }
    }

    private static class LayoutMenu
    extends JMenuPlus {
        private boolean initialized = false;

        private LayoutMenu(String string) {
            super(string);
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu jPopupMenu = super.getPopupMenu();
            Node[] nodeArray = SelectLayoutAction.getNodes();
            if (nodeArray.length != 0 && !this.initialized) {
                jPopupMenu.removeAll();
                JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(SelectLayoutAction.class, (String)"NAME_FreeDesign"));
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(new LayoutActionListener(null));
                jPopupMenu.addSeparator();
                RADVisualContainer rADVisualContainer = SelectLayoutAction.getContainer(nodeArray[0]);
                boolean bl = RADVisualContainer.isFreeDesignContainer(rADVisualContainer);
                if (bl) {
                    LayoutMenu.setBoldFontForMenuText(jMenuItem);
                }
                PaletteItem[] paletteItemArray = SelectLayoutAction.getAllLayouts();
                for (int i = 0; i < paletteItemArray.length; ++i) {
                    jMenuItem = new JMenuItem(paletteItemArray[i].getNode().getDisplayName());
                    HelpCtx.setHelpIDString((JComponent)jMenuItem, (String)SelectLayoutAction.class.getName());
                    LayoutMenu.addSortedMenuItem(jPopupMenu, jMenuItem);
                    jMenuItem.addActionListener(new LayoutActionListener(paletteItemArray[i]));
                    if (bl || !this.isContainersLayout(rADVisualContainer, paletteItemArray[i])) continue;
                    LayoutMenu.setBoldFontForMenuText(jMenuItem);
                }
                this.initialized = true;
            }
            return jPopupMenu;
        }

        private boolean isContainersLayout(RADVisualContainer rADVisualContainer, PaletteItem paletteItem) {
            return rADVisualContainer != null && (rADVisualContainer.getLayoutSupport().getLayoutDelegate().getSupportedClass() == paletteItem.getComponentClass() || rADVisualContainer.getLayoutSupport().getLayoutDelegate().getClass() == NullLayoutSupport.class && paletteItem.getComponentClass() == NullLayoutSupport.class);
        }

        private static void addSortedMenuItem(JPopupMenu jPopupMenu, JMenuItem jMenuItem) {
            int n = jPopupMenu.getComponentCount();
            String string = jMenuItem.getText();
            for (int i = 2; i < n; ++i) {
                String string2;
                if (!(jPopupMenu.getComponent(i) instanceof JMenuItem) || string.compareTo(string2 = ((JMenuItem)jPopupMenu.getComponent(i)).getText()) >= 0) continue;
                jPopupMenu.add((Component)jMenuItem, i);
                return;
            }
            jPopupMenu.add(jMenuItem);
        }

        private static void setBoldFontForMenuText(JMenuItem jMenuItem) {
            Font font = jMenuItem.getFont();
            jMenuItem.setFont(font.deriveFont(font.getStyle() | 1));
        }
    }
}

