/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.form.BindingCustomizer;
import org.netbeans.modules.form.BindingProperty;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponentCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class BindAction
extends CookieAction {
    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return new Class[]{RADComponentCookie.class};
    }

    public String getName() {
        return "Bind";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] nodeArray) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu jMenu = new JMenu(NbBundle.getMessage(BindAction.class, (String)"ACT_Bind"));
        jMenu.setEnabled(this.isEnabled());
        jMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                JMenu jMenu = (JMenu)menuEvent.getSource();
                BindAction.this.createBindingsSubmenu(jMenu);
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private void createBindingsSubmenu(JMenu jMenu) {
        BindingProperty[][] bindingPropertyArray;
        Node[] nodeArray;
        if (jMenu.getMenuComponentCount() > 0) {
            jMenu.removeAll();
        }
        if ((nodeArray = this.getActivatedNodes()).length != 1) {
            return;
        }
        RADComponentCookie rADComponentCookie = (RADComponentCookie)nodeArray[0].getCookie(RADComponentCookie.class);
        if (rADComponentCookie == null) {
            return;
        }
        BindingProperty[] bindingPropertyArray2 = bindingPropertyArray[(bindingPropertyArray = rADComponentCookie.getRADComponent().getBindingProperties())[0].length == 0 ? 1 : 0];
        if (bindingPropertyArray2.length > 0) {
            for (BindingProperty bindingProperty : bindingPropertyArray2) {
                BindingMenuItem bindingMenuItem = new BindingMenuItem(bindingProperty);
                bindingMenuItem.addActionListener(bindingMenuItem);
                jMenu.add(bindingMenuItem);
            }
        } else {
            JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(BindAction.class, (String)"MSG_NoBinding"));
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
        }
    }

    private static class BindingMenuItem
    extends JMenuItem
    implements ActionListener {
        private BindingProperty bindingProperty;

        private BindingMenuItem(BindingProperty bindingProperty) {
            this.bindingProperty = bindingProperty;
            this.setText(bindingProperty.getDisplayName());
            this.updateFont();
        }

        private void updateFont() {
            Font font = this.getFont();
            if (this.bindingProperty.getValue() != null) {
                this.setFont(font.deriveFont(font.getStyle() | 1));
            } else {
                this.setFont(font.deriveFont(font.getStyle() & 0xFFFFFFFE));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MetaBinding metaBinding = this.bindingProperty.getValue();
            final BindingCustomizer bindingCustomizer = new BindingCustomizer(this.bindingProperty);
            bindingCustomizer.setBinding(metaBinding);
            bindingCustomizer.getDialog(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BindingMenuItem.this.bindingProperty.setValue(bindingCustomizer.getBinding());
                    BindingMenuItem.this.updateFont();
                }
            }).setVisible(true);
        }
    }
}

