/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.ResourcePanel;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.form.ResourceValue;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

public class ResourceWrapperEditor
implements ExPropertyEditor,
FormAwareEditor,
PropertyChangeListener,
ChangeListener,
VetoableChangeListener {
    protected PropertyEditor delegateEditor;
    protected FormModel formModel;
    protected FormProperty property;
    private boolean ignoreChange;
    private PropertyChangeSupport changeSupport;
    private Object propertyValue;
    protected ResourcePanel resourcePanel;

    public ResourceWrapperEditor(PropertyEditor propertyEditor) {
        this.delegateEditor = propertyEditor;
        this.delegateEditor.addPropertyChangeListener(this);
    }

    public PropertyEditor getDelegatedPropertyEditor() {
        return this.delegateEditor;
    }

    void setDelegatedPropertyEditor(PropertyEditor propertyEditor) {
        this.delegateEditor.removePropertyChangeListener(this);
        this.delegateEditor = propertyEditor;
        this.delegateEditor.addPropertyChangeListener(this);
        this.propertyValue = this.delegateEditor.getValue();
    }

    public void setContext(FormModel formModel, FormProperty formProperty) {
        this.formModel = formModel;
        this.property = formProperty;
        if (this.delegateEditor instanceof FormAwareEditor) {
            ((FormAwareEditor)((Object)this.delegateEditor)).setContext(formModel, formProperty);
        }
    }

    public void updateFormVersionLevel() {
        if (this.getValue() instanceof ResourceValue) {
            this.formModel.raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
        }
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        if (this.property != null) {
            propertyEnv.removeVetoableChangeListener((VetoableChangeListener)this);
            propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            propertyEnv.addVetoableChangeListener((VetoableChangeListener)this);
        }
        if (this.delegateEditor instanceof ExPropertyEditor) {
            ((ExPropertyEditor)this.delegateEditor).attachEnv(propertyEnv);
        }
    }

    public void setValue(Object object) {
        this.propertyValue = object;
        this.ignoreChange = true;
        this.setValueToDelegate(object);
        this.ignoreChange = false;
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.propertyValue;
    }

    public Object getUnwrappedValue() {
        return this.delegateEditor.getValue();
    }

    public void setAsText(String string) {
        if (string.equals(this.delegateEditor.getAsText())) {
            return;
        }
        this.ignoreChange = true;
        this.delegateEditor.setAsText(string);
        this.ignoreChange = false;
        this.propertyValue = this.delegateEditor.getValue();
        this.firePropertyChange();
    }

    public String getAsText() {
        return this.delegateEditor.getAsText();
    }

    public boolean isPaintable() {
        return this.delegateEditor.isPaintable();
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        this.delegateEditor.paintValue(graphics, rectangle);
    }

    public String getJavaInitializationString() {
        if (this.propertyValue instanceof ResourceValue) {
            return ((ResourceValue)this.propertyValue).getJavaInitializationCode();
        }
        return this.delegateEditor.getJavaInitializationString();
    }

    public String[] getTags() {
        return this.delegateEditor.getTags();
    }

    public Component getCustomEditor() {
        JComponent jComponent;
        if (this.resourcePanel == null) {
            this.createResourcePanel();
        }
        if (this.resourcePanel != null) {
            boolean bl;
            String string;
            if (this.propertyValue instanceof ResourceValue) {
                string = ((ResourceValue)this.propertyValue).getKey();
                bl = true;
            } else {
                string = ResourceSupport.getDefaultKey(this.property, 2);
                bl = ResourceSupport.isPropertyForResourcing(this.property);
            }
            this.resourcePanel.init(string, bl);
            jComponent = this.resourcePanel.getComponent();
        } else {
            jComponent = null;
        }
        return this.createCustomEditorGUI(jComponent);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        ResourceWrapperEditor resourceWrapperEditor = this;
        synchronized (resourceWrapperEditor) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void setValueToDelegate(Object object) {
        if (object instanceof ResourceValue) {
            object = ((ResourceValue)object).getValue();
        }
        this.delegateEditor.setValue(object);
    }

    protected void setValueToResourcePanel() {
        this.resourcePanel.setValue(this.delegateEditor.getValue(), null, null);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.ignoreChange) {
            if (this.propertyValue instanceof ResourceValue) {
                this.setValueToResourcePanel();
            } else {
                this.propertyValue = this.delegateEditor.getValue();
            }
            this.firePropertyChange();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        ResourceValue resourceValue = this.resourcePanel.getResource();
        if (resourceValue != null) {
            if (resourceValue.getValue() == null) {
                this.setValueToResourcePanel();
                resourceValue = this.resourcePanel.getResource();
            }
            this.setValue(resourceValue);
        } else {
            this.propertyValue = this.delegateEditor.getValue();
            this.firePropertyChange();
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if ("state".equals(propertyChangeEvent.getPropertyName())) {
            boolean bl = false;
            if (this.resourcePanel != null) {
                ResourceValue resourceValue;
                if (this.propertyValue instanceof ResourceValue && (resourceValue = this.resourcePanel.getResource()) != null) {
                    if (resourceValue.getValue() == ResourceValue.IGNORED_VALUE) {
                        throw new PropertyVetoException("Invalid resource value", propertyChangeEvent);
                    }
                    if (resourceValue != this.propertyValue) {
                        this.setValue(resourceValue);
                    }
                } else {
                    bl = true;
                }
            }
            ResourceSupport.setExcludedProperty(this.property, bl);
        }
    }

    private void firePropertyChange() {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("", null, null);
        }
    }

    private void createResourcePanel() {
        this.resourcePanel = ResourceSupport.createResourcePanel(this.property, this.propertyValue instanceof ResourceValue);
        if (this.resourcePanel != null) {
            this.resourcePanel.addChangeListener(this);
        }
    }

    protected Component createCustomEditorGUI(Component component) {
        if (component == null) {
            return this.delegateEditor.getCustomEditor();
        }
        JPanel jPanel = new JPanel();
        Component component2 = this.delegateEditor.getCustomEditor();
        GroupLayout groupLayout = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setAutocreateGaps(true);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup().add(component2).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add(component).addPreferredGap(0)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().add(component2).addPreferredGap(1).add(component));
        return jPanel;
    }
}

