/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteMenuView;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.palette.ScrollPopupMenu;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

class FormToolBar
extends JToolBar {
    private FormDesigner formDesigner;
    private JToggleButton selectionButton;
    private JToggleButton connectionButton;
    private JToggleButton paletteButton;
    private JLabel addLabel;
    private PaletteMenuView paletteMenuView;
    private Listener listener;

    public FormToolBar(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
        this.setFloatable(false);
        this.setRollover(true);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.listener = new Listener();
        this.selectionButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/selection_mode.png")), false);
        this.selectionButton.addActionListener(this.listener);
        this.selectionButton.addMouseListener(this.listener);
        this.selectionButton.setToolTipText(FormUtils.getBundleString("CTL_SelectionButtonHint"));
        HelpCtx.setHelpIDString((JComponent)this.selectionButton, (String)"gui.about");
        this.selectionButton.setSelected(true);
        this.initButton(this.selectionButton);
        this.connectionButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/connection_mode.png")), false);
        this.connectionButton.addActionListener(this.listener);
        this.connectionButton.addMouseListener(this.listener);
        this.connectionButton.setToolTipText(FormUtils.getBundleString("CTL_ConnectionButtonHint"));
        HelpCtx.setHelpIDString((JComponent)this.connectionButton, (String)"gui.connecting.intro");
        this.initButton(this.connectionButton);
        this.paletteButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/beansButton.gif")), false);
        this.paletteButton.addActionListener(this.listener);
        this.paletteButton.addMouseListener(this.listener);
        this.paletteButton.setToolTipText(FormUtils.getBundleString("CTL_BeansButtonHint"));
        HelpCtx.setHelpIDString((JComponent)this.paletteButton, (String)"gui.components.adding");
        ScrollPopupMenu.doNotCancelPopupHack(this.paletteButton);
        this.initButton(this.paletteButton);
        this.addLabel = new JLabel();
        this.addMouseListener(this.listener);
        this.connectionButton.getAccessibleContext().setAccessibleName(this.connectionButton.getToolTipText());
        this.selectionButton.getAccessibleContext().setAccessibleName(this.selectionButton.getToolTipText());
        this.paletteButton.getAccessibleContext().setAccessibleName(this.paletteButton.getToolTipText());
        this.connectionButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_ConnectionMode"));
        this.selectionButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_SelectionMode"));
        this.paletteButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_AddMode"));
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        JToolBar.Separator separator2 = new JToolBar.Separator();
        separator2.setOrientation(1);
        JToolBar.Separator separator3 = new JToolBar.Separator();
        separator3.setOrientation(1);
        TestAction testAction = (TestAction)SystemAction.get(TestAction.class);
        JButton jButton = (JButton)testAction.getToolbarPresenter();
        jButton.addMouseListener(this.listener);
        this.initButton(jButton);
        this.add(Box.createHorizontalStrut(4));
        this.add(separator);
        this.add(Box.createHorizontalStrut(6));
        this.add(this.selectionButton);
        this.add(this.connectionButton);
        this.add(this.paletteButton);
        this.add(Box.createHorizontalStrut(6));
        this.add(jButton);
        this.add(Box.createHorizontalStrut(4));
        this.add(separator2);
        this.add(Box.createHorizontalStrut(4));
        this.installDesignerActions();
        this.add(Box.createHorizontalStrut(4));
        this.add(separator3);
        this.add(Box.createHorizontalStrut(4));
        this.installResizabilityActions();
        this.add(Box.createHorizontalGlue());
        this.add(this.addLabel);
        if (!FormLoaderSettings.getInstance().isPaletteInToolBar()) {
            this.addLabel.setVisible(false);
            this.paletteButton.setVisible(false);
        }
    }

    void installDesignerActions() {
        Collection<Action> collection = this.formDesigner.getDesignerActions(true);
        for (Action action : collection) {
            JButton jButton = this.add(action);
            this.initButton(jButton);
        }
    }

    void installResizabilityActions() {
        Collection<Action> collection = this.formDesigner.getResizabilityActions();
        Iterator<Action> iterator = collection.iterator();
        JToggleButton[] jToggleButtonArray = new JToggleButton[2];
        for (int i = 0; i < collection.size(); ++i) {
            Action action = iterator.next();
            JToggleButton jToggleButton = new JToggleButton();
            jToggleButton.setAction(action);
            this.initButton(jToggleButton);
            jToggleButtonArray[i] = jToggleButton;
            this.add(jToggleButton);
            this.add(Box.createHorizontalStrut(2));
        }
        this.formDesigner.setResizabilityButtons(jToggleButtonArray);
    }

    private void initButton(AbstractButton abstractButton) {
        if (!"Windows".equals(UIManager.getLookAndFeel().getID()) || !(abstractButton instanceof JToggleButton)) {
            abstractButton.setBorderPainted(false);
        }
        abstractButton.setOpaque(false);
        abstractButton.setFocusPainted(false);
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
    }

    void updateDesignerMode(int n) {
        this.selectionButton.setSelected(n == 0);
        this.connectionButton.setSelected(n == 1);
        this.paletteButton.setSelected(n == 2);
        if (this.addLabel.isVisible()) {
            PaletteItem paletteItem = PaletteUtils.getSelectedItem();
            if (paletteItem != null && n == 2) {
                this.addLabel.setIcon(new ImageIcon(paletteItem.getNode().getIcon(1)));
                this.addLabel.setText(paletteItem.getNode().getDisplayName());
            } else {
                this.addLabel.setText("");
                this.addLabel.setIcon(null);
            }
        }
    }

    void showPaletteButton(boolean bl) {
        this.addLabel.setVisible(bl);
        this.paletteButton.setVisible(bl);
    }

    private void showPaletteViewMenu() {
        if (this.paletteMenuView == null) {
            this.paletteMenuView = new PaletteMenuView(this.listener);
            this.paletteMenuView.getPopupMenu().addPopupMenuListener(this.listener);
        }
        Point point = this.paletteButton.getLocation();
        point.y += this.paletteButton.getHeight() + 2;
        this.paletteMenuView.getPopupMenu().show(this, point.x, point.y);
    }

    private void showVisibilityPopupMenu(Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(FormUtils.getBundleString("CTL_PaletteButton_MenuItem"));
        jCheckBoxMenuItem.setSelected(FormLoaderSettings.getInstance().isPaletteInToolBar());
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormLoaderSettings.getInstance().setPaletteInToolBar(jCheckBoxMenuItem.isSelected());
            }
        });
        jPopupMenu.add(jCheckBoxMenuItem);
        jPopupMenu.show(this, point.x, point.y);
    }

    public String getUIClassID() {
        if (UIManager.get("Nb.Toolbar.ui") != null) {
            return "Nb.Toolbar.ui";
        }
        return super.getUIClassID();
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    NodeAcceptor,
    PopupMenuListener {
        private boolean showMenu;

        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == FormToolBar.this.selectionButton) {
                FormToolBar.this.formDesigner.toggleSelectionMode();
            } else if (actionEvent.getSource() == FormToolBar.this.connectionButton) {
                FormToolBar.this.formDesigner.toggleConnectionMode();
            } else if (actionEvent.getSource() == FormToolBar.this.paletteButton) {
                if (this.showMenu) {
                    FormToolBar.this.formDesigner.toggleAddMode();
                    FormToolBar.this.showPaletteViewMenu();
                } else {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    FormToolBar.this.formDesigner.toggleSelectionMode();
                }
            }
        }

        public boolean acceptNodes(Node[] nodeArray) {
            if (nodeArray.length == 0) {
                return false;
            }
            PaletteItem paletteItem = (PaletteItem)nodeArray[0].getCookie(PaletteItem.class);
            PaletteUtils.selectItem(paletteItem);
            return true;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (PaletteUtils.getSelectedItem() == null) {
                FormToolBar.this.formDesigner.toggleSelectionMode();
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == FormToolBar.this.paletteButton) {
                this.showMenu = !FormToolBar.this.paletteButton.isSelected();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) && FormToolBar.this.formDesigner.getDesignerMode() == 0) {
                FormToolBar.this.showVisibilityPopupMenu(mouseEvent.getPoint());
            }
        }
    }
}

