/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.text.BadLocationException;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.BindingDesignSupport;
import org.netbeans.modules.form.CodeGenerator;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.DefaultRADAction;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormOthersNode;
import org.netbeans.modules.form.FormRootNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.PersistenceException;
import org.netbeans.modules.form.PersistenceManager;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.form.actions.EditContainerAction;
import org.netbeans.modules.form.actions.EditFormAction;
import org.netbeans.modules.form.assistant.AssistantModel;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormEditor {
    static final int LOADING = 1;
    static final int SAVING = 2;
    private FormModel formModel;
    private FormRootNode formRootNode;
    private FormDesigner formDesigner;
    private CodeGenerator codeGenerator;
    private FormJavaSource formJavaSource;
    private ResourceSupport resourceSupport;
    private BindingDesignSupport bindingSupport;
    private List<Throwable> persistenceErrors;
    private PersistenceManager persistenceManager;
    private boolean formLoaded = false;
    private static Map<FormModel, FormEditor> openForms = new Hashtable<FormModel, FormEditor>();
    private static Map<FormModel, AssistantModel> formModelToAssistant = new WeakHashMap<FormModel, AssistantModel>();
    private List<Window> floatingWindows;
    private FormDataObject formDataObject;
    private PropertyChangeListener dataObjectListener;
    private static PreferenceChangeListener settingsListener;
    private PropertyChangeListener paletteListener;
    private FormModelListener formListener;
    private List<Action> defaultActions;
    private boolean upgradeCheckPosted;

    FormEditor(FormDataObject formDataObject) {
        this.formDataObject = formDataObject;
    }

    public final FormNode getFormRootNode() {
        return this.formRootNode;
    }

    public final FormNode getOthersContainerNode() {
        FormOthersNode formOthersNode = this.formRootNode.getOthersNode();
        return formOthersNode != null ? formOthersNode : this.formRootNode;
    }

    public final FormModel getFormModel() {
        return this.formModel;
    }

    public final FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    private final FormJavaSource getFormJavaSource() {
        return this.formJavaSource;
    }

    CodeGenerator getCodeGenerator() {
        if (!this.formLoaded) {
            return null;
        }
        if (this.codeGenerator == null) {
            this.codeGenerator = new JavaCodeGenerator();
        }
        return this.codeGenerator;
    }

    ResourceSupport getResourceSupport() {
        if (this.resourceSupport == null && this.formModel != null) {
            this.resourceSupport = new ResourceSupport(this.formModel);
            this.resourceSupport.init();
        }
        return this.resourceSupport;
    }

    BindingDesignSupport getBindingSupport() {
        if (this.bindingSupport == null && this.formModel != null) {
            this.bindingSupport = new BindingDesignSupport(this.formModel);
        }
        return this.bindingSupport;
    }

    boolean isFormLoaded() {
        return this.formLoaded;
    }

    void loadFormDesigner() {
        JFrame jFrame;
        block2: {
            jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
            StatusDisplayer.getDefault().setStatusText(FormUtils.getFormattedBundleString("FMT_OpeningForm", new Object[]{this.formDataObject.getFormFile().getName()}));
            RepaintManager.currentManager(jFrame).paintDirtyRegions();
            jFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            jFrame.getGlassPane().setVisible(true);
            this.preCreationUpdate();
            try {
                this.loadFormData();
            }
            catch (PersistenceException persistenceException) {
                this.logPersistenceError(persistenceException, 0);
                if (this.formLoaded) break block2;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FormEditor.this.getFormDataObject().getFormEditorSupport().selectJavaEditor();
                    }
                });
            }
        }
        StatusDisplayer.getDefault().setStatusText("");
        jFrame.getGlassPane().setVisible(false);
        jFrame.getGlassPane().setCursor(null);
        this.reportErrors(1);
        this.postCreationUpdate();
    }

    boolean loadForm() {
        if (this.formLoaded) {
            return true;
        }
        if (EventQueue.isDispatchThread()) {
            try {
                this.loadFormData();
            }
            catch (PersistenceException persistenceException) {
                this.logPersistenceError(persistenceException, 0);
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            FormEditor.this.loadFormData();
                        }
                        catch (PersistenceException persistenceException) {
                            FormEditor.this.logPersistenceError(persistenceException, 0);
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.formLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFormData() throws PersistenceException {
        if (this.formLoaded) {
            return;
        }
        this.resetPersistenceErrorLog();
        this.persistenceManager = this.recognizeForm(this.formDataObject);
        this.formModel = new FormModel();
        this.formModel.setName(this.formDataObject.getName());
        this.formModel.setReadOnly(this.formDataObject.isReadOnly());
        this.formJavaSource = new FormJavaSource(this.formDataObject);
        this.formModel.getCodeStructure().setFormJavaSource(this.formJavaSource);
        openForms.put(this.formModel, this);
        Logger.getLogger("TIMER").log(Level.FINE, "FormModel", new Object[]{this.formDataObject.getPrimaryFile(), this.formModel});
        this.formModel.getSettings().getAutoSetComponentName();
        Object object = this.persistenceManager;
        synchronized (object) {
            try {
                FormLAF.executeWithLookAndFeel(this.formModel, new Mutex.ExceptionAction(){

                    public Object run() throws Exception {
                        FormEditor.this.persistenceManager.loadForm(FormEditor.this.formDataObject, FormEditor.this.formModel, FormEditor.this.persistenceErrors);
                        return null;
                    }
                });
            }
            catch (PersistenceException persistenceException) {
                this.persistenceManager = null;
                openForms.remove(this.formModel);
                this.formModel = null;
                throw persistenceException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.persistenceManager = null;
                openForms.remove(this.formModel);
                this.formModel = null;
                return;
            }
        }
        this.formLoaded = true;
        this.getCodeGenerator().initialize(this.formModel);
        object = this.getResourceSupport();
        if (((ResourceSupport)object).getDesignLocale() != null) {
            ((ResourceSupport)object).updateDesignLocale();
        }
        this.getBindingSupport();
        this.formModel.fireFormLoaded();
        if (this.formModel.wasCorrected()) {
            this.formModel.fireFormChanged(false);
        }
        this.formRootNode = new FormRootNode(this.formModel);
        this.formRootNode.getChildren().getNodes();
        this.formDataObject.getNodeDelegate().getChildren().add(new Node[]{this.formRootNode});
        this.attachFormListener();
        this.attachDataObjectListener();
        FormEditor.attachSettingsListener();
        this.attachPaletteListener();
    }

    public boolean saveForm() {
        try {
            this.saveFormData();
            return true;
        }
        catch (PersistenceException persistenceException) {
            this.logPersistenceError(persistenceException, 0);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFormData() throws PersistenceException {
        if (this.formLoaded && !this.formDataObject.formFileReadOnly() && !this.formModel.isReadOnly()) {
            this.formModel.fireFormToBeSaved();
            this.resetPersistenceErrorLog();
            PersistenceManager persistenceManager = this.persistenceManager;
            synchronized (persistenceManager) {
                this.persistenceManager.saveForm(this.formDataObject, this.formModel, this.persistenceErrors);
            }
        }
    }

    private void resetPersistenceErrorLog() {
        if (this.persistenceErrors != null) {
            this.persistenceErrors.clear();
        } else {
            this.persistenceErrors = new ArrayList<Throwable>();
        }
    }

    private void logPersistenceError(Throwable throwable, int n) {
        if (this.persistenceErrors == null) {
            this.persistenceErrors = new ArrayList<Throwable>();
        }
        if (n < 0) {
            this.persistenceErrors.add(throwable);
        } else {
            this.persistenceErrors.add(n, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceManager recognizeForm(FormDataObject formDataObject) throws PersistenceException {
        Object object;
        Object object2;
        Iterator<PersistenceManager> iterator = PersistenceManager.getManagers();
        if (!iterator.hasNext()) {
            PersistenceException persistenceException = new PersistenceException("No persistence manager registered");
            ErrorManager.getDefault().annotate((Throwable)persistenceException, 65536, null, FormUtils.getBundleString("MSG_ERR_NoPersistenceManager"), null, null);
            throw persistenceException;
        }
        do {
            object = object2 = iterator.next();
            synchronized (object) {
                try {
                    if (((PersistenceManager)object2).canLoadForm(formDataObject)) {
                        this.resetPersistenceErrorLog();
                        return object2;
                    }
                }
                catch (PersistenceException persistenceException) {
                    this.logPersistenceError(persistenceException);
                }
            }
        } while (iterator.hasNext());
        if (!this.anyPersistenceError()) {
            object2 = new PersistenceException("Form file format not recognized");
            ErrorManager.getDefault().annotate((Throwable)object2, 65536, null, FormUtils.getBundleString("MSG_ERR_NotRecognizedForm"), null, null);
        } else {
            object = null;
            int n = this.persistenceErrors.size();
            if (n == 1) {
                object2 = (PersistenceException)this.persistenceErrors.get(0);
                Throwable throwable = ((PersistenceException)object2).getOriginalException();
                object = throwable != null ? throwable : object2;
                n = 0;
            } else {
                object = object2 = new PersistenceException("Form file cannot be loaded");
            }
            ErrorManager.getDefault().annotate((Throwable)object, FormUtils.getBundleString("MSG_ERR_LoadingErrors"));
            for (int i = 0; i < n; ++i) {
                PersistenceException persistenceException = (PersistenceException)this.persistenceErrors.get(i);
                Throwable throwable = persistenceException.getOriginalException();
                ErrorManager.getDefault().annotate((Throwable)object2, throwable != null ? throwable : persistenceException);
            }
            this.resetPersistenceErrorLog();
        }
        throw object2;
    }

    private void logPersistenceError(Throwable throwable) {
        this.logPersistenceError(throwable, -1);
    }

    boolean anyPersistenceError() {
        return this.persistenceErrors != null && !this.persistenceErrors.isEmpty();
    }

    public void reportErrors(int n) {
        if (!this.anyPersistenceError()) {
            return;
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        boolean bl = n == 1 && this.formLoaded;
        boolean bl2 = false;
        for (Throwable throwable : this.persistenceErrors) {
            ErrorManager.Annotation[] annotationArray;
            if (throwable instanceof PersistenceException && (annotationArray = ((PersistenceException)throwable).getOriginalException()) != null) {
                throwable = annotationArray;
            }
            if (bl && !bl2) {
                annotationArray = errorManager.findAnnotations(throwable);
                int n2 = 0;
                if (annotationArray != null && annotationArray.length != 0) {
                    for (int i = 0; i < annotationArray.length; ++i) {
                        int n3 = annotationArray[i].getSeverity();
                        if (n3 == 0) {
                            n3 = 4096;
                        }
                        if (n3 <= n2) continue;
                        n2 = n3;
                    }
                } else {
                    n2 = 4096;
                }
                if (n2 > 16) {
                    bl2 = true;
                }
            }
            errorManager.notify(1, throwable);
            errorManager.notify(256, throwable);
        }
        if (bl && bl2) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JButton jButton = new JButton(FormUtils.getBundleString("CTL_ViewOnly"));
                    JButton jButton2 = new JButton(FormUtils.getBundleString("CTL_AllowEditing"));
                    Object object = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)FormUtils.getBundleString("MSG_FormLoadedWithErrors"), FormUtils.getBundleString("CTL_FormLoadedWithErrors"), -1, 2, new Object[]{jButton, jButton2, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton));
                    if (object == jButton) {
                        FormEditor.this.setFormReadOnly();
                    } else if (object == jButton2) {
                        FormEditor.this.destroyInvalidComponents();
                    } else {
                        FormEditor.this.getFormDesigner().reset(FormEditor.this);
                        FormEditor.this.closeForm();
                        FormEditor.this.getFormDataObject().getFormEditorSupport().selectJavaEditor();
                    }
                }
            });
        }
        this.resetPersistenceErrorLog();
    }

    private void destroyInvalidComponents() {
        Collection<RADComponent> collection = this.formModel.getAllComponents();
        ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>(collection.size());
        for (RADComponent rADComponent : collection) {
            if (rADComponent.isValid()) continue;
            arrayList.add(rADComponent);
        }
        for (RADComponent rADComponent : arrayList) {
            try {
                rADComponent.getNodeReference().destroy();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void setFormReadOnly() {
        this.formModel.setReadOnly(true);
        this.getFormDesigner().getHandleLayer().setViewOnly(true);
        this.detachFormListener();
        this.getFormDataObject().getFormEditorSupport().updateMVTCDisplayName();
    }

    boolean needPostCreationUpdate() {
        return Boolean.TRUE.equals(this.formDataObject.getPrimaryFile().getAttribute("justCreatedByNewWizard"));
    }

    private void preCreationUpdate() {
        Object object;
        FileObject fileObject = this.formDataObject.getPrimaryFile();
        Object object2 = fileObject.getAttribute("requiredLibrary");
        if (!(object2 == null || (object = fileObject.getAttribute("requiredClass")) != null && ClassPathUtils.isOnClassPath(fileObject, object.toString()))) {
            try {
                Library library = LibraryManager.getDefault().getLibrary((String)object2);
                ClassPathUtils.updateProject(fileObject, new ClassSource(object == null ? null : object.toString(), new ClassSource.LibraryEntry(library)));
            }
            catch (IOException iOException) {
                Logger.getLogger(FormEditor.class.getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    private void postCreationUpdate() {
        if (this.formLoaded && this.formModel != null && !this.formModel.isReadOnly() && this.needPostCreationUpdate()) {
            this.formModel.setMaxVersionLevel(FormModel.LATEST_VERSION);
            FormLAF.executeWithLookAndFeel(this.formModel, new Runnable(){

                public void run() {
                    FormEditor.this.getResourceSupport().prepareNewForm();
                }
            });
            this.formModel.getSettings().getLayoutCodeTarget();
            this.formModel.fireFormChanged(true);
            this.checkSuppressWarningsAnnotation();
            FormEditorSupport formEditorSupport = this.formDataObject.getFormEditorSupport();
            try {
                if (formEditorSupport.isModified()) {
                    this.saveFormData();
                    formEditorSupport.saveSourceOnly();
                }
                this.formDataObject.getPrimaryFile().setAttribute("justCreatedByNewWizard", null);
                this.formDataObject.getPrimaryFile().setAttribute("nonEditableTemplate", null);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    FormDesigner getFormDesigner() {
        if (!this.formLoaded) {
            return null;
        }
        return this.formDesigner;
    }

    void setFormDesigner(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
    }

    void closeForm() {
        if (this.formLoaded) {
            FormEditor formEditor;
            this.formModel.fireFormToBeClosed();
            openForms.remove(this.formModel);
            formModelToAssistant.remove(this.formModel);
            this.formLoaded = false;
            if (this.formDataObject.isValid()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if (FormEditor.this.formDataObject.isValid()) {
                            FormEditor.this.formDataObject.getNodeDelegate().getChildren().remove(new Node[]{FormEditor.this.formRootNode});
                        }
                        FormEditor.this.formRootNode = null;
                    }
                });
            }
            this.detachFormListener();
            this.detachDataObjectListener();
            this.detachPaletteListener();
            if (openForms.isEmpty()) {
                formEditor = null;
                FormEditor.detachSettingsListener();
            } else {
                formEditor = openForms.values().iterator().next();
            }
            if (ComponentInspector.exists()) {
                ComponentInspector.getInstance().focusForm(formEditor);
            }
            if (this.floatingWindows != null) {
                if (this.floatingWindows.size() > 0) {
                    LinkedList<Window> linkedList = new LinkedList<Window>(this.floatingWindows);
                    for (Window window : linkedList) {
                        if (!window.isVisible()) continue;
                        window.setVisible(false);
                    }
                }
                this.floatingWindows = null;
            }
            this.formDesigner = null;
            this.persistenceManager = null;
            this.persistenceErrors = null;
            this.formModel = null;
            this.codeGenerator = null;
            this.formJavaSource = null;
            this.resourceSupport = null;
            this.bindingSupport = null;
        }
    }

    private void attachFormListener() {
        if (this.formListener != null || this.formDataObject.isReadOnly() || this.formModel.isReadOnly()) {
            return;
        }
        this.formListener = new FormModelListener(){

            public void formChanged(FormModelEvent[] formModelEventArray) {
                Object object;
                if (formModelEventArray == null) {
                    return;
                }
                boolean bl = false;
                HashSet<ComponentContainer> hashSet = formModelEventArray.length > 0 ? new HashSet<ComponentContainer>() : null;
                HashSet<RADComponent> hashSet2 = null;
                FormNode formNode = null;
                for (int i = 0; i < formModelEventArray.length; ++i) {
                    int n;
                    object = formModelEventArray[i];
                    if (((FormModelEvent)object).isModifying()) {
                        bl = true;
                    }
                    if ((n = ((FormModelEvent)object).getChangeType()) != 4 && n != 5 && n != 7 && n != 8 && n != 9) continue;
                    ComponentContainer componentContainer = ((FormModelEvent)object).getContainer();
                    if (hashSet == null || !hashSet.contains(componentContainer)) {
                        FormEditor.this.updateNodeChildren(componentContainer);
                        if (hashSet != null) {
                            hashSet.add(componentContainer);
                        }
                    }
                    if (n == 8) {
                        FormNode formNode2 = componentContainer instanceof RADComponent ? ((RADComponent)((Object)componentContainer)).getNodeReference() : FormEditor.this.getOthersContainerNode();
                        if (!(formNode instanceof RADComponentNode)) {
                            if (formNode == FormEditor.this.formRootNode) continue;
                            formNode = formNode2;
                            continue;
                        }
                        if (formNode == formNode2) continue;
                        formNode = FormEditor.this.formRootNode;
                        continue;
                    }
                    if (n == 4) {
                        formNode = ((RADVisualContainer)componentContainer).getLayoutNodeReference();
                        continue;
                    }
                    if (n != 7 || !((FormModelEvent)object).getComponent().isInModel()) continue;
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<RADComponent>();
                    }
                    hashSet2.add(((FormModelEvent)object).getComponent());
                    hashSet2.remove(((FormModelEvent)object).getContainer());
                }
                FormDesigner formDesigner = FormEditor.this.getFormDesigner();
                if (formDesigner != null) {
                    if (hashSet2 != null) {
                        formDesigner.clearSelectionImpl();
                        object = hashSet2.iterator();
                        while (object.hasNext()) {
                            formDesigner.addComponentToSelectionImpl((RADComponent)object.next());
                        }
                        formDesigner.updateComponentInspector();
                    } else if (formNode != null) {
                        formDesigner.setSelectedNode(formNode);
                    }
                }
                if (bl) {
                    FormEditor.this.getFormDataObject().getFormEditorSupport().markFormModified();
                    FormEditor.this.checkFormVersionUpgrade();
                }
            }
        };
        this.formModel.addFormModelListener(this.formListener);
    }

    private void detachFormListener() {
        if (this.formListener != null) {
            this.formModel.removeFormModelListener(this.formListener);
            this.formListener = null;
        }
    }

    void updateNodeChildren(ComponentContainer componentContainer) {
        FormNode formNode = null;
        if (componentContainer == null || componentContainer == this.formModel.getModelContainer()) {
            formNode = this.formRootNode != null ? this.getOthersContainerNode() : null;
        } else if (componentContainer instanceof RADComponent) {
            formNode = ((RADComponent)((Object)componentContainer)).getNodeReference();
        }
        if (formNode != null) {
            formNode.updateChildren();
        }
    }

    private void checkFormVersionUpgrade() {
        FormModel.FormVersion formVersion = this.formModel.getCurrentVersionLevel();
        FormModel.FormVersion formVersion2 = this.formModel.getMaxVersionLevel();
        if (formVersion.ordinal() > formVersion2.ordinal()) {
            if (EventQueue.isDispatchThread()) {
                this.processVersionUpgrade(true);
            } else {
                this.confirmVersionUpgrade();
            }
        }
    }

    private void processVersionUpgrade(boolean bl) {
        if (!bl && this.formModel.hasPendingEvents()) {
            bl = true;
        }
        if (bl) {
            if (!this.upgradeCheckPosted) {
                this.upgradeCheckPosted = true;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FormEditor.this.upgradeCheckPosted = false;
                        if (FormEditor.this.formModel != null) {
                            FormEditor.this.processVersionUpgrade(false);
                        }
                    }
                });
            }
        } else {
            String string = FormUtils.getBundleString("CTL_UpgradeOption");
            String string2 = FormUtils.getBundleString("CTL_CancelOption");
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)FormUtils.getBundleString("MSG_UpgradeQuestion"), FormUtils.getBundleString("TITLE_FormatUpgrade"), -1, 3, (Object[])new String[]{string, string2}, (Object)string);
            if (DialogDisplayer.getDefault().notify(notifyDescriptor) == string) {
                this.confirmVersionUpgrade();
            } else {
                this.revertVersionUpgrade();
            }
        }
    }

    private void confirmVersionUpgrade() {
        if (this.formModel != null) {
            this.formModel.setMaxVersionLevel(FormModel.LATEST_VERSION);
        }
    }

    private void revertVersionUpgrade() {
        if (this.formModel != null) {
            this.formModel.getUndoRedoManager().undo();
            this.formModel.revertVersionLevel();
        }
    }

    private void attachDataObjectListener() {
        if (this.dataObjectListener != null) {
            return;
        }
        this.dataObjectListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("name".equals(propertyChangeEvent.getPropertyName())) {
                    String string = FormEditor.this.formDataObject.getName();
                    FormEditor.this.formModel.setName(string);
                    FormEditor.this.formRootNode.updateName(string);
                } else if ("cookie".equals(propertyChangeEvent.getPropertyName())) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            Node[] nodeArray = ComponentInspector.getInstance().getExplorerManager().getSelectedNodes();
                            for (int i = 0; i < nodeArray.length; ++i) {
                                ((FormNode)nodeArray[i]).updateCookies();
                            }
                        }
                    });
                }
            }
        };
        this.formDataObject.addPropertyChangeListener(this.dataObjectListener);
    }

    private void detachDataObjectListener() {
        if (this.dataObjectListener != null) {
            this.formDataObject.removePropertyChangeListener(this.dataObjectListener);
            this.dataObjectListener = null;
        }
    }

    private static void attachSettingsListener() {
        if (settingsListener != null) {
            return;
        }
        settingsListener = new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                for (FormModel formModel : openForms.keySet()) {
                    FormDesigner formDesigner;
                    String string = preferenceChangeEvent.getKey();
                    if ("useIndentEngine".equals(string)) {
                        formModel.fireSyntheticPropertyChanged(null, string, null, preferenceChangeEvent.getNewValue());
                        continue;
                    }
                    if ("selectionBorderSize".equals(string) || "selectionBorderColor".equals(string) || "connectionBorderColor".equals(string) || "formDesignerBackgroundColor".equals(string) || "formDesignerBorderColor".equals(string)) {
                        formDesigner = FormEditor.getFormDesigner(formModel);
                        if (formDesigner == null) continue;
                        formDesigner.updateVisualSettings();
                        continue;
                    }
                    if (!"toolBarPalette".equals(string) || (formDesigner = FormEditor.getFormDesigner(formModel)) == null) continue;
                    formDesigner.getFormToolBar().showPaletteButton(FormLoaderSettings.getInstance().isPaletteInToolBar());
                }
            }
        };
        FormLoaderSettings.getPreferences().addPreferenceChangeListener(settingsListener);
    }

    private static void detachSettingsListener() {
        if (settingsListener != null) {
            FormLoaderSettings.getPreferences().removePreferenceChangeListener(settingsListener);
            settingsListener = null;
        }
    }

    private void attachPaletteListener() {
        if (this.paletteListener != null) {
            return;
        }
        this.paletteListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedItem".equals(propertyChangeEvent.getPropertyName())) {
                    FormDesigner formDesigner;
                    FormModel formModel = FormEditor.this.getFormModel();
                    if (FormEditor.this.isFormLoaded() && formModel != null && !formModel.isReadOnly() && (formDesigner = FormEditor.getFormDesigner(formModel)) != null) {
                        if (propertyChangeEvent.getNewValue() == null) {
                            if (formDesigner.getDesignerMode() == 2) {
                                formDesigner.setDesignerMode(0);
                            }
                        } else {
                            if (formDesigner.getDesignerMode() == 2) {
                                formDesigner.setDesignerMode(0);
                            }
                            formDesigner.setDesignerMode(2);
                        }
                    }
                }
            }
        };
        PaletteUtils.addPaletteListener(this.paletteListener, this.formDataObject.getPrimaryFile());
    }

    private void detachPaletteListener() {
        if (this.paletteListener != null) {
            PaletteUtils.removePaletteListener(this.paletteListener, this.formDataObject.getPrimaryFile());
            this.paletteListener = null;
        }
    }

    void reinstallListener() {
        if (this.formListener != null) {
            this.formModel.removeFormModelListener(this.formListener);
            this.formModel.addFormModelListener(this.formListener);
        }
    }

    public static JEditorPane createCodeEditorPane(FormModel formModel) {
        FormDataObject formDataObject = FormEditor.getFormDataObject(formModel);
        JavaCodeGenerator javaCodeGenerator = (JavaCodeGenerator)FormEditor.getCodeGenerator(formModel);
        javaCodeGenerator.regenerateCode();
        JEditorPane jEditorPane = new JEditorPane();
        SimpleSection simpleSection = formDataObject.getFormEditorSupport().getInitComponentSection();
        int n = simpleSection.getText().indexOf(123) + 2 + simpleSection.getStartPosition().getOffset();
        FormUtils.setupEditorPane(jEditorPane, formDataObject.getPrimaryFile(), n);
        return jEditorPane;
    }

    public static synchronized AssistantModel getAssistantModel(FormModel formModel) {
        assert (formModel != null);
        AssistantModel assistantModel = formModelToAssistant.get(formModel);
        if (assistantModel == null) {
            assistantModel = new AssistantModel();
            formModelToAssistant.put(formModel, assistantModel);
        }
        return assistantModel;
    }

    public static FormDesigner getFormDesigner(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getFormDesigner() : null;
    }

    public static CodeGenerator getCodeGenerator(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getCodeGenerator() : null;
    }

    public static FormDataObject getFormDataObject(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getFormDataObject() : null;
    }

    public static FormJavaSource getFormJavaSource(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getFormJavaSource() : null;
    }

    static ResourceSupport getResourceSupport(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getResourceSupport() : null;
    }

    static BindingDesignSupport getBindingSupport(FormModel formModel) {
        FormEditor formEditor = openForms.get(formModel);
        return formEditor != null ? formEditor.getBindingSupport() : null;
    }

    public static FormEditor getFormEditor(FormModel formModel) {
        return openForms.get(formModel);
    }

    UndoRedo.Manager getFormUndoRedoManager() {
        return this.formModel != null ? this.formModel.getUndoRedoManager() : null;
    }

    public void registerFloatingWindow(Window window) {
        if (this.floatingWindows == null) {
            this.floatingWindows = new ArrayList<Window>();
        } else {
            this.floatingWindows.remove(window);
        }
        this.floatingWindows.add(window);
    }

    public void unregisterFloatingWindow(Window window) {
        if (this.floatingWindows != null) {
            this.floatingWindows.remove(window);
        }
    }

    public void registerDefaultComponentAction(Action action) {
        if (this.defaultActions == null) {
            this.createDefaultComponentActionsList();
        } else {
            this.defaultActions.remove(action);
        }
        this.defaultActions.add(0, action);
    }

    public void unregisterDefaultComponentAction(Action action) {
        if (this.defaultActions != null) {
            this.defaultActions.remove(action);
        }
    }

    private void createDefaultComponentActionsList() {
        this.defaultActions = new LinkedList<Action>();
        this.defaultActions.add((Action)SystemAction.get(EditContainerAction.class));
        this.defaultActions.add((Action)SystemAction.get(EditFormAction.class));
        this.defaultActions.add((Action)SystemAction.get(DefaultRADAction.class));
    }

    Collection<Action> getDefaultComponentActions() {
        if (this.defaultActions == null) {
            this.createDefaultComponentActionsList();
        }
        return Collections.unmodifiableList(this.defaultActions);
    }

    public static boolean updateProjectForNaturalLayout(FormModel formModel) {
        FormEditor formEditor = FormEditor.getFormEditor(formModel);
        if (formEditor != null && formModel.getSettings().getLayoutCodeTarget() != 1 && !ClassPathUtils.isOnClassPath(formEditor.getFormDataObject().getFormFile(), GroupLayout.class.getName())) {
            try {
                Library library = LibraryManager.getDefault().getLibrary("swing-layout");
                if (library == null) {
                    return false;
                }
                ClassSource classSource = new ClassSource("", new ClassSource.LibraryEntry(library));
                return Boolean.TRUE == ClassPathUtils.updateProject(formEditor.getFormDataObject().getFormFile(), classSource);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
            }
        }
        return false;
    }

    public static boolean updateProjectForBeansBinding(FormModel formModel) {
        FormEditor formEditor = FormEditor.getFormEditor(formModel);
        if (formEditor != null && !ClassPathUtils.isOnClassPath(formEditor.getFormDataObject().getFormFile(), Binding.class.getName())) {
            try {
                Library library = LibraryManager.getDefault().getLibrary("beans-binding");
                if (library == null) {
                    return false;
                }
                ClassSource classSource = new ClassSource("", new ClassSource.LibraryEntry(library));
                return Boolean.TRUE == ClassPathUtils.updateProject(formEditor.getFormDataObject().getFormFile(), classSource);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        return false;
    }

    public static boolean isNonVisualTrayEnabled() {
        return Boolean.getBoolean("netbeans.form.non_visual_tray");
    }

    private void checkSuppressWarningsAnnotation() {
        FileObject fileObject = this.getFormDataObject().getPrimaryFile();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        if (classPath.findResource("java/lang/SuppressWarnings.class") == null) {
            final String string = fileObject.getName();
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            final int[] nArray = new int[]{-1, -1};
            try {
                javaSource.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws Exception {
                        Tree tree;
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        ClassTree classTree = null;
                        CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                        for (Tree tree2 : compilationUnitTree.getTypeDecls()) {
                            if (tree2.getKind() != Tree.Kind.CLASS || !string.equals((tree = (ClassTree)tree2).getSimpleName().toString())) continue;
                            classTree = tree;
                        }
                        if (classTree == null) {
                            return;
                        }
                        for (Tree tree2 : classTree.getMembers()) {
                            if (tree2.getKind() != Tree.Kind.METHOD || !"initComponents".equals((tree = (MethodTree)tree2).getName().toString()) || tree.getParameters().size() != 0) continue;
                            ModifiersTree modifiersTree = tree.getModifiers();
                            for (AnnotationTree annotationTree : modifiersTree.getAnnotations()) {
                                if (!annotationTree.getAnnotationType().toString().contains("SuppressWarnings")) continue;
                                SourcePositions sourcePositions = workingCopy.getTrees().getSourcePositions();
                                nArray[0] = (int)sourcePositions.getStartPosition(compilationUnitTree, annotationTree);
                                nArray[1] = (int)sourcePositions.getEndPosition(compilationUnitTree, annotationTree);
                            }
                        }
                    }
                }).commit();
            }
            catch (IOException iOException) {
                Logger.getLogger(FormEditor.class.getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
            if (nArray[0] != -1) {
                try {
                    this.getFormDataObject().getFormEditorSupport().getDocument().remove(nArray[0], nArray[1] - nArray[0]);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(FormEditor.class.getName()).log(Level.INFO, badLocationException.getLocalizedMessage(), badLocationException);
                }
            }
        }
    }
}

