/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.openide.util.Utilities;

class CodeCustomEditor
extends JPanel
implements DocumentListener,
Runnable {
    private RADConnectionPropertyEditor propertyEditor;
    private JEditorPane codePane;
    private boolean ignoreUpdate;
    private JLabel headerLabel = new JLabel();
    private JLabel footerLabel = new JLabel();
    private JTextField typeField = new JTextField();
    private JScrollPane jScrollPane = new JScrollPane(){

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            JScrollBar jScrollBar = this.getHorizontalScrollBar();
            if (jScrollBar != null && jScrollBar.isVisible()) {
                dimension = new Dimension(dimension.width, dimension.height + ((Component)jScrollBar).getPreferredSize().height);
            }
            return dimension;
        }
    };

    public CodeCustomEditor(RADConnectionPropertyEditor rADConnectionPropertyEditor, FormModel formModel, FormProperty formProperty) {
        this.propertyEditor = rADConnectionPropertyEditor;
        this.codePane = new JEditorPane();
        this.jScrollPane.setViewportView(this.codePane);
        this.resetLayout();
        int n = -1;
        FormDataObject formDataObject = FormEditor.getFormDataObject(formModel);
        SimpleSection simpleSection = formDataObject.getFormEditorSupport().getInitComponentSection();
        if (formProperty instanceof RADProperty && formProperty.getWriteMethod() != null) {
            RADComponent rADComponent = ((RADProperty)formProperty).getRADComponent();
            this.headerLabel.setFont(this.codePane.getFont());
            this.headerLabel.setText("<html>" + rADComponent.getName() + ".<b>" + formProperty.getWriteMethod().getName() + "</b>(");
            this.footerLabel.setFont(this.codePane.getFont());
            this.footerLabel.setText(");");
            String string = rADComponent != formModel.getTopRADComponent() ? " " + rADComponent.getName() + "." + formProperty.getWriteMethod().getName() + "(" : " " + formProperty.getWriteMethod().getName() + "(";
            n = simpleSection.getText().indexOf(string);
            if (n >= 0) {
                n += string.length();
            }
        } else {
            this.headerLabel.setText(FormUtils.getBundleString("CodeCustomEditor.codeLabel"));
        }
        if (n < 0) {
            n = simpleSection.getText().indexOf(123) + 2;
        }
        FormUtils.setupEditorPane(this.codePane, formDataObject.getPrimaryFile(), n + simpleSection.getStartPosition().getOffset());
        this.typeField.setBorder(BorderFactory.createEmptyBorder());
        this.typeField.setEditable(false);
        this.typeField.setFont(this.codePane.getFont());
        this.typeField.setText(Utilities.getClassName((Class)formProperty.getValueType()));
        this.codePane.getDocument().addDocumentListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                CodeCustomEditor.this.revalidate();
                CodeCustomEditor.this.repaint();
            }
        });
    }

    private void resetLayout() {
        int n;
        int n2;
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setAutocreateContainerGaps(true);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.headerLabel, -2, -1, -2).add(3).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane, -2, 320, Short.MAX_VALUE).add((Component)this.typeField)).add(3).add((Component)this.footerLabel));
        if (this.jScrollPane.getPreferredSize().getHeight() > 300.0) {
            n2 = 300;
            n = -1;
        } else {
            n2 = -1;
            n = -2;
        }
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(this.jScrollPane.getInsets().top).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.headerLabel).add((Component)this.footerLabel))).add((Component)this.jScrollPane, -1, n2, n)).add((Component)this.typeField, -2, -1, -2));
    }

    void setValue(RADConnectionPropertyEditor.RADConnectionDesignValue rADConnectionDesignValue) {
        if (rADConnectionDesignValue != null && rADConnectionDesignValue.getType() == 2) {
            this.ignoreUpdate = true;
            this.codePane.setText(rADConnectionDesignValue.getCode());
            this.ignoreUpdate = false;
            this.resetLayout();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.invokeUpdate();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.invokeUpdate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void invokeUpdate() {
        if (!this.ignoreUpdate) {
            this.ignoreUpdate = true;
            EventQueue.invokeLater(this);
            this.revalidate();
            this.repaint();
        }
    }

    public void run() {
        this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(this.codePane.getText()));
        this.ignoreUpdate = false;
    }
}

