/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.palette.codeclips;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.visualweb.palette.codeclips.CodeClipUtilities;
import org.netbeans.modules.visualweb.palette.codeclips.CodeClipViewerPanel;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class CodeClipItemNode
extends FilterNode
implements EditCookie {
    private static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    private String name;
    private String bundleName;
    private String displayNameKey;
    private String tooltipKey;
    private String icon16URL;
    private String icon32URL;
    private String displayName;
    private String description;
    private Image icon16;
    private Image icon32;
    private String body;
    private DataNode dataNode;
    private FileObject fileObj;

    CodeClipItemNode(DataNode dataNode, String string, String string2, String string3, String string4, String string5, String string6, String string7, InstanceContent instanceContent) {
        super((Node)dataNode, FilterNode.Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.fileObj = dataNode.getDataObject().getPrimaryFile();
        this.dataNode = dataNode;
        instanceContent.add((Object)this);
        this.name = string;
        this.bundleName = string2;
        this.displayNameKey = string3;
        this.tooltipKey = string4;
        this.icon16URL = string5;
        this.icon32URL = string6;
        this.body = string7;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public void setName(String string) {
        if (!this.fileObj.canWrite()) {
            System.out.println("Cannot write to file.");
            return;
        }
        try {
            this.destroy();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        this.displayNameKey = string;
        try {
            CodeClipUtilities.createCodeClipFile(this.fileObj.getParent(), this.body, this.displayNameKey, this.bundleName, this.tooltipKey);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this._getDisplayName(this.bundleName, this.displayNameKey);
        }
        return this.displayName;
    }

    public String getShortDescription() {
        if (this.description == null) {
            this.description = this._getShortDescription(this.bundleName, this.tooltipKey, this.displayNameKey);
        }
        return this.description;
    }

    public Image getIcon(int n) {
        Image image = null;
        if (n == 1 || n == 3) {
            if (this.icon16 == null) {
                this.icon16 = this._getIcon(this.icon16URL);
                if (this.icon16 == null) {
                    this.icon16 = Utilities.loadImage((String)"org/netbeans/modules/palette/resources/unknown16.gif");
                }
            }
            image = this.icon16;
        } else if (n == 2 || n == 4) {
            if (this.icon32 == null) {
                this.icon32 = this._getIcon(this.icon32URL);
                if (this.icon32 == null) {
                    this.icon32 = Utilities.loadImage((String)"org/netbeans/modules/palette/resources/unknown32.gif");
                }
            }
            image = this.icon32;
        }
        return image;
    }

    public boolean canRename() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        Lookup lookup = this.getLookup();
        ActiveEditorDrop activeEditorDrop = (ActiveEditorDrop)lookup.lookup(ActiveEditorDrop.class);
        ActiveEditorDropTransferable activeEditorDropTransferable = new ActiveEditorDropTransferable(activeEditorDrop);
        exTransferable.put((ExTransferable.Single)activeEditorDropTransferable);
        return new NoExternalDndTransferable((Transferable)exTransferable);
    }

    public Transferable drag() throws IOException {
        Transferable transferable = this.clipboardCopy();
        return transferable;
    }

    public String _getDisplayName(String string, String string2) {
        String string3 = null;
        if (string != null) {
            try {
                string3 = NbBundle.getBundle((String)string).getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                string3 = string2;
            }
        } else {
            string3 = string2;
        }
        return string3;
    }

    public String _getShortDescription(String string, String string2, String string3) {
        String string4 = null;
        if (string2 != null && string != null) {
            try {
                string4 = NbBundle.getBundle((String)string).getString(string2);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        } else {
            string4 = string2 != null ? string2 : (string != null ? this._getDisplayName(string, string3) : string3);
        }
        return string4;
    }

    public Image _getIcon(String string) {
        Image image = null;
        try {
            image = Utilities.loadImage((String)string);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return image;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public void edit() {
        String string = this.getDisplayName();
        String string2 = this.getShortDescription();
        CodeClipViewerPanel codeClipViewerPanel = new CodeClipViewerPanel(this.getDisplayName(), string2, this.body);
        codeClipViewerPanel.setVisible(true);
        if (!codeClipViewerPanel.isCancelled()) {
            String string3 = this.displayNameKey;
            String string4 = this.bundleName;
            String string5 = codeClipViewerPanel.getContentText();
            String string6 = codeClipViewerPanel.getClipName();
            String string7 = this.tooltipKey;
            String string8 = codeClipViewerPanel.getToolTip();
            if (!string.equals(string6)) {
                string3 = string6;
                if (this.bundleName != null) {
                    string7 = string8;
                }
                string4 = null;
            }
            if (!string2.equals(string8)) {
                string7 = string8;
                if (this.bundleName != null) {
                    string3 = string6;
                }
                string4 = null;
            }
            try {
                CodeClipUtilities.createCodeClipFile(this.fileObj.getParent(), string5, string3, string4, string7);
                this.destroy();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    public void drop(JTextComponent jTextComponent) {
        ActiveEditorDrop activeEditorDrop = (ActiveEditorDrop)this.getLookup().lookup(ActiveEditorDrop.class);
        activeEditorDrop.handleTransfer(jTextComponent);
    }

    private static class NoExternalDndTransferable
    implements Transferable {
        private Transferable t;
        private DataFlavor uriListFlavor;

        public NoExternalDndTransferable(Transferable transferable) {
            this.t = transferable;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = this.t.getTransferDataFlavors();
            if (this.t.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || this.t.isDataFlavorSupported(this.getUriListFlavor())) {
                ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(dataFlavorArray.length);
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    if (!this.isDataFlavorSupported(dataFlavorArray[i])) continue;
                    arrayList.add(dataFlavorArray[i]);
                }
                dataFlavorArray = arrayList.toArray(new DataFlavor[arrayList.size()]);
            }
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (DataFlavor.javaFileListFlavor.equals(dataFlavor) || this.getUriListFlavor().equals(dataFlavor)) {
                return false;
            }
            return this.t.isDataFlavorSupported(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.t.getTransferData(dataFlavor);
        }

        private DataFlavor getUriListFlavor() {
            if (null == this.uriListFlavor) {
                try {
                    this.uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AssertionError((Object)classNotFoundException);
                }
            }
            return this.uriListFlavor;
        }
    }

    private static class ActiveEditorDropTransferable
    extends ExTransferable.Single {
        private ActiveEditorDrop drop;

        ActiveEditorDropTransferable(ActiveEditorDrop activeEditorDrop) {
            super(ActiveEditorDrop.FLAVOR);
            this.drop = activeEditorDrop;
        }

        public Object getData() {
            return this.drop;
        }
    }
}

