/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.awt.Actions;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

public class ProjectAction
extends LookupSensitiveAction
implements ContextAwareAction {
    private String command;
    private ProjectActionPerformer performer;
    private final String namePattern;
    private final String popupPattern;

    public ProjectAction(String string, String string2, Icon icon, Lookup lookup) {
        this(string, null, string2, null, icon, lookup);
    }

    public ProjectAction(String string, String string2, String string3, Icon icon, Lookup lookup) {
        this(string, null, string2, string3, icon, lookup);
    }

    public ProjectAction(ProjectActionPerformer projectActionPerformer, String string, Icon icon, Lookup lookup) {
        this(null, projectActionPerformer, string, null, icon, lookup);
    }

    private ProjectAction(ProjectActionPerformer projectActionPerformer, String string, String string2, Icon icon, Lookup lookup) {
        this(null, projectActionPerformer, string, string2, icon, lookup);
    }

    private ProjectAction(String string, ProjectActionPerformer projectActionPerformer, String string2, String string3, Icon icon, Lookup lookup) {
        super(icon, lookup, new Class[]{Project.class, DataObject.class});
        this.command = string;
        if (string != null) {
            ActionsUtil.SHORCUTS_MANAGER.registerAction(string, this);
        }
        this.performer = projectActionPerformer;
        this.namePattern = string2;
        this.popupPattern = string3;
        String string4 = ActionsUtil.formatName(this.getNamePattern(), 0, "");
        this.setDisplayName(string4);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)string4));
    }

    public void putValue(String string, Object object) {
        super.putValue(string, object);
        if ("AcceleratorKey".equals(string)) {
            ActionsUtil.SHORCUTS_MANAGER.registerShortcut(this.command, object);
        }
    }

    protected void actionPerformed(Lookup lookup) {
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, this.command);
        if (projectArray.length == 1) {
            if (this.command != null) {
                ActionProvider actionProvider = (ActionProvider)projectArray[0].getLookup().lookup(ActionProvider.class);
                actionProvider.invokeAction(this.command, Lookup.EMPTY);
            } else if (this.performer != null) {
                this.performer.perform(projectArray[0]);
            }
        }
    }

    protected void refresh(Lookup lookup) {
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, this.command);
        if (this.command != null) {
            this.setEnabled(projectArray.length == 1);
        } else if (this.performer != null && projectArray.length == 1) {
            this.setEnabled(this.performer.enable(projectArray[0]));
        } else {
            this.setEnabled(false);
        }
        String string = ActionsUtil.formatProjectSensitiveName(this.namePattern, projectArray);
        this.putValue("menuText", string);
        if (this.popupPattern != null) {
            String string2 = ActionsUtil.formatProjectSensitiveName(this.popupPattern, projectArray);
            this.putValue("popupText", string2);
        }
        this.putValue("ShortDescription", Actions.cutAmpersand((String)string));
    }

    protected final String getCommand() {
        return this.command;
    }

    protected final String getNamePattern() {
        return this.namePattern;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ProjectAction(this.command, this.performer, this.namePattern, this.popupPattern, (Icon)this.getValue("SmallIcon"), lookup);
    }
}

