/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.ProjectChooserAccessory;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class OpenProject
extends BasicAction {
    private static final String DISPLAY_NAME = NbBundle.getMessage(OpenProject.class, (String)"LBL_OpenProjectAction_Name");
    private static final String _SHORT_DESCRIPTION = NbBundle.getMessage(OpenProject.class, (String)"LBL_OpenProjectAction_Tooltip");

    public OpenProject() {
        super(DISPLAY_NAME, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/openProject.png")));
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/openProject.png");
        this.putValue("ShortDescription", _SHORT_DESCRIPTION);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OpenProjectListSettings openProjectListSettings;
        File[] fileArray;
        JFileChooser jFileChooser;
        block5: {
            int n;
            Serializable serializable;
            jFileChooser = ProjectChooserAccessory.createProjectChooser(true);
            jFileChooser.setMultiSelectionEnabled(true);
            for (DataObject dataObject : Utilities.actionsGlobalContext().lookupAll(DataObject.class)) {
                fileArray = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
                if (fileArray == null || OpenProjectList.getDefault().isOpen((Project)fileArray) || (serializable = FileUtil.toFile((FileObject)fileArray.getProjectDirectory())) == null) continue;
                jFileChooser.setCurrentDirectory(((File)serializable).getParentFile());
                jFileChooser.setSelectedFiles(new File[]{serializable});
                break;
            }
            openProjectListSettings = OpenProjectListSettings.getInstance();
            while ((n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) {
                fileArray = jFileChooser.isMultiSelectionEnabled() ? jFileChooser.getSelectedFiles() : new File[]{jFileChooser.getSelectedFile()};
                serializable = new ArrayList(fileArray.length);
                for (File file : fileArray) {
                    Project project = OpenProjectList.fileToProject(FileUtil.normalizeFile((File)file));
                    if (project == null) continue;
                    ((ArrayList)serializable).add(project);
                }
                if (((ArrayList)serializable).isEmpty()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenProject.class, (String)"MSG_notProjectDir"), 2));
                    continue;
                }
                File[] fileArray2 = new Project[((ArrayList)serializable).size()];
                ((ArrayList)serializable).toArray(fileArray2);
                OpenProjectList.getDefault().open((Project[])fileArray2, openProjectListSettings.isOpenSubprojects(), true);
                if (openProjectListSettings.isOpenAsMain() && fileArray2.length == 1) {
                    OpenProjectList.getDefault().setMainProject((Project)fileArray2[0]);
                }
                break block5;
            }
            return;
        }
        final ProjectTab projectTab = ProjectTab.findDefault("projectTabLogical_tc");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Node node = projectTab.getExplorerManager().getRootContext();
                ArrayList<Node> arrayList = new ArrayList<Node>(fileArray.length);
                for (int i = 0; i < fileArray.length; ++i) {
                    Node node2 = node.getChildren().findChild(fileArray[i].getName());
                    if (node2 == null) continue;
                    arrayList.add(node2);
                }
                try {
                    Node[] nodeArray = new Node[arrayList.size()];
                    arrayList.toArray(nodeArray);
                    projectTab.getExplorerManager().setSelectedNodes(nodeArray);
                    if (!Boolean.getBoolean("project.tab.no.selection")) {
                        projectTab.open();
                        projectTab.requestActive();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        openProjectListSettings.setLastOpenProjectDir(jFileChooser.getCurrentDirectory().getPath());
    }
}

