/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.NoMainProjectWarning;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;
import org.openide.awt.MouseUtils;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class MainProjectAction
extends BasicAction
implements PropertyChangeListener {
    private String command;
    private ProjectActionPerformer performer;
    private String name;

    public MainProjectAction(ProjectActionPerformer projectActionPerformer, String string, Icon icon) {
        this(null, projectActionPerformer, string, icon);
    }

    public MainProjectAction(String string, String string2, Icon icon) {
        this(string, null, string2, icon);
    }

    public MainProjectAction(String string, ProjectActionPerformer projectActionPerformer, String string2, Icon icon) {
        this.command = string;
        this.performer = projectActionPerformer;
        this.name = string2;
        this.setDisplayName(string2);
        if (icon != null) {
            this.setSmallIcon(icon);
        }
        this.refreshView();
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Project project = OpenProjectList.getDefault().getMainProject();
        if (project == null) {
            if (this.showNoMainProjectWarning(OpenProjectList.getDefault().getOpenProjects(), this.name)) {
                return;
            }
            project = OpenProjectList.getDefault().getMainProject();
        }
        if (this.command != null) {
            ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
            if (actionProvider != null) {
                if (Arrays.asList(actionProvider.getSupportedActions()).contains(this.command)) {
                    actionProvider.invokeAction(this.command, Lookup.EMPTY);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    this.refreshView();
                }
            }
        } else {
            this.performer.perform(project);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "MainProject" || propertyChangeEvent.getPropertyName() == "OpenProjects") {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    MainProjectAction.this.refreshView();
                }
            });
        }
    }

    private void refreshView() {
        boolean bl;
        Project project = OpenProjectList.getDefault().getMainProject();
        boolean bl2 = bl = OpenProjectList.getDefault().getOpenProjects().length == 0;
        if (this.command == null) {
            this.setEnabled(this.performer.enable(project));
        } else if (project == null) {
            this.setEnabled(!bl);
        } else if (ActionsUtil.commandSupported(project, this.command, Lookup.EMPTY)) {
            this.setEnabled(!bl);
        } else {
            this.setEnabled(false);
        }
    }

    private boolean showNoMainProjectWarning(Project[] projectArray, String string) {
        boolean bl;
        final JButton jButton = new JButton(NbBundle.getMessage(NoMainProjectWarning.class, (String)"LBL_NoMainClassWarning_ChooseMainProject_OK"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NoMainProjectWarning.class, (String)"AD_NoMainClassWarning_ChooseMainProject_OK"));
        final NoMainProjectWarning noMainProjectWarning = new NoMainProjectWarning(projectArray);
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        noMainProjectWarning.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)changeEvent.getSource()))) {
                    if (noMainProjectWarning.getSelectedProject() != null) {
                        jButton.doClick();
                    }
                } else {
                    jButton.setEnabled(noMainProjectWarning.getSelectedProject() != null);
                }
            }
        });
        jButton.setEnabled(noMainProjectWarning.getSelectedProject() != null);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)noMainProjectWarning, string == null ? NbBundle.getMessage(NoMainProjectWarning.class, (String)"CTL_NoMainProjectWarning_Title") : Actions.cutAmpersand((String)string), true, objectArray, objectArray[0], 0, null, null);
        dialogDescriptor.setMessageType(1);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != objectArray[0]) {
            bl = true;
        } else {
            Project project = noMainProjectWarning.getSelectedProject();
            OpenProjectList.getDefault().setMainProject(project);
            bl = false;
        }
        dialog.dispose();
        return bl;
    }
}

