/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.ExtIcon;
import org.netbeans.modules.project.ui.LazyProject;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.OpeningProjectPanel;
import org.netbeans.modules.project.ui.ProjectInfoAccessor;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.api.UnloadedProjectInformation;
import org.netbeans.modules.project.uiapi.ProjectOpenedTrampoline;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenProjectList {
    public static final Comparator<Project> PROJECT_BY_DISPLAYNAME = new ProjectByDisplayNameComparator();
    public static final String PROPERTY_OPEN_PROJECTS = "OpenProjects";
    public static final String PROPERTY_MAIN_PROJECT = "MainProject";
    public static final String PROPERTY_RECENT_PROJECTS = "RecentProjects";
    public static final String PROPERTY_REPLACE = "ReplaceProject";
    private static OpenProjectList INSTANCE;
    private static final int NUM_TEMPLATES = 15;
    static final Logger LOGGER;
    private static final RequestProcessor OPENING_RP;
    private List<Project> openProjects;
    private HashMap<ModuleInfo, List<Project>> openProjectsModuleInfos;
    private Project mainProject;
    private final RecentProjectList recentProjects;
    private static Object RECENT_TEMPLATES_LOCK;
    private final List<String> recentTemplates;
    private final PropertyChangeSupport pchSupport;
    private ProjectDeletionListener deleteListener = new ProjectDeletionListener();
    private NbProjectDeletionListener nbprojectDeleteListener = new NbProjectDeletionListener();
    private PropertyChangeListener infoListener;
    private final LoadOpenProjects LOAD = new LoadOpenProjects(0);

    OpenProjectList() {
        this.openProjects = new ArrayList<Project>();
        this.openProjectsModuleInfos = new HashMap();
        this.infoListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    OpenProjectList.this.checkModuleInfo((ModuleInfo)propertyChangeEvent.getSource());
                }
            }
        };
        this.pchSupport = new PropertyChangeSupport(this);
        this.recentProjects = new RecentProjectList(10);
        this.recentTemplates = new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenProjectList getDefault() {
        boolean bl = false;
        Object var1_1 = null;
        Class<OpenProjectList> clazz = OpenProjectList.class;
        synchronized (OpenProjectList.class) {
            if (INSTANCE == null) {
                INSTANCE = new OpenProjectList();
                OpenProjectList.INSTANCE.openProjects = OpenProjectList.loadProjectList();
                OpenProjectList.INSTANCE.recentProjects.load();
                WindowManager.getDefault().invokeWhenUIReady((Runnable)OpenProjectList.INSTANCE.LOAD);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return INSTANCE;
        }
    }

    static void waitProjectsFullyOpen() {
        OpenProjectList.getDefault().LOAD.waitFinished();
    }

    static void preferredProject(Project project) {
        if (project != null) {
            OpenProjectList.getDefault().LOAD.preferredProject(project);
        }
    }

    Future<Project[]> openProjectsAPI() {
        return this.LOAD;
    }

    final Project unwrapProject(Project project) {
        Project[] projectArray = this.getOpenProjects();
        if (project instanceof LazyProject) {
            LazyProject lazyProject = (LazyProject)project;
            for (Project project2 : projectArray) {
                if (!lazyProject.getProjectDirectory().equals(project2.getProjectDirectory())) continue;
                return project2;
            }
        }
        return project;
    }

    private List<String> getRecentTemplates() {
        assert (Thread.holdsLock(this));
        return this.recentTemplates;
    }

    public void open(Project project) {
        this.open(new Project[]{project}, false);
    }

    public void open(Project project, boolean bl) {
        this.open(new Project[]{project}, bl);
    }

    public void open(Project[] projectArray, boolean bl) {
        this.open(projectArray, bl, false);
    }

    public void open(final Project[] projectArray, final boolean bl, final boolean bl2) {
        if (projectArray.length == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        if (bl2) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        OpenProjectList.this.open(projectArray, bl, bl2);
                    }
                });
                return;
            }
            final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(OpenProjectList.class, (String)"CAP_Opening_Projects"));
            Frame frame = WindowManager.getDefault().getMainWindow();
            final JDialog jDialog = new JDialog(frame, NbBundle.getMessage(OpenProjectList.class, (String)"LBL_Opening_Projects_Progress"), true);
            final OpeningProjectPanel openingProjectPanel = new OpeningProjectPanel(progressHandle);
            jDialog.getContentPane().add(openingProjectPanel);
            jDialog.setDefaultCloseOperation(0);
            jDialog.pack();
            Rectangle rectangle = frame.getBounds();
            int n = rectangle.x + rectangle.width / 2;
            int n2 = rectangle.y + rectangle.height / 2;
            Dimension dimension = jDialog.getPreferredSize();
            jDialog.setBounds(n - dimension.width / 2, n2 - dimension.height / 2, dimension.width, dimension.height);
            OPENING_RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        OpenProjectList.this.doOpen(projectArray, bl, progressHandle, openingProjectPanel);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                jDialog.setVisible(false);
                                jDialog.dispose();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            jDialog.setVisible(true);
        } else {
            this.doOpen(projectArray, bl, null, null);
        }
        long l2 = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "opening projects took: " + (l2 - l) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpen(Project[] projectArray, boolean bl, ProgressHandle progressHandle, OpeningProjectPanel openingProjectPanel) {
        assert (!Arrays.asList(projectArray).contains(null)) : "Projects can't be null";
        this.LOAD.waitFinished();
        try {
            Project project32;
            this.LOAD.enter();
            boolean bl2 = false;
            int n = 1000;
            int n2 = n / 2;
            double d = 0.0;
            LinkedHashSet<Project> linkedHashSet = new LinkedHashSet<Project>();
            if (progressHandle != null) {
                progressHandle.start(n);
                progressHandle.progress(0);
            }
            if (openingProjectPanel != null) {
                assert (projectArray.length > 0) : "at least one project to open";
                openingProjectPanel.setProjectName(ProjectUtils.getInformation((Project)projectArray[0]).getDisplayName());
            }
            HashMap<Project, Set> hashMap = new HashMap<Project, Set>();
            LinkedList<Project> linkedList = new LinkedList<Project>(Arrays.asList(projectArray));
            while (!linkedList.isEmpty()) {
                Set set;
                Project project2 = (Project)linkedList.remove(0);
                Set set2 = set = bl ? (Set)hashMap.get(project2) : Collections.emptySet();
                if (set == null) {
                    SubprojectProvider subprojectProvider = (SubprojectProvider)project2.getLookup().lookup(SubprojectProvider.class);
                    set = subprojectProvider != null ? subprojectProvider.getSubprojects() : Collections.emptySet();
                    hashMap.put(project2, set);
                }
                linkedHashSet.add(project2);
                for (Project project32 : set) {
                    if (linkedHashSet.contains(project32) || linkedList.contains(project32)) continue;
                    linkedList.add(project32);
                }
                double d2 = ((double)n2 - d) / (double)(linkedList.size() + 1);
                int n3 = (int)d;
                if (progressHandle == null || n3 >= (int)(d += d2)) continue;
                progressHandle.progress((int)d);
            }
            double d3 = (n - n2) / linkedHashSet.size();
            final ArrayList<Project> arrayList = new ArrayList<Project>();
            project32 = new ArrayList();
            Object object = this;
            synchronized (object) {
                arrayList.addAll(this.openProjects);
            }
            for (Project logRecordArray2 : linkedHashSet) {
                if (openingProjectPanel != null) {
                    openingProjectPanel.setProjectName(ProjectUtils.getInformation((Project)logRecordArray2).getDisplayName());
                }
                bl2 |= this.doOpenProject(logRecordArray2);
                int n3 = (int)d;
                if (progressHandle == null || n3 >= (int)(d += d3)) continue;
                progressHandle.progress((int)d);
            }
            object = this;
            synchronized (object) {
                project32.addAll(this.openProjects);
                OpenProjectList.saveProjectList(this.openProjects);
                if (bl2) {
                    this.recentProjects.save();
                }
            }
            if (progressHandle != null) {
                progressHandle.finish();
            }
            boolean bl3 = bl2;
            LogRecord[] logRecordArray = OpenProjectList.createRecord("UI_OPEN_PROJECTS", linkedHashSet.toArray(new Project[0]));
            OpenProjectList.log(logRecordArray);
            Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>((List)project32, bl3){
                final /* synthetic */ List val$newprjs;
                final /* synthetic */ boolean val$recentProjectsChangedCopy;
                {
                    this.val$newprjs = list2;
                    this.val$recentProjectsChangedCopy = bl;
                }

                public Void run() {
                    OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_OPEN_PROJECTS, arrayList.toArray(new Project[arrayList.size()]), this.val$newprjs.toArray(new Project[this.val$newprjs.size()]));
                    if (this.val$recentProjectsChangedCopy) {
                        OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_RECENT_PROJECTS, null, null);
                    }
                    return null;
                }
            });
        }
        finally {
            this.LOAD.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Project[] projectArray, boolean bl) {
        int n;
        this.LOAD.waitFinished();
        Project[] projectArray2 = new Project[projectArray.length];
        for (n = 0; n < projectArray.length; ++n) {
            projectArray2[n] = this.unwrapProject(projectArray[n]);
        }
        if (!ProjectUtilities.closeAllDocuments(projectArray2, bl)) {
            return;
        }
        try {
            this.LOAD.enter();
            OpenProjectList.logProjects("close(): closing project: ", projectArray2);
            n = 0;
            boolean bl2 = false;
            ArrayList<Project> arrayList = new ArrayList<Project>();
            ArrayList<Project> arrayList2 = new ArrayList<Project>();
            ArrayList<Project> arrayList3 = new ArrayList<Project>();
            OpenProjectList openProjectList = this;
            synchronized (openProjectList) {
                arrayList.addAll(this.openProjects);
                for (int i = 0; i < projectArray2.length; ++i) {
                    if (!this.openProjects.contains(projectArray2[i])) continue;
                    if (n == 0) {
                        n = this.isMainProject(projectArray2[i]) ? 1 : 0;
                    }
                    this.openProjects.remove(projectArray2[i]);
                    this.removeModuleInfo(projectArray2[i]);
                    projectArray2[i].getProjectDirectory().removeFileChangeListener((FileChangeListener)this.deleteListener);
                    this.recentProjects.add(projectArray2[i]);
                    arrayList3.add(projectArray2[i]);
                    bl2 = true;
                }
                if (bl2) {
                    arrayList2.addAll(this.openProjects);
                    OpenProjectList.saveProjectList(this.openProjects);
                }
                if (n != 0) {
                    this.mainProject = null;
                    OpenProjectList.saveMainProject(this.mainProject);
                }
                if (bl2) {
                    this.recentProjects.save();
                }
            }
            for (Project project : arrayList3) {
                OpenProjectList.notifyClosed(project);
            }
            OpenProjectList.logProjects("close(): openProjects == ", this.openProjects.toArray(new Project[0]));
            if (bl2) {
                this.pchSupport.firePropertyChange(PROPERTY_OPEN_PROJECTS, arrayList.toArray(new Project[arrayList.size()]), arrayList2.toArray(new Project[arrayList2.size()]));
            }
            if (n != 0) {
                this.pchSupport.firePropertyChange(PROPERTY_MAIN_PROJECT, null, null);
            }
            if (bl2) {
                this.pchSupport.firePropertyChange(PROPERTY_RECENT_PROJECTS, null, null);
            }
            for (int i = 0; i < projectArray2.length; ++i) {
                try {
                    ProjectManager.getDefault().saveProject(projectArray2[i]);
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            LogRecord[] logRecordArray = OpenProjectList.createRecord("UI_CLOSED_PROJECTS", projectArray2);
            OpenProjectList.log(logRecordArray);
        }
        finally {
            this.LOAD.exit();
        }
    }

    public synchronized Project[] getOpenProjects() {
        Project[] projectArray = new Project[this.openProjects.size()];
        this.openProjects.toArray(projectArray);
        return projectArray;
    }

    public synchronized boolean isOpen(Project project) {
        for (Project project2 : this.openProjects) {
            if (!project.getProjectDirectory().equals(project2.getProjectDirectory())) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isMainProject(Project project) {
        return this.mainProject != null && project != null && this.mainProject.getProjectDirectory().equals(project.getProjectDirectory());
    }

    public synchronized Project getMainProject() {
        return this.mainProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainProject(Project project) {
        LOGGER.finer("Setting main project: " + project);
        OpenProjectList.logProjects("setMainProject(): openProjects == ", this.openProjects.toArray(new Project[0]));
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            if (project != null && !this.openProjects.contains(project)) {
                OpenProjectList.logProjects("setMainProject(): openProjects == ", this.openProjects.toArray(new Project[0]));
                throw new IllegalArgumentException("Project " + ProjectUtils.getInformation((Project)project).getDisplayName() + " is not open and cannot be set as main.");
            }
            this.mainProject = project;
            OpenProjectList.saveMainProject(project);
        }
        this.pchSupport.firePropertyChange(PROPERTY_MAIN_PROJECT, null, null);
    }

    public List<Project> getRecentProjects() {
        return (List)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<List>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List run() {
                Class<OpenProjectList> clazz = OpenProjectList.class;
                synchronized (OpenProjectList.class) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return OpenProjectList.this.recentProjects.getProjects();
                }
            }
        });
    }

    public boolean isRecentProjectsEmpty() {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                Class<OpenProjectList> clazz = OpenProjectList.class;
                synchronized (OpenProjectList.class) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return OpenProjectList.this.recentProjects.isEmpty();
                }
            }
        });
    }

    public List<UnloadedProjectInformation> getRecentProjectsInformation() {
        return (List)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<List>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List run() {
                Class<OpenProjectList> clazz = OpenProjectList.class;
                synchronized (OpenProjectList.class) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return OpenProjectList.this.recentProjects.getRecentProjectsInfo();
                }
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pchSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pchSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public List<DataObject> getTemplatesLRU(Project project, PrivilegedTemplates privilegedTemplates) {
        ArrayList<FileObject> arrayList = this.getTemplateNamesLRU(project, privilegedTemplates);
        ArrayList<DataObject> arrayList2 = new ArrayList<DataObject>();
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            if (fileObject != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    arrayList2.add(dataObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    iterator.remove();
                    ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
                }
                continue;
            }
            iterator.remove();
        }
        return arrayList2;
    }

    public synchronized void updateTemplatesLRU(FileObject fileObject) {
        String string = fileObject.getPath();
        if (this.getRecentTemplates().contains(string)) {
            this.getRecentTemplates().remove(string);
        }
        this.getRecentTemplates().add(0, string);
        if (this.getRecentTemplates().size() > 100) {
            this.getRecentTemplates().remove(100);
        }
        OpenProjectListSettings.getInstance().setRecentTemplates(new ArrayList<String>(this.getRecentTemplates()));
    }

    static void shutdown() {
        if (INSTANCE != null) {
            for (Project project : OpenProjectList.INSTANCE.openProjects) {
                OpenProjectList.notifyClosed(project);
            }
        }
    }

    public static Project fileToProject(File file) {
        try {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null && fileObject.isFolder()) {
                return ProjectManager.getDefault().findProject(fileObject);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static LinkedList<Project> URLs2Projects(Collection<URL> collection) {
        LinkedList<Project> linkedList = new LinkedList<Project>();
        for (URL uRL : collection) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null || !fileObject.isFolder()) continue;
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                if (project == null) continue;
                linkedList.add(project);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                ErrorManager.getDefault().notify(1, throwable);
            }
        }
        return linkedList;
    }

    private static List<URL> projects2URLs(Collection<Project> collection) {
        ArrayList<URL> arrayList = new ArrayList<URL>(collection.size());
        for (Project project : collection) {
            try {
                URL uRL = project.getProjectDirectory().getURL();
                if (uRL == null) continue;
                arrayList.add(uRL);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
        return arrayList;
    }

    private static boolean notifyOpened(Project project) {
        boolean bl = true;
        for (ProjectOpenedHook projectOpenedHook : project.getLookup().lookupAll(ProjectOpenedHook.class)) {
            try {
                ProjectOpenedTrampoline.DEFAULT.projectOpened(projectOpenedHook);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.log(Level.WARNING, null, runtimeException);
                OpenProjectList.INSTANCE.openProjects.remove(project);
                INSTANCE.removeModuleInfo(project);
                bl = false;
            }
            catch (Error error) {
                LOGGER.log(Level.WARNING, null, error);
                OpenProjectList.INSTANCE.openProjects.remove(project);
                INSTANCE.removeModuleInfo(project);
                bl = false;
            }
        }
        return bl;
    }

    private static void notifyClosed(Project project) {
        for (ProjectOpenedHook projectOpenedHook : project.getLookup().lookupAll(ProjectOpenedHook.class)) {
            try {
                ProjectOpenedTrampoline.DEFAULT.projectClosed(projectOpenedHook);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.log(Level.WARNING, null, runtimeException);
            }
            catch (Error error) {
                LOGGER.log(Level.WARNING, null, error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doOpenProject(final Project project) {
        boolean bl;
        LOGGER.finer("doOpenProject(): opening project " + project.toString());
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            if (this.openProjects.contains(project)) {
                return false;
            }
            this.openProjects.add(project);
            this.addModuleInfo(project);
            project.getProjectDirectory().addFileChangeListener((FileChangeListener)this.deleteListener);
            project.getProjectDirectory().addFileChangeListener((FileChangeListener)this.nbprojectDeleteListener);
            bl = this.recentProjects.remove(project);
        }
        OpenProjectList.logProjects("doOpenProject(): openProjects == ", this.openProjects.toArray(new Project[0]));
        OpenProjectList.notifyOpened(project);
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                ProjectUtilities.openProjectFiles(project);
                return null;
            }
        });
        return bl;
    }

    private static List<Project> loadProjectList() {
        List<URL> list = OpenProjectListSettings.getInstance().getOpenProjectsURLs();
        List<String> list2 = OpenProjectListSettings.getInstance().getOpenProjectsDisplayNames();
        List<ExtIcon> list3 = OpenProjectListSettings.getInstance().getOpenProjectsIcons();
        ArrayList<Project> arrayList = new ArrayList<Project>();
        Iterator<URL> iterator = list.iterator();
        Iterator<String> iterator2 = list2.iterator();
        Iterator<ExtIcon> iterator3 = list3.iterator();
        while (iterator.hasNext() && iterator2.hasNext() && iterator3.hasNext()) {
            arrayList.add(new LazyProject(iterator.next(), iterator2.next(), iterator3.next()));
        }
        return arrayList;
    }

    private static void saveProjectList(List<Project> list) {
        List<URL> list2 = OpenProjectList.projects2URLs(list);
        OpenProjectListSettings.getInstance().setOpenProjectsURLs(list2);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<ExtIcon> arrayList2 = new ArrayList<ExtIcon>();
        Iterator<Project> iterator = list.iterator();
        while (iterator.hasNext()) {
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)iterator.next());
            arrayList.add(projectInformation.getDisplayName());
            ExtIcon extIcon = new ExtIcon();
            extIcon.setIcon(projectInformation.getIcon());
            arrayList2.add(extIcon);
        }
        OpenProjectListSettings.getInstance().setOpenProjectsDisplayNames(arrayList);
        OpenProjectListSettings.getInstance().setOpenProjectsIcons(arrayList2);
    }

    private static void saveMainProject(Project project) {
        try {
            URL uRL = project == null ? null : project.getProjectDirectory().getURL();
            OpenProjectListSettings.getInstance().setMainProjectURL(uRL);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            OpenProjectListSettings.getInstance().setMainProjectURL(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<FileObject> getTemplateNamesLRU(Project project, PrivilegedTemplates privilegedTemplates) {
        Object object;
        Object object2;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(15);
        RecommendedTemplates recommendedTemplates = (RecommendedTemplates)project.getLookup().lookup(RecommendedTemplates.class);
        String[] stringArray = recommendedTemplates == null ? new String[]{} : recommendedTemplates.getRecommendedTypes();
        PrivilegedTemplates privilegedTemplates2 = privilegedTemplates != null ? privilegedTemplates : (PrivilegedTemplates)project.getLookup().lookup(PrivilegedTemplates.class);
        String[] stringArray2 = privilegedTemplates2 == null ? null : privilegedTemplates2.getPrivilegedTemplates();
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(privilegedTemplates2 == null ? new String[]{} : stringArray2));
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        if (privilegedTemplates == null) {
            object2 = this;
            synchronized (object2) {
                Iterator<String> iterator = this.getRecentTemplates().iterator();
                for (int i = 0; i < 15 && iterator.hasNext(); ++i) {
                    object = iterator.next();
                    FileObject fileObject = fileSystem.findResource((String)object);
                    if (fileObject == null) {
                        iterator.remove();
                        continue;
                    }
                    if (!OpenProjectList.isRecommended(project, fileObject)) continue;
                    arrayList.add(fileObject);
                    arrayList2.remove(object);
                }
            }
        }
        object2 = arrayList2.iterator();
        for (int i = arrayList.size(); i < 15 && object2.hasNext(); ++i) {
            String string = (String)object2.next();
            object = fileSystem.findResource(string);
            if (object == null) continue;
            arrayList.add((FileObject)object);
        }
        return arrayList;
    }

    static boolean isRecommended(Project project, FileObject fileObject) {
        if (OpenProjectList.getRecommendedTypes(project) == null || OpenProjectList.getRecommendedTypes(project).length == 0) {
            return true;
        }
        Object object = fileObject.getAttribute("templateCategory");
        if (object != null) {
            assert (object instanceof String) : fileObject + " attr templateCategory = " + object;
            Iterator<String> iterator = OpenProjectList.getCategories((String)object).iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (!Arrays.asList(OpenProjectList.getRecommendedTypes(project)).contains(string)) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return true;
    }

    private static String[] getRecommendedTypes(Project project) {
        RecommendedTemplates recommendedTemplates = (RecommendedTemplates)project.getLookup().lookup(RecommendedTemplates.class);
        return recommendedTemplates == null ? null : recommendedTemplates.getRecommendedTypes();
    }

    private static List<String> getCategories(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList;
    }

    private static ModuleInfo findModuleForProject(Project project) {
        Collection collection = Lookup.getDefault().lookupAll(ModuleInfo.class);
        ModuleInfo moduleInfo = null;
        for (ModuleInfo moduleInfo2 : collection) {
            if (!moduleInfo2.isEnabled() || moduleInfo2.getClassLoader() != project.getClass().getClassLoader()) continue;
            moduleInfo = moduleInfo2;
            break;
        }
        return moduleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModuleInfo(Project project) {
        ModuleInfo moduleInfo = OpenProjectList.findModuleForProject(project);
        if (moduleInfo != null) {
            HashMap<ModuleInfo, List<Project>> hashMap = this.openProjectsModuleInfos;
            synchronized (hashMap) {
                if (!this.openProjectsModuleInfos.containsKey(moduleInfo)) {
                    this.openProjectsModuleInfos.put(moduleInfo, new ArrayList());
                    moduleInfo.addPropertyChangeListener(this.infoListener);
                }
                this.openProjectsModuleInfos.get(moduleInfo).add(project);
            }
        }
    }

    private void removeModuleInfo(Project project) {
        ModuleInfo moduleInfo = OpenProjectList.findModuleForProject(project);
        this.removeModuleInfo(project, moduleInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModuleInfo(Project project, ModuleInfo moduleInfo) {
        if (moduleInfo != null) {
            HashMap<ModuleInfo, List<Project>> hashMap = this.openProjectsModuleInfos;
            synchronized (hashMap) {
                List<Project> list = this.openProjectsModuleInfos.get(moduleInfo);
                if (list != null) {
                    list.remove(project);
                    if (list.size() == 0) {
                        moduleInfo.removePropertyChangeListener(this.infoListener);
                        this.openProjectsModuleInfos.remove(moduleInfo);
                    }
                }
            }
        }
    }

    private void checkModuleInfo(ModuleInfo moduleInfo) {
        if (moduleInfo.isEnabled()) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.openProjectsModuleInfos.get(moduleInfo));
        if (arrayList != null && arrayList.size() > 0) {
            for (Project project : arrayList) {
                this.removeModuleInfo(project, moduleInfo);
            }
            this.close(arrayList.toArray(new Project[arrayList.size()]), false);
        }
    }

    private static LogRecord[] createRecord(String string, Project[] projectArray) {
        Object object;
        if (projectArray.length == 0) {
            return null;
        }
        HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
        for (Project project : projectArray) {
            String object2 = project.getClass().getName();
            object = (int[])hashMap.get(object2);
            if (object == null) {
                object = new int[1];
                hashMap.put(object2, (int[])object);
            }
            object[0] = object[0] + 1;
        }
        Logger logger = Logger.getLogger("org.netbeans.ui.projects");
        LogRecord[] logRecordArray = new LogRecord[hashMap.size()];
        int n = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            object = new LogRecord(Level.CONFIG, string);
            object.setParameters(new Object[]{entry.getKey(), OpenProjectList.afterLastDot((String)entry.getKey()), ((int[])entry.getValue())[0]});
            object.setLoggerName(logger.getName());
            object.setResourceBundle(NbBundle.getBundle(OpenProjectList.class));
            object.setResourceBundleName(OpenProjectList.class.getPackage().getName() + ".Bundle");
            logRecordArray[n++] = object;
        }
        return logRecordArray;
    }

    private static void log(LogRecord[] logRecordArray) {
        if (logRecordArray == null) {
            return;
        }
        Logger logger = Logger.getLogger("org.netbeans.ui.projects");
        for (LogRecord logRecord : logRecordArray) {
            logger.log(logRecord);
        }
    }

    private static String afterLastDot(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static void logProjects(String string, Project[] projectArray) {
        if (projectArray.length == 0) {
            return;
        }
        for (Project project : projectArray) {
            LOGGER.finer(string + project.toString());
        }
    }

    static {
        LOGGER = Logger.getLogger(OpenProjectList.class.getName());
        OPENING_RP = new RequestProcessor("Opening projects", 1);
        RECENT_TEMPLATES_LOCK = new Object();
    }

    private final class ProjectDeletionListener
    extends FileChangeAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(FileEvent fileEvent) {
            OpenProjectList openProjectList = OpenProjectList.this;
            synchronized (openProjectList) {
                Project project = null;
                Iterator iterator = OpenProjectList.this.openProjects.iterator();
                while (iterator.hasNext()) {
                    Project project2 = (Project)iterator.next();
                    if (!fileEvent.getFile().equals(project2.getProjectDirectory())) continue;
                    project = project2;
                    break;
                }
                if ((iterator = project) != null) {
                    SwingUtilities.invokeLater(new Runnable((Project)iterator){
                        final /* synthetic */ Project val$fRemove;
                        {
                            this.val$fRemove = project;
                        }

                        public void run() {
                            OpenProjectList.this.close(new Project[]{this.val$fRemove}, false);
                        }
                    });
                }
            }
        }
    }

    private final class NbProjectDeletionListener
    extends FileChangeAdapter {
        public void fileDeleted(FileEvent fileEvent) {
            OpenProjectList.this.recentProjects.refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProjectByDisplayNameComparator
    implements Comparator<Project> {
        private static Comparator<Object> COLLATOR = Collator.getInstance();

        @Override
        public int compare(Project project, Project project2) {
            String string = ProjectUtils.getInformation((Project)project).getDisplayName();
            String string2 = ProjectUtils.getInformation((Project)project2).getDisplayName();
            if (string != null && string2 != null) {
                return COLLATOR.compare(string, string2);
            }
            if (string == null && string2 != null) {
                LOGGER.log(Level.WARNING, project + ": ProjectInformation.getDisplayName() should not return null!");
                return -1;
            }
            if (string != null && string2 == null) {
                LOGGER.log(Level.WARNING, project2 + ": ProjectInformation.getDisplayName() should not return null!");
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RecentProjectList {
        private List<ProjectReference> recentProjects;
        private List<UnloadedProjectInformation> recentProjectsInfos;
        private int size;

        public RecentProjectList(int n) {
            this.size = n;
            this.recentProjects = new ArrayList<ProjectReference>(n);
            this.recentProjectsInfos = new ArrayList<UnloadedProjectInformation>(n);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "created a RecentProjectList: size=" + n);
            }
        }

        public void add(Project project) {
            int n = this.getIndex(project);
            if (n == -1) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "add new recent project: " + project);
                }
                if (this.recentProjects.size() == this.size) {
                    this.recentProjects.remove(this.size - 1);
                    this.recentProjectsInfos.remove(this.size - 1);
                }
                this.recentProjects.add(0, new ProjectReference(project));
                try {
                    this.recentProjectsInfos.add(0, ProjectInfoAccessor.DEFAULT.getProjectInfo(ProjectUtils.getInformation((Project)project).getDisplayName(), ProjectUtils.getInformation((Project)project).getIcon(), project.getProjectDirectory().getURL()));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "re-add recent project: " + project);
                }
                this.recentProjects.remove(n);
                this.recentProjects.add(0, new ProjectReference(project));
                this.recentProjectsInfos.remove(n);
                try {
                    this.recentProjectsInfos.add(0, ProjectInfoAccessor.DEFAULT.getProjectInfo(ProjectUtils.getInformation((Project)project).getDisplayName(), ProjectUtils.getInformation((Project)project).getIcon(), project.getProjectDirectory().getURL()));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            }
        }

        public boolean remove(Project project) {
            int n = this.getIndex(project);
            if (n != -1) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "remove recent project: " + project);
                }
                this.recentProjects.remove(n);
                this.recentProjectsInfos.remove(n);
                return true;
            }
            return false;
        }

        public void refresh() {
            assert (this.recentProjects.size() == this.recentProjectsInfos.size());
            boolean bl = false;
            Iterator<ProjectReference> iterator = this.recentProjects.iterator();
            Iterator<UnloadedProjectInformation> iterator2 = this.recentProjectsInfos.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                ProjectReference projectReference = iterator.next();
                iterator2.next();
                URL uRL = projectReference.getURL();
                FileObject fileObject = null;
                try {
                    fileObject = FileUtil.toFileObject((File)new File(uRL.toURI()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                Project project = null;
                if (fileObject != null && fileObject.isFolder()) {
                    try {
                        project = ProjectManager.getDefault().findProject(fileObject);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (project != null) continue;
                bl = true;
                if (fileObject != null && fileObject.isFolder()) {
                    fileObject.removeFileChangeListener((FileChangeListener)OpenProjectList.this.nbprojectDeleteListener);
                }
                iterator.remove();
                iterator2.remove();
            }
            if (bl) {
                OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_RECENT_PROJECTS, null, null);
                this.save();
            }
        }

        public List<Project> getProjects() {
            ArrayList<Project> arrayList = new ArrayList<Project>(this.recentProjects.size());
            ArrayList<ProjectReference> arrayList2 = new ArrayList<ProjectReference>(this.recentProjects);
            for (ProjectReference projectReference : arrayList2) {
                Project project = projectReference.getProject();
                if (project == null || !project.getProjectDirectory().isValid()) {
                    this.remove(project);
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "removing dead recent project: " + project);
                    continue;
                }
                arrayList.add(project);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "recent projects: " + arrayList);
            }
            return arrayList;
        }

        public boolean isEmpty() {
            boolean bl = this.recentProjects.isEmpty();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "recent projects empty? " + bl);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load() {
            List<URL> list = OpenProjectListSettings.getInstance().getRecentProjectsURLs();
            List<String> list2 = OpenProjectListSettings.getInstance().getRecentProjectsDisplayNames();
            List<ExtIcon> list3 = OpenProjectListSettings.getInstance().getRecentProjectsIcons();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "recent project list load: " + list);
            }
            this.recentProjects.clear();
            Object object = list.iterator();
            while (object.hasNext()) {
                this.recentProjects.add(new ProjectReference(object.next()));
            }
            this.recentProjectsInfos.clear();
            object = list2.iterator();
            Iterator<URL> iterator = list.iterator();
            Project project2 = list3.iterator();
            while (object.hasNext() && iterator.hasNext() && project2.hasNext()) {
                String string = (String)object.next();
                URL uRL = iterator.next();
                Icon icon = project2.next().getIcon();
                this.recentProjectsInfos.add(ProjectInfoAccessor.DEFAULT.getProjectInfo(string, icon, uRL));
            }
            if (this.recentProjects.size() != this.recentProjectsInfos.size()) {
                this.recentProjects.clear();
                this.recentProjectsInfos.clear();
            }
            object = this;
            synchronized (object) {
                for (Project project2 : OpenProjectList.this.openProjects) {
                    assert (project2 != null) : "There is null in " + OpenProjectList.access$200(OpenProjectList.this);
                    assert (project2.getProjectDirectory() != null) : "Project " + project2 + " has null project directory";
                    project2.getProjectDirectory().addFileChangeListener((FileChangeListener)OpenProjectList.this.nbprojectDeleteListener);
                }
            }
        }

        public void save() {
            Serializable serializable;
            ArrayList<URL> arrayList = new ArrayList<URL>(this.recentProjects.size());
            for (ProjectReference object2 : this.recentProjects) {
                serializable = object2.getURL();
                if (serializable == null) continue;
                arrayList.add((URL)serializable);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "recent project list save: " + arrayList);
            }
            OpenProjectListSettings.getInstance().setRecentProjectsURLs(arrayList);
            int n = this.recentProjectsInfos.size();
            ArrayList<String> arrayList2 = new ArrayList<String>(n);
            serializable = new ArrayList(n);
            for (UnloadedProjectInformation unloadedProjectInformation : this.recentProjectsInfos) {
                arrayList2.add(unloadedProjectInformation.getDisplayName());
                ExtIcon extIcon = new ExtIcon();
                extIcon.setIcon(unloadedProjectInformation.getIcon());
                serializable.add(extIcon);
            }
            OpenProjectListSettings.getInstance().setRecentProjectsDisplayNames(arrayList2);
            OpenProjectListSettings.getInstance().setRecentProjectsIcons((List<ExtIcon>)((Object)serializable));
        }

        private int getIndex(Project project) {
            URL uRL;
            try {
                if (project == null || project.getProjectDirectory() == null) {
                    return -1;
                }
                uRL = project.getProjectDirectory().getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return -1;
            }
            int n = 0;
            Iterator<ProjectReference> iterator = this.recentProjects.iterator();
            while (iterator.hasNext()) {
                URL uRL2 = iterator.next().getURL();
                if (uRL.equals(uRL2)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        private List<UnloadedProjectInformation> getRecentProjectsInfo() {
            this.refresh();
            return this.recentProjectsInfos;
        }

        private class ProjectReference {
            private WeakReference<Project> projectReference;
            private URL projectURL;

            public ProjectReference(URL uRL) {
                this.projectURL = uRL;
            }

            public ProjectReference(Project project) {
                block2: {
                    this.projectReference = new WeakReference<Project>(project);
                    try {
                        this.projectURL = project.getProjectDirectory().getURL();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block2;
                        LOGGER.log(Level.FINE, "FSIE getting URL for project: " + project.getProjectDirectory());
                    }
                }
            }

            public Project getProject() {
                block9: {
                    FileObject fileObject;
                    Project project = null;
                    if (this.projectReference != null && (project = (Project)this.projectReference.get()) != null) {
                        if (ProjectManager.getDefault().isValid(project)) {
                            return project;
                        }
                        return null;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "no active project reference for " + this.projectURL);
                    }
                    if (this.projectURL != null && (fileObject = URLMapper.findFileObject((URL)this.projectURL)) != null && fileObject.isFolder()) {
                        try {
                            project = ProjectManager.getDefault().findProject(fileObject);
                            if (project != null) {
                                this.projectReference = new WeakReference<Project>(project);
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.log(Level.FINE, "found " + project);
                                }
                                return project;
                            }
                        }
                        catch (IOException iOException) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block9;
                            LOGGER.log(Level.FINE, "could not load recent project from " + this.projectURL);
                        }
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "no recent project in " + this.projectURL);
                }
                return null;
            }

            public URL getURL() {
                return this.projectURL;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LoadOpenProjects
    implements Runnable,
    LookupListener,
    Future<Project[]> {
        final RequestProcessor RP = new RequestProcessor("Load Open Projects");
        final RequestProcessor.Task TASK = this.RP.create((Runnable)this);
        private int action;
        private LinkedList<Project> toOpenProjects = new LinkedList();
        private List<Project> lazilyOpenedProjects;
        private List<String> recentTemplates;
        private Project lazyMainProject;
        private Lookup.Result<FileObject> currentFiles;
        private int entered;
        private final Lock enteredGuard = new ReentrantLock();
        private final Condition enteredZeroed = this.enteredGuard.newCondition();

        public LoadOpenProjects(int n) {
            this.action = n;
            this.currentFiles = Utilities.actionsGlobalContext().lookupResult(FileObject.class);
            this.currentFiles.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.currentFiles));
        }

        final void waitFinished() {
            if (this.action == 0) {
                this.run();
            }
            this.TASK.waitFinished();
        }

        @Override
        public void run() {
            LOGGER.log(Level.FINE, "LoadOpenProjects.run: {0}", this.action);
            switch (this.action) {
                case 0: {
                    this.action = 1;
                    this.TASK.schedule(0);
                    this.resultChanged(null);
                    return;
                }
                case 1: {
                    this.action = 2;
                    this.loadOnBackground();
                    this.updateGlobalState();
                    return;
                }
                case 2: {
                    return;
                }
            }
            throw new IllegalStateException("unknown action: " + this.action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void preferredProject(Project project) {
            LinkedList<Project> linkedList = this.toOpenProjects;
            synchronized (linkedList) {
                for (Project project2 : this.toOpenProjects) {
                    if (!project2.getProjectDirectory().equals(project.getProjectDirectory())) continue;
                    this.toOpenProjects.remove(project2);
                    this.toOpenProjects.addFirst(project2);
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateGlobalState() {
            LOGGER.log(Level.FINER, "updateGlobalState");
            OpenProjectList openProjectList = INSTANCE;
            synchronized (openProjectList) {
                INSTANCE.openProjects = this.lazilyOpenedProjects;
                if (this.lazyMainProject != null) {
                    INSTANCE.mainProject = this.lazyMainProject;
                }
                INSTANCE.mainProject = OpenProjectList.this.unwrapProject(INSTANCE.mainProject);
                INSTANCE.getRecentTemplates().addAll(this.recentTemplates);
                LOGGER.log(Level.FINER, "updateGlobalState, applied");
            }
            INSTANCE.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_OPEN_PROJECTS, new Project[0], this.lazilyOpenedProjects.toArray(new Project[0]));
            INSTANCE.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_MAIN_PROJECT, null, INSTANCE.mainProject);
            LOGGER.log(Level.FINER, "updateGlobalState, done, notified");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadOnBackground() {
            Project[] projectArray;
            this.lazilyOpenedProjects = new ArrayList<Project>();
            List<URL> list = OpenProjectListSettings.getInstance().getOpenProjectsURLs();
            this.toOpenProjects.addAll(OpenProjectList.URLs2Projects(list));
            Serializable serializable = this.toOpenProjects;
            synchronized (serializable) {
                LOGGER.log(Level.FINER, "loadOnBackground {0}", this.toOpenProjects);
                projectArray = this.toOpenProjects.toArray(new Project[0]);
            }
            this.recentTemplates = new ArrayList<String>(OpenProjectListSettings.getInstance().getRecentTemplates());
            serializable = OpenProjectListSettings.getInstance().getMainProjectURL();
            Project project = this.toOpenProjects;
            synchronized (project) {
                for (Project project2 : this.toOpenProjects) {
                    INSTANCE.addModuleInfo(project2);
                    try {
                        if (serializable == null || !((URL)serializable).equals(project2.getProjectDirectory().getURL())) continue;
                        this.lazyMainProject = project2;
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {}
                }
            }
            while (true) {
                Object object = this.toOpenProjects;
                synchronized (object) {
                    if (this.toOpenProjects.isEmpty()) {
                        break;
                    }
                    project = this.toOpenProjects.remove();
                    LOGGER.log(Level.FINER, "after remove {0}", this.toOpenProjects);
                }
                LOGGER.log(Level.FINE, "about to open a project {0}", project);
                if (OpenProjectList.notifyOpened(project)) {
                    this.lazilyOpenedProjects.add(project);
                    LOGGER.log(Level.FINE, "notify opened {0}", project);
                    object = new PropertyChangeEvent(this, OpenProjectList.PROPERTY_REPLACE, null, project);
                    OpenProjectList.this.pchSupport.firePropertyChange((PropertyChangeEvent)object);
                    LOGGER.log(Level.FINE, "property change notified {0}", project);
                    continue;
                }
                if (this.lazyMainProject != project) continue;
                this.lazyMainProject = null;
            }
            if (projectArray != null) {
                OpenProjectList.log(OpenProjectList.createRecord("UI_INIT_PROJECTS", projectArray));
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            for (FileObject fileObject : this.currentFiles.allInstances()) {
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                OpenProjectList.preferredProject(project);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void enter() {
            try {
                this.enteredGuard.lock();
                ++this.entered;
            }
            finally {
                this.enteredGuard.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void exit() {
            try {
                this.enteredGuard.lock();
                if (--this.entered == 0) {
                    this.enteredZeroed.signalAll();
                }
            }
            finally {
                this.enteredGuard.unlock();
            }
        }

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.TASK.isFinished() && this.entered == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Project[] get() throws InterruptedException, ExecutionException {
            this.TASK.waitFinished();
            try {
                this.enteredGuard.lock();
                while (this.entered > 0) {
                    this.enteredZeroed.await();
                }
            }
            finally {
                this.enteredGuard.unlock();
            }
            return OpenProjectList.getDefault().getOpenProjects();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Project[] get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            long l2 = timeUnit.convert(l, TimeUnit.MILLISECONDS);
            if (!this.TASK.waitFinished(l)) {
                throw new TimeoutException();
            }
            try {
                this.enteredGuard.lock();
                if (this.entered > 0 && !this.enteredZeroed.await(l2, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException();
                }
            }
            finally {
                this.enteredGuard.unlock();
            }
            return OpenProjectList.getDefault().getOpenProjects();
        }
    }
}

