/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.share.configbean.SessionConfigSubBean;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.TextMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.DynamicPropertyPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyListMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppRootCustomizer;
import org.openide.util.NbBundle;

public class WebAppSessionConfigPanel
extends JPanel
implements TableModelListener {
    private final ResourceBundle webappBundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");
    private final ResourceBundle commonBundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private final TextMapping[] persistenceTypes = new TextMapping[]{new TextMapping("", ""), new TextMapping("memory", this.webappBundle.getString("MEMORY_PERSISTENCE_TYPE")), new TextMapping("file", this.webappBundle.getString("FILE_PERSISTENCE_TYPE")), new TextMapping("ha", this.webappBundle.getString("HA_PERSISTENCE_TYPE")), new TextMapping("mmap", this.webappBundle.getString("MMAP_PERSISTENCE_TYPE")), new TextMapping("replicated", this.webappBundle.getString("REPLICATED_PERSISTENCE_TYPE")), new TextMapping("s1ws60", this.webappBundle.getString("S1WS60_PERSISTENCE_TYPE")), new TextMapping("custom", this.webappBundle.getString("CUSTOM_PERSISTENCE_TYPE"))};
    private WebAppRootCustomizer masterPanel;
    private DefaultComboBoxModel persistenceTypeModel;
    private GenericTableModel mgrPropertiesModel;
    private GenericTablePanel mgrPropertiesPanel;
    private GenericTableModel storePropertiesModel;
    private GenericTablePanel storePropertiesPanel;
    private GenericTableModel sessionPropertiesModel;
    private GenericTablePanel sessionPropertiesPanel;
    private GenericTableModel cookiePropertiesModel;
    private GenericTablePanel cookiePropertiesPanel;
    private JComboBox jComboPersistenceType;
    private JLabel jLblPersistenceType;
    private JLabel jLblSessionManager;
    private JTabbedPane propertyTabbedPanel;
    private JPanel sessionMgrPanel;

    public WebAppSessionConfigPanel(WebAppRootCustomizer webAppRootCustomizer) {
        this.masterPanel = webAppRootCustomizer;
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.sessionMgrPanel = new JPanel();
        this.jLblSessionManager = new JLabel();
        this.jLblPersistenceType = new JLabel();
        this.jComboPersistenceType = new JComboBox();
        this.propertyTabbedPanel = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(this.webappBundle.getString("ACSN_WebAppSessionConfigTab"));
        this.getAccessibleContext().setAccessibleDescription(this.webappBundle.getString("ACSD_WebAppSessionConfigTab"));
        this.sessionMgrPanel.setLayout(new GridBagLayout());
        this.jLblSessionManager.setText(this.webappBundle.getString("LBL_SessionManager"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.sessionMgrPanel.add((Component)this.jLblSessionManager, gridBagConstraints);
        this.jLblPersistenceType.setLabelFor(this.jComboPersistenceType);
        this.jLblPersistenceType.setText(this.webappBundle.getString("LBL_PersistenceType_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.sessionMgrPanel.add((Component)this.jLblPersistenceType, gridBagConstraints);
        this.jComboPersistenceType.setPrototypeDisplayValue("Ay");
        this.jComboPersistenceType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebAppSessionConfigPanel.this.jComboPersistenceTypeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.sessionMgrPanel.add((Component)this.jComboPersistenceType, gridBagConstraints);
        this.jComboPersistenceType.getAccessibleContext().setAccessibleName(this.webappBundle.getString("ACSN_PersistenceType"));
        this.jComboPersistenceType.getAccessibleContext().setAccessibleDescription(this.webappBundle.getString("ACSD_PersistenceType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.sessionMgrPanel, gridBagConstraints);
        this.propertyTabbedPanel.setTabPlacement(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.propertyTabbedPanel, gridBagConstraints);
    }

    private void jComboPersistenceTypeActionPerformed(ActionEvent actionEvent) {
        TextMapping textMapping = (TextMapping)this.persistenceTypeModel.getSelectedItem();
        WebAppRoot webAppRoot = this.masterPanel.getBean();
        if (webAppRoot != null) {
            SessionConfigSubBean sessionConfigSubBean = webAppRoot.getSessionConfigBean();
            try {
                sessionConfigSubBean.setPersistenceType(textMapping.getXMLString());
            }
            catch (PropertyVetoException propertyVetoException) {
                this.persistenceTypeModel.setSelectedItem(this.getPersistenceTypeMapping(sessionConfigSubBean.getPersistenceType()));
            }
        }
    }

    void initUserComponents() {
        this.persistenceTypeModel = new DefaultComboBoxModel();
        for (int i = 0; i < this.persistenceTypes.length; ++i) {
            this.persistenceTypeModel.addElement(this.persistenceTypes[i]);
        }
        this.jComboPersistenceType.setModel(this.persistenceTypeModel);
        ArrayList<GenericTableModel.TableEntry> arrayList = new ArrayList<GenericTableModel.TableEntry>(3);
        arrayList.add(new GenericTableModel.AttributeEntry("Name", this.commonBundle.getString("LBL_Name"), true));
        arrayList.add(new GenericTableModel.AttributeEntry("Value", this.commonBundle.getString("LBL_Value"), true));
        arrayList.add(new GenericTableModel.ValueEntry("Description", this.commonBundle.getString("LBL_Description")));
        this.mgrPropertiesModel = new GenericTableModel("WebProperty", WebAppRootCustomizer.webPropertyFactory, arrayList);
        this.mgrPropertiesPanel = new GenericTablePanel(this.mgrPropertiesModel, this.webappBundle, "ManagerProperties", DynamicPropertyPanel.class, "AS_CFG_SessionConfigurationManagerProperty", PropertyListMapping.getPropertyList("ConfigManagerProperties"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.mgrPropertiesPanel, gridBagConstraints);
        this.propertyTabbedPanel.addTab(this.webappBundle.getString("TAB_ManagerProperties"), jPanel);
        this.storePropertiesModel = new GenericTableModel("WebProperty", WebAppRootCustomizer.webPropertyFactory, arrayList);
        this.storePropertiesPanel = new GenericTablePanel(this.storePropertiesModel, this.webappBundle, "StoreProperties", DynamicPropertyPanel.class, "AS_CFG_SessionConfigurationStoreProperty", PropertyListMapping.getPropertyList("ConfigStoreProperties"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.storePropertiesPanel, gridBagConstraints);
        this.propertyTabbedPanel.addTab(this.webappBundle.getString("TAB_StoreProperties"), jPanel);
        this.sessionPropertiesModel = new GenericTableModel("WebProperty", WebAppRootCustomizer.webPropertyFactory, arrayList);
        this.sessionPropertiesPanel = new GenericTablePanel(this.sessionPropertiesModel, this.webappBundle, "SessionProperties", DynamicPropertyPanel.class, "AS_CFG_SessionConfigurationSessionProperty", PropertyListMapping.getPropertyList("ConfigSessionProperties"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.sessionPropertiesPanel, gridBagConstraints);
        this.propertyTabbedPanel.addTab(this.webappBundle.getString("TAB_SessionProperties"), jPanel);
        this.cookiePropertiesModel = new GenericTableModel("WebProperty", WebAppRootCustomizer.webPropertyFactory, arrayList);
        this.cookiePropertiesPanel = new GenericTablePanel(this.cookiePropertiesModel, this.webappBundle, "CookieProperties", DynamicPropertyPanel.class, "AS_CFG_SessionConfigurationCookieProperty", PropertyListMapping.getPropertyList("ConfigCookieProperties"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.cookiePropertiesPanel, gridBagConstraints);
        this.propertyTabbedPanel.addTab(this.webappBundle.getString("TAB_CookieProperties"), jPanel);
    }

    public void addListeners() {
        this.mgrPropertiesModel.addTableModelListener(this);
        this.storePropertiesModel.addTableModelListener(this);
        this.sessionPropertiesModel.addTableModelListener(this);
        this.cookiePropertiesModel.addTableModelListener(this);
    }

    public void removeListeners() {
        this.mgrPropertiesModel.removeTableModelListener(this);
        this.storePropertiesModel.removeTableModelListener(this);
        this.sessionPropertiesModel.removeTableModelListener(this);
        this.cookiePropertiesModel.removeTableModelListener(this);
    }

    public void initFields(WebAppRoot webAppRoot) {
        ASDDVersion aSDDVersion = webAppRoot.getAppServerVersion();
        SessionConfigSubBean sessionConfigSubBean = webAppRoot.getSessionConfigBean();
        this.persistenceTypeModel.setSelectedItem(this.getPersistenceTypeMapping(sessionConfigSubBean.getPersistenceType()));
        this.mgrPropertiesPanel.setModel((CommonDDBean)sessionConfigSubBean.getManagerProperties(), aSDDVersion);
        this.storePropertiesPanel.setModel((CommonDDBean)sessionConfigSubBean.getStoreProperties(), aSDDVersion);
        this.sessionPropertiesPanel.setModel((CommonDDBean)sessionConfigSubBean.getSessionProperties(), aSDDVersion);
        this.cookiePropertiesPanel.setModel((CommonDDBean)sessionConfigSubBean.getCookieProperties(), aSDDVersion);
    }

    private TextMapping getPersistenceTypeMapping(String string) {
        TextMapping textMapping = this.persistenceTypes[0];
        if (string == null) {
            string = "";
        }
        for (int i = 0; i < this.persistenceTypes.length; ++i) {
            if (this.persistenceTypes[i].getXMLString().compareTo(string) != 0) continue;
            textMapping = this.persistenceTypes[i];
            break;
        }
        return textMapping;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        WebAppRoot webAppRoot = this.masterPanel.getBean();
        if (webAppRoot != null) {
            webAppRoot.setDirty();
        }
    }

    public String getHelpId() {
        String string = "AS_CFG_SessionConfigurationManager";
        switch (this.propertyTabbedPanel.getSelectedIndex()) {
            case 3: {
                string = "AS_CFG_SessionConfigurationCookie";
                break;
            }
            case 2: {
                string = "AS_CFG_SessionConfigurationSession";
                break;
            }
            case 1: {
                string = "AS_CFG_SessionConfigurationStore";
            }
        }
        return string;
    }

    public ValidationError.Partition getPartition() {
        switch (this.propertyTabbedPanel.getSelectedIndex()) {
            case 3: {
                return ValidationError.PARTITION_SESSION_COOKIE;
            }
            case 2: {
                return ValidationError.PARTITION_SESSION_SESSION;
            }
            case 1: {
                return ValidationError.PARTITION_SESSION_STORE;
            }
        }
        return ValidationError.PARTITION_SESSION_MANAGER;
    }
}

