/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openide.util.NbBundle;

public class LocaleMapping
implements Comparable {
    private final ResourceBundle webappBundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");
    private Locale locale;
    private String displayText;
    private boolean textOutOfDate;
    private static SortedMap sortedLocaleMappings = LocaleMapping.getSortedAvailableLocaleMappings();

    public LocaleMapping(Locale locale) {
        this.locale = locale;
        this.displayText = this.buildDisplayText();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof LocaleMapping) {
            LocaleMapping localeMapping = (LocaleMapping)object;
            bl = this.locale.equals(localeMapping.getLocale());
        }
        return bl;
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    public String toString() {
        if (this.textOutOfDate) {
            this.displayText = this.buildDisplayText();
        }
        return this.displayText;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void updateDisplayText() {
        this.textOutOfDate = true;
    }

    private String buildDisplayText() {
        Object[] objectArray = new Object[]{this.locale.toString(), this.locale.getDisplayName()};
        String string = MessageFormat.format(this.webappBundle.getString("LBL_LocaleComboBoxDisplayText"), objectArray);
        if (string == null || string.length() == 0) {
            string = this.webappBundle.getString("LBL_UnnamedLocale");
        }
        this.textOutOfDate = false;
        return string;
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object instanceof LocaleMapping) {
            LocaleMapping localeMapping = (LocaleMapping)object;
            n = this.locale.toString().compareTo(localeMapping.getLocale().toString());
        }
        return n;
    }

    public static SortedMap getSortedAvailableLocaleMappings() {
        if (sortedLocaleMappings == null) {
            Locale[] localeArray = Locale.getAvailableLocales();
            sortedLocaleMappings = new TreeMap(new LocaleComparator());
            for (int i = 0; i < localeArray.length; ++i) {
                sortedLocaleMappings.put(localeArray[i], new LocaleMapping(localeArray[i]));
            }
        }
        return sortedLocaleMappings;
    }

    public static LocaleMapping getLocaleMapping(Locale locale) {
        return (LocaleMapping)sortedLocaleMappings.get(locale);
    }

    public static LocaleMapping getLocaleMapping(String string) {
        return (LocaleMapping)sortedLocaleMappings.get(LocaleMapping.getLocale(string));
    }

    public static Locale getLocale(String string) {
        String[] stringArray;
        Locale locale = null;
        if (string != null && (stringArray = string.split("_", 3)).length >= 1) {
            String string2 = stringArray[0];
            if (string2 == null) {
                string2 = "";
            }
            if (stringArray.length >= 2) {
                String string3 = stringArray[1];
                if (string3 == null) {
                    string3 = "";
                }
                if (stringArray.length >= 3) {
                    String string4 = stringArray[2];
                    if (string4 == null) {
                        string4 = "";
                    }
                    locale = new Locale(string2, string3, string4);
                } else {
                    locale = new Locale(string2, string3);
                }
            } else {
                locale = new Locale(string2);
            }
        }
        return locale;
    }

    public static class LocaleComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n = -1;
            if (object instanceof Locale && object2 instanceof Locale) {
                Locale locale = (Locale)object;
                Locale locale2 = (Locale)object2;
                n = locale.toString().compareTo(locale2.toString());
            }
            return n;
        }
    }
}

