/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.FixedHeightJTable;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.MethodTableModel;

public abstract class MethodTablePanel
extends JPanel {
    private MethodTableModel model;
    protected TableWithToolTips methodTable;
    protected JScrollPane tablePane;
    protected JPanel tablePanel;
    public static final Color DisabledBackgroundColor = Color.lightGray;
    public static final Color EnabledBackgroundColor = Color.white;
    public static final Color DisabledTextColor = Color.darkGray;

    public MethodTablePanel(MethodTableModel methodTableModel) {
        this.model = methodTableModel;
        this.initComponents();
    }

    public MethodTablePanel() {
        this.model = this.getMethodTableModel();
        this.initComponents();
    }

    protected void setData() {
        this.methodTable.setModel(this.model);
    }

    protected abstract MethodTableModel getMethodTableModel();

    protected abstract String getTablePaneAcsblName();

    protected abstract String getTablePaneAcsblDesc();

    protected abstract String getTablePaneToolTip();

    protected String getToolTip(int n, int n2) {
        return null;
    }

    protected String getToolTip(int n) {
        return null;
    }

    protected void initComponents() {
        if (this.model == null) {
            return;
        }
        this.setLayout(new GridBagLayout());
        this.methodTable = new TableWithToolTips();
        JTableHeader jTableHeader = this.methodTable.getTableHeader();
        ColumnHeaderToolTips columnHeaderToolTips = new ColumnHeaderToolTips();
        jTableHeader.addMouseMotionListener(columnHeaderToolTips);
        this.methodTable.setModel(this.model);
        this.methodTable.setRowSelectionAllowed(false);
        this.methodTable.setSelectionMode(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = this.getPanel();
        if (jPanel != null) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(6, 6, 0, 5);
            this.add((Component)jPanel, gridBagConstraints);
        }
        this.tablePane = new JScrollPane(this.methodTable);
        this.tablePane.setOpaque(true);
        this.tablePane.setToolTipText(this.getTablePaneToolTip());
        this.add((Component)this.tablePane, this.getTableGridBagConstraints());
        this.tablePane.getAccessibleContext().setAccessibleName(this.getTablePaneAcsblName());
        this.tablePane.getAccessibleContext().setAccessibleDescription(this.getTablePaneAcsblDesc());
    }

    protected JPanel getPanel() {
        return null;
    }

    protected GridBagConstraints getTableGridBagConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        return gridBagConstraints;
    }

    protected void setColumnRenderer(TableCellRenderer tableCellRenderer, int n) {
        TableColumnModel tableColumnModel = this.methodTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellRenderer(tableCellRenderer);
    }

    protected void setColumnEditor(TableCellEditor tableCellEditor, int n) {
        TableColumnModel tableColumnModel = this.methodTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellEditor(tableCellEditor);
    }

    protected TableColumn getColumn(int n, JTable jTable) {
        return n >= 0 && n < jTable.getColumnCount() ? jTable.getColumnModel().getColumn(n) : null;
    }

    protected void adjustColumnWidth(int n, boolean bl) {
        this.adjustColumnWidth(this.methodTable, n, null, bl);
    }

    protected void adjustColumnWidth(JTable jTable, int n, Object object, boolean bl) {
        Object object2;
        Object object3;
        TableColumn tableColumn = this.getColumn(n, jTable);
        if (tableColumn == null) {
            System.out.println("Invalid column index: " + n);
            return;
        }
        int n2 = tableColumn.getWidth();
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, n);
        int n3 = component.getPreferredSize().width;
        if (object != null) {
            TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(0, n);
            object3 = this.getTableCellRendererComponent(tableCellRenderer2, jTable, object, false, false, 0, n, false);
            object2 = ((Component)object3).getPreferredSize();
            if (((Dimension)object2).width > n3) {
                n3 = ((Dimension)object2).width;
            }
        }
        for (int i = 0; i < this.methodTable.getRowCount(); ++i) {
            Serializable serializable;
            if (bl && jTable.getModel().isCellEditable(i, n) && (object3 = jTable.getCellEditor(i, n)) instanceof DefaultCellEditor && (object2 = ((DefaultCellEditor)object3).getComponent()) instanceof JComboBox) {
                serializable = ((Component)object2).getPreferredSize();
                if (((Dimension)serializable).width > n3) {
                    n3 = ((Dimension)serializable).width;
                }
            }
            if ((object3 = jTable.getValueAt(i, n)) == null) continue;
            object2 = jTable.getCellRenderer(i, n);
            serializable = this.getTableCellRendererComponent((TableCellRenderer)object2, jTable, object3, false, false, i, n, false);
            Dimension dimension = ((Component)serializable).getPreferredSize();
            if (dimension.width <= n3) continue;
            n3 = dimension.width;
        }
        tableColumn.setMinWidth(n3 += 4);
        tableColumn.setMaxWidth(n3);
        tableColumn.setPreferredWidth(n3);
    }

    public Component getTableCellRendererComponent(TableCellRenderer tableCellRenderer, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2, boolean bl3) {
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component instanceof JComponent) {
            Serializable serializable;
            Object object2;
            JComponent jComponent = (JComponent)component;
            if (jComponent instanceof JLabel) {
                object2 = object == null ? "" : object.toString();
                serializable = this.getFontMetrics(((JLabel)jComponent).getFont());
                String string = null;
                string = bl3 ? MethodTablePanel.rightAlignLongText((String)object2, serializable, this.cellWidth(jTable, (JLabel)jComponent, n, n2)) : MethodTablePanel.leftAlignLongText((String)object2, serializable, this.cellWidth(jTable, (JLabel)jComponent, n, n2));
                ((JLabel)jComponent).setText(string);
                if (!string.equals(object2)) {
                    ((JLabel)jComponent).setToolTipText((String)object2);
                } else {
                    ((JLabel)jComponent).setToolTipText(null);
                }
            }
            if (bl) {
                jComponent.setBackground(jTable.getSelectionBackground());
                jComponent.setOpaque(true);
            } else {
                object2 = jTable.getModel();
                serializable = object2.isCellEditable(n, n2) ? EnabledBackgroundColor : DisabledBackgroundColor;
                jComponent.setBackground((Color)serializable);
                jComponent.setOpaque(true);
            }
        } else {
            System.out.println("Not a JComponent: " + component);
        }
        return component;
    }

    public int cellWidth(JTable jTable, JLabel jLabel, int n, int n2) {
        int n3 = jTable.getCellRect((int)n, (int)n2, (boolean)false).width;
        Insets insets = jLabel.getInsets();
        return n3 -= insets.left + insets.right;
    }

    public static String rightAlignLongText(String string, FontMetrics fontMetrics, int n) {
        if (string.length() > 0) {
            int n2 = fontMetrics.stringWidth(string);
            if (n > 0 && n2 > n) {
                int n3 = 0;
                while (n2 > n && n3 < string.length()) {
                    String string2 = "..." + string.substring(++n3);
                    n2 = fontMetrics.stringWidth(string2);
                }
                string = "..." + string.substring(n3);
            }
        }
        return string;
    }

    public static String leftAlignLongText(String string, FontMetrics fontMetrics, int n) {
        if (string.length() > 0) {
            int n2 = fontMetrics.stringWidth(string);
            if (n > 0 && n2 > n) {
                int n3 = 0;
                while (n2 > n && n3 < string.length()) {
                    String string2 = string.substring(0, string.length() - ++n3) + "...";
                    n2 = fontMetrics.stringWidth(string2);
                }
                string = string.substring(0, string.length() - n3) + "...";
            }
        }
        return string;
    }

    public static Color brighter(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        if (d > 0.0 && d < 1.0) {
            d = 1.0 - d;
            int n4 = (int)(1.0 / (1.0 - d));
            if (n == 0 && n2 == 0 && n3 == 0) {
                return new Color(n4, n4, n4);
            }
            if (n > 0 && n < n4) {
                n = n4;
            }
            if (n2 > 0 && n2 < n4) {
                n2 = n4;
            }
            if (n3 > 0 && n3 < n4) {
                n3 = n4;
            }
            return new Color(Math.min((int)((double)n / d), 255), Math.min((int)((double)n2 / d), 255), Math.min((int)((double)n3 / d), 255));
        }
        if (d < 0.0 && d > -1.0) {
            d = 1.0 + d;
            return new Color(Math.max((int)((double)n * d), 0), Math.max((int)((double)n2 * d), 0), Math.max((int)((double)n3 * d), 0));
        }
        return color;
    }

    public void setTablePanePreferredSize(Dimension dimension) {
        this.tablePane.setMinimumSize(dimension);
        this.tablePane.setPreferredSize(dimension);
    }

    protected class TableWithToolTips
    extends FixedHeightJTable {
        protected TableWithToolTips() {
        }

        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                jComponent.setToolTipText(MethodTablePanel.this.getToolTip(n, n2));
            }
            return component;
        }
    }

    protected class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        int curCol = -1;
        Map tips = new HashMap();

        protected ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn tableColumn, String string) {
            if (string == null) {
                this.tips.remove(tableColumn);
            } else {
                this.tips.put(tableColumn, string);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = -1;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            if (n >= 0 && n != this.curCol) {
                jTableHeader.setToolTipText(MethodTablePanel.this.getToolTip(n));
                this.curCol = n;
            }
        }
    }
}

