/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BaseCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public abstract class InputDialog
extends JDialog
implements HelpCtx.Provider {
    public static final int CANCEL_OPTION = 0;
    public static final int OK_OPTION = 1;
    public static final int HELP_OPTION = 2;
    private final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private int chosenOption;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton helpButton;
    private JPanel messagePanel;
    private List errorList;
    private List warningList;

    public InputDialog(JPanel jPanel, String string) {
        this(jPanel, string, false, false);
    }

    public InputDialog(JPanel jPanel, String string, boolean bl) {
        this(jPanel, string, bl, false);
    }

    public InputDialog(JPanel jPanel, String string, boolean bl, boolean bl2) {
        super(InputDialog.getFrame(jPanel), string, true);
        JComponent jComponent;
        GridBagConstraints gridBagConstraints;
        Object object;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                InputDialog.this.chosenOption = 0;
            }
        });
        if (!bl2) {
            this.getContentPane().setLayout(new BorderLayout());
            object = "South";
        } else {
            this.getContentPane().setLayout(new GridBagLayout());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 15;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            object = gridBagConstraints;
        }
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.messagePanel = new JPanel();
        this.messagePanel.setLayout(new GridBagLayout());
        this.messagePanel.getAccessibleContext().setAccessibleName(this.bundle.getString("ACSN_ErrorTextArea"));
        this.messagePanel.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_ErrorTextArea"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 12, 5, 11);
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.messagePanel, gridBagConstraints);
        if (bl) {
            jComponent = new JLabel();
            ((JLabel)jComponent).setText(this.bundle.getString("LBL_RequiredMessage"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(6, 12, 11, 5);
            gridBagConstraints.anchor = 16;
            this.buttonPanel.add((Component)jComponent, gridBagConstraints);
        }
        this.okButton = new JButton(this.bundle.getString("LBL_OK"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 11, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputDialog.this.chosenOption = 1;
                InputDialog.this.actionOk();
            }
        });
        this.okButton.getAccessibleContext().setAccessibleName(this.bundle.getString("ACSN_OK"));
        this.okButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_OK"));
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        jComponent = new JButton(this.bundle.getString("LBL_Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 0, 11, 5);
        gridBagConstraints.anchor = 13;
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputDialog.this.chosenOption = 0;
                InputDialog.this.actionCancel();
            }
        });
        ((JButton)jComponent).getAccessibleContext().setAccessibleName(this.bundle.getString("ACSN_Cancel"));
        ((JButton)jComponent).getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_Cancel"));
        this.buttonPanel.add((Component)jComponent, gridBagConstraints);
        this.helpButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.helpButton, (String)this.bundle.getString("LBL_Help"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(6, 0, 11, 11);
        gridBagConstraints.anchor = 13;
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputDialog.this.chosenOption = 2;
                InputDialog.this.actionHelp();
            }
        });
        this.helpButton.getAccessibleContext().setAccessibleName(this.bundle.getString("ACSN_Help"));
        this.helpButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_Help"));
        this.buttonPanel.add((Component)this.helpButton, gridBagConstraints);
        this.getContentPane().add((Component)this.buttonPanel, object);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public int display() {
        this.setVisible(true);
        return this.chosenOption;
    }

    protected void actionOk() {
        super.dispose();
    }

    protected void actionCancel() {
        super.dispose();
    }

    protected void actionHelp() {
        Utils.invokeHelp(this.getHelpId());
    }

    protected abstract String getHelpId();

    public static Frame getFrame(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    protected void setLocationInside(JPanel jPanel) {
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Rectangle rectangle2 = jPanel.getBounds();
        if (n > rectangle2.width || n2 > rectangle2.height) {
            this.setLocationRelativeTo(jPanel);
        } else {
            Point point = jPanel.getLocationOnScreen();
            this.setLocation(point.x + (rectangle2.width - n) / 2, point.y + (rectangle2.height - n2) / 2);
        }
    }

    protected void setOkEnabled(boolean bl) {
        this.okButton.setEnabled(bl);
    }

    public void showErrors() {
        GridBagConstraints gridBagConstraints;
        JLabel jLabel;
        String string;
        Iterator iterator;
        boolean bl = false;
        boolean bl2 = false;
        this.messagePanel.removeAll();
        if (this.warningList != null && this.warningList.size() > 0) {
            bl2 = true;
            iterator = this.warningList.iterator();
            while (iterator.hasNext()) {
                string = iterator.next().toString();
                jLabel = new JLabel();
                jLabel.setIcon(BaseCustomizer.warningMessageIcon);
                jLabel.setText("<html>" + string + "</html>");
                jLabel.getAccessibleContext().setAccessibleName(this.bundle.getString("ASCN_WarningMessage"));
                jLabel.getAccessibleContext().setAccessibleDescription(string);
                jLabel.setForeground(BaseCustomizer.getWarningForegroundColor());
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                this.messagePanel.add((Component)jLabel, gridBagConstraints);
            }
        }
        if (this.errorList != null && this.errorList.size() > 0) {
            bl = true;
            iterator = this.errorList.iterator();
            while (iterator.hasNext()) {
                string = iterator.next().toString();
                jLabel = new JLabel();
                jLabel.setIcon(BaseCustomizer.errorMessageIcon);
                jLabel.setText("<html>" + string + "</html>");
                jLabel.getAccessibleContext().setAccessibleName(this.bundle.getString("ASCN_ErrorMessage"));
                jLabel.getAccessibleContext().setAccessibleDescription(string);
                jLabel.setForeground(BaseCustomizer.getErrorForegroundColor());
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                this.messagePanel.add((Component)jLabel, gridBagConstraints);
            }
        }
        this.pack();
        this.setOkEnabled(!bl);
    }

    protected void setErrors(Collection collection, Collection collection2) {
        this.warningList = new ArrayList(collection2);
        this.errorList = new ArrayList(collection);
        this.showErrors();
    }

    protected void setErrors(Collection collection) {
        this.setErrors(collection, Collections.EMPTY_LIST);
    }

    public void addWarning(String string) {
        if (this.warningList == null) {
            this.warningList = new ArrayList();
        }
        this.warningList.add(string);
        this.showErrors();
    }

    protected void addWarnings(Collection collection) {
        if (this.warningList == null) {
            this.warningList = new ArrayList(collection);
        } else {
            this.warningList.addAll(collection);
        }
        this.showErrors();
    }

    public void addError(String string) {
        if (this.errorList == null) {
            this.errorList = new ArrayList();
        }
        this.errorList.add(string);
        this.showErrors();
    }

    protected void addErrors(Collection collection) {
        if (this.errorList == null) {
            this.errorList = new ArrayList(collection);
        } else {
            this.errorList.addAll(collection);
        }
        this.showErrors();
    }

    protected void clearErrors() {
        this.warningList = null;
        this.errorList = null;
        this.showErrors();
    }

    public boolean hasErrors() {
        boolean bl = false;
        if (this.errorList != null && this.errorList.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getHelpId());
    }

    protected void setButtonPanelPreferredSize(Dimension dimension) {
        this.buttonPanel.setMinimumSize(dimension);
        this.buttonPanel.setPreferredSize(dimension);
    }
}

