/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.ErrorMessageDB;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.CustomizerErrorPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.CustomizerTitlePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;

public abstract class BaseCustomizer
extends JPanel
implements Customizer,
HelpCtx.Provider,
CustomizerErrorPanel.ErrorClient {
    protected final ResourceBundle commonBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private static final String errorGlyphPath = "org/netbeans/modules/j2ee/sun/share/configbean/customizers/common/resources/errorGlyph.gif";
    public static ImageIcon panelErrorIcon;
    private static final String errorIconPath = "org/netbeans/modules/j2ee/sun/share/configbean/customizers/common/resources/errorIcon.png";
    private static final String warningIconPath = "org/netbeans/modules/j2ee/sun/share/configbean/customizers/common/resources/warningIcon.png";
    public static ImageIcon errorMessageIcon;
    public static ImageIcon warningMessageIcon;
    private static final Object colorMonitor;
    private static Color errorTextForegroundColor;
    private static Color warningTextForegroundColor;
    private Base theBaseBean;
    private CustomizerTitlePanel titlePanel;
    private CustomizerErrorPanel errorPanel;
    protected PropertyChangeListener validationListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("validationStateChanged".equals(propertyChangeEvent.getPropertyName())) {
                BaseCustomizer.this.validationStateChanged((Boolean)propertyChangeEvent.getNewValue());
            } else if ("partitionStateChanged".equals(propertyChangeEvent.getPropertyName())) {
                BaseCustomizer.this.partitionStateChanged((ErrorMessageDB.PartitionState)propertyChangeEvent.getOldValue(), (ErrorMessageDB.PartitionState)propertyChangeEvent.getNewValue());
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getErrorForegroundColor() {
        Color color = null;
        Object object = colorMonitor;
        synchronized (object) {
            if (errorTextForegroundColor == null && (errorTextForegroundColor = UIManager.getColor("nb.errorForeground")) == null) {
                errorTextForegroundColor = new Color(89, 79, 191);
            }
            color = errorTextForegroundColor;
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getWarningForegroundColor() {
        Color color = null;
        Object object = colorMonitor;
        synchronized (object) {
            if (warningTextForegroundColor == null && (warningTextForegroundColor = UIManager.getColor("Label.foreground")) == null) {
                warningTextForegroundColor = new Color(0, 0, 0);
            }
            color = warningTextForegroundColor;
        }
        return color;
    }

    public BaseCustomizer() {
        this.titlePanel = new CustomizerTitlePanel();
        this.errorPanel = new CustomizerErrorPanel(this);
    }

    protected void addTitlePanel(String string) {
        this.titlePanel.setCustomizerTitle(string);
        this.add(this.titlePanel, this.titlePanel.getConstraints(), 0);
    }

    public CustomizerTitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    protected void addErrorPanel() {
        this.add((Component)this.errorPanel, this.errorPanel.getConstraints());
    }

    public CustomizerErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    public void setObject(Object object) {
        if (this.theBaseBean != object) {
            if (this.theBaseBean != null) {
                this.removeListeners();
            }
            if (this.setBean(object)) {
                assert (this.theBaseBean != null) : "Derived class failed to call super.setBean() in their implementation";
                this.initFields();
                this.addListeners();
                this.validateBean();
            }
        }
    }

    protected boolean setBean(Object object) {
        boolean bl = false;
        if (object instanceof Base) {
            this.theBaseBean = (Base)object;
            bl = true;
        } else {
            this.theBaseBean = null;
        }
        return bl;
    }

    Base getBean() {
        return this.theBaseBean;
    }

    protected abstract void initFields();

    protected void addListeners() {
        ErrorMessageDB.getMessageDB(this.theBaseBean).addPropertyChangeListener(this.validationListener);
    }

    protected void removeListeners() {
        ErrorMessageDB.getMessageDB(this.theBaseBean).removePropertyChangeListener(this.validationListener);
    }

    public void validationStateChanged(Boolean bl) {
    }

    public void partitionStateChanged(ErrorMessageDB.PartitionState partitionState, ErrorMessageDB.PartitionState partitionState2) {
        this.showErrors();
    }

    public boolean validateBean() {
        return this.theBaseBean.validateFields(false);
    }

    public boolean validateField(String string) {
        return this.theBaseBean.validateField(string);
    }

    public void showErrors() {
        this.errorPanel.showErrors(this.theBaseBean);
    }

    public abstract String getHelpId();

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getHelpId());
    }

    public static int getComponentIndex(Container container, Component component) {
        int n = -1;
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] != component) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public Color getErrorMessageForegroundColor() {
        return BaseCustomizer.getErrorForegroundColor();
    }

    public ValidationError.Partition getPartition() {
        return ValidationError.PARTITION_GLOBAL;
    }

    public ValidationError.Partition getGlobalPartition() {
        return null;
    }

    static {
        try {
            panelErrorIcon = new ImageIcon(Utils.getResourceURL(errorGlyphPath, BaseCustomizer.class));
        }
        catch (NullPointerException nullPointerException) {
            ErrorManager.getDefault().notify(1, (Throwable)nullPointerException);
            panelErrorIcon = null;
        }
        try {
            errorMessageIcon = new ImageIcon(Utils.getResourceURL(errorIconPath, InputDialog.class));
        }
        catch (NullPointerException nullPointerException) {
            ErrorManager.getDefault().notify(1, (Throwable)nullPointerException);
            errorMessageIcon = null;
        }
        try {
            warningMessageIcon = new ImageIcon(Utils.getResourceURL(warningIconPath, InputDialog.class));
        }
        catch (NullPointerException nullPointerException) {
            ErrorManager.getDefault().notify(1, (Throwable)nullPointerException);
            warningMessageIcon = null;
        }
        colorMonitor = new Object();
        errorTextForegroundColor = null;
        warningTextForegroundColor = null;
    }
}

