/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.beans.PropertyVetoException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.app.SunApplication;
import org.netbeans.modules.j2ee.sun.dd.api.app.Web;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseModuleRef;
import org.netbeans.modules.j2ee.sun.share.configbean.ConfigFinder;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;

public class WebAppRef
extends BaseModuleRef {
    private DDBean contextRootDD = null;
    private String contextRoot;

    protected void init(DDBean dDBean, Base base) throws ConfigurationException {
        super.init(dDBean, base);
        this.contextRootDD = this.getNameDD("context-root");
        this.loadFromPlanFile(this.getConfig());
    }

    protected void initModuleUri(DDBean dDBean) {
        DDBean[] dDBeanArray = dDBean.getChildBean("web-uri");
        if (dDBeanArray.length > 0) {
            this.setModuleUri(dDBeanArray[0]);
        } else {
            this.setModuleUri(null);
        }
    }

    public String getTitleFragment() {
        return this.bundle.getString("LBL_WebTitleFragment");
    }

    public String getWebUri() {
        return this.getModuleUri();
    }

    public String getContextRoot() {
        String string = null;
        string = this.contextRoot == null || this.contextRoot.length() == 0 && this.contextRootDD != null ? this.contextRootDD.getText() : this.contextRoot;
        return string;
    }

    public void setContextRoot(String string) throws PropertyVetoException {
        CharSequence charSequence;
        if (string != null) {
            string = string.replace(' ', '_');
        }
        if (string != null) {
            try {
                charSequence = new StringBuilder(string.length() + 25);
                String[] stringArray = string.split("/");
                for (int i = 0; i < stringArray.length; ++i) {
                    ((StringBuilder)charSequence).append(URLEncoder.encode(stringArray[i], "UTF-8"));
                    if (i == stringArray.length - 1) continue;
                    ((StringBuilder)charSequence).append('/');
                }
                string = ((StringBuilder)charSequence).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        charSequence = this.contextRoot;
        this.getVCS().fireVetoableChange("contextRoot", charSequence, string);
        this.contextRoot = string;
        this.getPCS().firePropertyChange("contextRoot", charSequence, this.contextRoot);
    }

    public String getHelpId() {
        return "AS_CFG_WebAppRef";
    }

    Collection getSnippets() {
        ArrayList<1> arrayList = new ArrayList<1>();
        Base.DefaultSnippet defaultSnippet = new Base.DefaultSnippet(){

            public CommonDDBean getDDSnippet() {
                Web web = WebAppRef.this.getConfig().getStorageFactory().createWeb();
                web.setWebUri(WebAppRef.this.getWebUri());
                web.setContextRoot(WebAppRef.this.getContextRoot());
                return web;
            }

            public boolean hasDDSnippet() {
                return Utils.notEmpty(WebAppRef.this.contextRoot);
            }

            public String getPropertyName() {
                return "Web";
            }
        };
        arrayList.add(defaultSnippet);
        return arrayList;
    }

    boolean loadFromPlanFile(SunONEDeploymentConfiguration sunONEDeploymentConfiguration) {
        String string = this.getUriText();
        Web web = (Web)sunONEDeploymentConfiguration.getBeans(string, this.constructFileName(), this.getParser(), new WebAppRefFinder());
        this.clearProperties();
        if (web != null) {
            String string2 = web.getContextRoot();
            if (Utils.notEmpty(string2) && string2.compareTo(this.getContextRoot()) != 0) {
                this.contextRoot = string2;
            }
        } else {
            this.setDefaultProperties();
        }
        return web != null;
    }

    protected void clearProperties() {
        this.contextRoot = null;
    }

    protected void setDefaultProperties() {
    }

    private class WebAppRefFinder
    implements ConfigFinder {
        private WebAppRefFinder() {
        }

        public Object find(Object object) {
            Web web = null;
            String string = WebAppRef.this.getWebUri();
            if (object instanceof SunApplication && string != null) {
                SunApplication sunApplication = (SunApplication)object;
                Web[] webArray = sunApplication.getWeb();
                for (int i = 0; i < webArray.length; ++i) {
                    if (string.compareTo(webArray[i].getWebUri()) != 0) continue;
                    web = webArray[i];
                    break;
                }
            }
            return web;
        }
    }
}

