/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.web.Cache;
import org.netbeans.modules.j2ee.sun.dd.api.web.CacheHelper;
import org.netbeans.modules.j2ee.sun.dd.api.web.CacheMapping;
import org.netbeans.modules.j2ee.sun.dd.api.web.DefaultHelper;
import org.netbeans.modules.j2ee.sun.dd.api.web.SunWebApp;
import org.netbeans.modules.j2ee.sun.dd.api.web.WebProperty;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.ConfigFinder;
import org.netbeans.modules.j2ee.sun.share.configbean.ErrorMessageDB;
import org.netbeans.modules.j2ee.sun.share.configbean.Snippet;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.schema2beans.BaseBean;

public class WebAppCache {
    private final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.Bundle");
    private static final String SunWebFileName = "sun-web.xml";
    private WebAppRoot webAppRoot;
    private String cacheMaxEntries;
    private String timeoutInSeconds;
    private String cacheEnabled;
    private List properties;
    private DefaultHelper defaultHelper;
    private List cacheHelpers;
    private List cacheMappings;
    private Boolean isValid = null;
    protected List validationFieldList = new ArrayList();
    public static final String FIELD_CACHE_MAX_ENTRIES = ":max-entries";
    public static final String FIELD_CACHE_TIMEOUT = ":timeout";

    protected void init(WebAppRoot webAppRoot) {
        this.webAppRoot = webAppRoot;
    }

    public Base getParent() {
        return this.webAppRoot;
    }

    protected void updateValidationFieldList() {
        this.validationFieldList.add(FIELD_CACHE_MAX_ENTRIES);
        this.validationFieldList.add(FIELD_CACHE_TIMEOUT);
    }

    public void validationStateChanged(Boolean bl) {
        this.isValid = bl;
    }

    public boolean isValid() {
        if (this.isValid == null) {
            boolean bl = this.validateFields(true);
            this.isValid = bl;
        }
        return this.isValid;
    }

    public boolean validateFields(boolean bl) {
        ErrorMessageDB errorMessageDB = this.webAppRoot.getMessageDB();
        boolean bl2 = true;
        errorMessageDB.clearErrors();
        Iterator iterator = this.validationFieldList.iterator();
        while (iterator.hasNext() && (bl2 || !bl)) {
            boolean bl3 = this.validateField((String)iterator.next());
            bl2 = bl2 && bl3;
        }
        return bl2;
    }

    public boolean validateField(String string) {
        ValidationError validationError = null;
        if (string.equals(FIELD_CACHE_MAX_ENTRIES)) {
            String string2 = this.getAbsoluteXpath(string);
            if (Utils.notEmpty(this.cacheMaxEntries)) {
                try {
                    int n = Integer.parseInt(this.cacheMaxEntries);
                    if (n < 0) {
                        Object[] objectArray = new Object[]{this.cacheMaxEntries, "0"};
                        String string3 = MessageFormat.format(this.bundle.getString("ERR_NumberTooLow"), objectArray);
                        validationError = ValidationError.getValidationError(ValidationError.PARTITION_CACHE_GENERAL, string2, string3);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Object[] objectArray = new Object[]{this.cacheMaxEntries};
                    String string4 = MessageFormat.format(this.bundle.getString("ERR_NumberInvalid"), objectArray);
                    validationError = ValidationError.getValidationError(ValidationError.PARTITION_CACHE_GENERAL, string2, string4);
                }
            }
            if (validationError == null) {
                validationError = ValidationError.getValidationErrorMask(ValidationError.PARTITION_CACHE_GENERAL, string2);
            }
        } else if (string.equals(FIELD_CACHE_TIMEOUT)) {
            String string5 = this.getAbsoluteXpath(string);
            if (Utils.notEmpty(this.timeoutInSeconds)) {
                try {
                    int n = Integer.parseInt(this.timeoutInSeconds);
                    if (n < -1) {
                        Object[] objectArray = new Object[]{this.timeoutInSeconds, "-1"};
                        String string6 = MessageFormat.format(this.bundle.getString("ERR_NumberTooLow"), objectArray);
                        validationError = ValidationError.getValidationError(ValidationError.PARTITION_CACHE_GENERAL, string5, string6);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Object[] objectArray = new Object[]{this.timeoutInSeconds};
                    String string7 = MessageFormat.format(this.bundle.getString("ERR_NumberInvalid"), objectArray);
                    validationError = ValidationError.getValidationError(ValidationError.PARTITION_CACHE_GENERAL, string5, string7);
                }
            }
            if (validationError == null) {
                validationError = ValidationError.getValidationErrorMask(ValidationError.PARTITION_CACHE_GENERAL, string5);
            }
        }
        if (validationError != null) {
            this.webAppRoot.getMessageDB().updateError(validationError);
        }
        return validationError == null || !Utils.notEmpty(validationError.getMessage());
    }

    protected String getAbsoluteXpath(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        stringBuffer.append("/sun-web-app/cache/");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String getCacheMaxEntries() {
        return this.cacheMaxEntries;
    }

    public void setCacheMaxEntries(String string) throws PropertyVetoException {
        if (string == null || string.length() == 0) {
            string = null;
        }
        String string2 = this.cacheMaxEntries;
        this.getVCS().fireVetoableChange("cacheMaxEntries", string2, string);
        this.cacheMaxEntries = string;
        this.getPCS().firePropertyChange("cacheMaxEntries", string2, this.cacheMaxEntries);
    }

    public String getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public void setTimeoutInSeconds(String string) throws PropertyVetoException {
        if (string == null || string.length() == 0) {
            string = null;
        }
        String string2 = this.timeoutInSeconds;
        this.getVCS().fireVetoableChange("timeoutInSeconds", string2, string);
        this.timeoutInSeconds = string;
        this.getPCS().firePropertyChange("timeoutInSeconds", string2, this.timeoutInSeconds);
    }

    public String getCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(String string) throws PropertyVetoException {
        String string2 = this.cacheEnabled;
        Boolean bl = Boolean.valueOf(string2);
        Boolean bl2 = Boolean.valueOf(string);
        this.getVCS().fireVetoableChange("cacheEnabled", bl, bl2);
        this.cacheEnabled = string;
        this.getPCS().firePropertyChange("cacheEnabled", bl, bl2);
    }

    public List getProperties() {
        return this.properties;
    }

    public WebProperty getProperty(int n) {
        return (WebProperty)this.properties.get(n);
    }

    public void setProperties(List list) throws PropertyVetoException {
        List list2 = this.properties;
        this.getVCS().fireVetoableChange("properties", list2, list);
        this.properties = list;
        this.getPCS().firePropertyChange("properties", list2, this.properties);
    }

    public void addProperty(WebProperty webProperty) throws PropertyVetoException {
        this.getVCS().fireVetoableChange("property", null, webProperty);
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(webProperty);
        this.getPCS().firePropertyChange("property", null, webProperty);
    }

    public void removeProperty(WebProperty webProperty) throws PropertyVetoException {
        this.getVCS().fireVetoableChange("property", webProperty, null);
        this.properties.remove(webProperty);
        this.getPCS().firePropertyChange("property", webProperty, null);
    }

    public DefaultHelper getDefaultHelper() {
        return this.defaultHelper;
    }

    public void setDefaultHelper(DefaultHelper defaultHelper) throws PropertyVetoException {
        if (defaultHelper == null) {
            defaultHelper = this.webAppRoot.getConfig().getStorageFactory().createDefaultHelper();
        }
        DefaultHelper defaultHelper2 = this.defaultHelper;
        this.getVCS().fireVetoableChange("defaultHelper", defaultHelper2, defaultHelper);
        this.defaultHelper = defaultHelper;
        this.getPCS().firePropertyChange("defaultHelper", defaultHelper2, this.defaultHelper);
    }

    public List getCacheHelpers() {
        return this.cacheHelpers;
    }

    public CacheHelper getCacheHelper(int n) {
        return (CacheHelper)this.cacheHelpers.get(n);
    }

    public void setCacheHelpers(List list) throws PropertyVetoException {
        List list2 = this.cacheHelpers;
        this.getVCS().fireVetoableChange("cacheHelpers", list2, list);
        this.cacheHelpers = list;
        this.getPCS().firePropertyChange("cacheHelpers", list2, this.cacheHelpers);
    }

    public void addProperty(CacheHelper cacheHelper) throws PropertyVetoException {
        this.getVCS().fireVetoableChange("cacheHelper", null, cacheHelper);
        if (this.cacheHelpers == null) {
            this.cacheHelpers = new ArrayList();
        }
        this.cacheHelpers.add(cacheHelper);
        this.getPCS().firePropertyChange("cacheHelper", null, cacheHelper);
    }

    public void removeProperty(CacheHelper cacheHelper) throws PropertyVetoException {
        this.getVCS().fireVetoableChange("cacheHelper", cacheHelper, null);
        this.cacheHelpers.remove(cacheHelper);
        this.getPCS().firePropertyChange("cacheHelper", cacheHelper, null);
    }

    public List getCacheMappings() {
        return this.cacheMappings;
    }

    public CacheMapping getCacheMapping(int n) {
        return (CacheMapping)this.cacheMappings.get(n);
    }

    public void setCacheMappings(List list) throws PropertyVetoException {
        List list2 = this.cacheMappings;
        this.getVCS().fireVetoableChange("cacheMappings", list2, list);
        this.cacheMappings = list;
        this.getPCS().firePropertyChange("cacheMappings", list2, this.cacheMappings);
    }

    public void addCacheMapping(CacheMapping cacheMapping) throws PropertyVetoException {
        this.getVCS().fireVetoableChange("cacheMapping", null, cacheMapping);
        if (this.cacheMappings == null) {
            this.cacheMappings = new ArrayList();
        }
        this.cacheMappings.add(cacheMapping);
        this.getPCS().firePropertyChange("cacheMapping", null, cacheMapping);
    }

    public void removeCacheMapping(CacheMapping cacheMapping) throws PropertyVetoException {
        this.getVCS().fireVetoableChange("cacheMapping", cacheMapping, null);
        this.cacheMappings.remove(cacheMapping);
        this.getPCS().firePropertyChange("cacheMapping", cacheMapping, null);
    }

    Collection getSnippets() {
        ArrayList<1> arrayList = new ArrayList<1>();
        Snippet snippet = new Snippet(){

            public BaseBean getCmpDDSnippet() {
                return null;
            }

            public CommonDDBean getDDSnippet() {
                CacheMapping[] cacheMappingArray;
                WebProperty[] webPropertyArray;
                DefaultHelper defaultHelper;
                CacheHelper[] cacheHelperArray;
                Cache cache = WebAppCache.this.webAppRoot.getConfig().getStorageFactory().createCache_NoDefaults();
                String string = WebAppCache.this.webAppRoot.getAppServerVersion().getWebAppVersionAsString();
                if (WebAppCache.this.cacheMaxEntries != null) {
                    cache.setMaxEntries(WebAppCache.this.cacheMaxEntries);
                }
                if (WebAppCache.this.timeoutInSeconds != null) {
                    cache.setTimeoutInSeconds(WebAppCache.this.timeoutInSeconds);
                }
                if (WebAppCache.this.cacheEnabled != null) {
                    cache.setEnabled(WebAppCache.this.cacheEnabled);
                }
                if ((cacheHelperArray = (CacheHelper[])Utils.listToArray(WebAppCache.this.getCacheHelpers(), CacheHelper.class, string)) != null) {
                    cache.setCacheHelper(cacheHelperArray);
                }
                if ((defaultHelper = WebAppCache.this.getDefaultHelper()).sizeWebProperty() > 0) {
                    cache.setDefaultHelper((DefaultHelper)defaultHelper.cloneVersion(string));
                }
                if ((webPropertyArray = (WebProperty[])Utils.listToArray(WebAppCache.this.getProperties(), WebProperty.class, string)) != null) {
                    cache.setWebProperty(webPropertyArray);
                }
                if ((cacheMappingArray = (CacheMapping[])Utils.listToArray(WebAppCache.this.getCacheMappings(), CacheMapping.class, string)) != null) {
                    cache.setCacheMapping(cacheMappingArray);
                }
                return cache;
            }

            public boolean hasDDSnippet() {
                if (WebAppCache.this.getCacheMaxEntries() != null) {
                    return true;
                }
                if (WebAppCache.this.getTimeoutInSeconds() != null) {
                    return true;
                }
                if (WebAppCache.this.getCacheEnabled() != null) {
                    return true;
                }
                List list = WebAppCache.this.getCacheHelpers();
                if (list != null && list.size() > 0) {
                    return true;
                }
                DefaultHelper defaultHelper = WebAppCache.this.getDefaultHelper();
                if (defaultHelper.sizeWebProperty() > 0) {
                    return true;
                }
                List list2 = WebAppCache.this.getProperties();
                if (list2 != null && list2.size() > 0) {
                    return true;
                }
                List list3 = WebAppCache.this.getCacheMappings();
                return list3 != null && list3.size() > 0;
            }

            public String getPropertyName() {
                return "Cache";
            }

            public String getFileName() {
                return WebAppCache.SunWebFileName;
            }

            public CommonDDBean mergeIntoRootDD(CommonDDBean commonDDBean) {
                Cache cache = (Cache)this.getDDSnippet();
                if (commonDDBean instanceof SunWebApp) {
                    SunWebApp sunWebApp = (SunWebApp)commonDDBean;
                    sunWebApp.setCache(cache);
                }
                return cache;
            }

            public CommonDDBean mergeIntoRovingDD(CommonDDBean commonDDBean) {
                return this.mergeIntoRootDD(commonDDBean);
            }
        };
        arrayList.add(snippet);
        return arrayList;
    }

    boolean loadFromPlanFile(SunONEDeploymentConfiguration sunONEDeploymentConfiguration) {
        String string = this.webAppRoot.getUriText();
        Cache cache = (Cache)sunONEDeploymentConfiguration.getBeans(string, SunWebFileName, this.webAppRoot.getParser(), new CacheFinder());
        this.clearProperties();
        if (null != cache) {
            this.cacheMaxEntries = cache.getMaxEntries();
            this.timeoutInSeconds = cache.getTimeoutInSeconds();
            this.cacheEnabled = cache.getEnabled();
            this.cacheHelpers = Utils.arrayToList((CommonDDBean[])cache.getCacheHelper());
            DefaultHelper defaultHelper = cache.getDefaultHelper();
            if (defaultHelper != null && defaultHelper.sizeWebProperty() > 0) {
                this.defaultHelper = (DefaultHelper)defaultHelper.clone();
            }
            this.properties = Utils.arrayToList((CommonDDBean[])cache.getWebProperty());
            this.cacheMappings = Utils.arrayToList((CommonDDBean[])cache.getCacheMapping());
        } else {
            this.setDefaultProperties();
        }
        return cache != null;
    }

    protected void clearProperties() {
        this.cacheMaxEntries = null;
        this.timeoutInSeconds = null;
        this.cacheEnabled = null;
        this.cacheHelpers = null;
        this.defaultHelper = this.webAppRoot.getConfig().getStorageFactory().createDefaultHelper();
        this.properties = null;
        this.cacheMappings = null;
    }

    protected void setDefaultProperties() {
    }

    protected PropertyChangeSupport getPCS() {
        return this.webAppRoot.getPCS();
    }

    protected VetoableChangeSupport getVCS() {
        return this.webAppRoot.getVCS();
    }

    private static class CacheFinder
    implements ConfigFinder {
        private CacheFinder() {
        }

        public Object find(Object object) {
            Cache cache = null;
            if (object instanceof SunWebApp) {
                SunWebApp sunWebApp = (SunWebApp)object;
                cache = sunWebApp.getCache();
            }
            return cache;
        }
    }
}

