/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;

public final class ErrorMessageDB {
    private Map errorSets = new HashMap(19);
    public static final String VALIDATION_STATE_CHANGED = "validationStateChanged";
    public static final String PARTITION_STATE_CHANGED = "partitionStateChanged";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private ErrorMessageDB() {
    }

    public Set getErrorPartitions() {
        return Collections.unmodifiableSet(this.errorSets.keySet());
    }

    public List getErrors(ValidationError.Partition partition) {
        List list = (List)this.errorSets.get(partition);
        if (list != null) {
            list = Collections.unmodifiableList(list);
        }
        return list;
    }

    public void addErrors(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addErrorImpl((ValidationError)iterator.next());
        }
    }

    public void addError(ValidationError validationError) {
        this.addErrorImpl(validationError);
    }

    public void removeError(ValidationError validationError) {
        List list = (List)this.errorSets.get(validationError.getPartition());
        if (list != null) {
            int n = list.indexOf(validationError);
            if (n != -1) {
                list.remove(n);
                this.firePartitionStateChanged(validationError.getPartition(), true, list.size() != 0);
            }
            if (list.size() == 0) {
                this.errorSets.remove(validationError.getPartition());
                if (this.errorSets.size() == 0) {
                    this.fireValidationStateChanged(true);
                }
            }
        }
    }

    public void updateError(ValidationError validationError) {
        if (Utils.notEmpty(validationError.getMessage())) {
            this.addErrorImpl(validationError);
        } else {
            this.removeError(validationError);
        }
    }

    private void addErrorImpl(ValidationError validationError) {
        boolean bl;
        boolean bl2 = this.errorSets.size() == 0;
        List list = this.getOrCreateErrorList(validationError.getPartition());
        boolean bl3 = bl = list.size() != 0;
        if (list.contains(validationError)) {
            list.remove(validationError);
        }
        list.add(validationError);
        if (bl2) {
            this.fireValidationStateChanged(false);
        }
        this.firePartitionStateChanged(validationError.getPartition(), bl, true);
    }

    private List getOrCreateErrorList(ValidationError.Partition partition) {
        ArrayList arrayList = (ArrayList)this.errorSets.get(partition);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.errorSets.put(partition, arrayList);
        }
        return arrayList;
    }

    public void clearErrors() {
        int n = this.errorSets.size();
        if (n > 0) {
            ArrayList arrayList = new ArrayList(this.errorSets.keySet());
            this.errorSets.clear();
            this.fireValidationStateChanged(true);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.firePartitionStateChanged((ValidationError.Partition)iterator.next(), true, false);
            }
        }
    }

    public boolean hasErrors() {
        return this.errorSets.size() > 0;
    }

    public boolean hasErrors(ValidationError.Partition partition) {
        boolean bl = false;
        List list = (List)this.errorSets.get(partition);
        if (list != null && list.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireValidationStateChanged(boolean bl) {
        this.propertyChangeSupport.firePropertyChange(VALIDATION_STATE_CHANGED, !bl, bl);
    }

    private void firePartitionStateChanged(ValidationError.Partition partition, boolean bl, boolean bl2) {
        PartitionState partitionState = new PartitionState(partition, bl);
        PartitionState partitionState2 = new PartitionState(partition, bl2);
        this.propertyChangeSupport.firePropertyChange(PARTITION_STATE_CHANGED, partitionState, partitionState2);
    }

    public static ErrorMessageDB getMessageDB(Base base) {
        ErrorMessageDB errorMessageDB = null;
        if (base != null) {
            errorMessageDB = base.getMessageDB();
        }
        return errorMessageDB;
    }

    static ErrorMessageDB createMessageDB() {
        return new ErrorMessageDB();
    }

    public static class PartitionState {
        private final ValidationError.Partition thePartition;
        private final boolean hasMessages;

        private PartitionState(ValidationError.Partition partition, boolean bl) {
            this.thePartition = partition;
            this.hasMessages = bl;
        }

        public ValidationError.Partition getPartition() {
            return this.thePartition;
        }

        public boolean hasMessages() {
            return this.hasMessages;
        }
    }
}

