/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.xml.cookies.CheckXMLCookie;
import org.netbeans.api.xml.cookies.ValidateXMLCookie;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.sun.share.config.ConfigDataNode;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationSaver;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.SecondaryConfigDataObject;
import org.netbeans.modules.j2ee.sun.share.config.Utils;
import org.netbeans.modules.j2ee.sun.share.config.ui.ConfigBeanTopComponent;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigDataObject
extends XMLDataObject
implements ConfigurationSaver,
FileChangeListener {
    public static final String SERVER_ID = "J2EE";
    private final File configKey;
    private HashSet secondaries = null;
    private boolean isEdited = false;
    private boolean isEditedChecked = false;
    private ValidateXMLCookie validateCookie = null;
    private CheckXMLCookie checkCookie = null;
    private XMLEditorSupport xmlEditorSupport = null;
    private XMLOpenSupport xmlOpenSupport = null;
    private boolean reloadDialogOpened;

    public ConfigDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.configKey = FileUtil.toFile((FileObject)fileObject);
        fileObject.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this), (Object)fileObject));
        this.initCookies();
    }

    private void initCookies() {
        CookieSet.Factory factory = new CookieSet.Factory(){

            public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
                return null;
            }
        };
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add(EditorCookie.class, factory);
        cookieSet.add(OpenCookie.class, factory);
        cookieSet.add(CloseCookie.class, factory);
        cookieSet.add(PrintCookie.class, factory);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getPrimaryFile().getName() + "_help");
    }

    public boolean isRenameAllowed() {
        return false;
    }

    protected Node createNodeDelegate() {
        return new ConfigDataNode(this);
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        DataObject dataObject = super.handleCopy(dataFolder);
        try {
            FileObject fileObject = dataObject.getPrimaryFile();
            dataObject.setValid(false);
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return dataObject;
    }

    public SunONEDeploymentConfiguration getDeploymentConfiguration() throws ConfigurationException {
        SunONEDeploymentConfiguration sunONEDeploymentConfiguration = SunONEDeploymentConfiguration.getConfiguration(this.configKey);
        if (sunONEDeploymentConfiguration == null) {
            FileObject fileObject = FileUtil.toFileObject((File)this.configKey);
            sunONEDeploymentConfiguration = SunONEDeploymentConfiguration.getConfiguration(this.configKey);
            if (sunONEDeploymentConfiguration == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unable to initialize DeploymentConfiguration for " + this.configKey.getPath() + " on server " + SERVER_ID));
            }
        }
        return sunONEDeploymentConfiguration;
    }

    public boolean hasSecondaries() {
        return this.getSecondaries().size() > 0;
    }

    protected void addSecondary(SecondaryConfigDataObject secondaryConfigDataObject) {
        this.getSecondaries().add(secondaryConfigDataObject);
    }

    protected void removeSecondary(SecondaryConfigDataObject secondaryConfigDataObject) {
        this.getSecondaries().remove(secondaryConfigDataObject);
    }

    protected Set getSecondaries() {
        if (this.secondaries != null) {
            return this.secondaries;
        }
        this.secondaries = new HashSet();
        FileObject[] fileObjectArray = this.getProvider().getConfigurationFiles();
        if (fileObjectArray != null) {
            for (int i = 0; i < fileObjectArray.length; ++i) {
                try {
                    SecondaryConfigDataObject secondaryConfigDataObject = (SecondaryConfigDataObject)DataObject.find((FileObject)fileObjectArray[i]);
                    this.secondaries.add(secondaryConfigDataObject);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.secondaries;
    }

    protected boolean isConfigEditorOpened() {
        Boolean bl = (Boolean)Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                ConfigBeanTopComponent configBeanTopComponent = ConfigDataObject.this.findOpenedConfigEditor();
                boolean bl = configBeanTopComponent != null ? configBeanTopComponent.isOpened() : false;
                return bl ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return bl;
    }

    private OpenCookie _getOpenCookie() {
        OpenCookie openCookie = this.getOpenCookie();
        for (SecondaryConfigDataObject secondaryConfigDataObject : this.getSecondaries()) {
            if (secondaryConfigDataObject.getOpenCookie() != null) continue;
            return null;
        }
        return openCookie;
    }

    protected OpenCookie getOpenCookie() {
        if (!Utils.isSunServer(this.getProvider().getServerID())) {
            return null;
        }
        if (!this.isEditedChecked) {
            this.isEdited = this.checkIsEdited();
        }
        if (!this.isEdited) {
            if (this.xmlOpenSupport == null) {
                this.xmlOpenSupport = new XMLOpenSupport(this);
            }
            return this.xmlOpenSupport;
        }
        return null;
    }

    private EditCookie _getEditCookie() {
        EditCookie editCookie = this.getEditCookie();
        for (SecondaryConfigDataObject secondaryConfigDataObject : this.getSecondaries()) {
            if (secondaryConfigDataObject.getEditCookie() != null) continue;
            return null;
        }
        return editCookie;
    }

    protected EditCookie getEditCookie() {
        if (!this.isConfigEditorOpened()) {
            if (this.xmlEditorSupport == null) {
                this.xmlEditorSupport = new XMLEditorSupport(this);
            }
            return this.xmlEditorSupport;
        }
        return null;
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        ConfigurationStorage configurationStorage = null;
        if (OpenCookie.class.isAssignableFrom(clazz)) {
            return (T)this._getOpenCookie();
        }
        if (EditCookie.class.isAssignableFrom(clazz) || EditorCookie.class.isAssignableFrom(clazz) || CloseCookie.class.isAssignableFrom(clazz) || PrintCookie.class.isAssignableFrom(clazz)) {
            return (T)this._getEditCookie();
        }
        if (ConfigurationStorage.class.isAssignableFrom(clazz)) {
            configurationStorage = this.getStorage();
        } else {
            if (ValidateXMLCookie.class.isAssignableFrom(clazz)) {
                if (this.validateCookie == null) {
                    InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
                    this.validateCookie = new ValidateXMLSupport(inputSource);
                }
                return (T)this.validateCookie;
            }
            if (CheckXMLCookie.class.isAssignableFrom(clazz)) {
                if (this.checkCookie == null) {
                    InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
                    this.checkCookie = new CheckXMLSupport(inputSource);
                }
                return (T)this.checkCookie;
            }
        }
        if (configurationStorage == null) {
            configurationStorage = super.getCookie(clazz);
        }
        return (T)configurationStorage;
    }

    private boolean checkIsEdited() {
        if (this.xmlEditorSupport != null) {
            this.isEditedChecked = true;
            return this.xmlEditorSupport.getOpenedPanes() != null;
        }
        return false;
    }

    public void editorClosed(ConfigBeanTopComponent configBeanTopComponent) {
        if (this.xmlOpenSupport != null) {
            this.xmlOpenSupport.reset();
        }
        configBeanTopComponent.reset();
        this.fireCookieChange();
    }

    protected J2eeModuleProvider getProvider() {
        FileObject fileObject = this.getPrimaryFile();
        J2eeModuleProvider j2eeModuleProvider = null;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        }
        if (j2eeModuleProvider == null) {
            throw new RuntimeException("Project " + project + " does not provide J2eeModuleProvider in its lookup");
        }
        return j2eeModuleProvider;
    }

    protected ConfigurationStorage getStorage() {
        ConfigurationStorage configurationStorage = null;
        try {
            SunONEDeploymentConfiguration sunONEDeploymentConfiguration = this.getDeploymentConfiguration();
            if (sunONEDeploymentConfiguration != null) {
                configurationStorage = sunONEDeploymentConfiguration.getStorage();
            }
        }
        catch (ConfigurationException configurationException) {
            ErrorManager.getDefault().notify(1, (Throwable)configurationException);
        }
        return configurationStorage;
    }

    public static FileObject getRelative(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject;
        while (string.startsWith("..")) {
            fileObject2 = fileObject2.getParent();
            if (!(string = string.substring(2)).startsWith("/")) continue;
            string = string.substring(1);
        }
        if (string.length() > 0) {
            fileObject2 = fileObject2.getFileObject(string);
        }
        return fileObject2;
    }

    public static String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        StringBuilder stringBuilder = new StringBuilder(160);
        while (!(FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) && !fileObject.equals(fileObject2) || fileObject.equals(fileObject2))) {
            stringBuilder.append("../");
            fileObject = fileObject.getParent();
        }
        if (!fileObject.equals(fileObject2)) {
            stringBuilder.append(FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2));
        }
        return stringBuilder.toString();
    }

    @Override
    public void resetChanged() {
        this.removeSaveCookie();
    }

    public void removeEditorChanges() {
        if (this.xmlEditorSupport != null) {
            this.xmlEditorSupport.notifyUnmodified();
        }
    }

    public void removeAllEditorChanges() {
        this.removeEditorChanges();
        for (SecondaryConfigDataObject secondaryConfigDataObject : this.getSecondaries()) {
            secondaryConfigDataObject.removeEditorChanges();
        }
    }

    public boolean areModified() {
        if (this.isModified()) {
            return true;
        }
        for (SecondaryConfigDataObject secondaryConfigDataObject : this.getSecondaries()) {
            if (!secondaryConfigDataObject.isModified()) continue;
            return true;
        }
        return false;
    }

    public void resetAllChanged() {
        this.resetChanged();
        for (SecondaryConfigDataObject secondaryConfigDataObject : this.getSecondaries()) {
            secondaryConfigDataObject.resetChanged();
        }
    }

    @Override
    public void setChanged() {
        this.addSaveCookie(new S());
    }

    public boolean isModified() {
        return super.isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReload(FileObject fileObject) throws IOException, InvalidModuleException, ConfigurationException {
        ConfigurationStorage configurationStorage = this.getStorage();
        if (configurationStorage != null && !configurationStorage.saveInProgress()) {
            boolean bl = true;
            boolean bl2 = false;
            if (this.isConfigEditorOpened()) {
                if (this.isModified()) {
                    bl = false;
                    if (!this.reloadDialogOpened) {
                        String string = NbBundle.getMessage(ConfigDataObject.class, (String)"MSG_ExternalChange", (Object)fileObject.getName());
                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
                        this.reloadDialogOpened = true;
                        try {
                            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                            if (NotifyDescriptor.YES_OPTION.equals(object)) {
                                this.resetChanged();
                                this.closeConfigEditors();
                                bl = true;
                                bl2 = true;
                            }
                            bl = false;
                        }
                        finally {
                            this.reloadDialogOpened = false;
                        }
                    }
                } else {
                    this.closeConfigEditors();
                    bl2 = true;
                }
            }
            if (bl) {
                configurationStorage.load();
            }
            if (bl2) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        OpenCookie openCookie = ConfigDataObject.this.getCookie(OpenCookie.class);
                        if (openCookie != null) {
                            openCookie.open();
                        }
                    }
                });
            }
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
        try {
            if (this.isValid() && fileEvent.getFile().equals(this.getPrimaryFile())) {
                this.handleReload(fileEvent.getFile());
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    protected void fireCookieChange() {
        this.fireLimitedCookieChange();
        for (SecondaryConfigDataObject secondaryConfigDataObject : this.getSecondaries()) {
            secondaryConfigDataObject.fireLimitedCookieChange();
        }
    }

    protected void fireLimitedCookieChange() {
        this.firePropertyChange("cookie", null, null);
    }

    protected final void addSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().add((Node.Cookie)saveCookie);
        this.setModified(true);
    }

    protected final void removeSaveCookie() {
        SaveCookie saveCookie = null;
        while ((saveCookie = this.getCookie(SaveCookie.class)) != null) {
            this.getCookieSet().remove((Node.Cookie)saveCookie);
        }
        this.setModified(false);
    }

    protected void openConfigEditor() {
        ConfigurationStorage configurationStorage = this.getStorage();
        ConfigBeanTopComponent configBeanTopComponent = ConfigDataObject.findOpenedConfigEditor(configurationStorage);
        if (configBeanTopComponent == null) {
            configBeanTopComponent = new ConfigBeanTopComponent(configurationStorage);
        }
        configBeanTopComponent.open();
        configBeanTopComponent.requestActive();
        this.fireCookieChange();
    }

    protected ConfigBeanTopComponent findOpenedConfigEditor() {
        return ConfigDataObject.findOpenedConfigEditor(this.getStorage());
    }

    public static ConfigBeanTopComponent findOpenedConfigEditor(final ConfigurationStorage configurationStorage) {
        ConfigBeanTopComponent configBeanTopComponent = (ConfigBeanTopComponent)((Object)Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
                    ConfigBeanTopComponent configBeanTopComponent;
                    if (!(topComponent instanceof ConfigBeanTopComponent) || !(configBeanTopComponent = (ConfigBeanTopComponent)topComponent).isFor(configurationStorage)) continue;
                    return configBeanTopComponent;
                }
                return null;
            }
        }));
        return configBeanTopComponent;
    }

    public boolean closeConfigEditors() {
        Object object2;
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        ConfigurationStorage configurationStorage = this.getStorage();
        for (Object object2 : TopComponent.getRegistry().getOpened()) {
            if (!(object2 instanceof ConfigBeanTopComponent) || !((ConfigBeanTopComponent)((Object)object2)).isFor(configurationStorage)) continue;
            arrayList.add(object2);
        }
        object2 = (Boolean)Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                Boolean bl = Boolean.TRUE;
                for (ConfigBeanTopComponent configBeanTopComponent : arrayList) {
                    bl = configBeanTopComponent.close() && bl != false ? Boolean.TRUE : Boolean.FALSE;
                }
                return bl;
            }
        });
        return (Boolean)object2;
    }

    private static class XMLEditorEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 6593415381104273008L;
        private final Class openSupportCookieClass;

        public XMLEditorEnv(ConfigDataObject configDataObject, Class clazz) {
            super((DataObject)configDataObject);
            this.openSupportCookieClass = clazz;
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((ConfigDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(this.openSupportCookieClass);
        }
    }

    private static class XMLEditorSupport
    extends DataEditorSupport
    implements EditCookie,
    EditorCookie.Observable,
    PrintCookie,
    CloseCookie {
        public XMLEditorSupport(ConfigDataObject configDataObject) {
            super((DataObject)configDataObject, (CloneableEditorSupport.Env)new XMLEditorEnv(configDataObject, EditCookie.class));
            this.setMIMEType("text/xml");
        }

        protected boolean canClose() {
            boolean bl = super.canClose();
            return bl;
        }

        public void saveDocument() throws IOException {
            block4: {
                StyledDocument styledDocument = this.getDocument();
                String string = EncodingUtil.detectEncoding((Document)styledDocument);
                if (string == null) {
                    string = "UTF8";
                }
                try {
                    new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), string);
                    if (this.queryCanEncode(styledDocument, string)) {
                        super.saveDocument();
                        this.getDataObject().setModified(false);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (!this.queryUpdateProlog(styledDocument, string, "UTF8")) break block4;
                    super.saveDocument();
                    this.getDataObject().setModified(false);
                }
            }
        }

        private boolean queryCanEncode(StyledDocument styledDocument, String string) {
            boolean bl = true;
            try {
                CharsetEncoder charsetEncoder = Charset.forName(string).newEncoder();
                if (!charsetEncoder.canEncode(styledDocument.getText(0, styledDocument.getLength()))) {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(XMLEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string}), 0, 2);
                    confirmation.setValue(NotifyDescriptor.NO_OPTION);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                        bl = false;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
            }
            return bl;
        }

        private boolean queryUpdateProlog(final StyledDocument styledDocument, String string, final String string2) {
            boolean bl = false;
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(XMLEditorSupport.class, (String)"MSG_BadEncodingDuringSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string, string2}), 0, 2);
            confirmation.setValue(NotifyDescriptor.NO_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (confirmation.getValue() == NotifyDescriptor.YES_OPTION) {
                try {
                    int n;
                    int n2 = Math.min(1000, styledDocument.getLength());
                    final char[] cArray = styledDocument.getText(0, n2).toCharArray();
                    int n3 = 0;
                    if (cArray[0] == '<' && cArray[1] == '?' && cArray[2] == 'x') {
                        for (n = 3; n < n2; ++n) {
                            if (cArray[n] != '?' || cArray[n + 1] != '>') continue;
                            n3 = n + 1;
                            break;
                        }
                    }
                    n = n3;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            block2: {
                                try {
                                    styledDocument.remove(0, n + 1);
                                    styledDocument.insertString(0, "<?xml version='1.0' encoding='" + string2 + "' ?> \n<!-- was: " + new String(cArray, 0, n + 1) + " -->", null);
                                }
                                catch (BadLocationException badLocationException) {
                                    if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                    badLocationException.printStackTrace();
                                }
                            }
                        }
                    };
                    NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
                    bl = true;
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
            return bl;
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            ((ConfigDataObject)this.getDataObject()).addSaveCookie(new Save());
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            ((ConfigDataObject)this.getDataObject()).resetChanged();
        }

        public void edit() {
            ConfigDataObject configDataObject = (ConfigDataObject)this.getDataObject();
            configDataObject.isEdited = true;
            this.open();
            configDataObject.fireCookieChange();
        }

        protected void notifyClosed() {
            super.notifyClosed();
            ConfigDataObject configDataObject = (ConfigDataObject)this.getDataObject();
            configDataObject.isEdited = false;
            configDataObject.fireCookieChange();
        }

        public void refreshDocument() {
            super.reloadDocument();
        }

        class Save
        implements SaveCookie {
            Save() {
            }

            public void save() throws IOException {
                XMLEditorSupport.this.saveDocument();
            }
        }
    }

    private static class XMLOpenSupport
    extends DataEditorSupport
    implements OpenCookie,
    PropertyChangeListener {
        public XMLOpenSupport(ConfigDataObject configDataObject) {
            super((DataObject)configDataObject, (CloneableEditorSupport.Env)new XMLEditorEnv(configDataObject, OpenCookie.class));
            this.setMIMEType("text/xml");
        }

        public void open() {
            ConfigDataObject configDataObject = (ConfigDataObject)this.getDataObject();
            configDataObject.addPropertyChangeListener(this);
            configDataObject.getPrimaryFile().refresh();
            ConfigurationStorage configurationStorage = configDataObject.getCookie(ConfigurationStorage.class);
            if (configurationStorage == null) {
                EditCookie editCookie = configDataObject.getCookie(EditCookie.class);
                if (editCookie != null) {
                    editCookie.edit();
                }
                return;
            }
            configDataObject.openConfigEditor();
        }

        protected CloneableTopComponent createCloneableTopComponent() {
            ConfigDataObject configDataObject = (ConfigDataObject)this.getDataObject();
            ConfigurationStorage configurationStorage = configDataObject.getCookie(ConfigurationStorage.class);
            return new ConfigBeanTopComponent(configurationStorage);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ConfigDataObject configDataObject;
            if ("modified".equals(propertyChangeEvent.getPropertyName()) && (configDataObject = (ConfigDataObject)this.getDataObject()).isValid()) {
                final ConfigurationStorage configurationStorage = configDataObject.getStorage();
                final String string = this.messageName();
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
                            ConfigBeanTopComponent configBeanTopComponent;
                            if (!(topComponent instanceof ConfigBeanTopComponent) || !(configBeanTopComponent = (ConfigBeanTopComponent)topComponent).isFor(configurationStorage)) continue;
                            configBeanTopComponent.setDisplayName(string);
                        }
                    }
                });
            }
        }

        public void reset() {
            ((ConfigDataObject)this.getDataObject()).removePropertyChangeListener(this);
        }
    }

    private class S
    implements SaveCookie {
        private S() {
        }

        public void save() throws IOException {
            ConfigurationStorage configurationStorage = ConfigDataObject.this.getStorage();
            if (configurationStorage != null) {
                configurationStorage.save();
            }
        }
    }
}

