/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.log.LogBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class LogCommand
extends BasicCommand {
    protected EventManager eventManager;
    private boolean defaultBranch;
    private String dateFilter;
    private boolean headerOnly;
    private boolean noTags;
    private String revisionFilter;
    private String stateFilter;
    private String userFilter;
    private boolean headerAndDescOnly;

    public LogCommand() {
        this.resetCVSCommand();
    }

    public Builder createBuilder(EventManager eventManager) {
        return new LogBuilder(eventManager, this);
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        this.eventManager = eventManager;
        super.execute(clientServices, eventManager);
        try {
            if (this.defaultBranch) {
                this.requests.add(1, new ArgumentRequest("-b"));
            }
            if (this.headerAndDescOnly) {
                this.requests.add(1, new ArgumentRequest("-t"));
            }
            if (this.headerOnly) {
                this.requests.add(1, new ArgumentRequest("-h"));
            }
            if (this.noTags) {
                this.requests.add(1, new ArgumentRequest("-N"));
            }
            if (this.userFilter != null) {
                this.requests.add(1, new ArgumentRequest("-w" + this.userFilter));
            }
            if (this.revisionFilter != null) {
                this.requests.add(1, new ArgumentRequest("-r" + this.revisionFilter));
            }
            if (this.stateFilter != null) {
                this.requests.add(1, new ArgumentRequest("-s" + this.stateFilter));
            }
            if (this.dateFilter != null) {
                this.requests.add(1, new ArgumentRequest("-d" + this.dateFilter));
            }
            this.addRequestForWorkingDirectory(clientServices);
            this.addArgumentRequests();
            this.addRequest(CommandRequest.LOG);
            clientServices.processRequests(this.requests);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
            if (!this.isBuilderSet()) {
                this.builder = null;
            }
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public boolean isDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(boolean bl) {
        this.defaultBranch = bl;
    }

    public String getDateFilter() {
        return this.dateFilter;
    }

    public void setDateFilter(String string) {
        this.dateFilter = string;
    }

    public boolean isHeaderOnly() {
        return this.headerOnly;
    }

    public void setHeaderOnly(boolean bl) {
        this.headerOnly = bl;
    }

    public boolean isNoTags() {
        return this.noTags;
    }

    public void setNoTags(boolean bl) {
        this.noTags = bl;
    }

    public String getRevisionFilter() {
        return this.revisionFilter;
    }

    public void setRevisionFilter(String string) {
        this.revisionFilter = string;
    }

    public String getStateFilter() {
        return this.stateFilter;
    }

    public void setStateFilter(String string) {
        this.stateFilter = string;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String string) {
        this.userFilter = string;
    }

    public boolean isHeaderAndDescOnly() {
        return this.headerAndDescOnly;
    }

    public void setHeaderAndDescOnly(boolean bl) {
        this.headerAndDescOnly = bl;
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("log ");
        stringBuffer.append(this.getCVSArguments());
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                stringBuffer.append(fileArray[i].getName());
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'b') {
            this.setDefaultBranch(true);
        } else if (c == 'h') {
            this.setHeaderOnly(true);
        } else if (c == 't') {
            this.setHeaderAndDescOnly(true);
        } else if (c == 'N') {
            this.setNoTags(true);
        } else if (c == 'd') {
            this.setDateFilter(string);
        } else if (c == 'r') {
            this.setRevisionFilter(string == null ? "" : string);
        } else if (c == 's') {
            this.setStateFilter(string);
        } else if (c == 'w') {
            this.setUserFilter(string == null ? "" : string);
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setDefaultBranch(false);
        this.setHeaderOnly(false);
        this.setHeaderAndDescOnly(false);
        this.setNoTags(false);
        this.setDateFilter(null);
        this.setRevisionFilter(null);
        this.setStateFilter(null);
        this.setUserFilter(null);
    }

    public String getOptString() {
        return "RlbhtNd:r:s:w:";
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isDefaultBranch()) {
            stringBuffer.append("-b ");
        }
        if (this.isHeaderAndDescOnly()) {
            stringBuffer.append("-t ");
        }
        if (this.isHeaderOnly()) {
            stringBuffer.append("-h ");
        }
        if (this.isNoTags()) {
            stringBuffer.append("-N ");
        }
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.userFilter != null) {
            stringBuffer.append("-w");
            stringBuffer.append(this.userFilter);
            stringBuffer.append(' ');
        }
        if (this.revisionFilter != null) {
            stringBuffer.append("-r");
            stringBuffer.append(this.revisionFilter);
            stringBuffer.append(' ');
        }
        if (this.stateFilter != null) {
            stringBuffer.append("-s");
            stringBuffer.append(this.stateFilter);
            stringBuffer.append(' ');
        }
        if (this.dateFilter != null) {
            stringBuffer.append("-d");
            stringBuffer.append(this.dateFilter);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

