/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionFactory;

public class CVSRoot {
    public static final String METHOD_LOCAL = "local";
    public static final String METHOD_FORK = "fork";
    public static final String METHOD_SERVER = "server";
    public static final String METHOD_PSERVER = "pserver";
    public static final String METHOD_EXT = "ext";
    private String method;
    private String username;
    private String password;
    private String hostname;
    private int port;
    private String repository;

    public static CVSRoot parse(String string) throws IllegalArgumentException {
        return new CVSRoot(string);
    }

    public static CVSRoot parse(Properties properties) throws IllegalArgumentException {
        return new CVSRoot(properties);
    }

    protected CVSRoot(Properties properties) throws IllegalArgumentException {
        String string;
        String string2 = properties.getProperty("method");
        if (string2 != null) {
            this.method = string2.intern();
        }
        this.hostname = properties.getProperty("hostname");
        if (this.hostname.length() == 0) {
            this.hostname = null;
        }
        if (this.hostname != null) {
            this.username = properties.getProperty("username");
            this.password = properties.getProperty("password");
            try {
                int n = Integer.parseInt(properties.getProperty("port"));
                if (n <= 0) {
                    throw new IllegalArgumentException("The port is not a positive number.");
                }
                this.port = n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("The port is not a number: '" + properties.getProperty("port") + "'.");
            }
        }
        if ((string = properties.getProperty("repository")) == null) {
            throw new IllegalArgumentException("Repository is obligatory.");
        }
        this.repository = string;
    }

    protected CVSRoot(String string) throws IllegalArgumentException {
        String string2;
        int n;
        boolean bl;
        int n2 = 0;
        if (!string.startsWith(":")) {
            bl = string.startsWith("/");
            if (!bl) {
                if (string.indexOf(58) == 1 && string.indexOf(92) == 2) {
                    this.method = METHOD_LOCAL;
                    this.repository = string;
                    this.normalize();
                    return;
                }
                n2 = string.indexOf(58);
                if (n2 < 0) {
                    n = string.indexOf(47);
                    if (n < 0) {
                        throw new IllegalArgumentException("CVSROOT must be an absolute pathname.");
                    }
                    this.method = METHOD_SERVER;
                } else {
                    this.method = METHOD_EXT;
                }
                n2 = 0;
            } else {
                this.method = METHOD_LOCAL;
            }
        } else {
            n2 = string.indexOf(58, 1);
            if (n2 < 0) {
                throw new IllegalArgumentException("The connection method does not end with ':'.");
            }
            n = n2;
            int n3 = string.indexOf(";", 1);
            if (n3 != -1 && n3 < n2) {
                n = n3;
                String string3 = string.substring(n3 + 1, n2);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "=;");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new IllegalArgumentException("Undefined " + string4 + " option value.");
                    }
                    string2 = stringTokenizer.nextToken();
                    if ("hostname".equals(string4)) {
                        this.hostname = string2;
                    } else if ("username".equals(string4)) {
                        this.username = string2;
                    } else if ("password".equals(string4)) {
                        this.password = string2;
                    }
                    if (!"port".equals(string4)) continue;
                    try {
                        this.port = Integer.parseInt(string2, 10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Port option must be number.");
                    }
                }
            }
            this.method = string.substring(1, n).intern();
            if ("extssh".equals(this.method)) {
                this.method = METHOD_EXT;
            }
            if ("ssh".equals(this.method)) {
                this.method = METHOD_EXT;
            }
            ++n2;
            bl = this.isLocalMethod(this.method);
        }
        if (bl) {
            this.repository = string.substring(n2);
        } else {
            int n4;
            String string5;
            n = string.substring(n2).lastIndexOf(64);
            if (n != -1) {
                n += n2;
            }
            if (n < 0) {
                n = n2;
            }
            int n5 = -1;
            int n6 = string.indexOf(58, n);
            if (n6 == -1) {
                n5 = string.indexOf(47, n);
                if (n5 < 0) {
                    throw new IllegalArgumentException("cvsroot " + string + " is malformed, host name is missing.");
                }
                string5 = string.substring(n2, n5);
            } else {
                string5 = string.substring(n2, n6);
            }
            int n7 = string5.lastIndexOf(64);
            if (n7 == -1) {
                if (string5.length() > 0) {
                    this.hostname = string5;
                }
            } else {
                string2 = string5.substring(0, n7);
                if (string2.length() > 0) {
                    n4 = string2.indexOf(58);
                    if (n4 != -1) {
                        this.username = string2.substring(0, n4);
                        this.password = string2.substring(n4 + 1);
                    } else {
                        this.username = string2;
                    }
                }
                this.hostname = string5.substring(n7 + 1);
            }
            if (this.hostname == null || this.hostname.length() == 0) {
                throw new IllegalArgumentException("Didn't specify hostname in CVSROOT '" + string + "'.");
            }
            if (n6 > 0) {
                char c;
                string2 = string.substring(n6 + 1);
                int n8 = 0;
                for (n4 = 0; string2.length() > n4 && Character.isDigit(c = string2.charAt(n4)); ++n4) {
                    int n9 = Character.digit(c, 10);
                    n8 = n8 * 10 + n9;
                }
                this.port = n8;
                if (n4 > 0) {
                    string2 = string2.substring(n4);
                }
                if (string2.startsWith(":")) {
                    string2 = string2.substring(1);
                }
                this.repository = string2;
            } else {
                this.port = 0;
                this.repository = string.substring(n5);
            }
        }
        this.normalize();
    }

    private void normalize() {
        int n = this.repository.length();
        int n2 = n - 1;
        while (n > 0 && this.repository.charAt(--n) == '/') {
        }
        if (n < n2) {
            this.repository = this.repository.substring(0, n + 1);
        }
    }

    public boolean isLocal() {
        return this.hostname == null;
    }

    public String toString() {
        if (this.hostname == null) {
            if (this.method == null) {
                return this.repository;
            }
            return ":" + this.method + ":" + this.repository;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.method != null) {
            stringBuffer.append(':');
            stringBuffer.append(this.method);
            stringBuffer.append(':');
        }
        if (this.username != null) {
            stringBuffer.append(this.username);
            stringBuffer.append('@');
        }
        stringBuffer.append(this.hostname);
        stringBuffer.append(':');
        if (this.port > 0) {
            stringBuffer.append(this.port);
        }
        stringBuffer.append(this.repository);
        return stringBuffer.toString();
    }

    public int getCompatibilityLevel(CVSRoot cVSRoot) {
        if (this.equals(cVSRoot)) {
            return 0;
        }
        boolean bl = this.isSameRepository(cVSRoot);
        boolean bl2 = this.isSameHost(cVSRoot);
        boolean bl3 = this.isSameMethod(cVSRoot);
        boolean bl4 = this.isSamePort(cVSRoot);
        boolean bl5 = this.isSameUser(cVSRoot);
        if (bl && bl2 && bl3 && bl4 && bl5) {
            return 1;
        }
        if (bl && bl2 && bl3) {
            return 2;
        }
        if (bl && bl2) {
            return 3;
        }
        return -1;
    }

    private boolean isSameRepository(CVSRoot cVSRoot) {
        if (this.repository.equals(cVSRoot.repository)) {
            return true;
        }
        try {
            return new File(this.repository).getCanonicalFile().equals(new File(cVSRoot.repository).getCanonicalFile());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean isSameHost(CVSRoot cVSRoot) {
        String string = cVSRoot.getHostName();
        if (this.hostname == string) {
            return true;
        }
        if (this.hostname != null) {
            return this.hostname.equalsIgnoreCase(string);
        }
        return false;
    }

    private boolean isSameMethod(CVSRoot cVSRoot) {
        if (this.method == null) {
            return cVSRoot.getMethod() == null;
        }
        return this.method.equals(cVSRoot.getMethod());
    }

    private boolean isSamePort(CVSRoot cVSRoot) {
        if (this.isLocal() == cVSRoot.isLocal()) {
            if (this.isLocal()) {
                return true;
            }
            if (this.port == cVSRoot.getPort()) {
                return true;
            }
            try {
                Connection connection = ConnectionFactory.getConnection(this);
                Connection connection2 = ConnectionFactory.getConnection(cVSRoot);
                return connection.getPort() == connection2.getPort();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        return false;
    }

    private boolean isSameUser(CVSRoot cVSRoot) {
        String string = cVSRoot.getUserName();
        if (string == this.getUserName()) {
            return true;
        }
        if (string != null) {
            return string.equals(this.getUserName());
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CVSRoot)) {
            return false;
        }
        CVSRoot cVSRoot = (CVSRoot)object;
        return this.toString().equals(cVSRoot.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getMethod() {
        return this.method;
    }

    protected void setMethod(String string) {
        if (string != null) {
            this.method = string.intern();
        } else {
            string = null;
        }
        if (this.isLocalMethod(string)) {
            this.username = null;
            this.password = null;
            this.hostname = null;
            this.port = 0;
        } else if (this.hostname == null) {
            throw new IllegalArgumentException("Hostname must not be null when setting a remote method.");
        }
    }

    private boolean isLocalMethod(String string) {
        return METHOD_LOCAL == string || METHOD_FORK == string;
    }

    public String getUserName() {
        return this.username;
    }

    protected void setUserName(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    protected void setPassword(String string) {
        this.password = string;
    }

    public String getHostName() {
        return this.hostname;
    }

    protected void setHostName(String string) {
        this.hostname = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getRepository() {
        return this.repository;
    }

    protected void setRepository(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The repository must not be null.");
        }
        this.repository = string;
    }
}

