/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIContainer;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.ElementPanel;
import org.netbeans.modules.xml.schema.abe.ElementPropertiesPanel;
import org.netbeans.modules.xml.schema.abe.InstanceDesignConstants;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.nodes.ABEAbstractNode;

public abstract class TagPanel
extends ABEBaseDropPanel
implements ComponentListener {
    private static final int X_OFFSET = 0;
    private static final int Y_OFFSET = 0;
    private static final int X_SHADOW_OFFSET = 4;
    private static final int Y_SHADOW_OFFSET = 4;
    public static final int BOTTOM_PAD = 5;
    private ElementPanel elementPanel;
    private boolean hover;
    private String tagName;
    private boolean readonlyTag;
    private static final int TAG_HEIGHT = 29;
    private int XFUDGE = 3;
    protected ArrayList<Component> excludePaintComponentList = new ArrayList();
    Color fillTopColor = InstanceDesignConstants.TAG_BG_NORMAL_TOP_GRADIENT_COLOR;
    Color fillBottomColor = InstanceDesignConstants.TAG_BG_NORMAL_BOTTOM_GRADIENT_COLOR;
    int tagNosePointOffset;
    private int extremeLeftX;
    private int extremeRightX;
    private Point leftBottomPoint;
    private Point rightBottomPoint;
    private Point rightNosePoint;
    private Point leftNosePoint;
    boolean recalculateRequired = true;
    Dimension myDim;

    public TagPanel(ElementPanel elementPanel, InstanceUIContext instanceUIContext) {
        super(instanceUIContext);
        this.elementPanel = elementPanel;
        this.initialize();
    }

    private void initialize() {
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        int n = InstanceDesignConstants.TAG_FONT.getSize() * 2 + 5;
        this.setPreferredSize(new Dimension(100, n));
        this.initMouseListener();
        this.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                containerEvent.getComponent().addComponentListener(TagPanel.this);
                TagPanel.this.forceSizeRecalculate();
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                containerEvent.getComponent().removeComponentListener(TagPanel.this);
                TagPanel.this.forceSizeRecalculate();
            }
        });
    }

    public void removeElement() {
        if (this.getElementPanel().getParent() != null) {
            this.getElementPanel().removeElement();
        }
    }

    protected void initMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                TagPanel.this.mouseClickedActionHandler(mouseEvent, true);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                TagPanel.this.mouseClickedActionHandler(mouseEvent, false);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                TagPanel.this.mouseClickedActionHandler(mouseEvent, true);
            }
        });
    }

    protected void mouseClickedActionHandler(MouseEvent mouseEvent, boolean bl) {
        if (mouseEvent.getClickCount() == 1) {
            if (mouseEvent.isPopupTrigger()) {
                this.context.getMultiComponentActionManager().showPopupMenu(mouseEvent, (ABEBaseDropPanel)this);
                return;
            }
            if (bl) {
                return;
            }
            if (mouseEvent.isControlDown()) {
                this.context.getComponentSelectionManager().addToSelectedComponents(this);
            } else {
                this.context.getComponentSelectionManager().setSelectedComponent(this);
            }
        }
    }

    public ElementPanel getElementPanel() {
        return this.elementPanel;
    }

    boolean isHover() {
        return this.hover;
    }

    void setHover(boolean bl) {
        boolean bl2 = this.hover;
        if (bl2 != bl) {
            this.hover = bl;
            this.repaint();
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String string) {
        this.tagName = string;
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        int n;
        float f;
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        this.fillTopColor = InstanceDesignConstants.TAG_BG_NORMAL_TOP_GRADIENT_COLOR;
        this.fillBottomColor = InstanceDesignConstants.TAG_BG_NORMAL_BOTTOM_GRADIENT_COLOR;
        this.setDrawParamsForSharedElement(graphics2D);
        boolean bl = false;
        if (this.isHover()) {
            this.fillTopColor = InstanceDesignConstants.DARK_BLUE;
            this.fillBottomColor = InstanceDesignConstants.DARK_BLUE;
        } else if (this.context.getComponentSelectionManager().isSelected(this)) {
            bl = true;
        }
        Shape shape = this.getTagShape();
        Rectangle rectangle = shape.getBounds();
        graphics.translate(4, 4);
        graphics2D.setColor(new Color(240, 240, 240));
        graphics2D.fill(shape);
        graphics.translate(-1, -1);
        graphics2D.setColor(new Color(224, 224, 224));
        graphics2D.fill(shape);
        graphics.translate(-1, -1);
        graphics2D.setColor(new Color(192, 192, 192));
        graphics2D.fill(shape);
        graphics.translate(2, 2);
        graphics.translate(-4, -4);
        float f2 = f = (float)rectangle.getX();
        float f3 = (float)rectangle.getY();
        for (n = 1; n <= this.getRowCount(); ++n) {
            float f4 = f3;
            f3 = f3 + (float)TagPanel.getTagHeight() - 5.0f;
            object = new GradientPaint(f2, f4, this.fillTopColor, f, f3, this.fillBottomColor, false);
            graphics2D.setPaint((Paint)object);
            graphics2D.fill(shape);
        }
        n = (int)rectangle.getY();
        graphics2D.setColor(this.fillBottomColor);
        object = new BasicStroke(2.0f);
        Stroke stroke = null;
        stroke = graphics2D.getStroke();
        graphics2D.setStroke((Stroke)object);
        for (int i = 1; i < this.getRowCount(); ++i) {
            n = n + TagPanel.getTagHeight() - 5;
            graphics2D.drawLine(this.extremeLeftX + 1, n, this.extremeRightX - 1, n);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setColor(InstanceDesignConstants.TAG_OUTLINE_COLOR);
        stroke = null;
        if (bl) {
            stroke = graphics2D.getStroke();
            object = new BasicStroke(2.0f);
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(InstanceDesignConstants.XP_ORANGE);
        }
        graphics2D.draw(shape);
        if (bl && stroke != null) {
            graphics2D.setStroke(stroke);
        }
        this.resetDrawParamsForSharedElement(graphics2D);
    }

    protected int getA() {
        int n = 29;
        return (n - 5) / 2;
    }

    public int getTagNosePointOffset() {
        int n = 24;
        this.tagNosePointOffset = n / 2;
        return this.tagNosePointOffset;
    }

    private Shape _getTagShape(Graphics graphics) {
        int n = 24;
        int n2 = 0;
        int n3 = 0;
        int n4 = n / 2;
        int n5 = this.getA();
        int n6 = this.getAbsoluteWidth();
        this.tagNosePointOffset = n4;
        return new Polygon(new int[]{n2, n2 + n5, n6 - n2 - n5, n6 - n2, n6 - n2 - n5, n2 + n5}, new int[]{n4, n3, n3, n4, n - n3, n - n3}, 6);
    }

    public Shape getTagShape() {
        Rectangle rectangle = this.getChildrenAreaUnion();
        int n = 24;
        int n2 = this.getA();
        int n3 = rectangle.x;
        int n4 = rectangle.y - 2;
        int n5 = this.getHeight() - 5;
        int n6 = rectangle.width;
        this.tagNosePointOffset = n / 2;
        if (this.getRowCount() > 1) {
            n6 += 8;
        }
        int n7 = n6;
        if (this.getEndSlash() != null) {
            n7 = this.getEndSlash().getBounds().x;
        }
        this.extremeLeftX = n3;
        this.extremeRightX = n3 + n6;
        this.leftBottomPoint = new Point(n3, n4 + n);
        this.rightBottomPoint = new Point(n3 + n7, n4 + n5);
        this.rightNosePoint = new Point(n3 + n7 + n2, n4 + n5 - n / 2);
        this.leftNosePoint = new Point(n3 - n2, n4 + n / 2);
        return new Polygon(new int[]{n3 - n2, n3, n3 + n6, n3 + n6, n3 + n7, n3 + n7 + n2, n3 + n7, n3, n3, n3}, new int[]{n4 + n / 2, n4, n4, n4 + n5 - n, n4 + n5 - n, n4 + n5 - n / 2, n4 + n5, n4 + n5, n4 + n, n4 + n}, 10);
    }

    private int getAbsoluteWidth() {
        boolean bl = false;
        int n = 0;
        for (Component component : this.getComponents()) {
            int n2 = component.getBounds().x;
            if ((n2 += component.getPreferredSize().width) <= n) continue;
            n = n2;
        }
        return n += this.getA();
    }

    private Rectangle getChildrenAreaUnion() {
        Component[] componentArray = this.getComponents();
        if (componentArray.length <= 0) {
            return null;
        }
        Rectangle rectangle = componentArray[1].getBounds();
        for (Component component : componentArray) {
            if (this.excludePaintComponentList.contains(component)) continue;
            rectangle = SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, component.getBounds());
        }
        return rectangle;
    }

    public int getInterComponentSpacing() {
        return 0;
    }

    public Dimension _getPreferredSize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            n += dimension.width + this.getInterComponentSpacing();
            int n4 = n2 = n2 > dimension.width ? n2 : dimension.width;
            if (!(component instanceof ElementPropertiesPanel)) continue;
            n3 = dimension.width;
        }
        if (this.getRowCount() > 1) {
            n = n2 * 6 + this.getInterComponentSpacing() * 6 * 2 + this.getA() * 2 + n3 + 25;
        } else {
            n += n2 + this.getA() * 2 + 20;
            n += this.getElementPanel().getAXIContainer().getName().length() < 3 ? 10 : 0;
        }
        return new Dimension(n, 24 * this.getRowCount() + 5);
    }

    public Dimension getPreferredSize() {
        if (this.recalculateRequired) {
            this.myDim = this._getPreferredSize();
            this.recalculateRequired = false;
        }
        return this.myDim;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public static int getTagHeight() {
        return 29;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.setHover(false);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.setHover(false);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.setHover(true);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.setHover(true);
    }

    public ABEAbstractNode getNBNode() {
        return this.getElementPanel().getNBNode();
    }

    public AXIComponent getAXIComponent() {
        return this.getElementPanel().getAXIContainer();
    }

    public int getRowCount() {
        return 1;
    }

    public boolean isReadonlyTag() {
        return this.readonlyTag;
    }

    public void setReadonlyTag(boolean bl) {
        this.readonlyTag = bl;
    }

    private void setDrawParamsForSharedElement(Graphics2D graphics2D) {
        AXIContainer aXIContainer = this.getElementPanel().getAXIContainer();
        boolean bl = false;
        if (aXIContainer instanceof Element) {
            bl = ((Element)aXIContainer).isReference();
        }
        if (aXIContainer.isShared() || bl) {
            this.fillTopColor = InstanceDesignConstants.TAG_BG_SHARED_TOP_GRADIENT_COLOR;
            this.fillBottomColor = InstanceDesignConstants.TAG_BG_SHARED_BOTTOM_GRADIENT_COLOR;
        }
        if (aXIContainer.isReadOnly()) {
            this.fillTopColor = InstanceDesignConstants.TAG_BG_READONLY_TOP_GRADIENT_COLOR;
            this.fillBottomColor = InstanceDesignConstants.TAG_BG_READONLY_BOTTOM_GRADIENT_COLOR;
        }
    }

    private void resetDrawParamsForSharedElement(Graphics2D graphics2D) {
    }

    public Point getLeftBottomPoint() {
        return this.leftBottomPoint;
    }

    public Point getRightBottomPoint() {
        return this.rightBottomPoint;
    }

    public Point getRightNosePoint() {
        return this.rightNosePoint;
    }

    public Point getLeftNosePoint() {
        return this.leftNosePoint;
    }

    public JLabel getEndSlash() {
        return null;
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.forceSizeRecalculate();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.forceSizeRecalculate();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.forceSizeRecalculate();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.forceSizeRecalculate();
    }

    public void forceSizeRecalculate() {
        this.recalculateRequired = true;
    }
}

