/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.event.KeyEvent;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.UIUtilities;
import org.netbeans.modules.xml.schema.abe.visitors.BackTraversalVisitor;
import org.netbeans.modules.xml.schema.abe.visitors.DownTraversalVisitor;
import org.netbeans.modules.xml.schema.abe.visitors.FrontTraversalVisitor;
import org.netbeans.modules.xml.schema.abe.visitors.TraversalVisitor;
import org.netbeans.modules.xml.schema.abe.visitors.UpTraversalVisitor;

public class FocusTraversalManager {
    boolean metaKeyDown;
    InstanceUIContext context;
    KeyEvent currentEvent;
    ABEBaseDropPanel currentComp;

    public FocusTraversalManager(InstanceUIContext instanceUIContext) {
        this.context = instanceUIContext;
    }

    public void handleEvent(KeyEvent keyEvent, ABEBaseDropPanel aBEBaseDropPanel) {
        this.currentEvent = keyEvent;
        this.currentComp = aBEBaseDropPanel;
        NavigationType navigationType = FocusTraversalManager.getNavigationType(keyEvent);
        ABEBaseDropPanel aBEBaseDropPanel2 = null;
        TraversalVisitor traversalVisitor = null;
        switch (navigationType) {
            case FRONT: {
                traversalVisitor = new FrontTraversalVisitor(aBEBaseDropPanel);
                break;
            }
            case BACK: {
                traversalVisitor = new BackTraversalVisitor(aBEBaseDropPanel);
                break;
            }
            case UP: {
                traversalVisitor = new UpTraversalVisitor(aBEBaseDropPanel);
                break;
            }
            case DOWN: {
                traversalVisitor = new DownTraversalVisitor(aBEBaseDropPanel);
                break;
            }
            case NONE: {
                return;
            }
        }
        aBEBaseDropPanel.accept(traversalVisitor);
        aBEBaseDropPanel2 = ((TraversalVisitor)traversalVisitor).getResult();
        if (aBEBaseDropPanel2 != null) {
            if (keyEvent.isControlDown()) {
                this.context.getComponentSelectionManager().addToSelectedComponents(aBEBaseDropPanel2);
            } else {
                this.context.getComponentSelectionManager().setSelectedComponent(aBEBaseDropPanel2);
            }
            UIUtilities.scrollViewTo(aBEBaseDropPanel2, this.context);
        }
        keyEvent.consume();
    }

    public static NavigationType getNavigationType(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 39) {
            return NavigationType.FRONT;
        }
        if (n == 37) {
            return NavigationType.BACK;
        }
        return NavigationType.NONE;
    }

    public boolean isFocusChangeEvent(KeyEvent keyEvent) {
        return FocusTraversalManager.getNavigationType(keyEvent) != NavigationType.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NavigationType {
        FRONT,
        BACK,
        UP,
        DOWN,
        NONE;

    }
}

