/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.schema.abe.InstanceDesignConstants;

class ExpandCollapseButton
extends JPanel {
    private static final long serialVersionUID = 7526472295622776147L;
    public static final int WIDTH = 12;
    public static final int HEIGHT = 12;
    boolean mouseInside = false;
    List<ActionListener> all = new ArrayList<ActionListener>();
    String text;
    boolean dragMode = false;

    public ExpandCollapseButton(String string) {
        this(string, true);
    }

    public ExpandCollapseButton(String string, final boolean bl) {
        if (!string.equals("+") && !string.equals("-")) {
            throw new IllegalArgumentException("Arg can be only + or -");
        }
        this.text = string;
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                ExpandCollapseButton.this.fireActionPerformedEvent();
                if (bl) {
                    ExpandCollapseButton.this.setText(ExpandCollapseButton.this.getText().equals("+") ? "-" : "+");
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                ExpandCollapseButton.this.mouseInside = false;
                ExpandCollapseButton.this.repaint();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                ExpandCollapseButton.this.mouseInside = true;
                ExpandCollapseButton.this.repaint();
            }
        });
    }

    public void addActionListener(ActionListener actionListener) {
        this.all.add(actionListener);
    }

    private void fireActionPerformedEvent() {
        for (ActionListener actionListener : this.all) {
            actionListener.actionPerformed(new ActionEvent(this, 1980, this.getText()));
        }
    }

    public boolean isExpanded() {
        return this.getText().equals("-");
    }

    public boolean isCollapsed() {
        return !this.isExpanded();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = 8;
        int n2 = 8;
        int n3 = 0;
        int n4 = 0;
        if (this.mouseInside) {
            graphics.setColor(InstanceDesignConstants.MOUSEOVER_EXPAND_BUTTON_COLOR);
        } else {
            graphics.setColor(InstanceDesignConstants.DARK_BLUE);
        }
        if (this.dragMode) {
            graphics.setColor(Color.WHITE);
        }
        Polygon polygon = null;
        polygon = this.getText().equals("+") ? new Polygon(new int[]{n3, n3, n3 + n, n3}, new int[]{n4, n4 + n2, n4 + n2 / 2, n4}, 3) : new Polygon(new int[]{n3, n3 + n, n3 + n / 2, n3}, new int[]{n4, n4, n4 + n2, n4}, 3);
        graphics.drawPolygon(polygon);
        graphics.fillPolygon(polygon);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(12, 12);
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public synchronized String getText() {
        return this.text;
    }

    public synchronized void setText(String string) {
        this.text = string;
        this.repaint();
    }

    public void setDragMode(boolean bl) {
        this.dragMode = bl;
        this.repaint();
    }

    public void setWatchForComponent(Component component) {
        component.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (ExpandCollapseButton.this.isCollapsed()) {
                            ExpandCollapseButton.this.setText("-");
                        }
                    }
                });
            }

            public void componentHidden(ComponentEvent componentEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (ExpandCollapseButton.this.isExpanded()) {
                            ExpandCollapseButton.this.setText("+");
                        }
                    }
                });
            }
        });
    }
}

