/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIContainer;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.AutoSizingPanel;
import org.netbeans.modules.xml.schema.abe.CompositorPropertiesPanel;
import org.netbeans.modules.xml.schema.abe.ContainerPanel;
import org.netbeans.modules.xml.schema.abe.ElementPanel;
import org.netbeans.modules.xml.schema.abe.ElementsContainerPanel;
import org.netbeans.modules.xml.schema.abe.ExpandCollapseButton;
import org.netbeans.modules.xml.schema.abe.InplaceEditableLabel;
import org.netbeans.modules.xml.schema.abe.InstanceDesignConstants;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.ModelEventMediator;
import org.netbeans.modules.xml.schema.abe.TweenerPanel;
import org.netbeans.modules.xml.schema.abe.UIUtilities;
import org.netbeans.modules.xml.schema.abe.UIVisitor;
import org.netbeans.modules.xml.schema.abe.nodes.ABEAbstractNode;
import org.netbeans.modules.xml.schema.abe.nodes.CompositorNode;
import org.netbeans.modules.xml.schema.abe.palette.DnDHelper;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositorPanel
extends ElementsContainerPanel {
    private static final long serialVersionUID = 7526472295622776147L;
    Compositor.CompositorType compositorType;
    ExpandCollapseButton expandButton;
    InplaceEditableLabel compositorTypeLabel;
    JPanel compositorTypePanel;
    JLabel contentModelInfoLabel;
    private ABEAbstractNode compositorNode;
    private JLabel itemCountLabel;
    private static final int BORDER_THICKNESS = 2;
    private static final EmptyBorder emptyBorder = new EmptyBorder(2, 2, 2, 2);
    SpringLayout compositorTypePanelLayout;

    public CompositorPanel(InstanceUIContext instanceUIContext, Compositor compositor, Component component) {
        super(instanceUIContext, (AXIComponent)compositor, component, true);
        this.setBorder(emptyBorder);
        this.setDrawAnnotation(false);
        this.initMouseListener();
        this.initKeyListener();
        this.makeNBNode();
        this.addSelectionListener();
        compositor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CompositorPanel.this.verifyChildrenWithModel();
                    }
                });
            }
        });
    }

    protected void initMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                CompositorPanel.this.mouseClickedActionHandler(mouseEvent, true);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                CompositorPanel.this.mouseClickedActionHandler(mouseEvent, false);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                CompositorPanel.this.mouseClickedActionHandler(mouseEvent, true);
            }
        });
    }

    protected void mouseClickedActionHandler(MouseEvent mouseEvent, boolean bl) {
        if (mouseEvent.getClickCount() == 1) {
            if (mouseEvent.isPopupTrigger()) {
                this.context.getMultiComponentActionManager().showPopupMenu(mouseEvent, (ABEBaseDropPanel)this);
                return;
            }
            if (bl) {
                return;
            }
            if (mouseEvent.isControlDown()) {
                this.context.getComponentSelectionManager().addToSelectedComponents(this);
            } else {
                this.context.getComponentSelectionManager().setSelectedComponent(this);
            }
        }
    }

    protected void initKeyListener() {
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 113) {
                    CompositorPanel.this.compositorTypeLabel.showEditor();
                }
                if (CompositorPanel.this.context.getFocusTraversalManager().isFocusChangeEvent(keyEvent)) {
                    CompositorPanel.this.context.getFocusTraversalManager().handleEvent(keyEvent, CompositorPanel.this);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == ' ') {
                    CompositorPanel.this.compositorTypeLabel.showEditor();
                }
            }
        });
    }

    @Override
    public void addHeaderPanel() {
        AutoSizingPanel autoSizingPanel = new AutoSizingPanel(this.context);
        autoSizingPanel.setHorizontalScaling(true);
        autoSizingPanel.setOpaque(false);
        this.compositorTypePanel = autoSizingPanel;
        this.compositorTypePanelLayout = new SpringLayout();
        this.compositorTypePanel.setLayout(this.compositorTypePanelLayout);
        this.compositorTypeLabel = new InplaceEditableLabel(this.getCompositorTypeString());
        this.compositorTypeLabel.setForeground(InstanceDesignConstants.COMPOSITOR_TYPE_LABEL_COLOR);
        if (this.getAXIParent().isReadOnly()) {
            this.compositorTypeLabel.setToolTipText(NbBundle.getMessage(CompositorPanel.class, (String)"TTP_COMPOSITOR_READONLY", (Object)this.getCompositorType().getName()));
        }
        if (!(this.parentPanel instanceof ElementPanel)) {
            this.setPanelIndendation(0);
        }
        Component component = Box.createHorizontalStrut(this.getPanelIndendation());
        this.compositorTypePanel.add(component);
        this.compositorTypePanelLayout.putConstraint("West", component, 0, "West", (Component)this.compositorTypePanel);
        this.compositorTypePanelLayout.putConstraint("North", component, 0, "North", (Component)this.compositorTypePanel);
        this.compositorTypePanel.add(this.compositorTypeLabel);
        this.compositorTypePanelLayout.putConstraint("West", (Component)this.compositorTypeLabel, 0, "East", component);
        this.compositorTypePanelLayout.putConstraint("North", (Component)this.compositorTypeLabel, 0, "North", (Component)this.compositorTypePanel);
        component = Box.createHorizontalStrut(10);
        this.compositorTypePanel.add(component);
        this.compositorTypePanelLayout.putConstraint("West", component, 0, "East", (Component)this.compositorTypeLabel);
        this.compositorTypePanelLayout.putConstraint("North", component, 0, "North", (Component)this.compositorTypePanel);
        CompositorPropertiesPanel compositorPropertiesPanel = new CompositorPropertiesPanel(this.getCompositor(), this.context);
        this.compositorTypePanel.add(compositorPropertiesPanel);
        this.compositorTypePanelLayout.putConstraint("West", (Component)compositorPropertiesPanel, 0, "East", component);
        this.compositorTypePanelLayout.putConstraint("North", (Component)compositorPropertiesPanel, 0, "North", (Component)this.compositorTypePanel);
        compositorPropertiesPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CompositorPanel.this.dispatchEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                CompositorPanel.this.dispatchEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                CompositorPanel.this.dispatchEvent(mouseEvent);
            }
        });
        this.compositorTypePanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CompositorPanel.this.dispatchEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                CompositorPanel.this.dispatchEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                CompositorPanel.this.dispatchEvent(mouseEvent);
            }
        });
        component = Box.createHorizontalStrut(10);
        this.compositorTypePanel.add(component);
        this.compositorTypePanelLayout.putConstraint("West", component, 0, "East", (Component)compositorPropertiesPanel);
        this.compositorTypePanelLayout.putConstraint("North", component, 0, "North", (Component)this.compositorTypePanel);
        this.itemCountLabel = new JLabel();
        this.itemCountLabel.setForeground(Color.GRAY.brighter());
        this.refreshItemCount();
        this.compositorTypePanel.add(this.itemCountLabel);
        this.compositorTypePanelLayout.putConstraint("West", (Component)this.itemCountLabel, 0, "East", component);
        this.compositorTypePanelLayout.putConstraint("North", (Component)this.itemCountLabel, 0, "North", (Component)this.compositorTypePanel);
        this.add((Component)this.compositorTypePanel, "North");
        this.compositorTypeLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CompositorPanel.this.dispatchEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                CompositorPanel.this.dispatchEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                CompositorPanel.this.dispatchEvent(mouseEvent);
            }
        });
        this.initCompositorTypeEditListener();
    }

    protected void initCompositorTypeEditListener() {
        this.compositorTypeLabel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("PROPERTY_MODE_CHANGE") && propertyChangeEvent.getNewValue() == InplaceEditableLabel.Mode.EDIT) {
                    Compositor.CompositorType[] compositorTypeArray = CompositorPanel.filterAllIfNeeded(CompositorPanel.this.getCompositor());
                    final JComboBox<Compositor.CompositorType> jComboBox = new JComboBox<Compositor.CompositorType>(compositorTypeArray);
                    jComboBox.setSelectedItem(CompositorPanel.this.getCompositorType());
                    jComboBox.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Compositor.CompositorType compositorType = (Compositor.CompositorType)jComboBox.getSelectedItem();
                            CompositorPanel.this.compositorTypeLabel.hideEditor();
                            CompositorPanel.this.setCompositorTypeInModel(compositorType);
                            if (CompositorPanel.this.getParentContainerPanel() instanceof ElementPanel) {
                                ((ElementPanel)CompositorPanel.this.getParentContainerPanel()).expandChild();
                            }
                        }
                    });
                    if (CompositorPanel.this.getAXIParent().isReadOnly()) {
                        String string = NbBundle.getMessage(CompositorPanel.class, (String)"MSG_READONLY_COMPOSITORTYPE_EDIT", (Object)CompositorPanel.this.getCompositorType().getName());
                        CompositorPanel.this.compositorTypeLabel.setEditInfoText(string, CompositorPanel.this.context);
                    } else {
                        CompositorPanel.this.compositorTypeLabel.setInlineEditorComponent(jComboBox);
                    }
                }
            }
        });
    }

    void initButton() {
        this.expandButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompositorPanel.this.handleExpandOrCollapse();
            }
        });
    }

    void handleExpandOrCollapse() {
        if (!this.expandButton.isExpanded()) {
            this.expandChild();
        } else {
            this.collapseChild();
        }
    }

    void expandChild() {
        if (this.childrenPanel != null) {
            this.childrenPanel.setVisible(true);
            this.revalidate();
            this.repaint();
        }
    }

    void collapseChild() {
        if (this.childrenPanel != null) {
            this.childrenPanel.setVisible(false);
            this.revalidate();
            this.repaint();
        }
    }

    void refreshItemCount() {
        int n = this.getAXIChildren().size();
        String string = NbBundle.getMessage(ContainerPanel.class, (String)"LBL_ITEM_STRING");
        String string2 = NbBundle.getMessage(ContainerPanel.class, (String)"LBL_ITEMS_STRING");
        String string3 = n == 1 ? string : string2;
        this.itemCountLabel.setText("[" + n + " " + string3 + "]     ");
    }

    public void _paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.setAnnotationString(this.getCompositorType().toString());
        Rectangle rectangle = this.getBounds();
        int n = rectangle.x + this.getWidth() + 2;
        int n2 = rectangle.y - 10;
        Point point = new Point(n, n2);
        super.setStartDrawPoint(point);
        super.paintComponent(graphics2D);
    }

    public Compositor.CompositorType getCompositorType() {
        AXIComponent aXIComponent = this.getAXIParent();
        if (aXIComponent instanceof Compositor) {
            return ((Compositor)aXIComponent).getType();
        }
        return null;
    }

    public String getCompositorTypeString() {
        Compositor.CompositorType compositorType = this.getCompositorType();
        String string = null;
        switch (compositorType) {
            case SEQUENCE: {
                string = NbBundle.getMessage(CompositorPanel.class, (String)"LBL_Sequence");
                break;
            }
            case CHOICE: {
                string = NbBundle.getMessage(CompositorPanel.class, (String)"LBL_Choice");
                break;
            }
            case ALL: {
                string = NbBundle.getMessage(CompositorPanel.class, (String)"LBL_All");
            }
        }
        if (string == null) {
            string = this.getCompositorType().getName();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < 8) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void setCompositorTypeInModel(Compositor.CompositorType compositorType) {
        ((Compositor)this.getAXIParent()).setType(compositorType);
    }

    private Compositor getCompositor() {
        return (Compositor)this.getAXIParent();
    }

    @Override
    public List<? extends AXIComponent> getAXIChildren() {
        return this.getAXIParent().getChildren();
    }

    public void removeElement(Element element) {
        super.removeElement((AXIContainer)element);
        this.refreshItemCount();
    }

    public void addElement(Element element) {
        super.addElement((AXIContainer)element);
        this.refreshItemCount();
    }

    public void addCompositor(Compositor compositor) {
        int n = this.getAXIChildren().indexOf(compositor);
        if (this.isAlreadyAdded((AXIComponent)compositor) != null) {
            return;
        }
        CompositorPanel compositorPanel = new CompositorPanel(this.context, compositor, this);
        this.addChildAt(compositorPanel, n);
        this.refreshItemCount();
    }

    public void removeChildCompositor(Compositor compositor) {
        Component component = null;
        for (Component component2 : this.getChildrenList()) {
            if (!(component2 instanceof CompositorPanel) || ((CompositorPanel)component2).getCompositor() != compositor) continue;
            component = component2;
            break;
        }
        if (component != null) {
            this.removeComponent(component);
        }
        this.refreshItemCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewCompositorAt(TweenerPanel tweenerPanel, DnDHelper.PaletteItem paletteItem) {
        int n = this.getChildrenList().indexOf(tweenerPanel);
        if (n == -1) {
            return;
        }
        n /= 2;
        AXIModel aXIModel = this.getAXIParent().getModel();
        Compositor compositor = null;
        switch (paletteItem) {
            case SEQUENCE: {
                compositor = aXIModel.getComponentFactory().createSequence();
                break;
            }
            case CHOICE: {
                compositor = aXIModel.getComponentFactory().createChoice();
                break;
            }
            case ALL: {
                compositor = aXIModel.getComponentFactory().createAll();
            }
        }
        if (compositor == null) {
            return;
        }
        aXIModel.startTransaction();
        try {
            this.getAXIParent().addChildAtIndex((AXIComponent)compositor, n);
        }
        finally {
            aXIModel.endTransaction();
        }
    }

    @Override
    protected void setupAXIComponentListener() {
        super.setupAXIComponentListener();
        this.getAXIParent().addPropertyChangeListener((PropertyChangeListener)new ModelEventMediator(this, this.getAXIParent()){

            public void _propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("compositor")) {
                    if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                        CompositorPanel.this.addCompositor((Compositor)propertyChangeEvent.getNewValue());
                    } else if (propertyChangeEvent.getNewValue() == null && propertyChangeEvent.getOldValue() != null) {
                        CompositorPanel.this.removeChildCompositor((Compositor)propertyChangeEvent.getOldValue());
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("type")) {
                    CompositorPanel.this.compositorTypeLabel.setText(CompositorPanel.this.getCompositorTypeString());
                }
                CompositorPanel.this.refreshItemCount();
            }
        });
    }

    @Override
    public void visit(Compositor compositor) {
        super.visit(compositor);
        this.visitorResult = null;
        CompositorPanel compositorPanel = new CompositorPanel(this.context, compositor, this);
        this.visitorResult = compositorPanel;
    }

    @Override
    public void tweenerDrop(TweenerPanel tweenerPanel, DnDHelper.PaletteItem paletteItem) {
        super.tweenerDrop(tweenerPanel, paletteItem);
        if (DnDHelper.isCompositor(paletteItem)) {
            if (paletteItem != DnDHelper.PaletteItem.ALL && ((Compositor)this.getAXIComponent()).getType() != Compositor.CompositorType.ALL) {
                this.addNewCompositorAt(tweenerPanel, paletteItem);
            }
        }
    }

    @Override
    public void tweenerDragEntered(TweenerPanel tweenerPanel, DnDHelper.PaletteItem paletteItem) {
        super.tweenerDragEntered(tweenerPanel, paletteItem);
        if (!this.tweenerDragAccept(tweenerPanel, paletteItem)) {
            return;
        }
        LineBorder lineBorder = new LineBorder(InstanceDesignConstants.DARK_BLUE, 2, true);
        this.setBorder(lineBorder);
        this.repaint();
        ContentModel contentModel = this.getCompositor().getContentModel();
        if (contentModel != null) {
            String string = UIUtilities.getContentModelTypeString(contentModel.getType());
            String string2 = NbBundle.getMessage(UIUtilities.class, (String)"MSG_DROP_INFO_TYPE");
            tweenerPanel.setDropInfoText(string2 + " " + string + " " + contentModel.getName());
        } else {
            String string = NbBundle.getMessage(UIUtilities.class, (String)"MSG_DROP_INFO_LOCAL");
            tweenerPanel.setDropInfoText(string + this.getCompositor().getType().getName());
        }
    }

    @Override
    public boolean tweenerDragAccept(TweenerPanel tweenerPanel, DnDHelper.PaletteItem paletteItem) {
        block6: {
            block5: {
                if (this.getAXIParent().isReadOnly()) {
                    String string = NbBundle.getMessage(CompositorPanel.class, (String)"MSG_READONLY_COMPOSITOR_DROP", (Object)this.getAXIParent().getContentModel().getName());
                    UIUtilities.showErrorMessageFor(string, this.context, tweenerPanel);
                    return false;
                }
                if (this.getCompositorType() == Compositor.CompositorType.ALL && paletteItem != DnDHelper.PaletteItem.ELEMENT) {
                    String string = NbBundle.getMessage(CompositorPanel.class, (String)"MSG_ALL_COMPOSITOR_DROP_REJECT");
                    UIUtilities.showErrorMessageFor(string, this.context, tweenerPanel);
                    return false;
                }
                if (paletteItem == DnDHelper.PaletteItem.ELEMENT) break block5;
                if (!DnDHelper.isCompositor(paletteItem)) break block6;
                if (paletteItem == DnDHelper.PaletteItem.ALL) break block6;
            }
            return true;
        }
        String string = NbBundle.getMessage(CompositorPanel.class, (String)"MSG_COMPOSITOR_DROP_REJECT");
        UIUtilities.showErrorMessageFor(string, this.context, tweenerPanel);
        return false;
    }

    @Override
    public void tweenerDragExited(TweenerPanel tweenerPanel) {
        super.tweenerDragExited(tweenerPanel);
        UIUtilities.hideGlassMessage();
        this.setBorder(emptyBorder);
        this.repaint();
    }

    protected void makeNBNode() {
        this.compositorNode = new CompositorNode((Compositor)this.getAXIParent(), this.context);
        if (this.getAXIParent().isReadOnly()) {
            this.compositorNode.setReadOnly(true);
        }
    }

    @Override
    public ABEAbstractNode getNBNode() {
        return this.compositorNode;
    }

    @Override
    public AXIComponent getAXIComponent() {
        return this.getAXIParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompositor() {
        AXIComponent aXIComponent;
        if (this.getAXIComponent() instanceof Compositor && (aXIComponent = this.getAXIComponent()).getModel() != null) {
            this.context.getAXIModel().startTransaction();
            try {
                ((AXIComponent)aXIComponent.getParent()).removeChild(this.getAXIComponent());
            }
            finally {
                this.context.getAXIModel().endTransaction();
            }
        }
    }

    private void addSelectionListener() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("SELECTED")) {
                    if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        CompositorPanel.this.compositorTypeLabel.setForeground(InstanceDesignConstants.COMPOSITOR_TYPE_LABEL_SELECTED_COLOR);
                        Font font = CompositorPanel.this.compositorTypeLabel.getFont();
                        font = new Font(font.getName(), 1, font.getSize());
                        CompositorPanel.this.compositorTypeLabel.setFont(font);
                        CompositorPanel.this.drawBoldString(true);
                        CompositorPanel.this.setBorder(new LineBorder(InstanceDesignConstants.XP_ORANGE, 2, true));
                    } else {
                        CompositorPanel.this.compositorTypeLabel.setForeground(InstanceDesignConstants.COMPOSITOR_TYPE_LABEL_COLOR);
                        Font font = CompositorPanel.this.compositorTypeLabel.getFont();
                        font = new Font(font.getName(), 0, font.getSize());
                        CompositorPanel.this.compositorTypeLabel.setFont(font);
                        CompositorPanel.this.drawBoldString(false);
                        CompositorPanel.this.setBorder(emptyBorder);
                    }
                }
            }
        });
    }

    public void showExpandButton(boolean bl) {
        this.expandButton.setVisible(bl);
    }

    @Override
    public void accept(UIVisitor uIVisitor) {
        uIVisitor.visit(this);
    }

    public static Compositor.CompositorType[] filterAllIfNeeded(Compositor compositor) {
        if (compositor.getParent() instanceof Compositor) {
            return new Compositor.CompositorType[]{Compositor.CompositorType.SEQUENCE, Compositor.CompositorType.CHOICE};
        }
        for (AXIComponent aXIComponent : compositor.getChildren()) {
            if (!(aXIComponent instanceof Compositor)) continue;
            return new Compositor.CompositorType[]{Compositor.CompositorType.SEQUENCE, Compositor.CompositorType.CHOICE};
        }
        return Compositor.CompositorType.values();
    }
}

