/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.nsicom;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformDetector;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public class NSIcomPlatformDetector
extends CDCPlatformDetector {
    private static Set propertiesToFix;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getPlatformName() {
        return "NSIcom";
    }

    public String getPlatformType() {
        return "nsicom";
    }

    public boolean accept(FileObject fileObject) {
        FileObject fileObject2 = CDCPlatformUtil.findTool((String)"bin", (String)"pJSCP", Collections.singleton(fileObject));
        return fileObject2 != null;
    }

    public CDCPlatform detectPlatform(FileObject fileObject) throws IOException {
        Object object;
        String string;
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError();
        }
        FileObject fileObject2 = CDCPlatformUtil.findTool((String)"bin", (String)"pJSCP", Collections.singleton(fileObject));
        if (fileObject2 == null) {
            throw new IOException("pJSCP.exe can not be found in desired location!");
        }
        File file = FileUtil.toFile((FileObject)fileObject2);
        if (file == null) {
            throw new IOException("pJSCP.exe can not be found in desired location!");
        }
        String string2 = file.getAbsolutePath();
        FileObject fileObject3 = fileObject.getFileObject("bin");
        String string3 = File.createTempFile("nb-cdcplatformdetect", "properties").getAbsolutePath();
        this.getSDKProperties(string2, string3);
        File file2 = new File(string3);
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file2);
        properties.load(fileInputStream);
        HashMap<String, String> hashMap = new HashMap<String, String>(properties.size());
        Object object2 = properties.keys();
        while (object2.hasMoreElements()) {
            string = (String)object2.nextElement();
            object = properties.getProperty(string);
            object = this.fixSymLinks(fileObject, string, (String)object);
            hashMap.put(string, (String)object);
        }
        ((InputStream)fileInputStream).close();
        file2.delete();
        object2 = (String)hashMap.get("java.vm.version");
        if (!$assertionsDisabled && object2 == null) {
            throw new AssertionError((Object)"Platform name is null");
        }
        string = (String)hashMap.get("sun.boot.class.path");
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError((Object)"Boot classpath is null");
        }
        object = new HashMap();
        object.put(CDCPlatform.PROP_EXEC_MAIN, null);
        object.put(CDCPlatform.PROP_EXEC_APPLET, null);
        CDCDevice.CDCProfile cDCProfile = new CDCDevice.CDCProfile("PP-1.0", "NSIcom CDC-1.0 PP-1.0", "1.0", (Map)object, string, null, true);
        CDCDevice cDCDevice = new CDCDevice();
        cDCDevice.setProfiles(new CDCDevice.CDCProfile[]{cDCProfile});
        return new CDCPlatform((String)object2, (String)object2, this.getPlatformType(), "1.3", Collections.singletonList(fileObject.getURL()), Collections.EMPTY_LIST, Collections.EMPTY_LIST, new CDCDevice[]{cDCDevice}, true);
    }

    public int getVersion() {
        return 1;
    }

    private String fixSymLinks(FileObject fileObject, String string, String string2) {
        if (Utilities.isUnix() && propertiesToFix.contains(string)) {
            try {
                String string3;
                CharSequence charSequence;
                String[] stringArray = string2.split(File.pathSeparator);
                boolean bl = false;
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file != null && !((String)(charSequence = file.getAbsolutePath())).equals(string3 = file.getCanonicalPath())) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!stringArray[i].startsWith(string3)) continue;
                        stringArray[i] = (String)charSequence + stringArray[i].substring(string3.length());
                        bl = true;
                    }
                }
                if (bl) {
                    charSequence = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i > 0) {
                            ((StringBuffer)charSequence).append(File.pathSeparatorChar);
                        }
                        ((StringBuffer)charSequence).append(stringArray[i]);
                    }
                    return ((StringBuffer)charSequence).toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    private void getSDKProperties(String string, String string2) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        try {
            String[] stringArray = new String[]{string, "-classpath", InstalledFileLocator.getDefault().locate("modules/ext/org-netbeans-modules-j2me-cdc-platform-nsicom-probe.jar", "org.netbeans.modules.java.j2seplatform", false).getAbsolutePath(), "org.netbeans.modules.j2me.cdc.platform.nsicom.wizard.SDKProbe", string2};
            Process process = runtime.exec(stringArray);
            process.waitFor();
            int n = process.exitValue();
            if (n != 0) {
                throw new IOException();
            }
        }
        catch (InterruptedException interruptedException) {
            IOException iOException = new IOException();
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)interruptedException);
            throw iOException;
        }
    }

    static {
        $assertionsDisabled = !NSIcomPlatformDetector.class.desiredAssertionStatus();
        propertiesToFix = new HashSet();
        propertiesToFix.add("sun.boot.class.path");
        propertiesToFix.add("sun.boot.library.path");
        propertiesToFix.add("java.library.path");
        propertiesToFix.add("java.ext.dirs");
        propertiesToFix.add("java.home");
    }
}

