/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.uml.project.UMLProjectGenerator;
import org.netbeans.modules.uml.project.ui.UMLProjectSettings;
import org.netbeans.modules.uml.project.ui.common.JavaSourceRootsUI;
import org.netbeans.modules.uml.project.ui.wizards.PanelConfigureProject;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewUMLProjectWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_UML = 0;
    public static final int TYPE_UML_JAVA = 1;
    public static final int TYPE_REVERSE_ENGINEER = 2;
    public static final String PROP_WIZARD_TYPE = "uml-wizard-type";
    public static final String PROP_NAME_INDEX = "nameIndex";
    public static final String PROP_PROJECT_NAME = "name";
    public static final String PROP_PROJECT_DIR = "projdir";
    public static final String PROP_WIZARD_TITLE = "NewProjectWizard_Title";
    public static final String PROP_WIZARD_ERROR_MESSAGE = "WizardPanel_errorMessage";
    public static final String PROP_SET_AS_MAIN = "setAsMain";
    public static final String PROP_JAVA_SOURCE_PROJECT = "javaSrcProject";
    public static final String PROP_JAVA_SOURCE_ROOTS_MODEL = "javaSourceRootsModel";
    public static final String PROP_MODELING_MODE = "modelingMode";
    public static final String PROP_PROJECT_MODEL_TYPE = "projectModelType";
    private int type;
    private File projectDir;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private boolean hideJavaProjectPanel = true;

    public NewUMLProjectWizardIterator() {
        this(0);
    }

    public NewUMLProjectWizardIterator(int n) {
        this.type = n;
    }

    public static NewUMLProjectWizardIterator umlJava() {
        return new NewUMLProjectWizardIterator(1);
    }

    public static NewUMLProjectWizardIterator reverseEngineer() {
        return new NewUMLProjectWizardIterator(2);
    }

    private WizardDescriptor.Panel[] createPanels() {
        if (this.type == 0) {
            return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type)};
        }
        if (this.type == 1) {
            return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type)};
        }
        return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type)};
    }

    private String[] createSteps() {
        if (this.type == 0) {
            return new String[]{NbBundle.getMessage(NewUMLProjectWizardIterator.class, (String)"LAB_ConfigureProject")};
        }
        if (this.type == 1) {
            return new String[]{NbBundle.getMessage(NewUMLProjectWizardIterator.class, (String)"LAB_ConfigureProject")};
        }
        return new String[]{NbBundle.getMessage(NewUMLProjectWizardIterator.class, (String)"LAB_ConfigureProject")};
    }

    public Set instantiate() throws IOException {
        Serializable serializable;
        Object object;
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        File file = (File)this.wiz.getProperty(PROP_PROJECT_DIR);
        if (file != null) {
            this.projectDir = file = FileUtil.normalizeFile((File)file);
        }
        String string2 = (String)this.wiz.getProperty(PROP_PROJECT_NAME);
        AntProjectHelper antProjectHelper = null;
        if (this.type == 0 || this.type == 1) {
            string = null;
            string = this.type == 1 ? "Implementation" : (this.type == 0 ? "Design" : "Analysis");
            if (string.equalsIgnoreCase("Implementation")) {
                object = (Project)this.wiz.getProperty(PROP_JAVA_SOURCE_PROJECT);
                serializable = (JavaSourceRootsUI.JavaSourceRootsModel)this.wiz.getProperty(PROP_JAVA_SOURCE_ROOTS_MODEL);
                antProjectHelper = UMLProjectGenerator.createRevEngProject(file, string2, object, (JavaSourceRootsUI.JavaSourceRootsModel)serializable, null, this.type);
            } else {
                antProjectHelper = UMLProjectGenerator.createEmptyProject(file, string2, string, null, new String[0], this.type);
            }
        } else if (this.type == 2) {
            string = (Project)this.wiz.getProperty(PROP_JAVA_SOURCE_PROJECT);
            object = (JavaSourceRootsUI.JavaSourceRootsModel)this.wiz.getProperty(PROP_JAVA_SOURCE_ROOTS_MODEL);
            antProjectHelper = UMLProjectGenerator.createRevEngProject(file, string2, (Project)string, (JavaSourceRootsUI.JavaSourceRootsModel)object, null, this.type);
        }
        string = FileUtil.toFileObject((File)file);
        object = ProjectManager.getDefault().findProject((FileObject)string);
        serializable = (Integer)this.wiz.getProperty(PROP_NAME_INDEX);
        UMLProjectSettings.getDefault().setNewProjectCount((int)serializable);
        hashSet.add(string);
        File file2 = file = file != null ? file.getParentFile() : null;
        if (file != null && file.exists()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
        return hashSet;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz.putProperty(PROP_PROJECT_DIR, null);
        this.wiz.putProperty(PROP_PROJECT_NAME, null);
        this.wiz = null;
        this.panels = null;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewUMLProjectWizardIterator.class, (String)"LAB_IteratorName"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        PanelConfigureProject panelConfigureProject = (PanelConfigureProject)this.panels[0];
        if (this.type == 1 && !panelConfigureProject.isImplementationModeSelected()) {
            return this.index < this.panels.length - 2;
        }
        return this.index < this.panels.length - 1;
    }

    private boolean hideJavaProjectPanel() {
        return this.hideJavaProjectPanel;
    }

    public void hideJavaProjectPanel(boolean bl) {
        this.hideJavaProjectPanel = bl;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }
}

